# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ComparisonPeriod(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ComparisonPeriod - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'kpi': 'str',
            'date_started': 'datetime',
            'date_ended': 'datetime',
            'kpi_total_on': 'int',
            'kpi_total_off': 'int',
            'interaction_count_on': 'int',
            'interaction_count_off': 'int',
            'kpi_results': 'list[KpiResult]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'kpi': 'kpi',
            'date_started': 'dateStarted',
            'date_ended': 'dateEnded',
            'kpi_total_on': 'kpiTotalOn',
            'kpi_total_off': 'kpiTotalOff',
            'interaction_count_on': 'interactionCountOn',
            'interaction_count_off': 'interactionCountOff',
            'kpi_results': 'kpiResults',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._kpi = None
        self._date_started = None
        self._date_ended = None
        self._kpi_total_on = None
        self._kpi_total_off = None
        self._interaction_count_on = None
        self._interaction_count_off = None
        self._kpi_results = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this ComparisonPeriod.
        The globally unique identifier for the object.

        :return: The id of this ComparisonPeriod.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ComparisonPeriod.
        The globally unique identifier for the object.

        :param id: The id of this ComparisonPeriod.
        :type: str
        """
        

        self._id = id

    @property
    def kpi(self):
        """
        Gets the kpi of this ComparisonPeriod.
        Key Performance Indicator optimised during the comparison period.

        :return: The kpi of this ComparisonPeriod.
        :rtype: str
        """
        return self._kpi

    @kpi.setter
    def kpi(self, kpi):
        """
        Sets the kpi of this ComparisonPeriod.
        Key Performance Indicator optimised during the comparison period.

        :param kpi: The kpi of this ComparisonPeriod.
        :type: str
        """
        

        self._kpi = kpi

    @property
    def date_started(self):
        """
        Gets the date_started of this ComparisonPeriod.
        Start date of the comparison period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_started of this ComparisonPeriod.
        :rtype: datetime
        """
        return self._date_started

    @date_started.setter
    def date_started(self, date_started):
        """
        Sets the date_started of this ComparisonPeriod.
        Start date of the comparison period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_started: The date_started of this ComparisonPeriod.
        :type: datetime
        """
        

        self._date_started = date_started

    @property
    def date_ended(self):
        """
        Gets the date_ended of this ComparisonPeriod.
        End date of the comparison period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_ended of this ComparisonPeriod.
        :rtype: datetime
        """
        return self._date_ended

    @date_ended.setter
    def date_ended(self, date_ended):
        """
        Sets the date_ended of this ComparisonPeriod.
        End date of the comparison period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_ended: The date_ended of this ComparisonPeriod.
        :type: datetime
        """
        

        self._date_ended = date_ended

    @property
    def kpi_total_on(self):
        """
        Gets the kpi_total_on of this ComparisonPeriod.
        Absolute metric (in which the KPI is based) total for the interactions handled by predictive routing (GPR was on)

        :return: The kpi_total_on of this ComparisonPeriod.
        :rtype: int
        """
        return self._kpi_total_on

    @kpi_total_on.setter
    def kpi_total_on(self, kpi_total_on):
        """
        Sets the kpi_total_on of this ComparisonPeriod.
        Absolute metric (in which the KPI is based) total for the interactions handled by predictive routing (GPR was on)

        :param kpi_total_on: The kpi_total_on of this ComparisonPeriod.
        :type: int
        """
        

        self._kpi_total_on = kpi_total_on

    @property
    def kpi_total_off(self):
        """
        Gets the kpi_total_off of this ComparisonPeriod.
        Absolute metric (in which the KPI is based) total for the interactions not routed by predictive routing (GPR was off)

        :return: The kpi_total_off of this ComparisonPeriod.
        :rtype: int
        """
        return self._kpi_total_off

    @kpi_total_off.setter
    def kpi_total_off(self, kpi_total_off):
        """
        Sets the kpi_total_off of this ComparisonPeriod.
        Absolute metric (in which the KPI is based) total for the interactions not routed by predictive routing (GPR was off)

        :param kpi_total_off: The kpi_total_off of this ComparisonPeriod.
        :type: int
        """
        

        self._kpi_total_off = kpi_total_off

    @property
    def interaction_count_on(self):
        """
        Gets the interaction_count_on of this ComparisonPeriod.
        Total interactions handled by predictive routing (GPR was on)

        :return: The interaction_count_on of this ComparisonPeriod.
        :rtype: int
        """
        return self._interaction_count_on

    @interaction_count_on.setter
    def interaction_count_on(self, interaction_count_on):
        """
        Sets the interaction_count_on of this ComparisonPeriod.
        Total interactions handled by predictive routing (GPR was on)

        :param interaction_count_on: The interaction_count_on of this ComparisonPeriod.
        :type: int
        """
        

        self._interaction_count_on = interaction_count_on

    @property
    def interaction_count_off(self):
        """
        Gets the interaction_count_off of this ComparisonPeriod.
        Total interactions not routed by predictive routing (GPR was off)

        :return: The interaction_count_off of this ComparisonPeriod.
        :rtype: int
        """
        return self._interaction_count_off

    @interaction_count_off.setter
    def interaction_count_off(self, interaction_count_off):
        """
        Sets the interaction_count_off of this ComparisonPeriod.
        Total interactions not routed by predictive routing (GPR was off)

        :param interaction_count_off: The interaction_count_off of this ComparisonPeriod.
        :type: int
        """
        

        self._interaction_count_off = interaction_count_off

    @property
    def kpi_results(self):
        """
        Gets the kpi_results of this ComparisonPeriod.
        KPI results for each metric

        :return: The kpi_results of this ComparisonPeriod.
        :rtype: list[KpiResult]
        """
        return self._kpi_results

    @kpi_results.setter
    def kpi_results(self, kpi_results):
        """
        Sets the kpi_results of this ComparisonPeriod.
        KPI results for each metric

        :param kpi_results: The kpi_results of this ComparisonPeriod.
        :type: list[KpiResult]
        """
        

        self._kpi_results = kpi_results

    @property
    def self_uri(self):
        """
        Gets the self_uri of this ComparisonPeriod.
        The URI for this object

        :return: The self_uri of this ComparisonPeriod.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this ComparisonPeriod.
        The URI for this object

        :param self_uri: The self_uri of this ComparisonPeriod.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

