import logging

# watchtower-specific logging levels that signal the start and end of
# tasks, respectively.
START_LEVEL_NUM = logging.INFO + 2
DONE_LEVEL_NUM = logging.INFO + 4

# default host to send the watchtower requests to
# should be given by the main code in most cases
DEFAULT_HOST = 'localhost:8855'

# key in the logging payload that holds the deduplication identifier
DEDUP_ID_KEY = 'dedup_id'

# default name of the logger, when no name is provided by the user
# or through an environment variable called K_SERVICE or FUNCTION_NAME
DEFAULT_LOGGER_NAME = 'watchtower-logging'

# length of the execution_id generated by default
EXECUTION_ID_LENGTH = 10

# interval with which the python environment is send with the logging events
DEFAULT_ENV_INTERVAL = 600

# default configuration on http logging requests
DEFAULT_HTTP_TIMEOUT = 2
DEFAULT_RETRY_COUNT = 3
DEFAULT_BACKOFF_FACTOR = 1

# format string for the user-agent-string, that holds the version
USER_AGENT_STR_FMT = 'watchtower-logging-python/{version}'

# configuration for sending an incident to the alerts endpoint
DEFAULT_ALERT_RETRY_COUNT = 5
DEFAULT_ALERT_BACKOFF_FACTOR = 1
DEFAULT_ALERT_HTTP_TIMEOUT = 10