# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (40,16,16,8,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        22 443
        54 88
        313 41
        237 212
        418 208
        225 304
        57 278
        268 371
        130 407
        176 419
        66 294
        84 387
        337 383
        6 154
        320 143
        119 101
        193 327
        115 194
        178 186
        56 304
        1 117
        254 398
        133 101
        217 37
        189 156
        128 206
        129 208
        170 426
        225 201
        65 84
        10 282
        312 215
        312 216
        88 439
        23 248
        400 182
        60 433
        454 81
        437 371
        329 364
        128 16
        175 35
        103 447
        200 82
        120 399
        183 230
        212 269
        379 211
        286 123
        114 44
        72 453
        378 210
        76 430
        352 139
        321 324
        81 85
        169 416
        216 209
        90 352
        372 184
        199 455
        130 179
        373 185
        390 444
        75 164
        171 177
        198 395
        138 167
        137 38
        56 365
        86 117
        428 147
        187 331
        59 83
        158 436
        161 436
        403 202
        112 217
        404 401
        125 163
        440 328
        227 100
        377 224
        309 252
        320 428
        408 204
        223 190
        442 414
        179 145
        327 225
        408 434
        338 316
        207 185
        426 333
        235 203
        95 74
        325 306
        377 89
        234 246
        178 129
        383 92
        431 261
        27 198
        370 0
        408 451
        235 31
        254 197
        376 335
        218 361
        196 99
        150 332
        176 250
        214 391
        341 36
        118 151
        279 200
        26 422
        335 97
        430 209
        334 96
        197 441
        365 118
        366 119
        181 74
        185 107
        186 108
        53 54
        197 166
        194 193
        326 439
        265 233
        132 400
        228 57
        287 93
        20 88
        146 262
        277 142
        359 152
        266 328
        250 96
        279 303
        240 164
        295 180
        220 242
        135 127
        69 431
        325 412
        46 38
        227 278
        356 147
        348 87
        276 104
        66 450
        317 230
        283 432
        88 217
        301 420
        284 304
        126 386
        321 246
        448 347
        367 360
        13 288
        203 338
        376 210
        51 108
        326 388
        59 258
        226 271
        106 9
        35 246
        59 21
        165 443
        82 367
        291 113
        6 438
        247 86
        403 285
        98 317
        29 204
        61 274
        191 234
        19 92
        10 20
        366 375
        403 256
        228 153
        69 244
        359 263
        389 155
        352 270
        346 421
        419 349
        354 116
        415 305
        319 293
        15 71
        72 215
        55 167
        160 412
        150 401
        47 311
        400 294
        226 32
        102 48
        43 55
        19 146
        132 276
        253 391
        133 277
        77 190
        249 42
        81 349
        331 410
        407 34
        14 322
        227 110
        34 425
        235 89
        244 294
        59 350
        378 268
        138 33
        33 139
        270 42
        393 42
        245 296
        119 295
        194 198
        141 451
        356 142
        62 137
        398 397
        255 284
        46 125
        426 149
        14 156
        27 95
        375 384
        128 199
        155 297
        249 90
        114 163
        177 41
        403 241
        398 449
        73 206
        368 217
        438 105
        135 153
        67 404
        385 8
        212 80
        453 145
        74 306
        399 388
        280 434
        208 452
        285 117
        308 213
        371 48
        178 362
        379 24
        303 63
        305 64
        314 184
        97 454
        149 399
        45 374
        201 353
        171 329
        390 166
        369 332
        368 333
        455 436
        1 343
        134 330
        227 406
        211 430
        205 123
        11 396
        183 324
        179 362
        120 113
        52 232
        302 334
        386 317
        143 74
        402 64
        220 257
        323 334
        337 93
        385 450
        307 263
        6 211
        365 327
        96 349
        23 180
        203 19
        338 282
        351 133
        341 75
        142 95
        176 289
        69 402
        177 290
        312 154
        310 423
        191 420
        259 131
        237 61
        236 111
        115 355
        319 120
        134 328
        213 7
        222 82
        342 68
        54 298
        354 454
        195 164
        339 182
        313 99
        71 343
        340 183
        28 339
        290 100
        52 34
        84 407
        48 357
        229 222
        104 279
        307 318
        56 94
        168 160
        117 40
        359 21
        72 363
        258 78
        25 445
        342 414
        126 50
        323 316
        52 145
        370 218
        252 154
        253 153
        428 430
        286 204
        185 388
        285 435
        411 447
        245 174
        130 269
        201 232
        53 162
        113 107
        104 327
        25 281
        87 357
        170 146
        130 23
        452 358
        395 104
        1 209
        195 429
        60 443
        229 39
        91 241
        341 92
        373 37
        394 238
        243 221
        78 246
        372 318
        241 362
        86 24
        349 226
        369 44
        27 355
        401 38
        194 366
        83 331
        173 248
        236 446
        237 447
        452 387
        248 279
        409 257
        98 0
        394 196
        1 416
        116 125
        445 226
        124 360
        449 182
        368 399
        424 179
        109 393
        315 440
        299 68
        13 374
        71 295
        97 110
        102 433
        184 306
        25 451
        101 363
        282 146
        365 251
        155 35
        431 438
        161 442
        262 149
        406 364
        309 136
        35 206
        438 64
        427 322
        274 291
        289 275
        416 363
        453 381
        158 297
        207 360
        152 318
        26 163
        405 328
        148 413
        124 144
        10 298
        122 451
        455 87
        135 41
        168 111
        16 160
        195 337
        203 257
        9 75
        137 387
        304 39
        429 371
        106 195
        138 373
        140 374
        153 99
        159 124
        323 289
        177 406
        17 123
        273 346
        129 91
        3 348
        344 396
        345 397
        193 353
        240 214
        15 277
        170 341
        337 242
        43 124
        254 444
        54 333
        115 384
        219 43
        394 268
        21 311
        240 196
        26 275
        231 223
        369 448
        30 7
        378 413
        169 40
        308 293
        273 134
        250 7
        251 8
        214 278
        127 57
        40 256
        300 261
        272 224
        31 32
        313 141
        437 106
        282 293
        310 299
        80 167
        65 52
        13 333
        303 425
        224 442
        310 83
        368 90
        31 316
        251 276
        231 395
        417 228
        111 372
        319 262
        184 421
        158 148
        291 392
        172 91
        95 239
        265 144
        173 39
        369 422
        118 427
        173 269
        346 446
        129 245
        263 230
        174 270
        404 393
        123 224
        266 188
        356 375
        62 382
        70 357
        61 382
        245 108
        9 409
        300 0
        126 294
        18 210
        187 220
        258 58
        50 315
        411 367
        418 256
        159 202
        395 63
        109 162
        372 412
        252 147
        89 410
        169 34
        79 42
        44 113
        322 264
        340 414
        87 122
        55 336
        402 345
        441 261
        364 283
        46 432
        386 191
        168 297
        447 207
        392 347
        387 192
        21 346
        418 159
        166 64
        271 85
        170 298
        14 355
        422 392
        56 182
        17 176
        366 15
        389 160
        223 156
        10 2
        127 406
        240 228
        215 343
        423 342
        150 283
        114 354
        364 125
        253 45
        155 306
        133 63
        417 260
        449 200
        219 49
        215 435
        60 446
        382 192
        62 448
        330 421
        171 280
        354 332
        209 24
        376 281
        244 339
        111 357
        296 37
        370 152
        427 8
        73 221
        439 162
        239 190
        30 344
        178 192
        235 396
        189 8
        319 302
        67 45
        423 350
        303 232
        216 363
        305 233
        173 82
        5 381
        11 157
        336 49
        272 445
        62 150
        109 51
        210 238
        452 79
        161 286
        144 444
        386 264
        121 51
        335 85
        47 440
        307 273
        4 165
        112 392
        172 418
        53 288
        271 204
        100 238
        78 183
        414 58
        79 186
        411 84
        348 148
        231 151
        12 275
        300 301
        25 348
        181 131
        96 31
        76 136
        14 321
        309 259
        302 7
        308 20
        310 22
        273 47
        274 46
        65 255
        302 44
        57 288
        428 188
        77 175
        207 139
        417 53
        231 132
        94 397
        378 165
        114 12
        151 267
        66 189
        197 345
        126 427
        424 192
        140 162
        288 51
        370 188
        71 351
        361 318
        143 259
        169 453
        102 423
        353 63
        171 454
        247 415
        181 355
        2 157
        374 393
        385 50
        275 280
        248 225
        22 287
        148 70
        413 281
        299 93
        157 338
        76 154
        186 432
        377 11
        23 425
        18 4
        321 389
        390 233
        379 166
        30 20
        205 408
        103 107
        157 242
        320 136
        331 58
        236 102
        98 420
        323 293
        140 36
        377 68
        222 144
        168 455
        340 350
        79 38
        174 109
        253 36
        216 147
        2 344
        250 396
        251 397
        437 165
        265 336
        196 429
        19 344
        72 295
        131 412
        315 317
        292 55
        213 422
        252 218
        5 247
        15 136
        128 340
        314 446
        256 358
        61 347
        415 105
        292 202
        181 389
        296 33
        381 241
        77 264
        30 262
        18 391
        320 142
        68 242
        18 99
        77 234
        143 330
        119 353
        260 298
        380 405
        300 266
        325 239
        380 315
        339 254
        3 272
        284 232
        285 233
        259 361
        121 283
        3 73
        151 193
        287 4
        291 163
        22 48
        267 322
        448 107
        260 383
        409 92
        91 292
        360 167
        417 36
        24 105
        219 444
        407 358
        277 198
        13 249
        66 191
        199 442
        312 105
        292 33
        236 307
        65 424
        175 325
        174 326
        116 401
        384 131
        356 101
        314 297
        266 211
        287 429
        268 122
        229 336
        373 347
        409 93
        443 70
        329 332
        28 94
        221 58
        120 112
        73 158
        137 103
        431 380
        86 390
        28 49
        351 425
        32 243
        276 449
        12 334
        301 440
        405 218
        145 180
        261 379
        313 376
        110 116
        284 200
        12 81
        161 221
        16 175
        187 433
        152 421
        249 108
        267 190
        201 180
        229 94
        16 324
        187 342
        445 205
        17 11
        6 405
        308 112
        89 243
        67 110
        385 345
        237 138
        45 278
        159 139
        39 80
        214 238
        314 70
        299 410
        380 0
        420 311
        410 257
        47 230
        29 436
        265 202
        419 205
        359 98
        244 441
        415 435
        220 106
        76 343
        134 361
        3 199
        411 269
        27 223
        115 267
        272 243
        5 40
        189 132
        213 289
        435 381
        352 388
        441 450
        118 400
        263 350
        83 60
        362 358
        271 281
        255 367
        28 402
        141 290
        326 37
        280 419
        391 75
        309 375
        135 67
        270 208
        258 206
        78 311
        286 32
        127 121
        335 100
        188 330
        260 164
        29 122
        141 394
        416 351
        121 404
        424 212
        85 434
        305 49
        156 234
        41 97
        90 296
        384 239
        9 4
        219 247
        17 316
        2 383
        426 140
        149 439
        26 329
        29 413
        433 437
        5 172
        382 432
        290 434
        450 301
        69 50
        398 222
        255 80
        274 103
        172 43
        264 324
        """

        self.waters = """
        0.22973 0.85932 0.0
        0.42806 0.6853 0.3125
        0.11805 0.22821 0.8125
        0.79101 0.05905 0.0
        0.36556 0.14663 0.1875
        0.34916 0.59976 0.0
        0.30306 0.78198 0.625
        0.9539 0.29291 0.0
        0.9539 0.79291 0.5
        0.28666 0.16917 0.3125
        0.11805 0.27179 0.6875
        0.0 0.1737 0.8125
        0.80306 0.28198 0.375
        0.3289 0.37026 0.5
        0.8289 0.87026 0.5
        0.57194 0.7616 0.5
        0.8125 0.96478 0.8125
        0.92806 0.1853 0.6875
        0.42806 0.1853 0.1875
        0.11805 0.22821 0.1875
        0.07194 0.3147 0.8125
        0.1875 0.96478 0.1875
        0.33399 0.07743 0.0
        0.67111 0.62975 0.5
        0.30306 0.71803 0.125
        0.67111 0.12975 0.0
        0.78666 0.33084 0.6875
        0.71334 0.83084 0.3125
        0.07194 0.6853 0.8125
        0.65084 0.09976 0.5
        0.04611 0.29291 0.0
        0.92806 0.1853 0.3125
        0.86556 0.14663 0.3125
        0.125 0.5 0.625
        0.58834 0.60571 0.1875
        0.8125 0.96478 0.1875
        0.30306 0.28198 0.125
        0.10351 0.435 0.8125
        0.60351 0.435 0.3125
        0.91166 0.60571 0.6875
        0.41166 0.60571 0.1875
        0.57194 0.2616 0.0
        0.39649 0.435 0.3125
        0.16601 0.57743 0.0
        0.86556 0.35337 0.1875
        0.42806 0.3147 0.3125
        0.66601 0.42257 0.5
        0.16601 0.92257 0.5
        0.39649 0.065 0.8125
        0.13444 0.64663 0.8125
        0.07194 0.8147 0.6875
        0.41166 0.39429 0.8125
        0.65084 0.59976 0.0
        0.28666 0.33084 0.8125
        0.21334 0.33084 0.6875
        0.10351 0.565 0.8125
        0.92806 0.6853 0.8125
        0.42806 0.3147 0.6875
        0.0 0.04117 0.375
        0.125 0.0 0.125
        0.3125 0.03522 0.3125
        0.8125 0.46478 0.6875
        0.70899 0.44095 0.0
        0.69694 0.71803 0.125
        0.19694 0.71803 0.625
        0.70899 0.55905 0.0
        0.0 0.8263 0.1875
        0.5 0.3263 0.1875
        0.08834 0.10571 0.8125
        0.11805 0.77179 0.8125
        0.5 0.04117 0.125
        0.54611 0.70709 0.5
        0.5 0.6737 0.8125
        0.8125 0.03522 0.1875
        0.58834 0.89429 0.3125
        0.30306 0.21803 0.375
        0.42806 0.7616 0.5
        0.84916 0.90024 0.0
        0.0 0.95883 0.375
        0.5 0.45883 0.375
        0.89649 0.565 0.8125
        0.75 0.25 0.25
        0.91166 0.60571 0.3125
        0.1875 0.03522 0.1875
        0.6875 0.53522 0.1875
        0.69694 0.21803 0.375
        0.28666 0.66917 0.1875
        0.60351 0.065 0.8125
        0.13444 0.35337 0.8125
        0.0 0.1226 0.125
        0.20899 0.44095 0.5
        0.3125 0.53522 0.8125
        0.19694 0.21803 0.125
        0.22973 0.14068 0.0
        0.0 0.6737 0.6875
        0.63444 0.85337 0.1875
        0.88195 0.22821 0.1875
        0.61805 0.27179 0.1875
        0.15084 0.90024 0.0
        0.4539 0.20709 0.0
        0.57194 0.2384 0.5
        0.57194 0.7384 0.0
        0.3125 0.03522 0.6875
        0.8125 0.46478 0.3125
        0.80306 0.71803 0.375
        0.30306 0.71803 0.875
        0.27027 0.14068 0.5
        0.89649 0.435 0.1875
        0.39649 0.435 0.6875
        0.34916 0.40024 0.0
        0.57194 0.3147 0.3125
        0.5 0.0 0.75
        0.0 0.3774 0.625
        0.91166 0.39429 0.3125
        0.78666 0.33084 0.3125
        0.71334 0.83084 0.6875
        0.63444 0.35337 0.3125
        0.36556 0.64663 0.3125
        0.88195 0.77179 0.8125
        0.61805 0.72821 0.8125
        0.0 0.3774 0.375
        0.5 0.3774 0.875
        0.58834 0.10571 0.6875
        0.86556 0.14663 0.6875
        0.10351 0.565 0.1875
        0.67111 0.37026 0.5
        0.0 0.8263 0.8125
        0.5 0.3263 0.8125
        0.875 0.0 0.875
        0.375 0.5 0.875
        0.66601 0.57743 0.5
        0.58834 0.89429 0.6875
        0.88195 0.77179 0.1875
        0.61805 0.72821 0.1875
        0.34916 0.90024 0.5
        0.5 0.29358 0.0
        0.5 0.79358 0.5
        0.6875 0.46478 0.1875
        0.0 0.5 0.75
        0.125 0.5 0.375
        0.28666 0.33084 0.1875
        0.57194 0.1853 0.8125
        0.57194 0.8147 0.1875
        0.5 0.8774 0.375
        0.08834 0.60571 0.3125
        0.58834 0.60571 0.8125
        0.11805 0.27179 0.3125
        0.4539 0.79291 0.0
        0.60351 0.065 0.1875
        0.13444 0.35337 0.1875
        0.65084 0.40024 0.0
        0.80306 0.78198 0.875
        0.33399 0.92257 0.0
        0.42806 0.2616 0.0
        0.38195 0.77179 0.6875
        0.6875 0.96478 0.3125
        0.86556 0.85337 0.3125
        0.07194 0.1853 0.6875
        0.6875 0.03522 0.3125
        0.1875 0.53522 0.3125
        0.6875 0.96478 0.6875
        0.83399 0.07743 0.5
        0.27027 0.35932 0.0
        0.77027 0.35932 0.5
        0.30306 0.21803 0.625
        0.41166 0.10571 0.3125
        0.19694 0.71803 0.375
        0.0 0.54117 0.875
        0.625 0.0 0.625
        0.5 0.6226 0.125
        0.19694 0.28198 0.375
        0.69694 0.28198 0.875
        0.29101 0.55905 0.0
        0.84916 0.59976 0.5
        0.29101 0.44095 0.0
        0.79101 0.94095 0.0
        0.88195 0.22821 0.8125
        0.61805 0.27179 0.8125
        0.5 0.5 0.75
        0.60351 0.565 0.6875
        0.63444 0.64663 0.6875
        0.65084 0.90024 0.5
        0.9539 0.70709 0.0
        0.0 0.95883 0.625
        0.5 0.95883 0.125
        0.0 0.45883 0.125
        0.5 0.45883 0.625
        0.16601 0.07743 0.5
        0.36556 0.85337 0.1875
        0.92806 0.8147 0.3125
        0.77027 0.85932 0.0
        0.0 0.8774 0.125
        0.625 0.5 0.875
        0.75 0.75 0.75
        0.69694 0.78198 0.625
        0.28666 0.16917 0.6875
        0.42806 0.1853 0.8125
        0.11805 0.72821 0.3125
        0.69694 0.78198 0.375
        0.8125 0.03522 0.8125
        0.86556 0.64663 0.1875
        0.71334 0.66917 0.8125
        0.20899 0.55905 0.5
        0.07194 0.1853 0.3125
        0.72973 0.14068 0.5
        0.78666 0.16917 0.8125
        0.875 0.0 0.125
        0.0 0.5 0.25
        0.375 0.5 0.125
        0.38195 0.72821 0.1875
        0.5 0.1737 0.3125
        0.30306 0.78198 0.375
        0.8125 0.53522 0.6875
        0.92806 0.3147 0.8125
        0.42806 0.2384 0.5
        0.42806 0.6853 0.6875
        0.42806 0.7384 0.0
        0.08834 0.39429 0.6875
        0.36556 0.85337 0.8125
        0.17111 0.62975 0.0
        0.17111 0.12975 0.5
        0.89649 0.065 0.3125
        0.0 0.6226 0.375
        0.78666 0.83084 0.1875
        0.91166 0.10571 0.8125
        0.78666 0.66917 0.6875
        0.78666 0.16917 0.1875
        0.54611 0.29291 0.5
        0.38195 0.27179 0.8125
        0.0 0.6226 0.625
        0.10351 0.935 0.6875
        0.80306 0.78198 0.125
        0.72973 0.64068 0.0
        0.22973 0.64068 0.5
        0.91166 0.89429 0.1875
        0.0 0.1737 0.1875
        0.375 0.0 0.625
        0.875 0.5 0.625
        0.5 0.20643 0.5
        0.67111 0.87026 0.0
        0.38195 0.22821 0.6875
        0.39649 0.565 0.6875
        0.13444 0.14663 0.6875
        0.91166 0.10571 0.1875
        0.07194 0.7616 0.0
        0.3125 0.46478 0.8125
        0.89649 0.935 0.3125
        0.27027 0.64068 0.0
        0.77027 0.64068 0.5
        0.33399 0.42257 0.5
        0.92806 0.2384 0.0
        0.92806 0.7384 0.5
        0.42806 0.8147 0.8125
        0.38195 0.27179 0.1875
        0.07194 0.6853 0.1875
        0.83399 0.57743 0.0
        0.39649 0.565 0.3125
        0.13444 0.14663 0.3125
        0.0 0.0 0.25
        0.5 0.8774 0.625
        0.25 0.25 0.75
        0.19694 0.78198 0.125
        0.07194 0.3147 0.1875
        0.1875 0.96478 0.8125
        0.91166 0.89429 0.8125
        0.15084 0.59976 0.5
        0.28666 0.83084 0.3125
        0.78666 0.83084 0.8125
        0.5 0.1226 0.625
        0.79101 0.55905 0.5
        0.3125 0.46478 0.1875
        0.71334 0.16917 0.3125
        0.84916 0.09976 0.0
        0.29101 0.94095 0.5
        0.79101 0.44095 0.5
        0.80306 0.28198 0.625
        0.88195 0.72821 0.3125
        0.61805 0.77179 0.3125
        0.4539 0.29291 0.5
        0.78666 0.66917 0.3125
        0.75 0.25 0.75
        0.63444 0.14663 0.1875
        0.07194 0.2616 0.5
        0.58834 0.39429 0.8125
        0.8289 0.62975 0.0
        0.3289 0.62975 0.5
        0.8289 0.12975 0.5
        0.3289 0.12975 0.0
        0.36556 0.35337 0.6875
        0.88195 0.27179 0.6875
        0.61805 0.22821 0.6875
        0.84916 0.40024 0.5
        0.1875 0.53522 0.6875
        0.0 0.29358 0.5
        0.0 0.79358 0.0
        0.57194 0.6853 0.6875
        0.1875 0.46478 0.6875
        0.625 0.0 0.375
        0.19694 0.28198 0.625
        0.15084 0.09976 0.0
        0.21334 0.83084 0.1875
        0.13444 0.85337 0.3125
        0.92806 0.3147 0.1875
        0.71334 0.66917 0.1875
        0.86556 0.64663 0.8125
        0.21334 0.66917 0.6875
        0.60351 0.935 0.1875
        0.3125 0.96478 0.6875
        0.0 0.3263 0.6875
        0.5 0.8263 0.6875
        0.20899 0.05905 0.0
        0.10351 0.935 0.3125
        0.38195 0.72821 0.8125
        0.54611 0.20709 0.0
        0.5 0.0 0.25
        0.13444 0.85337 0.6875
        0.9539 0.20709 0.5
        0.08834 0.89429 0.8125
        0.39649 0.935 0.8125
        0.0 0.3263 0.3125
        0.5 0.8263 0.3125
        0.83399 0.92257 0.5
        0.86556 0.85337 0.6875
        0.92806 0.2616 0.5
        0.89649 0.935 0.6875
        0.66601 0.92257 0.0
        0.16601 0.42257 0.0
        0.80306 0.71803 0.625
        0.27027 0.85932 0.5
        0.71334 0.33084 0.8125
        0.41166 0.89429 0.3125
        0.10351 0.065 0.3125
        0.72973 0.35932 0.0
        0.22973 0.35932 0.5
        0.88195 0.27179 0.3125
        0.61805 0.22821 0.3125
        0.08834 0.60571 0.6875
        0.21334 0.16917 0.8125
        0.04611 0.20709 0.5
        0.04611 0.70709 0.0
        0.0 0.0 0.75
        0.25 0.25 0.25
        0.10351 0.065 0.6875
        0.4539 0.70709 0.5
        0.07194 0.2384 0.0
        0.07194 0.7384 0.5
        0.3125 0.96478 0.3125
        0.89649 0.435 0.8125
        0.66601 0.07743 0.0
        0.80306 0.21803 0.125
        0.125 0.0 0.875
        0.57194 0.6853 0.3125
        0.1875 0.46478 0.3125
        0.69694 0.71803 0.875
        0.71334 0.33084 0.1875
        0.72973 0.85932 0.5
        0.54611 0.79291 0.0
        0.5 0.04117 0.875
        0.5 0.54117 0.375
        0.20899 0.94095 0.0
        0.0 0.54117 0.125
        0.41166 0.89429 0.6875
        0.5 0.54117 0.625
        0.5 0.70643 0.0
        0.63444 0.35337 0.6875
        0.88195 0.72821 0.6875
        0.61805 0.77179 0.6875
        0.89649 0.565 0.1875
        0.15084 0.40024 0.5
        0.8289 0.37026 0.0
        0.3289 0.87026 0.0
        0.41166 0.10571 0.6875
        0.5 0.95883 0.875
        0.0 0.45883 0.875
        0.36556 0.35337 0.3125
        0.57194 0.8147 0.8125
        0.57194 0.1853 0.1875
        0.0 0.1226 0.875
        0.5 0.1226 0.375
        0.25 0.75 0.25
        0.21334 0.83084 0.8125
        0.41166 0.60571 0.8125
        0.6875 0.46478 0.8125
        0.19694 0.21803 0.875
        0.63444 0.85337 0.8125
        0.04611 0.79291 0.5
        0.0 0.8774 0.875
        0.625 0.5 0.125
        0.10351 0.435 0.1875
        0.70899 0.94095 0.5
        0.21334 0.66917 0.3125
        0.38195 0.22821 0.3125
        0.91166 0.39429 0.6875
        0.41166 0.39429 0.1875
        0.5 0.1737 0.6875
        0.75 0.75 0.25
        0.0 0.20643 0.0
        0.0 0.70643 0.5
        0.0 0.6737 0.3125
        0.08834 0.39429 0.3125
        0.92806 0.7616 0.0
        0.58834 0.39429 0.1875
        0.11805 0.72821 0.6875
        0.33399 0.57743 0.5
        0.5 0.3774 0.125
        0.28666 0.83084 0.6875
        0.57194 0.3147 0.6875
        0.60351 0.565 0.3125
        0.71334 0.16917 0.6875
        0.21334 0.16917 0.1875
        0.08834 0.10571 0.1875
        0.8125 0.53522 0.3125
        0.60351 0.935 0.8125
        0.58834 0.10571 0.3125
        0.0 0.04117 0.625
        0.28666 0.66917 0.8125
        0.5 0.6737 0.1875
        0.30306 0.28198 0.875
        0.3125 0.53522 0.1875
        0.80306 0.21803 0.875
        0.08834 0.89429 0.1875
        0.39649 0.935 0.1875
        0.86556 0.35337 0.8125
        0.1875 0.03522 0.8125
        0.6875 0.53522 0.8125
        0.63444 0.64663 0.3125
        0.21334 0.33084 0.3125
        0.92806 0.8147 0.6875
        0.42806 0.8147 0.1875
        0.36556 0.14663 0.8125
        0.38195 0.77179 0.3125
        0.19694 0.78198 0.875
        0.60351 0.435 0.6875
        0.29101 0.05905 0.5
        0.69694 0.21803 0.625
        0.36556 0.64663 0.6875
        0.70899 0.05905 0.5
        0.34916 0.09976 0.5
        0.25 0.75 0.75
        0.17111 0.37026 0.0
        0.17111 0.87026 0.5
        0.11805 0.77179 0.1875
        0.89649 0.065 0.6875
        0.39649 0.065 0.1875
        0.13444 0.64663 0.1875
        0.77027 0.14068 0.0
        0.375 0.0 0.375
        0.875 0.5 0.375
        0.83399 0.42257 0.0
        0.92806 0.6853 0.1875
        0.07194 0.8147 0.3125
        0.63444 0.14663 0.8125
        0.5 0.5 0.25
        0.5 0.6226 0.875
        0.69694 0.28198 0.125
        0.6875 0.03522 0.6875
        """

        self.coord = "relative"

        self.cages = """
        12 0.0 0.25 0.25
        12 0.0 0.75 0.25
        12 0.0 0.25 0.75
        12 0.0 0.75 0.75
        12 0.5 0.25 0.75
        12 0.5 0.75 0.75
        12 0.5 0.25 0.25
        12 0.5 0.75 0.25
        15 0.0 0.04558 0.0
        15 0.0 0.95442 0.0
        15 0.5 0.04558 0.5
        15 0.0 0.54558 0.5
        15 0.5 0.95442 0.5
        15 0.0 0.45442 0.5
        15 0.5 0.54558 0.0
        15 0.5 0.45442 0.0
        15 0.33596 0.0 0.0
        15 0.66404 0.0 0.0
        15 0.83596 0.0 0.5
        15 0.33596 0.5 0.5
        15 0.16404 0.0 0.5
        15 0.66404 0.5 0.5
        15 0.83596 0.5 0.0
        15 0.16404 0.5 0.0
        14 0.18442 0.29075 0.0
        14 0.81558 0.70925 0.0
        14 0.81558 0.29075 0.0
        14 0.68442 0.29075 0.5
        14 0.18442 0.79075 0.5
        14 0.18442 0.70925 0.0
        14 0.31558 0.70925 0.5
        14 0.81558 0.20925 0.5
        14 0.31558 0.29075 0.5
        14 0.81558 0.79075 0.5
        14 0.68442 0.79075 0.0
        14 0.68442 0.70925 0.5
        14 0.18442 0.20925 0.5
        14 0.31558 0.20925 0.0
        14 0.31558 0.79075 0.0
        14 0.68442 0.20925 0.0
        16 0.0 0.38089 0.0
        16 0.0 0.61911 0.0
        16 0.5 0.38089 0.5
        16 0.0 0.88089 0.5
        16 0.5 0.61911 0.5
        16 0.0 0.11911 0.5
        16 0.5 0.88089 0.0
        16 0.5 0.11911 0.0
        12 0.25 0.09531 0.25
        12 0.75 0.90469 0.25
        12 0.75 0.09531 0.75
        12 0.75 0.90469 0.75
        12 0.25 0.59531 0.75
        12 0.25 0.90469 0.75
        12 0.25 0.09531 0.75
        12 0.75 0.40469 0.75
        12 0.25 0.90469 0.25
        12 0.75 0.59531 0.25
        12 0.75 0.40469 0.25
        12 0.75 0.09531 0.25
        12 0.25 0.40469 0.25
        12 0.25 0.59531 0.25
        12 0.25 0.40469 0.75
        12 0.75 0.59531 0.75
        12 0.10335 0.16285 0.0
        12 0.89665 0.83715 0.0
        12 0.89665 0.16285 0.0
        12 0.60335 0.16285 0.5
        12 0.10335 0.66285 0.5
        12 0.10335 0.83715 0.0
        12 0.39665 0.83715 0.5
        12 0.89665 0.33715 0.5
        12 0.39665 0.16285 0.5
        12 0.89665 0.66285 0.5
        12 0.60335 0.66285 0.0
        12 0.60335 0.83715 0.5
        12 0.10335 0.33715 0.5
        12 0.39665 0.33715 0.0
        12 0.39665 0.66285 0.0
        12 0.60335 0.33715 0.0
        """

        self.bondlen = 3

        self.cell = """
        31.237117499287592 72.10269846066109 16.04856797051575
        """

        self.density = 0.3770837703776376

        self.cell = cellvectors(a=31.237117499287592,
                                b=72.10269846066109,
                                c=16.04856797051575)
