# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (32,16,16,4,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        208 151
        73 279
        220 307
        71 174
        261 365
        340 200
        110 282
        11 363
        379 52
        163 287
        120 301
        347 158
        229 260
        288 384
        145 288
        341 279
        378 132
        117 62
        314 268
        175 57
        126 290
        29 334
        89 15
        145 359
        129 134
        283 377
        311 352
        7 145
        137 281
        277 90
        39 346
        214 271
        72 18
        70 130
        225 233
        73 157
        170 23
        302 357
        149 380
        305 354
        287 34
        223 320
        343 19
        47 48
        380 166
        209 9
        386 217
        88 374
        163 309
        200 238
        240 224
        100 321
        289 211
        17 187
        261 194
        257 106
        90 369
        12 381
        142 32
        49 167
        190 116
        253 46
        65 2
        386 121
        205 254
        215 70
        362 101
        347 46
        300 286
        94 249
        133 356
        315 165
        154 323
        233 57
        317 263
        91 148
        305 125
        276 353
        244 160
        202 230
        380 87
        188 282
        74 145
        345 383
        10 243
        84 33
        30 79
        322 188
        207 204
        266 263
        0 350
        357 236
        27 54
        96 378
        242 143
        237 369
        281 316
        307 331
        107 268
        68 52
        327 387
        376 32
        59 141
        210 92
        301 385
        202 361
        94 299
        251 177
        367 203
        341 172
        374 168
        170 339
        0 321
        220 300
        95 320
        41 307
        267 353
        67 162
        234 214
        348 192
        364 270
        120 294
        138 206
        216 370
        51 315
        12 173
        8 322
        257 164
        283 279
        16 347
        105 334
        358 266
        189 143
        11 334
        55 298
        368 280
        86 299
        165 238
        180 86
        158 255
        211 107
        119 327
        283 121
        188 50
        220 111
        241 215
        379 256
        50 49
        280 250
        182 382
        38 101
        116 104
        96 173
        128 49
        196 227
        103 372
        236 355
        239 227
        115 256
        110 265
        239 267
        28 228
        103 349
        28 88
        40 74
        215 281
        224 1
        167 159
        161 155
        12 141
        296 98
        364 268
        58 253
        13 238
        254 56
        184 340
        77 161
        40 170
        66 358
        40 325
        41 325
        85 230
        3 23
        103 90
        171 260
        177 271
        284 319
        149 137
        368 116
        329 217
        1 340
        50 214
        259 326
        248 310
        38 268
        387 64
        182 253
        119 151
        21 6
        290 320
        39 221
        154 146
        244 236
        332 249
        47 155
        367 309
        173 125
        375 255
        184 62
        257 246
        121 67
        245 87
        336 315
        132 112
        284 14
        213 158
        151 218
        126 171
        183 303
        350 172
        97 333
        9 339
        216 316
        110 230
        128 131
        317 158
        212 239
        109 179
        328 29
        198 135
        274 352
        138 124
        91 54
        371 30
        345 339
        17 331
        112 162
        187 23
        153 191
        39 64
        115 129
        368 285
        303 176
        256 31
        2 82
        120 143
        169 109
        293 359
        46 375
        191 272
        75 165
        311 217
        382 118
        330 79
        247 104
        186 313
        96 85
        348 107
        290 249
        144 207
        295 381
        286 4
        97 60
        350 72
        189 199
        196 271
        25 3
        311 206
        333 313
        241 327
        77 222
        227 78
        140 323
        41 84
        9 206
        78 278
        296 117
        156 168
        3 43
        129 292
        164 193
        69 363
        346 14
        42 32
        71 259
        302 378
        198 334
        376 178
        133 366
        314 310
        55 99
        380 363
        150 2
        27 201
        152 142
        229 92
        151 124
        135 19
        231 2
        52 178
        244 211
        133 61
        198 367
        378 355
        218 155
        231 45
        11 140
        11 139
        113 304
        17 323
        17 325
        226 379
        272 172
        342 375
        265 26
        114 236
        247 384
        159 287
        297 350
        99 81
        55 123
        242 385
        16 373
        314 43
        178 195
        115 68
        124 228
        270 81
        29 309
        72 279
        108 66
        91 241
        383 40
        371 324
        372 324
        208 161
        208 225
        76 107
        7 83
        183 104
        347 266
        297 275
        213 252
        219 353
        126 255
        125 82
        20 269
        146 193
        299 273
        69 150
        305 193
        27 290
        293 116
        175 332
        386 341
        335 123
        175 206
        74 98
        256 282
        243 31
        147 355
        61 80
        303 100
        201 39
        5 344
        131 181
        225 228
        219 125
        35 262
        352 43
        109 87
        10 69
        188 189
        88 86
        312 100
        314 191
        319 308
        8 199
        180 223
        171 14
        4 13
        300 37
        127 42
        5 376
        299 320
        185 45
        361 363
        375 318
        235 308
        93 271
        63 147
        274 81
        128 30
        60 321
        311 25
        231 130
        186 251
        36 98
        366 318
        221 1
        291 306
        113 136
        321 64
        111 200
        229 263
        117 122
        362 66
        240 303
        296 237
        186 261
        78 353
        182 318
        198 168
        157 349
        53 31
        162 154
        108 155
        16 58
        141 85
        205 387
        229 174
        127 89
        312 284
        183 235
        24 132
        137 113
        322 291
        233 360
        312 97
        62 238
        240 92
        153 164
        239 93
        359 247
        291 267
        137 91
        210 75
        94 235
        373 227
        127 76
        102 196
        192 289
        75 357
        118 360
        310 164
        226 246
        71 144
        373 213
        197 330
        219 265
        223 136
        70 343
        35 377
        372 262
        114 362
        348 106
        194 319
        99 245
        59 140
        361 243
        379 20
        133 358
        308 356
        101 191
        220 33
        26 269
        131 152
        370 295
        44 342
        59 162
        317 319
        258 277
        284 351
        264 217
        197 180
        185 123
        83 33
        21 8
        135 139
        148 57
        325 328
        287 286
        150 166
        250 117
        34 203
        160 76
        245 130
        285 92
        296 359
        169 6
        354 154
        152 20
        168 343
        36 369
        160 15
        234 336
        69 323
        156 203
        149 105
        249 104
        100 346
        264 138
        300 385
        180 167
        126 190
        12 65
        58 123
        60 124
        56 272
        51 278
        292 276
        47 329
        157 187
        181 50
        205 274
        110 291
        205 275
        241 333
        351 261
        170 288
        51 338
        148 387
        80 318
        54 351
        183 285
        252 194
        210 62
        274 57
        352 364
        324 163
        102 278
        277 72
        131 122
        120 223
        24 226
        263 356
        337 101
        373 134
        10 354
        161 118
        345 18
        156 215
        5 165
        355 289
        176 209
        264 218
        374 105
        212 358
        221 288
        194 177
        67 248
        332 384
        224 260
        32 326
        95 294
        56 337
        55 337
        285 356
        129 78
        248 146
        179 118
        75 232
        197 105
        144 342
        28 94
        219 51
        269 282
        344 42
        54 136
        332 201
        27 14
        73 63
        149 233
        225 374
        196 252
        65 135
        25 121
        9 384
        197 113
        302 26
        316 304
        224 346
        216 150
        204 174
        102 234
        18 209
        114 153
        7 1
        341 147
        90 340
        115 189
        231 19
        193 63
        203 316
        127 106
        386 289
        45 276
        48 366
        266 204
        21 182
        210 280
        77 19
        336 13
        177 273
        371 122
        208 343
        79 163
        275 43
        348 310
        56 218
        97 28
        345 283
        108 337
        173 63
        24 22
        336 181
        33 195
        382 270
        111 4
        66 48
        41 330
        190 259
        79 167
        307 304
        46 207
        262 309
        297 64
        190 342
        335 222
        22 20
        24 106
        371 98
        159 214
        361 109
        259 260
        329 211
        44 160
        187 146
        333 351
        142 250
        301 365
        34 37
        157 277
        377 381
        7 326
        141 139
        159 251
        275 272
        0 209
        207 38
        166 130
        292 243
        305 246
        349 331
        144 76
        176 247
        192 67
        166 281
        330 29
        237 184
        301 252
        132 192
        89 142
        308 273
        60 327
        222 267
        48 244
        71 42
        278 68
        234 286
        112 85
        44 368
        45 222
        213 294
        240 184
        0 138
        199 294
        36 383
        383 35
        232 174
        212 16
        328 140
        61 273
        83 200
        226 53
        156 313
        264 172
        10 82
        237 176
        22 89
        31 230
        250 293
        248 3
        96 265
        128 195
        365 37
        25 339
        280 15
        88 313
        276 82
        185 169
        175 228
        246 338
        44 366
        6 134
        18 369
        298 38
        122 13
        254 99
        297 258
        315 26
        181 269
        53 112
        253 298
        185 245
        298 270
        376 83
        95 255
        73 381
        35 328
        242 195
        8 80
        202 139
        179 306
        317 171
        114 232
        61 93
        242 68
        86 251
        344 257
        103 111
        119 70
        367 370
        37 304
        152 178
        58 6
        362 204
        262 295
        102 385
        186 34
        329 364
        5 338
        108 335
        74 84
        49 143
        201 148
        254 119
        216 331
        212 335
        258 23
        322 93
        65 370
        202 306
        77 306
        153 147
        357 15
        52 338
        302 22
        53 354
        312 235
        21 179
        293 326
        199 134
        81 360
        36 372
        324 4
        258 221
        59 377
        95 80
        136 365
        87 360
        344 232
        169 292
        47 382
        295 349
        84 30
        """

        self.waters = """
        0.75 0.15988 0.25
        0.63345 0.33981 0.56907
        0.25032 0.96481 0.4375
        0.63487 0.03662 0.74344
        0.38399 0.38529 0.32197
        0.5 0.59728 0.52834
        0.07137 0.75 0.72822
        0.58981 0.38345 0.68094
        0.07095 0.65978 0.94697
        0.71665 0.17763 0.99053
        0.30406 0.90263 0.64969
        0.24968 0.0352 0.9375
        0.36513 0.96338 0.25657
        0.42763 0.46665 0.25947
        0.86471 0.36601 0.57197
        0.63529 0.63399 0.07197
        0.0 0.67864 0.52178
        0.4102 0.11656 0.68094
        0.61643 0.17721 0.19407
        0.13487 0.96338 0.24344
        0.42721 0.63357 0.94407
        0.04364 0.75 0.88738
        0.5 0.67864 0.97822
        0.58981 0.11656 0.68094
        0.5 0.75 0.875
        0.65263 0.05406 0.89969
        0.40978 0.67906 0.19697
        0.90978 0.32095 0.69697
        0.95636 0.25 0.11262
        0.28335 0.17763 0.99053
        0.36471 0.36601 0.92803
        0.30221 0.79506 0.84666
        0.57237 0.53335 0.74053
        0.4102 0.38345 0.68094
        0.19779 0.29506 0.34666
        0.42721 0.13357 0.05594
        0.5 0.25 0.125
        0.21665 0.32237 0.50947
        0.80221 0.79506 0.65334
        0.76592 0.25 0.60322
        0.5 0.20636 0.86262
        0.34728 0.25 0.77834
        0.61601 0.61471 0.67803
        0.71481 0.00032 0.6875
        0.78662 0.61513 0.00657
        0.13529 0.86601 0.42803
        0.88357 0.67721 0.69407
        0.86656 0.83981 0.06907
        0.83136 0.75 0.13157
        0.24968 0.46481 0.9375
        0.24968 0.5352 0.0625
        0.36656 0.6602 0.43094
        0.38399 0.61471 0.67803
        0.38357 0.82279 0.80594
        0.0 0.29364 0.63738
        0.92721 0.86643 0.55594
        0.84738 0.94595 0.39969
        0.9102 0.11656 0.81907
        0.0 0.75 0.625
        0.40988 0.0 0.0
        0.88357 0.17721 0.30594
        0.0 0.58136 0.11844
        0.57237 0.46665 0.25947
        0.5 0.91864 0.38157
        0.78335 0.17763 0.50947
        0.2852 0.99968 0.3125
        0.84728 0.75 0.27834
        0.54506 0.94779 0.90334
        0.30406 0.59738 0.64969
        0.2852 0.00032 0.6875
        0.04506 0.05221 0.40334
        0.69595 0.59738 0.64969
        0.61601 0.11471 0.32197
        0.5 0.01592 0.35322
        0.5 0.29364 0.86262
        0.58981 0.61656 0.31907
        0.69779 0.70494 0.84666
        0.08981 0.88345 0.18094
        0.21665 0.67763 0.49053
        0.28335 0.32237 0.99053
        0.0 0.59728 0.97166
        0.92763 0.96665 0.75947
        0.28662 0.88487 0.49344
        0.5 0.41864 0.61844
        0.40978 0.32095 0.80303
        0.36471 0.86601 0.07197
        0.07095 0.34023 0.05303
        0.07237 0.96665 0.75947
        0.04364 0.25 0.11262
        0.57279 0.63357 0.94407
        0.54364 0.25 0.38738
        0.0 0.20636 0.63738
        0.71481 0.50032 0.3125
        0.08981 0.61656 0.18094
        0.92906 0.34023 0.05303
        0.0 0.51592 0.85322
        0.40978 0.82095 0.19697
        0.92864 0.25 0.27178
        0.5 0.32137 0.02178
        0.95494 0.94779 0.59666
        0.80221 0.29506 0.34666
        0.78335 0.82237 0.49053
        0.25032 0.5352 0.4375
        0.45636 0.25 0.38738
        0.78662 0.38487 0.99344
        0.13345 0.1602 0.93094
        0.57137 0.75 0.77178
        0.69779 0.79506 0.84666
        0.90978 0.82095 0.30303
        0.11601 0.88529 0.82197
        0.26592 0.75 0.10322
        0.42906 0.34023 0.44697
        0.42721 0.86643 0.94407
        0.15273 0.25 0.72166
        0.66864 0.75 0.36844
        0.25 0.65988 0.75
        0.75032 0.46481 0.9375
        0.54506 0.44779 0.09666
        0.0 0.90273 0.97166
        0.95494 0.05221 0.40334
        0.13487 0.46338 0.75657
        0.59013 0.0 0.0
        0.45494 0.44779 0.09666
        0.0 0.82137 0.52178
        0.88399 0.11471 0.17803
        0.36656 0.83981 0.43094
        0.86513 0.46338 0.75657
        0.61643 0.67721 0.80594
        0.34738 0.44595 0.89969
        0.19779 0.70494 0.65334
        0.09013 0.0 0.5
        0.40988 0.5 0.0
        0.5 0.82137 0.97822
        0.9102 0.61656 0.18094
        0.11643 0.67721 0.69407
        0.21481 0.99968 0.1875
        0.09023 0.32095 0.69697
        0.09023 0.17906 0.69697
        0.80406 0.09738 0.14969
        0.24968 0.96481 0.0625
        0.34738 0.05406 0.89969
        0.34738 0.94595 0.10032
        0.54506 0.55221 0.90334
        0.21481 0.49968 0.8125
        0.75 0.65988 0.75
        0.59023 0.32095 0.80303
        0.5 0.98409 0.64678
        0.58981 0.88345 0.31907
        0.90978 0.17906 0.69697
        0.08981 0.11656 0.81907
        0.25032 0.0352 0.5625
        0.92763 0.03335 0.24053
        0.45494 0.55221 0.90334
        0.63345 0.83981 0.43094
        0.42763 0.96665 0.74053
        0.9102 0.88345 0.18094
        0.11643 0.17721 0.30594
        0.5 0.09728 0.47166
        0.95494 0.55221 0.59666
        0.19595 0.40263 0.14969
        0.71665 0.67763 0.00947
        0.0 0.91864 0.11844
        0.45494 0.94779 0.90334
        0.30221 0.29506 0.15334
        0.57095 0.84023 0.55303
        0.5 0.58136 0.38157
        0.15263 0.05406 0.60032
        0.21338 0.38487 0.99344
        0.11601 0.11471 0.17803
        0.11643 0.82279 0.69407
        0.59023 0.17906 0.80303
        0.84738 0.44595 0.60032
        0.71481 0.99968 0.3125
        0.4102 0.88345 0.31907
        0.71338 0.61513 0.49344
        0.86656 0.1602 0.93094
        0.69779 0.29506 0.15334
        0.07237 0.46665 0.24053
        0.42763 0.53335 0.74053
        0.07095 0.84023 0.94697
        0.13345 0.33981 0.93094
        0.34738 0.55406 0.10032
        0.95636 0.75 0.88738
        0.80406 0.40263 0.14969
        0.61601 0.38529 0.32197
        0.07279 0.86643 0.55594
        0.11643 0.32279 0.30594
        0.5 0.08136 0.61844
        0.21338 0.61513 0.00657
        0.19595 0.59738 0.85032
        0.7852 0.49968 0.8125
        0.71338 0.88487 0.49344
        0.57279 0.86643 0.94407
        0.5 0.90273 0.52834
        0.04506 0.44779 0.40334
        0.36513 0.46338 0.74344
        0.15263 0.55406 0.39969
        0.16864 0.25 0.86844
        0.19595 0.09738 0.14969
        0.11601 0.61471 0.82197
        0.5 0.40273 0.47166
        0.84728 0.25 0.72166
        0.21338 0.88487 0.00657
        0.19779 0.20494 0.34666
        0.78335 0.67763 0.49053
        0.84738 0.05406 0.60032
        0.78662 0.11513 0.99344
        0.80221 0.70494 0.65334
        0.0 0.01592 0.14678
        0.69779 0.20494 0.15334
        0.63487 0.53662 0.25657
        0.71665 0.82237 0.00947
        0.0 0.70636 0.36262
        0.04506 0.55221 0.59666
        0.21481 0.50032 0.1875
        0.07279 0.13357 0.44407
        0.28662 0.11513 0.50657
        0.75032 0.96481 0.0625
        0.86513 0.96338 0.24344
        0.33136 0.75 0.36844
        0.36656 0.33981 0.56907
        0.66864 0.25 0.63157
        0.09023 0.82095 0.30303
        0.08981 0.38345 0.81907
        0.71338 0.38487 0.50657
        0.0 0.09728 0.02834
        0.42864 0.75 0.77178
        0.13529 0.63399 0.42803
        0.92906 0.15978 0.05303
        0.74968 0.5352 0.4375
        0.28335 0.82237 0.00947
        0.15263 0.94595 0.39969
        0.63345 0.6602 0.43094
        0.0 0.08136 0.88157
        0.2852 0.50032 0.3125
        0.88399 0.38529 0.17803
        0.65273 0.75 0.22166
        0.61643 0.32279 0.19407
        0.5 0.48409 0.35322
        0.09023 0.67906 0.30303
        0.69595 0.40263 0.35032
        0.0 0.17864 0.47822
        0.2852 0.49968 0.6875
        0.25 0.84013 0.75
        0.73409 0.75 0.10322
        0.04506 0.94779 0.59666
        0.45636 0.75 0.61262
        0.71665 0.32237 0.99053
        0.57237 0.96665 0.74053
        0.86656 0.33981 0.93094
        0.59013 0.5 0.0
        0.11601 0.38529 0.17803
        0.09013 0.5 0.5
        0.92864 0.75 0.72822
        0.90988 0.0 0.5
        0.92763 0.53335 0.75947
        0.30221 0.70494 0.84666
        0.54364 0.75 0.61262
        0.63345 0.1602 0.56907
        0.71481 0.49968 0.6875
        0.74968 0.46481 0.5625
        0.07279 0.36643 0.44407
        0.38357 0.17721 0.19407
        0.84738 0.55406 0.39969
        0.7852 0.99968 0.1875
        0.34728 0.75 0.22166
        0.86471 0.63399 0.42803
        0.15273 0.75 0.27834
        0.75 0.84013 0.75
        0.36471 0.63399 0.07197
        0.88399 0.88529 0.82197
        0.13487 0.53662 0.24344
        0.74968 0.96481 0.4375
        0.0 0.48409 0.14678
        0.86513 0.03662 0.75657
        0.74968 0.0352 0.5625
        0.21665 0.82237 0.49053
        0.57095 0.15978 0.44697
        0.28662 0.61513 0.49344
        0.57237 0.03335 0.25947
        0.65263 0.55406 0.10032
        0.13529 0.13399 0.57197
        0.28335 0.67763 0.00947
        0.54506 0.05221 0.09666
        0.92721 0.36643 0.44407
        0.7852 0.50032 0.1875
        0.30406 0.40263 0.35032
        0.25 0.34013 0.25
        0.65273 0.25 0.77834
        0.63529 0.86601 0.07197
        0.9102 0.38345 0.81907
        0.16864 0.75 0.13157
        0.19779 0.79506 0.65334
        0.65263 0.44595 0.89969
        0.07237 0.53335 0.75947
        0.38399 0.11471 0.32197
        0.57279 0.36643 0.05594
        0.71338 0.11513 0.50657
        0.88357 0.82279 0.69407
        0.0 0.40273 0.02834
        0.28662 0.38487 0.50657
        0.15263 0.44595 0.60032
        0.5 0.70636 0.13738
        0.75 0.34013 0.25
        0.23409 0.25 0.60322
        0.42906 0.84023 0.55303
        0.13345 0.83981 0.06907
        0.33136 0.25 0.63157
        0.92763 0.46665 0.24053
        0.30221 0.20494 0.15334
        0.61601 0.88529 0.67803
        0.75032 0.0352 0.9375
        0.88357 0.32279 0.30594
        0.07137 0.25 0.27178
        0.69595 0.90263 0.64969
        0.4102 0.61656 0.31907
        0.21665 0.17763 0.50947
        0.90988 0.5 0.5
        0.92906 0.65978 0.94697
        0.95494 0.44779 0.40334
        0.0 0.41864 0.88157
        0.80221 0.20494 0.34666
        0.13345 0.6602 0.06907
        0.36513 0.03662 0.74344
        0.38357 0.32279 0.19407
        0.40978 0.17906 0.80303
        0.63487 0.46338 0.74344
        0.92721 0.13357 0.44407
        0.36471 0.13399 0.92803
        0.78662 0.88487 0.00657
        0.26592 0.25 0.89678
        0.36656 0.1602 0.56907
        0.83136 0.25 0.86844
        0.0 0.25 0.375
        0.21338 0.11513 0.99344
        0.0 0.79364 0.36262
        0.36513 0.53662 0.25657
        0.86471 0.86601 0.42803
        0.42906 0.65978 0.55303
        0.63529 0.13399 0.92803
        0.57095 0.34023 0.44697
        0.63487 0.96338 0.25657
        0.80406 0.59738 0.85032
        0.07237 0.03335 0.24053
        0.57095 0.65978 0.55303
        0.57279 0.13357 0.05594
        0.78335 0.32237 0.50947
        0.92721 0.63357 0.55594
        0.61643 0.82279 0.80594
        0.42906 0.15978 0.44697
        0.69595 0.09738 0.35032
        0.0 0.32137 0.47822
        0.7852 0.00032 0.8125
        0.23409 0.75 0.39678
        0.38399 0.88529 0.67803
        0.59023 0.82095 0.19697
        0.86513 0.53662 0.24344
        0.59023 0.67906 0.19697
        0.90978 0.67906 0.30303
        0.63529 0.36601 0.92803
        0.0 0.98409 0.85322
        0.19595 0.90263 0.85032
        0.76592 0.75 0.39678
        0.21481 0.00032 0.8125
        0.80406 0.90263 0.85032
        0.13529 0.36601 0.57197
        0.86656 0.6602 0.06907
        0.25 0.15988 0.25
        0.75032 0.5352 0.0625
        0.57137 0.25 0.22822
        0.30406 0.09738 0.35032
        0.42721 0.36643 0.05594
        0.42864 0.25 0.22822
        0.07279 0.63357 0.55594
        0.07095 0.15978 0.05303
        0.88399 0.61471 0.82197
        0.5 0.51592 0.64678
        0.45494 0.05221 0.09666
        0.5 0.79364 0.13738
        0.38357 0.67721 0.80594
        0.13487 0.03662 0.75657
        0.42763 0.03335 0.25947
        0.92906 0.84023 0.94697
        0.5 0.17864 0.02178
        0.73409 0.25 0.89678
        0.25032 0.46481 0.5625
        0.65263 0.94595 0.10032
        0.86471 0.13399 0.57197
        """

        self.coord = "relative"

        self.cages = """
        15 0.75 1.35922 0.75
        12 0.1109 0.75 0.48837
        12 0.31975 0.93025 0.875
        12 1.0 0.6391 0.76163
        12 0.68025 0.43025 1.125
        15 -0.10922 0.0 0.0
        12 0.18025 0.43025 0.375
        14 0.17456 0.25 0.09874
        15 0.25 0.85922 0.25
        12 0.5 0.6391 0.73837
        12 0.5 0.1391 0.26163
        15 -0.39078 0.0 -0.5
        12 1.0 0.3609 1.23837
        14 -0.17456 -0.25 -0.09874
        12 0.31975 0.43025 0.125
        12 -0.31975 -0.06975 -0.125
        15 -0.25 -0.85922 -0.25
        12 0.5 0.3609 0.26163
        12 0.0 0.1391 0.23837
        16 0.0 -0.75 -0.125
        14 0.0 0.92456 0.34874
        14 0.5 0.92456 0.15126
        12 -0.31975 -0.93025 -0.875
        14 0.0 0.42456 -0.34874
        12 0.0 -0.1391 -0.23837
        15 0.89078 0.5 1.0
        12 0.81975 1.43025 1.375
        14 0.5 1.42456 0.84874
        16 -0.5 0.75 0.375
        14 1.0 1.57544 1.34874
        12 -0.18025 0.06975 -0.625
        15 0.10922 0.5 0.0
        15 0.10922 0.0 0.0
        15 0.39078 0.0 0.5
        12 0.1109 1.25 0.51163
        15 0.75 1.64078 1.25
        12 0.8891 1.75 1.48837
        14 0.5 1.07544 0.84874
        14 -0.32544 0.25 -0.59874
        12 -0.18025 -1.06975 -0.375
        14 0.82544 0.25 1.09874
        15 -0.25 -1.14078 -0.75
        12 0.68025 1.56975 0.875
        15 0.25 1.14078 0.75
        12 0.3891 1.25 0.98837
        16 0.5 -0.75 0.625
        12 0.81975 0.56975 0.625
        14 0.0 -0.92456 -0.34874
        12 -0.1109 -0.75 -0.48837
        14 0.5 0.57544 0.15126
        15 0.60922 0.5 0.5
        12 0.5 -0.1391 0.73837
        15 0.25 0.35922 -0.25
        14 0.32544 0.25 0.40126
        15 0.25 0.64078 0.25
        12 0.18025 1.06975 0.375
        12 0.31975 0.56975 -0.125
        14 0.32544 -0.25 0.59874
        12 0.3891 0.75 0.01163
        15 0.39078 0.5 0.5
        12 0.6109 1.25 0.98837
        12 -0.3891 -1.25 -0.98837
        12 0.31975 0.06975 0.125
        14 0.17456 -0.25 -0.09874
        16 0.0 0.75 0.125
        12 0.18025 0.56975 -0.375
        14 0.67456 0.75 0.59874
        12 0.18025 -0.06975 0.625
        """

        self.bondlen = 3

        self.cell = """
        33.03241216881754 33.03241216881754 19.92373636035559
        """

        self.density = 0.5334725964599439

        self.cell = cellvectors(a=33.03241216881754,
                                b=33.03241216881754,
                                c=19.92373636035559)
