# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (24,0,0,12,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        26 134
        140 71
        137 169
        56 40
        35 189
        2 162
        47 171
        75 31
        113 188
        133 98
        52 175
        146 64
        97 27
        49 129
        15 93
        67 172
        10 120
        185 63
        180 139
        48 158
        163 167
        165 158
        81 21
        195 203
        22 62
        121 169
        83 190
        200 13
        36 110
        34 199
        18 101
        111 98
        7 82
        10 82
        103 70
        46 20
        53 94
        7 16
        37 45
        27 203
        60 197
        176 19
        195 84
        46 96
        9 23
        74 135
        55 49
        173 201
        80 184
        175 90
        13 150
        200 99
        23 38
        131 145
        28 1
        30 173
        164 136
        37 150
        201 71
        79 110
        51 38
        188 134
        197 44
        116 56
        130 188
        128 47
        178 104
        185 117
        14 17
        119 124
        166 65
        43 72
        99 190
        198 141
        26 132
        18 151
        192 108
        114 32
        76 39
        119 135
        137 87
        67 134
        94 45
        140 14
        131 157
        192 152
        53 139
        145 95
        34 125
        73 61
        39 77
        147 53
        118 98
        23 187
        202 130
        161 44
        127 129
        68 66
        22 138
        27 165
        10 133
        22 117
        50 77
        82 111
        179 174
        42 152
        180 174
        6 125
        118 93
        38 139
        99 84
        137 167
        185 97
        86 193
        15 43
        193 75
        102 160
        57 200
        23 11
        161 132
        62 122
        2 136
        163 32
        103 83
        160 74
        88 156
        57 176
        74 196
        120 177
        128 142
        115 62
        81 123
        179 89
        82 127
        202 78
        67 202
        56 167
        118 112
        101 158
        51 201
        41 83
        154 129
        69 123
        141 95
        34 75
        148 90
        173 104
        145 149
        186 176
        117 150
        101 126
        36 59
        72 98
        10 154
        61 97
        182 159
        124 143
        130 199
        93 21
        115 195
        158 189
        105 142
        161 6
        25 69
        102 109
        86 125
        1 58
        181 193
        80 149
        85 117
        138 19
        88 170
        178 147
        118 16
        92 113
        181 12
        143 168
        116 32
        116 33
        186 41
        103 139
        79 31
        107 151
        61 58
        4 2
        30 174
        176 84
        0 107
        15 120
        80 175
        91 186
        115 19
        1 65
        89 11
        14 135
        177 168
        137 197
        172 33
        128 130
        4 83
        81 43
        64 12
        12 65
        76 168
        126 3
        19 159
        190 45
        47 110
        5 49
        12 59
        30 147
        179 136
        119 102
        114 156
        55 141
        199 171
        144 64
        191 60
        164 94
        30 162
        46 187
        9 179
        182 99
        18 110
        148 135
        91 183
        175 133
        194 184
        42 109
        192 71
        48 203
        146 79
        138 68
        143 109
        102 187
        160 20
        64 58
        29 46
        178 20
        193 188
        90 177
        122 24
        100 152
        194 168
        165 151
        50 149
        136 70
        37 57
        66 45
        22 48
        166 171
        114 123
        53 183
        37 138
        54 68
        50 17
        172 191
        33 44
        121 78
        26 191
        148 184
        165 58
        195 24
        155 5
        14 42
        74 152
        54 182
        143 17
        87 161
        116 92
        166 3
        115 97
        106 190
        89 29
        61 153
        95 16
        75 40
        92 197
        9 96
        78 40
        95 72
        104 11
        132 32
        91 13
        183 70
        154 43
        85 27
        0 153
        140 77
        51 100
        52 157
        28 73
        170 127
        132 69
        18 153
        7 155
        202 125
        8 155
        87 86
        51 174
        173 29
        178 38
        101 73
        4 94
        36 105
        35 126
        128 181
        73 62
        124 108
        63 48
        163 6
        194 157
        55 21
        145 177
        123 129
        198 157
        52 108
        162 41
        88 49
        131 196
        78 105
        180 41
        76 52
        81 111
        15 194
        147 96
        154 141
        144 153
        146 151
        91 66
        166 31
        57 164
        156 21
        196 50
        113 40
        39 109
        3 146
        140 104
        192 39
        4 96
        169 113
        89 100
        121 59
        156 112
        107 122
        170 44
        93 198
        169 199
        200 70
        203 68
        180 164
        121 86
        8 127
        1 189
        0 189
        88 60
        34 167
        201 187
        42 11
        26 92
        67 56
        198 133
        181 79
        24 182
        155 112
        159 106
        160 77
        107 28
        2 29
        186 106
        100 20
        172 6
        7 55
        80 72
        106 150
        54 13
        85 122
        184 17
        90 124
        35 142
        142 65
        76 149
        35 144
        196 108
        9 103
        36 144
        191 5
        120 16
        28 3
        111 25
        25 112
        87 134
        24 63
        31 105
        163 60
        8 114
        0 63
        47 126
        8 33
        131 148
        66 84
        85 54
        185 159
        162 183
        119 71
        171 59
        170 25
        5 69
        """

        self.waters = """
        0.04173 0.70827 0.97916
        0.0 0.0 0.93748
        0.66667 0.33334 0.22949
        0.4168 0.2084 0.91685
        0.7942 0.58839 0.21387
        0.66654 0.70827 0.646
        0.66667 0.33333 0.72379
        0.7916 0.58321 0.58315
        0.04173 0.70827 0.646
        0.12753 0.87247 0.25
        0.08347 0.54173 0.54168
        0.37247 0.99495 0.31235
        0.87494 0.12507 0.87516
        0.54173 0.08346 0.11996
        0.54173 0.08347 0.38004
        0.29173 0.95827 0.52084
        0.87494 0.74987 0.54686
        0.4584 0.9168 0.41685
        0.33333 0.66667 0.94266
        0.2084 0.4168 0.08315
        0.62247 0.62753 0.31235
        0.4168 0.2084 0.58315
        0.54173 0.45827 0.04168
        0.21086 0.78914 0.29184
        0.12507 0.87494 0.04686
        0.87494 0.12507 0.62484
        0.58839 0.7942 0.71387
        0.70827 0.04174 0.02084
        0.25013 0.12507 0.95314
        0.66667 0.33333 0.27051
        0.87753 0.12247 0.25
        0.29173 0.95827 0.85401
        0.37753 0.00506 0.68766
        0.99494 0.62247 0.68766
        0.42172 0.21086 0.79184
        0.7916 0.58321 0.91685
        0.08347 0.54173 0.88004
        0.54173 0.45827 0.11996
        0.33333 0.66667 0.27621
        0.0 0.0 0.39061
        0.20581 0.7942 0.78614
        0.00506 0.37753 0.18766
        0.33347 0.04174 0.35401
        0.45827 0.91654 0.54168
        0.99494 0.37247 0.68766
        0.70827 0.66654 0.146
        0.7942 0.58839 0.28614
        0.45827 0.54173 0.88004
        0.70827 0.66654 0.02084
        0.45827 0.54174 0.61996
        0.5832 0.7916 0.41685
        0.21086 0.42172 0.29184
        0.12507 0.25013 0.45314
        0.57828 0.78914 0.20816
        0.4584 0.9168 0.08315
        0.5416 0.4584 0.58315
        0.12247 0.87753 0.75
        0.33347 0.29173 0.146
        0.87494 0.12507 0.95314
        0.04173 0.33347 0.85401
        0.37753 0.37247 0.68766
        0.04173 0.33347 0.97916
        0.33347 0.29173 0.02084
        0.95827 0.66654 0.02084
        0.7916 0.2084 0.91685
        0.0 0.0 0.89061
        0.74987 0.87494 0.12484
        0.87247 0.74495 0.75
        0.5832 0.7916 0.08315
        0.66654 0.95827 0.646
        0.37247 0.99494 0.18766
        0.95827 0.29173 0.35401
        0.66654 0.95827 0.52084
        0.29173 0.33347 0.97916
        0.54173 0.45827 0.38004
        0.37753 0.00506 0.81235
        0.0 0.0 0.43748
        0.74987 0.87494 0.37516
        0.99494 0.62247 0.81235
        0.45827 0.91654 0.88004
        0.70827 0.04173 0.47916
        0.5416 0.0832 0.58315
        0.9168 0.4584 0.58315
        0.00506 0.62753 0.18766
        0.0 0.0 0.10939
        0.54173 0.08347 0.04168
        0.78914 0.21086 0.79184
        0.87247 0.12753 0.75
        0.29173 0.33347 0.646
        0.41161 0.20581 0.28614
        0.91653 0.45827 0.45832
        0.70827 0.04173 0.146
        0.33334 0.66667 0.72949
        0.25013 0.12507 0.54686
        0.62247 0.62753 0.18766
        0.66654 0.70827 0.52084
        0.87753 0.75506 0.25
        0.95827 0.29173 0.02084
        0.87494 0.12507 0.54686
        0.12507 0.87494 0.12484
        0.37247 0.37753 0.31235
        0.45827 0.54173 0.95832
        0.95827 0.66654 0.35401
        0.21086 0.78914 0.20816
        0.62247 0.99495 0.31235
        0.04173 0.70827 0.85401
        0.91654 0.45827 0.11996
        0.29173 0.95827 0.97916
        0.2084 0.4168 0.41685
        0.12507 0.87494 0.37516
        0.33333 0.66667 0.89549
        0.7916 0.2084 0.58315
        0.0 0.0 0.60939
        0.33333 0.66667 0.77051
        0.29173 0.95827 0.646
        0.12507 0.25013 0.04686
        0.20581 0.7942 0.71387
        0.66667 0.33334 0.05734
        0.0 0.0 0.56252
        0.91653 0.45827 0.38004
        0.04173 0.70827 0.52084
        0.99494 0.37247 0.81235
        0.33347 0.04174 0.02084
        0.45827 0.91654 0.61996
        0.0832 0.5416 0.41685
        0.66667 0.33333 0.77621
        0.5416 0.4584 0.91685
        0.08346 0.54173 0.61996
        0.66654 0.70827 0.85401
        0.33333 0.66667 0.60451
        0.62753 0.62247 0.81235
        0.54173 0.45827 0.45832
        0.62753 0.00506 0.68766
        0.04174 0.33347 0.52084
        0.75506 0.87753 0.75
        0.66667 0.33333 0.39549
        0.41161 0.20581 0.21387
        0.12247 0.24495 0.75
        0.4584 0.5416 0.08315
        0.33333 0.66667 0.22379
        0.70827 0.04174 0.35401
        0.45827 0.54174 0.54168
        0.87494 0.74987 0.87516
        0.2084 0.7916 0.41685
        0.9168 0.4584 0.91685
        0.70827 0.66654 0.47916
        0.5416 0.0832 0.91685
        0.74495 0.87247 0.25
        0.66667 0.33333 0.44266
        0.74987 0.87494 0.45314
        0.66667 0.33333 0.10451
        0.45827 0.91654 0.95832
        0.33347 0.29173 0.35401
        0.08346 0.54173 0.95832
        0.33333 0.66667 0.55734
        0.87494 0.74987 0.62484
        0.25013 0.12507 0.62484
        0.33347 0.29173 0.47916
        0.66654 0.70827 0.97916
        0.0832 0.5416 0.08315
        0.70827 0.66654 0.35401
        0.78914 0.21086 0.70816
        0.7942 0.20581 0.21387
        0.42172 0.21086 0.70816
        0.37247 0.37753 0.18766
        0.66654 0.95827 0.97916
        0.25013 0.12507 0.87516
        0.25506 0.12753 0.75
        0.12507 0.87494 0.45314
        0.20581 0.41161 0.78614
        0.04173 0.33347 0.646
        0.29173 0.33347 0.85401
        0.78914 0.57828 0.70816
        0.79419 0.20581 0.28614
        0.12753 0.25506 0.25
        0.95827 0.29173 0.47916
        0.12507 0.25013 0.12484
        0.95827 0.66654 0.47916
        0.57828 0.78914 0.29184
        0.24495 0.12247 0.25
        0.21086 0.42172 0.20816
        0.66654 0.95827 0.85401
        0.2084 0.7916 0.08315
        0.62247 0.99494 0.18766
        0.54173 0.08347 0.45832
        0.91653 0.45827 0.04168
        0.95827 0.29173 0.146
        0.00505 0.62753 0.31235
        0.58839 0.7942 0.78614
        0.87494 0.74987 0.95314
        0.95827 0.66654 0.146
        0.62753 0.62247 0.68766
        0.12507 0.25013 0.37516
        0.62753 0.00506 0.81235
        0.33347 0.04173 0.47916
        0.0 0.0 0.06252
        0.4584 0.5416 0.41685
        0.20581 0.41161 0.71387
        0.29173 0.33347 0.52084
        0.37753 0.37247 0.81235
        0.33347 0.04173 0.146
        0.00505 0.37753 0.31235
        0.78914 0.57828 0.79184
        0.74987 0.87494 0.04686
        """

        self.coord = "relative"

        self.cages = """
        16 0.33333 0.66667 0.02073
        12 -0.33386 -0.16693 0.58336
        16 -0.66667 -0.33333 -0.64516
        12 0.51011 0.02022 -0.25
        12 0.16693 0.33386 -0.08336
        12 0.51011 0.48989 0.75
        12 -0.66667 -0.33333 0.66797
        16 0.0 0.0 -0.68749
        12 0.16693 -0.16693 0.58336
        12 0.33386 0.16693 -0.58336
        12 0.0 0.0 0.0
        12 0.16693 0.33386 0.58336
        12 -0.51011 -0.48989 0.25
        12 0.33333 0.66667 -0.16797
        12 -0.16693 0.16693 -0.58336
        12 0.66667 0.33333 0.16797
        12 -0.16693 0.16693 0.08336
        12 0.33386 0.16693 0.08336
        12 -0.02022 -0.51011 0.75
        12 -0.16693 -0.33386 -0.58336
        16 -0.66667 -0.33333 -0.52073
        12 0.48989 -0.02022 0.25
        16 0.0 0.0 0.68749
        12 -0.33333 -0.66667 -0.66797
        16 -0.33333 -0.66667 0.64516
        12 0.02022 0.51011 0.25
        16 -0.33333 -0.66667 0.52073
        12 -0.33386 -0.16693 -0.08336
        16 0.66667 0.33333 -0.14516
        12 -0.16693 -0.33386 0.08336
        16 0.66667 0.33333 -0.02073
        16 0.0 0.0 0.18749
        16 0.33333 0.66667 0.14516
        12 0.0 0.0 0.5
        16 0.0 0.0 -0.18749
        12 0.16693 -0.16693 -0.08336
        """

        self.bondlen = 3

        self.cell = """
        13.71339157921279 0.0 0.0
        -6.856695789606392 11.87614547964188 0.0
        4.119972161719321e-15 7.136001109867242e-15 67.28425150153997
        """

        self.density = 0.5564525150232659

        self.cell = cellvectors(a=13.71339157921279,
                                b=13.71339157921279,
                                c=67.28425150153997,
                                C=119.99999999999999)
