# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (6,8,4,0,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        96 40
        65 13
        103 47
        87 46
        11 91
        34 21
        96 24
        4 5
        33 85
        8 52
        68 32
        27 100
        63 57
        62 56
        101 75
        19 70
        11 94
        42 81
        96 68
        99 2
        17 52
        34 40
        56 73
        59 91
        7 42
        60 93
        50 94
        51 95
        66 70
        19 52
        97 75
        10 5
        14 77
        91 76
        54 49
        51 71
        19 13
        14 85
        55 75
        26 0
        23 56
        79 20
        97 20
        11 71
        11 72
        21 83
        54 81
        6 73
        28 98
        16 35
        62 88
        3 57
        48 44
        69 22
        72 13
        5 57
        67 34
        9 73
        12 79
        67 68
        33 102
        6 31
        17 78
        4 70
        103 41
        7 86
        60 37
        50 1
        89 48
        85 41
        82 38
        63 29
        62 28
        63 37
        62 37
        10 86
        9 86
        15 101
        93 88
        59 56
        59 57
        3 64
        69 50
        79 25
        80 25
        103 68
        34 78
        33 78
        54 2
        46 47
        84 102
        84 13
        61 63
        22 73
        16 83
        17 84
        60 44
        14 87
        99 82
        36 71
        35 72
        66 91
        79 21
        29 64
        61 92
        97 77
        27 38
        66 23
        74 64
        26 49
        19 94
        18 95
        51 52
        6 5
        48 38
        14 40
        65 95
        15 41
        92 82
        27 81
        26 82
        80 41
        1 71
        60 43
        7 92
        61 43
        7 2
        95 31
        94 30
        15 24
        65 58
        101 47
        55 100
        43 38
        28 74
        47 99
        96 46
        53 89
        36 21
        83 90
        84 90
        36 39
        35 39
        66 51
        18 72
        29 45
        9 88
        43 98
        92 45
        42 98
        93 45
        20 40
        58 6
        81 0
        69 76
        53 85
        18 8
        67 80
        12 33
        12 39
        67 90
        55 0
        23 31
        22 30
        4 74
        80 102
        15 20
        93 0
        53 32
        87 27
        59 30
        55 44
        16 25
        75 89
        44 2
        3 31
        4 30
        83 1
        23 74
        87 89
        53 24
        103 77
        3 76
        9 29
        10 28
        42 88
        65 1
        12 32
        18 76
        101 26
        45 98
        39 90
        37 86
        78 25
        50 8
        100 77
        49 24
        102 35
        22 64
        69 58
        58 70
        48 49
        99 100
        97 32
        54 46
        61 10
        16 8
        17 36
        """

        self.waters = """
        0.0 0.625 0.11993
        0.125 0.5 0.61993
        0.375 0.375 0.11993
        0.29253 0.91753 0.42578
        0.70747 0.08247 0.42578
        0.5 0.125 0.38007
        0.29253 0.29253 0.42578
        0.29253 0.29253 0.19922
        0.125 0.875 0.61993
        0.20747 0.54253 0.30078
        0.54253 0.20747 0.30078
        0.70747 0.70747 0.57422
        0.70747 0.70747 0.80078
        0.5 0.125 0.61993
        0.79253 0.20747 0.92578
        0.20747 0.79253 0.92578
        0.20747 0.79253 0.69922
        0.79253 0.20747 0.69922
        0.29253 0.91753 0.57422
        0.70747 0.08247 0.57422
        0.0 0.625 0.88007
        0.0 0.5 0.75
        0.08247 0.70747 0.42578
        0.91753 0.29253 0.42578
        0.33247 0.66753 0.95429
        0.08247 0.91753 0.76721
        0.20747 0.79253 0.07422
        0.79253 0.20747 0.07422
        0.79253 0.20747 0.30078
        0.20747 0.79253 0.30078
        0.83247 0.83247 0.45429
        0.16753 0.16753 0.45429
        0.625 0.625 0.88007
        0.70747 0.95747 0.80078
        0.04253 0.29253 0.80078
        0.45747 0.79253 0.69922
        0.79253 0.45747 0.69922
        0.58247 0.58247 0.26721
        0.625 0.0 0.11993
        0.58247 0.58247 0.73279
        0.0 0.375 0.88007
        0.375 0.0 0.88007
        0.04253 0.29253 0.19922
        0.70747 0.95747 0.19922
        0.625 0.625 0.11993
        0.08247 0.91753 0.23279
        0.125 0.25 0.0
        0.25 0.125 0.0
        0.58247 0.79253 0.07422
        0.33247 0.66753 0.04571
        0.08247 0.70747 0.57422
        0.91753 0.29253 0.57422
        0.875 0.125 0.61993
        0.58247 0.79253 0.92578
        0.20747 0.41753 0.07422
        0.79253 0.58247 0.07422
        0.875 0.5 0.38007
        0.5 0.875 0.38007
        0.375 0.375 0.5
        0.70747 0.70747 0.42578
        0.70747 0.70747 0.19922
        0.5 0.0 0.25
        0.79253 0.45747 0.30078
        0.45747 0.79253 0.30078
        0.125 0.875 0.38007
        0.29253 0.29253 0.57422
        0.75 0.375 0.5
        0.29253 0.29253 0.80078
        0.375 0.375 0.88007
        0.25 0.625 0.5
        0.625 0.25 0.5
        0.875 0.5 0.61993
        0.5 0.875 0.61993
        0.125 0.5 0.38007
        0.875 0.125 0.38007
        0.875 0.75 0.0
        0.375 0.75 0.5
        0.66753 0.33247 0.95429
        0.91753 0.08247 0.76721
        0.95747 0.70747 0.80078
        0.29253 0.04253 0.80078
        0.0 0.375 0.11993
        0.375 0.0 0.11993
        0.20747 0.54253 0.69922
        0.54253 0.20747 0.69922
        0.625 0.0 0.88007
        0.41753 0.41753 0.26721
        0.875 0.125 0.0
        0.0 0.5 0.25
        0.75 0.875 0.0
        0.41753 0.41753 0.73279
        0.625 0.625 0.5
        0.29253 0.04253 0.19922
        0.95747 0.70747 0.19922
        0.83247 0.83247 0.54571
        0.16753 0.16753 0.54571
        0.20747 0.41753 0.92578
        0.79253 0.58247 0.92578
        0.91753 0.08247 0.23279
        0.41753 0.20747 0.07422
        0.66753 0.33247 0.04571
        0.125 0.875 0.0
        0.5 0.0 0.75
        0.41753 0.20747 0.92578
        """

        self.coord = "relative"

        self.cages = """
        12 0.0 0.5 0.0
        12 0.0 0.5 0.5
        12 0.5 0.0 0.5
        12 0.5 0.0 0.0
        15 0.0 0.0 0.11402
        15 0.5 0.5 0.61402
        15 0.5 0.5 0.38598
        15 0.0 0.0 0.88598
        12 0.0 0.0 0.5
        12 0.5 0.5 0.0
        14 0.17011 0.17011 0.31715
        14 0.82989 0.82989 0.31715
        14 0.32989 0.67011 0.81715
        14 0.32989 0.67011 0.18285
        14 0.82989 0.82989 0.68285
        14 0.67011 0.32989 0.81715
        14 0.67011 0.32989 0.18285
        14 0.17011 0.17011 0.68285
        """

        self.bondlen = 3

        self.cell = """
        15.612917728598967 15.612917728598967 52.58311051449798
        """

        self.density = 0.24252174134611568

        self.cell = cellvectors(a=15.612917728598967,
                                b=15.612917728598967,
                                c=52.58311051449798)
