# coding: utf-8
import genice2.lattices
from genice2.cell import cellvectors


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.cell = """
        38.1655980555777 52.119307970263776 28.137560859940926
        """
        self.waters = """
        19.082799027788937 -14.072213151974479 2.6378963306188514
        19.082799027788937 -15.922448584939174 0.0
        14.55378292053932 -16.35243287569615 2.6378963306188514
        16.144047977517335 -17.290580419139143 0.0
        16.681515012131563 -14.50219744273151 4.396493884364761
        19.082799027788937 -11.270800348573166 1.7585975537458989
        19.082799027788937 -11.270800348573166 -1.7585975537458989
        19.082799027788937 -14.072213151974479 -2.6378963306188514
        16.681515012131563 -9.837519379404997 2.6378963306188514
        15.091249955153517 -8.886342008935404 0.0
        16.681515012131563 -9.837519379404997 -2.6378963306188514
        11.882191056629125 -15.414285332220206 1.7585975537458989
        11.882191056629125 -15.414285332220206 -1.7585975537458989
        14.55378292053932 -16.35243287569615 -2.6378963306188514
        12.41965809124335 -12.61287252881901 2.6378963306188514
        12.41965809124335 -10.749607268893666 0.0
        15.091249955153517 -11.700784639330314 4.396493884364761
        12.41965809124335 -12.61287252881901 -2.6378963306188514
        16.681515012131563 -14.50219744273151 -4.396493884364761
        15.091249955153517 -11.700784639330314 -4.396493884364761
        19.082799027788937 -14.072213151974479 -11.430884099341844
        19.082799027788937 -15.922448584939174 -14.068780429954163
        14.55378292053932 -16.35243287569615 -11.430884099341844
        16.144047977517335 -17.290580419139143 -14.068780429954163
        16.681515012131563 -14.50219744273151 -9.672286545589401
        19.082799027788937 -11.270800348573166 -15.827377983706578
        19.082799027788937 -11.270800348573166 -12.310182876201779
        19.082799027788937 -14.072213151974479 -16.706676760566484
        16.681515012131563 -9.837519379404997 -11.430884099341844
        15.091249955153517 -8.886342008935404 -14.068780429954163
        16.681515012131563 -9.837519379404997 -16.706676760566484
        11.882191056629125 -15.414285332220206 -15.827377983706578
        11.882191056629125 -15.414285332220206 -12.310182876201779
        14.55378292053932 -16.35243287569615 -16.706676760566484
        12.41965809124335 -12.61287252881901 -11.430884099341844
        12.41965809124335 -10.749607268893666 -14.068780429954163
        15.091249955153517 -11.700784639330314 -9.672286545589401
        12.41965809124335 -12.61287252881901 -16.706676760566484
        16.681515012131563 -14.50219744273151 -18.465274314318897
        15.091249955153517 -11.700784639330314 -18.465274314318897
        -14.334330731693221 -21.421035575792477 2.6378963306188514
        -16.462062823318202 -23.27127100875717 4.396493884364761
        -15.924595788704009 -20.50894768630381 0.0
        -19.082799027788937 -24.209418552200166 2.6378963306188514
        -19.082799027788937 -22.359183119268476 0.0
        -11.15704469358236 -23.27127100875717 2.6378963306188514
        -11.694511728196614 -26.059653985164775 4.396493884364761
        -14.871797766340187 -26.059653985164775 5.275792661224669
        -11.15704469358236 -23.27127100875717 -2.6378963306188514
        -14.334330731693221 -21.421035575792477 -2.6378963306188514
        -11.694511728196614 -26.059653985164775 -4.396493884364761
        -14.871797766340187 -26.059653985164775 -5.275792661224669
        -16.462062823318202 -23.27127100875717 -4.396493884364761
        -9.570023712449576 -24.209418552200166 0.0
        -15.924595788704009 -31.610360283992915 0.0
        -19.082799027788937 -29.760124851061164 0.0
        -14.334330731693221 -30.698272394503956 -2.6378963306188514
        -16.462062823318202 -28.848036961572262 -4.396493884364761
        -19.082799027788937 -27.909889418096466 -2.6378963306188514
        -9.570023712449576 -27.909889418096466 0.0
        -11.15704469358236 -28.848036961572262 2.6378963306188514
        -14.334330731693221 -30.698272394503956 2.6378963306188514
        -16.462062823318202 -28.848036961572262 4.396493884364761
        -19.082799027788937 -27.909889418096466 2.6378963306188514
        -11.15704469358236 -28.848036961572262 -2.6378963306188514
        -19.082799027788937 -24.209418552200166 -2.6378963306188514
        -14.334330731693221 -21.421035575792477 -11.430884099341844
        -16.462062823318202 -23.27127100875717 -9.672286545589401
        -15.924595788704009 -20.50894768630381 -14.068780429954163
        -19.082799027788937 -24.209418552200166 -11.430884099341844
        -19.082799027788937 -22.359183119268476 -14.068780429954163
        -11.15704469358236 -23.27127100875717 -16.706676760566484
        -14.334330731693221 -21.421035575792477 -16.706676760566484
        -11.694511728196614 -26.059653985164775 -18.465274314318897
        -14.871797766340187 -26.059653985164775 -19.344573091211345
        -16.462062823318202 -23.27127100875717 -18.465274314318897
        -11.15704469358236 -23.27127100875717 -11.430884099341844
        -11.694511728196614 -26.059653985164775 -9.672286545589401
        -14.871797766340187 -26.059653985164775 -8.792987768729494
        -9.570023712449576 -24.209418552200166 -14.068780429954163
        -15.924595788704009 -31.610360283992915 -14.068780429954163
        -19.082799027788937 -29.760124851061164 -14.068780429954163
        -14.334330731693221 -30.698272394503956 -16.706676760566484
        -16.462062823318202 -28.848036961572262 -18.465274314318897
        -19.082799027788937 -27.909889418096466 -16.706676760566484
        -9.570023712449576 -27.909889418096466 -14.068780429954163
        -11.15704469358236 -28.848036961572262 -11.430884099341844
        -14.334330731693221 -30.698272394503956 -11.430884099341844
        -16.462062823318202 -28.848036961572262 -9.672286545589401
        -19.082799027788937 -27.909889418096466 -11.430884099341844
        -11.15704469358236 -28.848036961572262 -16.706676760566484
        -19.082799027788937 -24.209418552200166 -16.706676760566484
        15.902268913832875 18.6326525993849 7.03439021497711
        13.774536822240663 18.6326525993849 9.672286545589401
        13.774536822240663 18.6326525993849 4.396493884364761
        10.59725078409709 18.6326525993849 5.275792661224669
        10.59725078409709 18.6326525993849 8.792987768729494
        11.134717818711342 10.267503670162085 7.03439021497711
        10.053391011811994 12.130768930087344 9.672286545589401
        8.466370030679181 14.93218173348857 5.275792661224669
        8.466370030679181 14.93218173348857 8.792987768729494
        10.053391011811994 12.130768930087344 4.396493884364761
        17.49253397081092 15.870329276964627 7.03439021497711
        14.55378292053932 16.35243287569615 11.430884099341844
        16.681515012131563 14.50219744273151 9.672286545589401
        14.55378292053932 16.35243287569615 2.6378963306188514
        16.681515012131563 14.50219744273151 4.396493884364761
        9.51592397719777 16.782417166453207 3.5171951075048264
        11.882191056629125 15.414285332220206 1.7585975537458989
        9.51592397719777 16.782417166453207 10.551585322481909
        11.882191056629125 15.414285332220206 12.310182876201779
        14.31200385685486 10.267503670162085 7.03439021497711
        12.41965809124335 12.61287252881901 11.430884099341844
        15.091249955153517 11.700784639330314 9.672286545589401
        12.41965809124335 12.61287252881901 2.6378963306188514
        15.091249955153517 11.700784639330314 4.396493884364761
        15.902268913832875 18.6326525993849 -7.03439021497711
        13.774536822240663 18.6326525993849 -4.396493884364761
        13.774536822240663 18.6326525993849 -9.672286545589401
        10.59725078409709 18.6326525993849 -5.275792661224669
        10.59725078409709 18.6326525993849 -8.792987768729494
        11.134717818711342 10.267503670162085 -7.03439021497711
        10.053391011811994 12.130768930087344 -4.396493884364761
        8.466370030679181 14.93218173348857 -5.275792661224669
        8.466370030679181 14.93218173348857 -8.792987768729494
        10.053391011811994 12.130768930087344 -9.672286545589401
        17.49253397081092 15.870329276964627 -7.03439021497711
        14.55378292053932 16.35243287569615 -2.6378963306188514
        16.681515012131563 14.50219744273151 -4.396493884364761
        14.55378292053932 16.35243287569615 -11.430884099341844
        16.681515012131563 14.50219744273151 -9.672286545589401
        9.51592397719777 16.782417166453207 -3.5171951075048264
        11.882191056629125 15.414285332220206 -1.7585975537458989
        9.51592397719777 16.782417166453207 -10.551585322481909
        11.882191056629125 15.414285332220206 -12.310182876201779
        14.31200385685486 10.267503670162085 -7.03439021497711
        12.41965809124335 12.61287252881901 -2.6378963306188514
        15.091249955153517 11.700784639330314 -4.396493884364761
        12.41965809124335 12.61287252881901 -11.430884099341844
        15.091249955153517 11.700784639330314 -9.672286545589401
        -13.774536822240663 -18.6326525993849 4.396493884364761
        -17.49253397081092 -21.421035575792477 7.03439021497711
        -15.902268913832875 -18.6326525993849 7.03439021497711
        -16.144047977517335 -17.290580419139143 0.0
        -14.55378292053932 -16.35243287569615 2.6378963306188514
        -16.681515012131563 -14.50219744273151 4.396493884364761
        -24.391061233337098 -18.6326525993849 4.396493884364761
        -23.83126732385191 -21.421035575792477 2.6378963306188514
        -22.241002266873895 -20.50894768630381 0.0
        -22.263329141744826 -18.6326525993849 7.03439021497711
        -20.673064084766953 -15.870329276964627 7.03439021497711
        -20.673064084766953 -21.421035575792477 7.03439021497711
        -21.703535232259668 -23.27127100875717 4.396493884364761
        -17.49253397081092 -15.870329276964627 7.03439021497711
        -13.774536822240663 -18.6326525993849 -9.672286545589401
        -17.49253397081092 -21.421035575792477 -7.03439021497711
        -15.902268913832875 -18.6326525993849 -7.03439021497711
        -16.144047977517335 -17.290580419139143 -14.068780429954163
        -14.55378292053932 -16.35243287569615 -11.430884099341844
        -16.681515012131563 -14.50219744273151 -9.672286545589401
        -24.391061233337098 -18.6326525993849 -9.672286545589401
        -23.83126732385191 -21.421035575792477 -11.430884099341844
        -22.241002266873895 -20.50894768630381 -14.068780429954163
        -22.263329141744826 -18.6326525993849 -7.03439021497711
        -20.673064084766953 -15.870329276964627 -7.03439021497711
        -20.673064084766953 -21.421035575792477 -7.03439021497711
        -21.703535232259668 -23.27127100875717 -9.672286545589401
        -17.49253397081092 -15.870329276964627 -7.03439021497711
        -9.010229802964306 -21.421035575792477 4.396493884364761
        -10.59725078409709 -18.6326525993849 5.275792661224669
        -9.010229802964306 -21.421035575792477 9.672286545589401
        -10.59725078409709 -18.6326525993849 8.792987768729494
        -7.960675856413003 -23.27127100875717 7.03439021497711
        -13.774536822240663 -18.6326525993849 9.672286545589401
        -9.54769683757856 -26.059653985164775 7.03439021497711
        -9.010229802964306 -21.421035575792477 -4.396493884364761
        -10.59725078409709 -18.6326525993849 -5.275792661224669
        -9.010229802964306 -21.421035575792477 -9.672286545589401
        -10.59725078409709 -18.6326525993849 -8.792987768729494
        -7.960675856413003 -23.27127100875717 -7.03439021497711
        -13.774536822240663 -18.6326525993849 -4.396493884364761
        -9.54769683757856 -26.059653985164775 -7.03439021497711
        15.348867742018532 -2.8014128034045473 4.396493884364761
        16.939132798996518 -8.459657271365858e-16 5.275792661224669
        16.939132798996518 -4.664678063359602 2.6378963306188514
        19.082799027788937 -2.8014128034045473 1.7585975537458989
        19.082799027788937 -8.459657271365858e-16 3.5171951075048264
        16.939132798996518 -8.459657271365858e-16 -5.275792661224669
        15.348867742018532 -2.8014128034045473 -4.396493884364761
        16.939132798996518 -4.664678063359602 -2.6378963306188514
        19.082799027788937 -2.8014128034045473 -1.7585975537458989
        19.082799027788937 -8.459657271365858e-16 -3.5171951075048264
        12.677275878141138 -1.86326525993849 2.6378963306188514
        12.677275878141138 1.86326525993849 2.6378963306188514
        15.348867742018532 2.8014128034045473 4.396493884364761
        12.677275878141138 1.86326525993849 -2.6378963306188514
        12.677275878141138 -1.86326525993849 -2.6378963306188514
        15.348867742018532 2.8014128034045473 -4.396493884364761
        15.348867742018532 -5.589795779808861 0.0
        12.677275878141138 -3.7265305198835748 0.0
        12.677275878141138 3.7265305198835748 0.0
        16.939132798996518 4.664678063359602 2.6378963306188514
        19.082799027788937 2.8014128034045473 1.7585975537458989
        16.939132798996518 4.664678063359602 -2.6378963306188514
        19.082799027788937 2.8014128034045473 -1.7585975537458989
        15.348867742018532 5.589795779808861 0.0
        16.939132798996518 -8.459657271365858e-16 -19.344573091211345
        15.348867742018532 -2.8014128034045473 -18.465274314318897
        16.939132798996518 -4.664678063359602 -16.706676760566484
        19.082799027788937 -2.8014128034045473 -15.827377983706578
        19.082799027788937 -8.459657271365858e-16 -17.58597553745899
        15.348867742018532 -2.8014128034045473 -9.672286545589401
        16.939132798996518 -8.459657271365858e-16 -8.792987768729494
        16.939132798996518 -4.664678063359602 -11.430884099341844
        19.082799027788937 -2.8014128034045473 -12.310182876201779
        19.082799027788937 -8.459657271365858e-16 -10.551585322481909
        12.677275878141138 1.86326525993849 -16.706676760566484
        12.677275878141138 -1.86326525993849 -16.706676760566484
        15.348867742018532 2.8014128034045473 -18.465274314318897
        12.677275878141138 -1.86326525993849 -11.430884099341844
        12.677275878141138 1.86326525993849 -11.430884099341844
        15.348867742018532 2.8014128034045473 -9.672286545589401
        15.348867742018532 -5.589795779808861 -14.068780429954163
        12.677275878141138 -3.7265305198835748 -14.068780429954163
        12.677275878141138 3.7265305198835748 -14.068780429954163
        16.939132798996518 4.664678063359602 -16.706676760566484
        19.082799027788937 2.8014128034045473 -15.827377983706578
        16.939132798996518 4.664678063359602 -11.430884099341844
        19.082799027788937 2.8014128034045473 -12.310182876201779
        15.348867742018532 5.589795779808861 -14.068780429954163
        -16.681515012131563 -9.837519379404997 -2.6378963306188514
        -15.091249955153517 -8.886342008935404 0.0
        -16.681515012131563 -9.837519379404997 2.6378963306188514
        -11.882191056629125 -15.414285332220206 1.7585975537458989
        -11.882191056629125 -15.414285332220206 -1.7585975537458989
        -14.55378292053932 -16.35243287569615 -2.6378963306188514
        -12.41965809124335 -12.61287252881901 -2.6378963306188514
        -12.41965809124335 -10.749607268893666 0.0
        -15.091249955153517 -11.700784639330314 -4.396493884364761
        -12.41965809124335 -12.61287252881901 2.6378963306188514
        -15.091249955153517 -11.700784639330314 4.396493884364761
        -16.681515012131563 -14.50219744273151 -4.396493884364761
        -16.681515012131563 -9.837519379404997 -16.706676760566484
        -15.091249955153517 -8.886342008935404 -14.068780429954163
        -16.681515012131563 -9.837519379404997 -11.430884099341844
        -11.882191056629125 -15.414285332220206 -15.827377983706578
        -11.882191056629125 -15.414285332220206 -12.310182876201779
        -14.55378292053932 -16.35243287569615 -16.706676760566484
        -12.41965809124335 -12.61287252881901 -16.706676760566484
        -12.41965809124335 -10.749607268893666 -14.068780429954163
        -15.091249955153517 -11.700784639330314 -18.465274314318897
        -12.41965809124335 -12.61287252881901 -11.430884099341844
        -16.681515012131563 -14.50219744273151 -18.465274314318897
        -15.091249955153517 -11.700784639330314 -9.672286545589401
        -6.6408140616744245 -20.743484572189303 2.6378963306188514
        -7.146508235907948 -17.9551015957817 1.7585975537458989
        -9.51592397719777 -16.782417166453207 3.5171951075048264
        -6.6408140616744245 -20.743484572189303 11.430884099341844
        -7.146508235907948 -17.9551015957817 12.310182876201779
        -9.51592397719777 -16.782417166453207 10.551585322481909
        -4.780241156476506 -23.297330662744386 7.03439021497711
        -3.9978463963194684 -21.68163211566527 4.396493884364761
        -3.9978463963194684 -21.68163211566527 9.672286545589401
        -2.4044326775027196 -18.893249139224636 4.396493884364761
        -4.503540570552933 -17.016954052305813 2.6378963306188514
        -1.593413718820043 -17.72056470989629 7.03439021497711
        -5.28593533071 -14.93218173348857 4.396493884364761
        -3.1868274376400803 -14.93218173348857 7.03439021497711
        -2.4044326775027196 -18.893249139224636 9.672286545589401
        -4.503540570552933 -17.016954052305813 11.430884099341844
        -8.466370030679181 -14.93218173348857 5.275792661224669
        -8.466370030679181 -14.93218173348857 8.792987768729494
        -5.28593533071 -14.93218173348857 9.672286545589401
        -6.6408140616744245 -20.743484572189303 -2.6378963306188514
        -7.146508235907948 -17.9551015957817 -1.7585975537458989
        -9.51592397719777 -16.782417166453207 -3.5171951075048264
        -6.6408140616744245 -20.743484572189303 -11.430884099341844
        -7.146508235907948 -17.9551015957817 -12.310182876201779
        -9.51592397719777 -16.782417166453207 -10.551585322481909
        -4.780241156476506 -23.297330662744386 -7.03439021497711
        -3.9978463963194684 -21.68163211566527 -9.672286545589401
        -3.9978463963194684 -21.68163211566527 -4.396493884364761
        -2.4044326775027196 -18.893249139224636 -9.672286545589401
        -4.503540570552933 -17.016954052305813 -11.430884099341844
        -1.593413718820043 -17.72056470989629 -7.03439021497711
        -5.28593533071 -14.93218173348857 -9.672286545589401
        -3.1868274376400803 -14.93218173348857 -7.03439021497711
        -2.4044326775027196 -18.893249139224636 -4.396493884364761
        -4.503540570552933 -17.016954052305813 -2.6378963306188514
        -8.466370030679181 -14.93218173348857 -5.275792661224669
        -5.28593533071 -14.93218173348857 -4.396493884364761
        -8.466370030679181 -14.93218173348857 -8.792987768729494
        10.053391011811994 -12.130768930087344 4.396493884364761
        7.922510258361315 -10.267503670162085 2.6378963306188514
        11.134717818711342 -10.267503670162085 7.03439021497711
        9.54769683757856 -7.479120693754452 7.03439021497711
        7.416816084127879 -7.479120693754452 4.396493884364761
        8.466370030679181 -14.93218173348857 5.275792661224669
        4.742075558392105 -12.130768930087344 2.6378963306188514
        5.28593533071 -14.93218173348857 4.396493884364761
        10.053391011811994 -12.130768930087344 9.672286545589401
        8.466370030679181 -14.93218173348857 8.792987768729494
        7.922510258361315 -10.267503670162085 11.430884099341844
        4.742075558392105 -12.130768930087344 11.430884099341844
        5.28593533071 -14.93218173348857 9.672286545589401
        7.416816084127879 -7.479120693754452 9.672286545589401
        4.236381384158668 -7.479120693754452 5.275792661224669
        4.236381384158668 -7.479120693754452 8.792987768729494
        2.6429676653484284 -10.267503670162085 4.396493884364761
        1.593413718820043 -12.130768930087344 7.03439021497711
        3.1868274376400803 -14.93218173348857 7.03439021497711
        2.6429676653484284 -10.267503670162085 9.672286545589401
        10.053391011811994 -12.130768930087344 -9.672286545589401
        7.922510258361315 -10.267503670162085 -11.430884099341844
        11.134717818711342 -10.267503670162085 -7.03439021497711
        9.54769683757856 -7.479120693754452 -7.03439021497711
        7.416816084127879 -7.479120693754452 -9.672286545589401
        10.053391011811994 -12.130768930087344 -4.396493884364761
        8.466370030679181 -14.93218173348857 -5.275792661224669
        7.922510258361315 -10.267503670162085 -2.6378963306188514
        4.742075558392105 -12.130768930087344 -2.6378963306188514
        5.28593533071 -14.93218173348857 -4.396493884364761
        8.466370030679181 -14.93218173348857 -8.792987768729494
        4.742075558392105 -12.130768930087344 -11.430884099341844
        5.28593533071 -14.93218173348857 -9.672286545589401
        7.416816084127879 -7.479120693754452 -4.396493884364761
        4.236381384158668 -7.479120693754452 -5.275792661224669
        4.236381384158668 -7.479120693754452 -8.792987768729494
        2.6429676653484284 -10.267503670162085 -9.672286545589401
        1.593413718820043 -12.130768930087344 -7.03439021497711
        3.1868274376400803 -14.93218173348857 -7.03439021497711
        2.6429676653484284 -10.267503670162085 -4.396493884364761
        -11.882191056629125 15.414285332220206 1.7585975537458989
        -12.41965809124335 12.61287252881901 2.6378963306188514
        -14.55378292053932 16.35243287569615 2.6378963306188514
        -16.681515012131563 14.50219744273151 4.396493884364761
        -15.091249955153517 11.700784639330314 4.396493884364761
        -11.882191056629125 15.414285332220206 12.310182876201779
        -12.41965809124335 12.61287252881901 11.430884099341844
        -14.55378292053932 16.35243287569615 11.430884099341844
        -16.681515012131563 14.50219744273151 9.672286545589401
        -15.091249955153517 11.700784639330314 9.672286545589401
        -9.51592397719777 16.782417166453207 3.5171951075048264
        -10.053391011811994 12.130768930087344 4.396493884364761
        -8.466370030679181 14.93218173348857 5.275792661224669
        -9.51592397719777 16.782417166453207 10.551585322481909
        -8.466370030679181 14.93218173348857 8.792987768729494
        -10.053391011811994 12.130768930087344 9.672286545589401
        -15.902268913832875 18.6326525993849 7.03439021497711
        -17.49253397081092 15.870329276964627 7.03439021497711
        -13.774536822240663 18.6326525993849 9.672286545589401
        -13.774536822240663 18.6326525993849 4.396493884364761
        -10.59725078409709 18.6326525993849 5.275792661224669
        -10.59725078409709 18.6326525993849 8.792987768729494
        -11.134717818711342 10.267503670162085 7.03439021497711
        -14.31200385685486 10.267503670162085 7.03439021497711
        -11.882191056629125 15.414285332220206 -1.7585975537458989
        -12.41965809124335 12.61287252881901 -2.6378963306188514
        -14.55378292053932 16.35243287569615 -2.6378963306188514
        -16.681515012131563 14.50219744273151 -4.396493884364761
        -15.091249955153517 11.700784639330314 -4.396493884364761
        -11.882191056629125 15.414285332220206 -12.310182876201779
        -12.41965809124335 12.61287252881901 -11.430884099341844
        -14.55378292053932 16.35243287569615 -11.430884099341844
        -16.681515012131563 14.50219744273151 -9.672286545589401
        -15.091249955153517 11.700784639330314 -9.672286545589401
        -9.51592397719777 16.782417166453207 -3.5171951075048264
        -8.466370030679181 14.93218173348857 -5.275792661224669
        -10.053391011811994 12.130768930087344 -4.396493884364761
        -9.51592397719777 16.782417166453207 -10.551585322481909
        -10.053391011811994 12.130768930087344 -9.672286545589401
        -8.466370030679181 14.93218173348857 -8.792987768729494
        -15.902268913832875 18.6326525993849 -7.03439021497711
        -17.49253397081092 15.870329276964627 -7.03439021497711
        -13.774536822240663 18.6326525993849 -4.396493884364761
        -13.774536822240663 18.6326525993849 -9.672286545589401
        -10.59725078409709 18.6326525993849 -5.275792661224669
        -10.59725078409709 18.6326525993849 -8.792987768729494
        -11.134717818711342 10.267503670162085 -7.03439021497711
        -14.31200385685486 10.267503670162085 -7.03439021497711
        -23.85359419872287 -4.664678063359602 7.03439021497711
        -20.673064084766953 -7.479120693754452 4.396493884364761
        -17.49253397081092 -7.479120693754452 4.396493884364761
        -16.939132798996518 -4.664678063359602 2.6378963306188514
        -17.49253397081092 -7.479120693754452 9.672286545589401
        -16.939132798996518 -4.664678063359602 11.430884099341844
        -20.673064084766953 -7.479120693754452 9.672286545589401
        -22.263329141744826 -7.479120693754452 7.03439021497711
        -16.939132798996518 -6.7677258170926405e-16 5.275792661224669
        -16.939132798996518 -6.7677258170926405e-16 8.792987768729494
        -14.31200385685486 -4.664678063359602 7.03439021497711
        -15.348867742018532 -2.8014128034045473 9.672286545589401
        -15.348867742018532 -2.8014128034045473 4.396493884364761
        -15.902268913832875 -7.479120693754452 7.03439021497711
        -23.85359419872287 -4.664678063359602 -7.03439021497711
        -17.49253397081092 -7.479120693754452 -4.396493884364761
        -16.939132798996518 -4.664678063359602 -2.6378963306188514
        -20.673064084766953 -7.479120693754452 -4.396493884364761
        -20.673064084766953 -7.479120693754452 -9.672286545589401
        -17.49253397081092 -7.479120693754452 -9.672286545589401
        -16.939132798996518 -4.664678063359602 -11.430884099341844
        -22.263329141744826 -7.479120693754452 -7.03439021497711
        -16.939132798996518 -6.7677258170926405e-16 -5.275792661224669
        -16.939132798996518 -6.7677258170926405e-16 -8.792987768729494
        -14.31200385685486 -4.664678063359602 -7.03439021497711
        -15.348867742018532 -2.8014128034045473 -4.396493884364761
        -15.348867742018532 -2.8014128034045473 -9.672286545589401
        -15.902268913832875 -7.479120693754452 -7.03439021497711
        -12.41965809124335 10.749607268893666 0.0
        -16.144047977517335 17.290580419139143 0.0
        -19.082799027788937 15.922448584939174 0.0
        -19.082799027788937 14.072213151974479 -2.6378963306188514
        -19.082799027788937 14.072213151974479 2.6378963306188514
        -15.091249955153517 8.886342008935404 0.0
        -16.681515012131563 9.837519379404997 2.6378963306188514
        -16.681515012131563 9.837519379404997 -2.6378963306188514
        -19.082799027788937 11.270800348573166 1.7585975537458989
        -19.082799027788937 11.270800348573166 -1.7585975537458989
        -12.41965809124335 10.749607268893666 -14.068780429954163
        -16.144047977517335 17.290580419139143 -14.068780429954163
        -19.082799027788937 15.922448584939174 -14.068780429954163
        -19.082799027788937 14.072213151974479 -16.706676760566484
        -19.082799027788937 14.072213151974479 -11.430884099341844
        -15.091249955153517 8.886342008935404 -14.068780429954163
        -16.681515012131563 9.837519379404997 -11.430884099341844
        -16.681515012131563 9.837519379404997 -16.706676760566484
        -19.082799027788937 11.270800348573166 -15.827377983706578
        -19.082799027788937 11.270800348573166 -12.310182876201779
        2.4044326775027196 18.893249139224636 4.396493884364761
        3.9978463963194684 21.68163211566527 4.396493884364761
        0.0 19.127786025110186 2.6378963306188514
        2.4044326775027196 23.531867548596992 2.6378963306188514
        0.0 21.916169001517765 1.7585975537458989
        3.9978463963194684 21.68163211566527 -4.396493884364761
        2.4044326775027196 23.531867548596992 -2.6378963306188514
        2.4044326775027196 18.893249139224636 -4.396493884364761
        0.0 19.127786025110186 -2.6378963306188514
        0.0 21.916169001517765 -1.7585975537458989
        6.6408140616744245 20.743484572189303 -2.6378963306188514
        6.6408140616744245 22.593720005120908 0.0
        7.146508235907948 17.9551015957817 1.7585975537458989
        6.6408140616744245 20.743484572189303 2.6378963306188514
        7.146508235907948 17.9551015957817 -1.7585975537458989
        3.9978463963194684 24.443955438085602 0.0
        4.503540570552933 17.016954052305813 2.6378963306188514
        4.503540570552933 17.016954052305813 -2.6378963306188514
        2.910126851736211 16.078806508829786 0.0
        0.0 17.25149093815825 0.0
        3.9978463963194684 21.68163211566527 -18.465274314318897
        2.4044326775027196 23.531867548596992 -16.706676760566484
        2.4044326775027196 18.893249139224636 -18.465274314318897
        0.0 19.127786025110186 -16.706676760566484
        0.0 21.916169001517765 -15.827377983706578
        2.4044326775027196 18.893249139224636 -9.672286545589401
        3.9978463963194684 21.68163211566527 -9.672286545589401
        0.0 19.127786025110186 -11.430884099341844
        2.4044326775027196 23.531867548596992 -11.430884099341844
        0.0 21.916169001517765 -12.310182876201779
        6.6408140616744245 20.743484572189303 -16.706676760566484
        6.6408140616744245 22.593720005120908 -14.068780429954163
        7.146508235907948 17.9551015957817 -15.827377983706578
        7.146508235907948 17.9551015957817 -12.310182876201779
        6.6408140616744245 20.743484572189303 -11.430884099341844
        3.9978463963194684 24.443955438085602 -14.068780429954163
        4.503540570552933 17.016954052305813 -16.706676760566484
        4.503540570552933 17.016954052305813 -11.430884099341844
        2.910126851736211 16.078806508829786 -14.068780429954163
        0.0 17.25149093815825 -14.068780429954163
        -1.593413718820043 -2.8014128034045473 7.03439021497711
        -3.1868274376400803 -6.7677258170926405e-16 7.03439021497711
        -2.6429676653484284 -4.664678063359602 4.396493884364761
        -4.742075558392105 -2.8014128034045473 2.6378963306188514
        -5.28593533071 -6.7677258170926405e-16 4.396493884364761
        -10.053391011811994 -2.8014128034045473 9.672286545589401
        -11.134717818711342 -4.664678063359602 7.03439021497711
        -10.053391011811994 -2.8014128034045473 4.396493884364761
        -8.466370030679181 -6.7677258170926405e-16 5.275792661224669
        -8.466370030679181 -6.7677258170926405e-16 8.792987768729494
        -7.922510258361315 -4.664678063359602 11.430884099341844
        -7.416816084127879 -7.479120693754452 9.672286545589401
        -9.54769683757856 -7.479120693754452 7.03439021497711
        -2.6429676653484284 -4.664678063359602 9.672286545589401
        -4.742075558392105 -2.8014128034045473 11.430884099341844
        -5.28593533071 -6.7677258170926405e-16 9.672286545589401
        -4.236381384158668 -7.479120693754452 5.275792661224669
        -4.236381384158668 -7.479120693754452 8.792987768729494
        -7.922510258361315 -4.664678063359602 2.6378963306188514
        -7.416816084127879 -7.479120693754452 4.396493884364761
        -1.593413718820043 -2.8014128034045473 -7.03439021497711
        -3.1868274376400803 -6.7677258170926405e-16 -7.03439021497711
        -2.6429676653484284 -4.664678063359602 -9.672286545589401
        -4.742075558392105 -2.8014128034045473 -11.430884099341844
        -5.28593533071 -6.7677258170926405e-16 -9.672286545589401
        -10.053391011811994 -2.8014128034045473 -4.396493884364761
        -11.134717818711342 -4.664678063359602 -7.03439021497711
        -8.466370030679181 -6.7677258170926405e-16 -5.275792661224669
        -10.053391011811994 -2.8014128034045473 -9.672286545589401
        -8.466370030679181 -6.7677258170926405e-16 -8.792987768729494
        -7.922510258361315 -4.664678063359602 -2.6378963306188514
        -7.416816084127879 -7.479120693754452 -4.396493884364761
        -9.54769683757856 -7.479120693754452 -7.03439021497711
        -2.6429676653484284 -4.664678063359602 -4.396493884364761
        -4.742075558392105 -2.8014128034045473 -2.6378963306188514
        -5.28593533071 -6.7677258170926405e-16 -4.396493884364761
        -4.236381384158668 -7.479120693754452 -5.275792661224669
        -4.236381384158668 -7.479120693754452 -8.792987768729494
        -7.922510258361315 -4.664678063359602 -11.430884099341844
        -7.416816084127879 -7.479120693754452 -9.672286545589401
        -3.1868274376400803 26.059653985164775 7.03439021497711
        -4.780241156476506 23.297330662744386 7.03439021497711
        -1.593413718820043 26.059653985164775 4.396493884364761
        -3.9978463963194684 21.68163211566527 4.396493884364761
        -2.4044326775027196 23.531867548596992 2.6378963306188514
        -1.593413718820043 26.059653985164775 9.672286545589401
        -3.9978463963194684 21.68163211566527 9.672286545589401
        -2.4044326775027196 23.531867548596992 11.430884099341844
        1.593413718820043 26.059653985164775 9.672286545589401
        3.1868274376400803 26.059653985164775 7.03439021497711
        4.780241156476506 23.297330662744386 7.03439021497711
        1.593413718820043 26.059653985164775 4.396493884364761
        1.593413718820043 17.72056470989629 7.03439021497711
        -1.593413718820043 17.72056470989629 7.03439021497711
        -2.4044326775027196 18.893249139224636 9.672286545589401
        -2.4044326775027196 18.893249139224636 4.396493884364761
        -3.1868274376400803 26.059653985164775 -7.03439021497711
        -4.780241156476506 23.297330662744386 -7.03439021497711
        -1.593413718820043 26.059653985164775 -9.672286545589401
        -3.9978463963194684 21.68163211566527 -9.672286545589401
        -2.4044326775027196 23.531867548596992 -11.430884099341844
        -1.593413718820043 26.059653985164775 -4.396493884364761
        -3.9978463963194684 21.68163211566527 -4.396493884364761
        -2.4044326775027196 23.531867548596992 -2.6378963306188514
        1.593413718820043 26.059653985164775 -4.396493884364761
        3.1868274376400803 26.059653985164775 -7.03439021497711
        4.780241156476506 23.297330662744386 -7.03439021497711
        1.593413718820043 26.059653985164775 -9.672286545589401
        1.593413718820043 17.72056470989629 -7.03439021497711
        -1.593413718820043 17.72056470989629 -7.03439021497711
        -2.4044326775027196 18.893249139224636 -4.396493884364761
        -2.4044326775027196 18.893249139224636 -9.672286545589401
        10.053391011811994 -2.8014128034045473 4.396493884364761
        8.466370030679181 -8.459657271365858e-16 5.275792661224669
        10.053391011811994 2.8014128034045473 4.396493884364761
        10.053391011811994 -2.8014128034045473 9.672286545589401
        8.466370030679181 -8.459657271365858e-16 8.792987768729494
        10.053391011811994 2.8014128034045473 9.672286545589401
        11.134717818711342 -4.664678063359602 7.03439021497711
        14.31200385685486 4.664678063359602 7.03439021497711
        11.134717818711342 4.664678063359602 7.03439021497711
        10.053391011811994 -2.8014128034045473 -4.396493884364761
        8.466370030679181 -8.459657271365858e-16 -5.275792661224669
        10.053391011811994 2.8014128034045473 -4.396493884364761
        10.053391011811994 -2.8014128034045473 -9.672286545589401
        8.466370030679181 -8.459657271365858e-16 -8.792987768729494
        10.053391011811994 2.8014128034045473 -9.672286545589401
        11.134717818711342 -4.664678063359602 -7.03439021497711
        14.31200385685486 4.664678063359602 -7.03439021497711
        11.134717818711342 4.664678063359602 -7.03439021497711
        17.49253397081092 21.421035575792477 7.03439021497711
        14.334330731693221 21.421035575792477 11.430884099341844
        16.462062823318202 23.27127100875717 9.672286545589401
        14.334330731693221 21.421035575792477 2.6378963306188514
        16.462062823318202 23.27127100875717 4.396493884364761
        9.010229802964306 21.421035575792477 4.396493884364761
        11.15704469358236 23.27127100875717 2.6378963306188514
        9.010229802964306 21.421035575792477 9.672286545589401
        11.15704469358236 23.27127100875717 11.430884099341844
        14.871797766340187 26.059653985164775 5.275792661224669
        14.871797766340187 26.059653985164775 8.792987768729494
        9.54769683757856 26.059653985164775 7.03439021497711
        11.694511728196614 26.059653985164775 9.672286545589401
        11.694511728196614 26.059653985164775 4.396493884364761
        7.960675856413003 23.27127100875717 7.03439021497711
        17.49253397081092 21.421035575792477 -7.03439021497711
        14.334330731693221 21.421035575792477 -2.6378963306188514
        16.462062823318202 23.27127100875717 -4.396493884364761
        14.334330731693221 21.421035575792477 -11.430884099341844
        16.462062823318202 23.27127100875717 -9.672286545589401
        9.010229802964306 21.421035575792477 -4.396493884364761
        11.15704469358236 23.27127100875717 -2.6378963306188514
        9.010229802964306 21.421035575792477 -9.672286545589401
        11.15704469358236 23.27127100875717 -11.430884099341844
        14.871797766340187 26.059653985164775 -5.275792661224669
        14.871797766340187 26.059653985164775 -8.792987768729494
        9.54769683757856 26.059653985164775 -7.03439021497711
        11.694511728196614 26.059653985164775 -4.396493884364761
        11.694511728196614 26.059653985164775 -9.672286545589401
        7.960675856413003 23.27127100875717 -7.03439021497711
        -15.348867742018532 -5.589795779808861 0.0
        -15.348867742018532 -5.589795779808861 -14.068780429954163
        -9.509531239526872 9.316326299692436 0.0
        -7.922510258361315 10.267503670162085 2.6378963306188514
        -3.148661839585162 13.04285681957598 0.0
        -4.742075558392105 12.130768930087344 -2.6378963306188514
        -4.742075558392105 12.130768930087344 2.6378963306188514
        -7.922510258361315 10.267503670162085 -2.6378963306188514
        -7.146508235907948 17.9551015957817 1.7585975537458989
        -7.146508235907948 17.9551015957817 -1.7585975537458989
        -5.28593533071 14.93218173348857 -4.396493884364761
        -4.503540570552933 17.016954052305813 -2.6378963306188514
        -2.910126851736211 16.078806508829786 0.0
        -5.28593533071 14.93218173348857 4.396493884364761
        -4.503540570552933 17.016954052305813 2.6378963306188514
        -9.509531239526872 9.316326299692436 -14.068780429954163
        -7.922510258361315 10.267503670162085 -11.430884099341844
        -3.148661839585162 13.04285681957598 -14.068780429954163
        -4.742075558392105 12.130768930087344 -16.706676760566484
        -4.742075558392105 12.130768930087344 -11.430884099341844
        -7.922510258361315 10.267503670162085 -16.706676760566484
        -7.146508235907948 17.9551015957817 -15.827377983706578
        -7.146508235907948 17.9551015957817 -12.310182876201779
        -5.28593533071 14.93218173348857 -18.465274314318897
        -4.503540570552933 17.016954052305813 -16.706676760566484
        -2.910126851736211 16.078806508829786 -14.068780429954163
        -5.28593533071 14.93218173348857 -9.672286545589401
        -4.503540570552933 17.016954052305813 -11.430884099341844
        0.0 5.589795779808861 2.6378963306188514
        0.0 3.7265305198835748 0.0
        -2.6429676653484284 4.664678063359602 4.396493884364761
        -3.148661839585162 1.86326525993849 0.0
        -4.742075558392105 2.8014128034045473 2.6378963306188514
        0.0 9.316326299692436 2.6378963306188514
        0.0 9.316326299692436 -2.6378963306188514
        0.0 5.589795779808861 -2.6378963306188514
        0.0 11.179591559617721 0.0
        -9.509531239526872 5.589795779808861 0.0
        -7.922510258361315 4.664678063359602 2.6378963306188514
        -7.416816084127879 7.479120693754452 4.396493884364761
        -2.6429676653484284 10.267503670162085 4.396493884364761
        -4.236381384158668 7.479120693754452 5.275792661224669
        -2.6429676653484284 10.267503670162085 -4.396493884364761
        -2.6429676653484284 4.664678063359602 -4.396493884364761
        -4.236381384158668 7.479120693754452 -5.275792661224669
        -4.742075558392105 2.8014128034045473 -2.6378963306188514
        -7.922510258361315 4.664678063359602 -2.6378963306188514
        -7.416816084127879 7.479120693754452 -4.396493884364761
        0.0 5.589795779808861 -11.430884099341844
        0.0 3.7265305198835748 -14.068780429954163
        -2.6429676653484284 4.664678063359602 -9.672286545589401
        -3.148661839585162 1.86326525993849 -14.068780429954163
        -4.742075558392105 2.8014128034045473 -11.430884099341844
        0.0 9.316326299692436 -16.706676760566484
        0.0 5.589795779808861 -16.706676760566484
        0.0 9.316326299692436 -11.430884099341844
        0.0 11.179591559617721 -14.068780429954163
        -9.509531239526872 5.589795779808861 -14.068780429954163
        -7.922510258361315 4.664678063359602 -11.430884099341844
        -7.416816084127879 7.479120693754452 -9.672286545589401
        -2.6429676653484284 10.267503670162085 -18.465274314318897
        -2.6429676653484284 4.664678063359602 -18.465274314318897
        -4.236381384158668 7.479120693754452 -19.344573091211345
        -2.6429676653484284 10.267503670162085 -9.672286545589401
        -4.236381384158668 7.479120693754452 -8.792987768729494
        -4.742075558392105 2.8014128034045473 -16.706676760566484
        -7.922510258361315 4.664678063359602 -16.706676760566484
        -7.416816084127879 7.479120693754452 -18.465274314318897
        7.146508235907948 -17.9551015957817 1.7585975537458989
        7.146508235907948 -17.9551015957817 -1.7585975537458989
        6.6408140616744245 -22.593720005120908 0.0
        6.6408140616744245 -20.743484572189303 -2.6378963306188514
        6.6408140616744245 -20.743484572189303 2.6378963306188514
        2.910126851736211 -16.078806508829786 0.0
        4.503540570552933 -17.016954052305813 2.6378963306188514
        4.503540570552933 -17.016954052305813 -2.6378963306188514
        0.0 -19.127786025110186 2.6378963306188514
        0.0 -17.25149093815825 0.0
        2.4044326775027196 -18.893249139224636 4.396493884364761
        0.0 -21.916169001517765 1.7585975537458989
        0.0 -21.916169001517765 -1.7585975537458989
        0.0 -19.127786025110186 -2.6378963306188514
        2.4044326775027196 -23.531867548596992 -2.6378963306188514
        3.9978463963194684 -21.68163211566527 -4.396493884364761
        3.9978463963194684 -24.443955438085602 0.0
        2.4044326775027196 -23.531867548596992 2.6378963306188514
        3.9978463963194684 -21.68163211566527 4.396493884364761
        2.4044326775027196 -18.893249139224636 -4.396493884364761
        7.146508235907948 -17.9551015957817 -15.827377983706578
        7.146508235907948 -17.9551015957817 -12.310182876201779
        6.6408140616744245 -22.593720005120908 -14.068780429954163
        6.6408140616744245 -20.743484572189303 -16.706676760566484
        6.6408140616744245 -20.743484572189303 -11.430884099341844
        2.910126851736211 -16.078806508829786 -14.068780429954163
        4.503540570552933 -17.016954052305813 -11.430884099341844
        4.503540570552933 -17.016954052305813 -16.706676760566484
        0.0 -19.127786025110186 -11.430884099341844
        0.0 -17.25149093815825 -14.068780429954163
        2.4044326775027196 -18.893249139224636 -9.672286545589401
        0.0 -21.916169001517765 -15.827377983706578
        0.0 -19.127786025110186 -16.706676760566484
        0.0 -21.916169001517765 -12.310182876201779
        2.4044326775027196 -23.531867548596992 -16.706676760566484
        3.9978463963194684 -21.68163211566527 -18.465274314318897
        3.9978463963194684 -24.443955438085602 -14.068780429954163
        2.4044326775027196 -18.893249139224636 -18.465274314318897
        2.4044326775027196 -23.531867548596992 -11.430884099341844
        3.9978463963194684 -21.68163211566527 -9.672286545589401
        7.922510258361315 -4.664678063359602 2.6378963306188514
        9.509531239526872 -5.589795779808861 0.0
        3.148661839585162 1.86326525993849 0.0
        4.742075558392105 2.8014128034045473 2.6378963306188514
        4.742075558392105 -2.8014128034045473 2.6378963306188514
        5.28593533071 -8.459657271365858e-16 4.396493884364761
        3.148661839585162 -1.86326525993849 0.0
        9.509531239526872 5.589795779808861 0.0
        7.922510258361315 4.664678063359602 -2.6378963306188514
        4.742075558392105 2.8014128034045473 -2.6378963306188514
        7.922510258361315 4.664678063359602 2.6378963306188514
        7.922510258361315 -4.664678063359602 -2.6378963306188514
        4.742075558392105 -2.8014128034045473 -2.6378963306188514
        5.28593533071 -8.459657271365858e-16 -4.396493884364761
        7.922510258361315 -4.664678063359602 -11.430884099341844
        9.509531239526872 -5.589795779808861 -14.068780429954163
        3.148661839585162 1.86326525993849 -14.068780429954163
        4.742075558392105 2.8014128034045473 -11.430884099341844
        4.742075558392105 -2.8014128034045473 -11.430884099341844
        5.28593533071 -8.459657271365858e-16 -9.672286545589401
        3.148661839585162 -1.86326525993849 -14.068780429954163
        9.509531239526872 5.589795779808861 -14.068780429954163
        7.922510258361315 4.664678063359602 -16.706676760566484
        4.742075558392105 2.8014128034045473 -16.706676760566484
        7.922510258361315 4.664678063359602 -11.430884099341844
        7.922510258361315 -4.664678063359602 -16.706676760566484
        4.742075558392105 -2.8014128034045473 -16.706676760566484
        5.28593533071 -8.459657271365858e-16 -18.465274314318897
        9.51592397719777 -16.782417166453207 3.5171951075048264
        9.51592397719777 -16.782417166453207 -3.5171951075048264
        10.59725078409709 -18.6326525993849 5.275792661224669
        13.774536822240663 -18.6326525993849 -4.396493884364761
        10.59725078409709 -18.6326525993849 -5.275792661224669
        11.15704469358236 -23.27127100875717 2.6378963306188514
        9.010229802964306 -21.421035575792477 4.396493884364761
        11.15704469358236 -23.27127100875717 -2.6378963306188514
        9.010229802964306 -21.421035575792477 -4.396493884364761
        14.334330731693221 -21.421035575792477 -2.6378963306188514
        9.570023712449576 -24.209418552200166 0.0
        9.51592397719777 -16.782417166453207 -17.58597553745899
        9.51592397719777 -16.782417166453207 -10.551585322481909
        13.774536822240663 -18.6326525993849 -18.465274314318897
        10.59725078409709 -18.6326525993849 -19.344573091211345
        10.59725078409709 -18.6326525993849 -8.792987768729494
        11.15704469358236 -23.27127100875717 -16.706676760566484
        9.010229802964306 -21.421035575792477 -18.465274314318897
        14.334330731693221 -21.421035575792477 -16.706676760566484
        11.15704469358236 -23.27127100875717 -11.430884099341844
        9.010229802964306 -21.421035575792477 -9.672286545589401
        9.570023712449576 -24.209418552200166 -14.068780429954163
        -6.6408140616744245 -22.593720005120908 0.0
        -6.6408140616744245 -22.593720005120908 -14.068780429954163
        9.509531239526872 -9.316326299692436 0.0
        14.31200385685486 -10.267503670162085 7.03439021497711
        9.509531239526872 -9.316326299692436 -14.068780429954163
        14.31200385685486 -10.267503670162085 -7.03439021497711
        2.6429676653484284 10.267503670162085 4.396493884364761
        4.236381384158668 7.479120693754452 5.275792661224669
        4.742075558392105 12.130768930087344 2.6378963306188514
        7.922510258361315 10.267503670162085 2.6378963306188514
        7.416816084127879 7.479120693754452 4.396493884364761
        2.6429676653484284 10.267503670162085 9.672286545589401
        4.236381384158668 7.479120693754452 8.792987768729494
        7.922510258361315 10.267503670162085 11.430884099341844
        7.416816084127879 7.479120693754452 9.672286545589401
        4.742075558392105 12.130768930087344 11.430884099341844
        1.593413718820043 12.130768930087344 7.03439021497711
        9.54769683757856 7.479120693754452 7.03439021497711
        3.1868274376400803 14.93218173348857 7.03439021497711
        5.28593533071 14.93218173348857 9.672286545589401
        5.28593533071 14.93218173348857 4.396493884364761
        2.6429676653484284 10.267503670162085 -4.396493884364761
        4.236381384158668 7.479120693754452 -5.275792661224669
        7.922510258361315 10.267503670162085 -2.6378963306188514
        7.416816084127879 7.479120693754452 -4.396493884364761
        4.742075558392105 12.130768930087344 -2.6378963306188514
        2.6429676653484284 10.267503670162085 -9.672286545589401
        4.236381384158668 7.479120693754452 -8.792987768729494
        4.742075558392105 12.130768930087344 -11.430884099341844
        7.922510258361315 10.267503670162085 -11.430884099341844
        7.416816084127879 7.479120693754452 -9.672286545589401
        1.593413718820043 12.130768930087344 -7.03439021497711
        9.54769683757856 7.479120693754452 -7.03439021497711
        3.1868274376400803 14.93218173348857 -7.03439021497711
        5.28593533071 14.93218173348857 -4.396493884364761
        5.28593533071 14.93218173348857 -9.672286545589401
        2.6429676653484284 4.664678063359602 4.396493884364761
        1.593413718820043 2.8014128034045473 7.03439021497711
        -1.593413718820043 2.8014128034045473 7.03439021497711
        1.593413718820043 -2.8014128034045473 7.03439021497711
        3.1868274376400803 -8.459657271365858e-16 7.03439021497711
        2.6429676653484284 -4.664678063359602 4.396493884364761
        -3.148661839585162 -1.86326525993849 0.0
        0.0 -3.7265305198835748 0.0
        0.0 -5.589795779808861 2.6378963306188514
        2.6429676653484284 4.664678063359602 -9.672286545589401
        1.593413718820043 2.8014128034045473 -7.03439021497711
        -1.593413718820043 2.8014128034045473 -7.03439021497711
        1.593413718820043 -2.8014128034045473 -7.03439021497711
        3.1868274376400803 -8.459657271365858e-16 -7.03439021497711
        2.6429676653484284 -4.664678063359602 -9.672286545589401
        -3.148661839585162 -1.86326525993849 -14.068780429954163
        0.0 -3.7265305198835748 -14.068780429954163
        0.0 -5.589795779808861 -11.430884099341844
        -17.49253397081092 21.421035575792477 7.03439021497711
        -22.02155007806054 17.290580419139143 14.068780429954163
        -22.241002266873895 20.50894768630381 14.068780429954163
        -22.02155007806054 17.290580419139143 0.0
        -22.241002266873895 20.50894768630381 0.0
        -17.49253397081092 21.421035575792477 -7.03439021497711
        -6.6408140616744245 -29.525587965175152 0.0
        -9.010229802964306 -30.698272394503956 4.396493884364761
        -6.6408140616744245 -31.375823398140366 2.6378963306188514
        -7.960675856413003 -28.848036961572262 7.03439021497711
        -3.9978463963194684 -24.443955438085602 0.0
        -3.9978463963194684 -27.675352532243892 0.0
        -2.4044326775027196 -23.531867548596992 2.6378963306188514
        -6.6408140616744245 -29.525587965175152 -14.068780429954163
        -9.010229802964306 -30.698272394503956 -9.672286545589401
        -6.6408140616744245 -31.375823398140366 -11.430884099341844
        -3.9978463963194684 -24.443955438085602 -14.068780429954163
        -3.9978463963194684 -27.675352532243892 -14.068780429954163
        -7.960675856413003 -28.848036961572262 -7.03439021497711
        -2.4044326775027196 -23.531867548596992 -11.430884099341844
        3.148661839585162 -13.04285681957598 0.0
        3.148661839585162 -13.04285681957598 -14.068780429954163
        2.6429676653484284 4.664678063359602 -4.396493884364761
        9.509531239526872 9.316326299692436 0.0
        3.148661839585162 13.04285681957598 0.0
        2.6429676653484284 4.664678063359602 -18.465274314318897
        9.509531239526872 9.316326299692436 -14.068780429954163
        3.148661839585162 13.04285681957598 -14.068780429954163
        -14.31200385685486 4.664678063359602 7.03439021497711
        -15.348867742018532 2.8014128034045473 4.396493884364761
        -15.902268913832875 7.479120693754452 7.03439021497711
        -17.49253397081092 7.479120693754452 4.396493884364761
        -16.939132798996518 4.664678063359602 2.6378963306188514
        -15.348867742018532 2.8014128034045473 9.672286545589401
        -22.263329141744826 7.479120693754452 7.03439021497711
        -20.673064084766953 7.479120693754452 9.672286545589401
        -20.673064084766953 7.479120693754452 4.396493884364761
        -17.49253397081092 7.479120693754452 9.672286545589401
        -16.939132798996518 4.664678063359602 11.430884099341844
        -14.31200385685486 4.664678063359602 -7.03439021497711
        -15.348867742018532 2.8014128034045473 -9.672286545589401
        -15.902268913832875 7.479120693754452 -7.03439021497711
        -17.49253397081092 7.479120693754452 -9.672286545589401
        -16.939132798996518 4.664678063359602 -11.430884099341844
        -15.348867742018532 2.8014128034045473 -4.396493884364761
        -22.263329141744826 7.479120693754452 -7.03439021497711
        -20.673064084766953 7.479120693754452 -4.396493884364761
        -20.673064084766953 7.479120693754452 -9.672286545589401
        -17.49253397081092 7.479120693754452 -4.396493884364761
        -16.939132798996518 4.664678063359602 -2.6378963306188514
        -9.010229802964306 21.421035575792477 -4.396493884364761
        -6.6408140616744245 20.743484572189303 -2.6378963306188514
        -9.010229802964306 21.421035575792477 -18.465274314318897
        -6.6408140616744245 20.743484572189303 -16.706676760566484
        -10.053391011811994 2.8014128034045473 4.396493884364761
        -12.677275878141138 1.86326525993849 2.6378963306188514
        -11.134717818711342 4.664678063359602 7.03439021497711
        -12.677275878141138 3.7265305198835748 0.0
        -9.54769683757856 7.479120693754452 7.03439021497711
        -15.348867742018532 5.589795779808861 0.0
        -10.053391011811994 2.8014128034045473 -9.672286545589401
        -12.677275878141138 1.86326525993849 -11.430884099341844
        -11.134717818711342 4.664678063359602 -7.03439021497711
        -12.677275878141138 3.7265305198835748 -14.068780429954163
        -15.348867742018532 5.589795779808861 -14.068780429954163
        -9.54769683757856 7.479120693754452 -7.03439021497711
        -1.593413718820043 12.130768930087344 7.03439021497711
        -1.593413718820043 12.130768930087344 -7.03439021497711
        9.570023712449576 24.209418552200166 0.0
        9.570023712449576 24.209418552200166 -14.068780429954163
        -12.677275878141138 -1.86326525993849 11.430884099341844
        -12.677275878141138 -1.86326525993849 2.6378963306188514
        -10.053391011811994 2.8014128034045473 9.672286545589401
        -12.677275878141138 1.86326525993849 11.430884099341844
        -12.677275878141138 -1.86326525993849 -2.6378963306188514
        -10.053391011811994 2.8014128034045473 -4.396493884364761
        -12.677275878141138 1.86326525993849 -2.6378963306188514
        -12.677275878141138 -1.86326525993849 -11.430884099341844
        -2.4044326775027196 -23.531867548596992 11.430884099341844
        -2.4044326775027196 -23.531867548596992 -2.6378963306188514
        -10.053391011811994 -12.130768930087344 9.672286545589401
        -9.509531239526872 -9.316326299692436 14.068780429954163
        -7.922510258361315 -10.267503670162085 11.430884099341844
        -14.31200385685486 -10.267503670162085 7.03439021497711
        -11.134717818711342 -10.267503670162085 7.03439021497711
        -9.509531239526872 -5.589795779808861 14.068780429954163
        -12.677275878141138 -3.7265305198835748 14.068780429954163
        -10.053391011811994 -12.130768930087344 -4.396493884364761
        -9.509531239526872 -9.316326299692436 0.0
        -7.922510258361315 -10.267503670162085 -2.6378963306188514
        -14.31200385685486 -10.267503670162085 -7.03439021497711
        -11.134717818711342 -10.267503670162085 -7.03439021497711
        -9.509531239526872 -5.589795779808861 0.0
        -12.677275878141138 -3.7265305198835748 0.0
        2.6429676653484284 -4.664678063359602 9.672286545589401
        2.6429676653484284 -4.664678063359602 -4.396493884364761
        -21.703535232259668 -23.27127100875717 9.672286545589401
        -21.703535232259668 -23.27127100875717 -4.396493884364761
        -2.910126851736211 -16.078806508829786 0.0
        1.593413718820043 -17.72056470989629 7.03439021497711
        -3.148661839585162 -13.04285681957598 0.0
        -4.742075558392105 -12.130768930087344 2.6378963306188514
        0.0 -9.316326299692436 2.6378963306188514
        -2.6429676653484284 -10.267503670162085 4.396493884364761
        -1.593413718820043 -12.130768930087344 7.03439021497711
        0.0 -11.179591559617721 0.0
        -2.910126851736211 -16.078806508829786 -14.068780429954163
        1.593413718820043 -17.72056470989629 -7.03439021497711
        -3.148661839585162 -13.04285681957598 -14.068780429954163
        -4.742075558392105 -12.130768930087344 -11.430884099341844
        0.0 -9.316326299692436 -11.430884099341844
        -2.6429676653484284 -10.267503670162085 -9.672286545589401
        -1.593413718820043 -12.130768930087344 -7.03439021497711
        0.0 -11.179591559617721 -14.068780429954163
        7.960675856413003 -23.27127100875717 7.03439021497711
        7.960675856413003 -23.27127100875717 -7.03439021497711
        4.780241156476506 -23.297330662744386 7.03439021497711
        4.780241156476506 -23.297330662744386 -7.03439021497711
        -10.053391011811994 -12.130768930087344 4.396493884364761
        -4.742075558392105 -12.130768930087344 -2.6378963306188514
        -7.922510258361315 -10.267503670162085 2.6378963306188514
        -10.053391011811994 -12.130768930087344 -9.672286545589401
        -4.742075558392105 -12.130768930087344 -16.706676760566484
        -7.922510258361315 -10.267503670162085 -11.430884099341844
        12.41965809124335 10.749607268893666 14.068780429954163
        15.091249955153517 8.886342008935404 14.068780429954163
        16.681515012131563 9.837519379404997 11.430884099341844
        12.41965809124335 10.749607268893666 0.0
        15.091249955153517 8.886342008935404 0.0
        16.681515012131563 9.837519379404997 -2.6378963306188514
        -3.1868274376400803 14.93218173348857 7.03439021497711
        -3.1868274376400803 14.93218173348857 -7.03439021497711
        0.0 -5.589795779808861 11.430884099341844
        0.0 -5.589795779808861 -2.6378963306188514
        0.0 -9.316326299692436 11.430884099341844
        -2.6429676653484284 -10.267503670162085 9.672286545589401
        0.0 -9.316326299692436 -2.6378963306188514
        -2.6429676653484284 -10.267503670162085 -4.396493884364761
        16.681515012131563 9.837519379404997 2.6378963306188514
        16.681515012131563 9.837519379404997 -11.430884099341844
        """
        self.coord = "absolute"
        self.bondlen = 3
        self.density = 0.5019985322904406

        self.cell = cellvectors(a=38.1655980555777,
                                b=52.119307970263776,
                                c=28.137560859940926)
