"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineBadgeNotification = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const codePipeline = require("@aws-cdk/aws-codepipeline");
const targets = require("@aws-cdk/aws-events-targets");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const ssm = require("@aws-cdk/aws-ssm");
const cdk = require("@aws-cdk/core");
class CodePipelineBadgeNotification extends cdk.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g;
        super(scope, id);
        this.badgeUrl = '';
        this.codePipelineLink = '';
        const pipeline = codePipeline.Pipeline.fromPipelineArn(this, 'CodePipeline', props.pipelineArn);
        const gitHubToken = ((_b = props === null || props === void 0 ? void 0 : props.gitHubTokenFromSecretsManager) === null || _b === void 0 ? void 0 : _b.secretsManagerArn) && ((_c = props === null || props === void 0 ? void 0 : props.gitHubTokenFromSecretsManager) === null || _c === void 0 ? void 0 : _c.secretKey)
            ? cdk.SecretValue.secretsManager(props.gitHubTokenFromSecretsManager.secretsManagerArn, {
                jsonField: props.gitHubTokenFromSecretsManager.secretKey,
            })
            : null;
        const targetLambda = this.createCodePipelineEventLambdaFunction(pipeline.pipelineName, gitHubToken, (_d = props === null || props === void 0 ? void 0 : props.notification) === null || _d === void 0 ? void 0 : _d.stageName, (_e = props === null || props === void 0 ? void 0 : props.notification) === null || _e === void 0 ? void 0 : _e.ssmSlackWebHookUrl, (_f = props === null || props === void 0 ? void 0 : props.notification) === null || _f === void 0 ? void 0 : _f.ssmGoogleChatWebHookUrl, (_g = props === null || props === void 0 ? void 0 : props.notification) === null || _g === void 0 ? void 0 : _g.ssmTelegramWebHookUrl);
        pipeline.onStateChange('CodePipelineChange', {
            eventPattern: {
                source: ['aws.codepipeline'],
                detailType: ['CodePipeline Pipeline Execution State Change'],
            },
            target: new targets.LambdaFunction(targetLambda),
        });
    }
    createCodePipelineEventLambdaFunction(codePipelineName, gitHubToken, stage, ssmSlackWebHookUrl, ssmGoogleChatWebHookUrl, ssmTelegramWebHookUrl) {
        var _b, _c;
        const badgeBucket = new s3.Bucket(this, 'BadgeBucket', {
            publicReadAccess: true,
        });
        const stageKeyName = stage ? `${stage}-` : '';
        const badgeBucketImageKeyName = `${stageKeyName}latest-build.svg`;
        const lambdaFunc = new lambda.DockerImageFunction(this, 'CodepipelineEventLambda', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/codepipeline-event'), {
                cmd: ['codepipelineEventLambda.handler'],
            }),
            environment: {
                STAGE: stage !== null && stage !== void 0 ? stage : '',
                SLACK_WEBHOOK_URL: ssmSlackWebHookUrl ?
                    ssm.StringParameter.valueForStringParameter(this, ssmSlackWebHookUrl) : '',
                GOOGLE_CHAT_WEBHOOK_URL: ssmGoogleChatWebHookUrl ?
                    ssm.StringParameter.valueForStringParameter(this, ssmGoogleChatWebHookUrl) : '',
                TELEGRAM_WEBHOOK_URL: ssmTelegramWebHookUrl ?
                    ssm.StringParameter.valueForStringParameter(this, ssmTelegramWebHookUrl) : '',
                BADGE_BUCKET_NAME: badgeBucket.bucketName,
                BADGE_BUCKET_IMAGE_KEY_NAME: badgeBucketImageKeyName,
                CODE_PIPELINE_NAME: codePipelineName,
                GITHUB_PERSONAL_TOKEN: gitHubToken ? `${gitHubToken}` : '',
            },
            timeout: cdk.Duration.seconds(30),
        });
        badgeBucket.grantReadWrite(lambdaFunc);
        if (ssmSlackWebHookUrl && lambdaFunc.role) {
            lambdaFunc.role.attachInlinePolicy(new iam.Policy(this, 'ssmSlackWebHookUrl', {
                statements: [
                    new iam.PolicyStatement({
                        effect: iam.Effect.ALLOW,
                        actions: ['ssm:GetParameter', 'ssm:GetParameters'],
                        resources: [`arn:aws:ssm:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:parameter/${ssmSlackWebHookUrl}`],
                    }),
                ],
            }));
        }
        if (ssmGoogleChatWebHookUrl && lambdaFunc.role) {
            lambdaFunc.role.attachInlinePolicy(new iam.Policy(this, 'ssmGoogleChatWebHookUrl', {
                statements: [
                    new iam.PolicyStatement({
                        effect: iam.Effect.ALLOW,
                        actions: ['ssm:GetParameter', 'ssm:GetParameters'],
                        resources: [`arn:aws:ssm:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:parameter/${ssmGoogleChatWebHookUrl}`],
                    }),
                ],
            }));
        }
        if (ssmTelegramWebHookUrl && lambdaFunc.role) {
            lambdaFunc.role.attachInlinePolicy(new iam.Policy(this, 'ssmTelegramWebHookUrl', {
                statements: [
                    new iam.PolicyStatement({
                        effect: iam.Effect.ALLOW,
                        actions: ['ssm:GetParameter', 'ssm:GetParameters'],
                        resources: [`arn:aws:ssm:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:parameter/${ssmTelegramWebHookUrl}`],
                    }),
                ],
            }));
        }
        const region = (_b = cdk.Aws.REGION) !== null && _b !== void 0 ? _b : 'ap-northeast-1';
        this.badgeUrl = `https://${badgeBucket.bucketName}.s3-ap-northeast-1.amazonaws.com/${badgeBucketImageKeyName}#1`;
        this.codePipelineLink = `https://${region}.console.aws.amazon.com/codesuite/codepipeline/pipelines/${codePipelineName}/view`;
        new cdk.CfnOutput(this, 'badgeMarkdownLink', {
            value: `[![Build Status](${this.badgeUrl})](${this.codePipelineLink})`,
        });
        (_c = lambdaFunc.role) === null || _c === void 0 ? void 0 : _c.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AWSCodePipeline_ReadOnlyAccess'));
        this.tagResource(lambdaFunc);
        return lambdaFunc;
    }
    tagResource(scope) {
        cdk.Tags.of(scope).add('CDK-CfnStackId', cdk.Aws.STACK_ID);
        cdk.Tags.of(scope).add('CDK-CfnStackName', cdk.Aws.STACK_NAME);
    }
}
exports.CodePipelineBadgeNotification = CodePipelineBadgeNotification;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineBadgeNotification[_a] = { fqn: "cdk-codepipeline-badge-notification.CodePipelineBadgeNotification", version: "1.0.48" };
//# sourceMappingURL=data:application/json;base64,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