# coding: utf-8

"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.10.1
    Contact: me@ariesclark.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from vrchatapi.configuration import Configuration


class GroupAuditLogEntry(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'created_at': 'datetime',
        'group_id': 'str',
        'actor_id': 'str',
        'actor_displayname': 'str',
        'target_id': 'str',
        'event_type': 'str',
        'description': 'str',
        'data': 'object'
    }

    attribute_map = {
        'id': 'id',
        'created_at': 'created_at',
        'group_id': 'groupId',
        'actor_id': 'actorId',
        'actor_displayname': 'actorDisplayname',
        'target_id': 'targetId',
        'event_type': 'eventType',
        'description': 'description',
        'data': 'data'
    }

    def __init__(self, id=None, created_at=None, group_id=None, actor_id=None, actor_displayname=None, target_id=None, event_type='group.update', description=None, data=None, local_vars_configuration=None):  # noqa: E501
        """GroupAuditLogEntry - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._created_at = None
        self._group_id = None
        self._actor_id = None
        self._actor_displayname = None
        self._target_id = None
        self._event_type = None
        self._description = None
        self._data = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if created_at is not None:
            self.created_at = created_at
        if group_id is not None:
            self.group_id = group_id
        if actor_id is not None:
            self.actor_id = actor_id
        if actor_displayname is not None:
            self.actor_displayname = actor_displayname
        if target_id is not None:
            self.target_id = target_id
        if event_type is not None:
            self.event_type = event_type
        if description is not None:
            self.description = description
        if data is not None:
            self.data = data

    @property
    def id(self):
        """Gets the id of this GroupAuditLogEntry.  # noqa: E501


        :return: The id of this GroupAuditLogEntry.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this GroupAuditLogEntry.


        :param id: The id of this GroupAuditLogEntry.  # noqa: E501
        :type id: str
        """
        if (self.local_vars_configuration.client_side_validation and
                id is not None and not re.search(r'gaud_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', id)):  # noqa: E501
            raise ValueError(r"Invalid value for `id`, must be a follow pattern or equal to `/gaud_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/`")  # noqa: E501

        self._id = id

    @property
    def created_at(self):
        """Gets the created_at of this GroupAuditLogEntry.  # noqa: E501


        :return: The created_at of this GroupAuditLogEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this GroupAuditLogEntry.


        :param created_at: The created_at of this GroupAuditLogEntry.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def group_id(self):
        """Gets the group_id of this GroupAuditLogEntry.  # noqa: E501


        :return: The group_id of this GroupAuditLogEntry.  # noqa: E501
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """Sets the group_id of this GroupAuditLogEntry.


        :param group_id: The group_id of this GroupAuditLogEntry.  # noqa: E501
        :type group_id: str
        """
        if (self.local_vars_configuration.client_side_validation and
                group_id is not None and not re.search(r'grp_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', group_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `group_id`, must be a follow pattern or equal to `/grp_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/`")  # noqa: E501

        self._group_id = group_id

    @property
    def actor_id(self):
        """Gets the actor_id of this GroupAuditLogEntry.  # noqa: E501

        A users unique ID, usually in the form of `usr_c1644b5b-3ca4-45b4-97c6-a2a0de70d469`. Legacy players can have old IDs in the form of `8JoV9XEdpo`. The ID can never be changed.  # noqa: E501

        :return: The actor_id of this GroupAuditLogEntry.  # noqa: E501
        :rtype: str
        """
        return self._actor_id

    @actor_id.setter
    def actor_id(self, actor_id):
        """Sets the actor_id of this GroupAuditLogEntry.

        A users unique ID, usually in the form of `usr_c1644b5b-3ca4-45b4-97c6-a2a0de70d469`. Legacy players can have old IDs in the form of `8JoV9XEdpo`. The ID can never be changed.  # noqa: E501

        :param actor_id: The actor_id of this GroupAuditLogEntry.  # noqa: E501
        :type actor_id: str
        """

        self._actor_id = actor_id

    @property
    def actor_displayname(self):
        """Gets the actor_displayname of this GroupAuditLogEntry.  # noqa: E501


        :return: The actor_displayname of this GroupAuditLogEntry.  # noqa: E501
        :rtype: str
        """
        return self._actor_displayname

    @actor_displayname.setter
    def actor_displayname(self, actor_displayname):
        """Sets the actor_displayname of this GroupAuditLogEntry.


        :param actor_displayname: The actor_displayname of this GroupAuditLogEntry.  # noqa: E501
        :type actor_displayname: str
        """

        self._actor_displayname = actor_displayname

    @property
    def target_id(self):
        """Gets the target_id of this GroupAuditLogEntry.  # noqa: E501

        Typically GroupID or GroupRoleID, but could be other types of IDs.  # noqa: E501

        :return: The target_id of this GroupAuditLogEntry.  # noqa: E501
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """Sets the target_id of this GroupAuditLogEntry.

        Typically GroupID or GroupRoleID, but could be other types of IDs.  # noqa: E501

        :param target_id: The target_id of this GroupAuditLogEntry.  # noqa: E501
        :type target_id: str
        """

        self._target_id = target_id

    @property
    def event_type(self):
        """Gets the event_type of this GroupAuditLogEntry.  # noqa: E501

        The type of event that occurred. This is a string that is prefixed with the type of object that the event occurred on. For example, a group role update event would be prefixed with `group.role`.  # noqa: E501

        :return: The event_type of this GroupAuditLogEntry.  # noqa: E501
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """Sets the event_type of this GroupAuditLogEntry.

        The type of event that occurred. This is a string that is prefixed with the type of object that the event occurred on. For example, a group role update event would be prefixed with `group.role`.  # noqa: E501

        :param event_type: The event_type of this GroupAuditLogEntry.  # noqa: E501
        :type event_type: str
        """

        self._event_type = event_type

    @property
    def description(self):
        """Gets the description of this GroupAuditLogEntry.  # noqa: E501

        A human-readable description of the event.  # noqa: E501

        :return: The description of this GroupAuditLogEntry.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this GroupAuditLogEntry.

        A human-readable description of the event.  # noqa: E501

        :param description: The description of this GroupAuditLogEntry.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def data(self):
        """Gets the data of this GroupAuditLogEntry.  # noqa: E501

        The data associated with the event. The format of this data is dependent on the event type.  # noqa: E501

        :return: The data of this GroupAuditLogEntry.  # noqa: E501
        :rtype: object
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this GroupAuditLogEntry.

        The data associated with the event. The format of this data is dependent on the event type.  # noqa: E501

        :param data: The data of this GroupAuditLogEntry.  # noqa: E501
        :type data: object
        """

        self._data = data

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GroupAuditLogEntry):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GroupAuditLogEntry):
            return True

        return self.to_dict() != other.to_dict()
