Markdown documentation created by [pyLODE](http://github.com/rdflib/pyLODE) 2.8.10

# ISO21972 Information technology — Upper level ontology for smart city indicators

## Metadata
* **URI**
  * `http://ontology.eil.utoronto.ca/ISO21972/iso21972`
* **Creators(s)**
  * Created by Mark S. Fox (msf@eil.utoronto.ca).
* **Version Information**
  * 0.1 8 November 2019
* **Imports**
  * [time:2016](http://www.w3.org/2006/time#2016)
* **Ontology RDF**
  * RDF ([iso21972.ttl](turtle))
### Description
<p>Draft version of the ISO 21972 Ontology.</p>
<p>Includes a subset of the GCI Foundation ontology by:</p>
<p>Fox, M.S. (2015) “The Role of Ontologies in Publishing and Analyzing City Indicators”, Computers, Environment and Urban Systems, Vol. 54, pp. 266-279.</p>
<p>Includes a subset of the OM ontology by:</p>
<p>Rijgersberg, H., Wigham, M., and Top, J.L., (2011), “How Semantics can Improve Engineering Processes: A Case of Units of Measure and Quantities”, Advanced Engineering Informatics, Vol. 25, pp. 276-287.</p>
<p>and the GovStat ontology by:</p>
<p>Pattuelli, M.C., (2003), “The GovStat Ontology: Technical Report”. The GovStat Project, Integration Design Laboratory, School of Information and Library Science, University of North Carolina at Chapel Hill, http://ils.unc.edu/govstat/papers/govstatontology.doc.</p>

## Table of Contents
1. [Classes](#classes)
1. [Object Properties](#objectproperties)
1. [Functional Properties](#functionalproperties)
1. [Datatype Properties](#datatypeproperties)
1. [Annotation Properties](#annotationproperties)
1. [Named Individuals](#namedindividuals)
1. [Namespaces](#namespaces)
1. [Legend](#legend)


## Overview

**Figure 1:** Ontology overview
## Classes
[Application_area](#Application_area),
[Binary_prefix](#Binary_prefix),
[Cardinality](#Cardinality),
[Cardinality_scale](#Cardinality_scale),
[Cardinality_unit](#Cardinality_unit),
[City](#City),
[City](#City1),
[DataTypeProperty](#DataTypeProperty),
[DateTimeInterval](#DateTimeInterval),
[Dimension](#Dimension),
[Distinct_count](#Distinct_count),
[Feature](#Feature),
[Feature](#Feature1),
[ISO21972Thing](#ISO21972Thing),
[Indicator](#Indicator),
[Mean](#Mean),
[Measurement_scale_category](#Measurement_scale_category),
[Monetary_unit](#Monetary_unit),
[ObjectProperty](#ObjectProperty),
[Observation](#Observation),
[Ordered_measurement_scale_category](#Ordered_measurement_scale_category),
[Parameter](#Parameter),
[Polygon](#Polygon),
[Population](#Population),
[RatioIndicator](#RatioIndicator),
[SI prefix](#SIprefix),
[Sample](#Sample),
[Sample_cardinality](#Sample_cardinality),
[Sample_mean](#Sample_mean),
[Sample_standard_deviation](#Sample_standard_deviation),
[Sample_sum](#Sample_sum),
[Singular_unit](#Singular_unit),
[Standard_deviation](#Standard_deviation),
[Statistic](#Statistic),
[Sum](#Sum),
[System_of_units](#System_of_units),
[Variable](#Variable),
[Vectorial_or_tensorial_character](#Vectorial_or_tensorial_character),
[cardinal scale](#cardinalscale),
[compound unit](#compoundunit),
[fixed point](#fixedpoint),
[fixed zero point](#fixedzeropoint),
[interval scale](#intervalscale),
[measure](#measure),
[measurement scale](#Measurement_scale),
[nominal scale](#nominalscale),
[ordinal scale](#ordinalscale),
[phenomenon](#Phenomenon),
[point](#point),
[prefix](#Prefix),
[quantity](#quantity),
[ratio scale](#ratioscale),
[unit division](#unitdivision),
[unit exponentiation](#unitexponentiation),
[unit multiple or submultiple](#unitmultipleorsubmultiple),
[unit multiplication](#unitmultiplication),
[unit of measure](#Unit_of_measure),
### Polygon
Property | Value
--- | ---
URI | `http://http://www.opengis.net/ont/geosparql#Polygon`
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Feature](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Feature) (c)<br />
### Application_area
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Application_area`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
### Binary_prefix
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Binary_prefix`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
### cardinal scale
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinal_scale`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#element](http://ontology.eil.utoronto.ca/ISO21972/iso21972#element) (op) **only** [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Fixed_point](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Fixed_point) (c)<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Interval_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Interval_scale) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ratio_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ratio_scale) (c)<br />
### Cardinality
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality`
Description | <p>Cardinality of the Population. Note that there is no property that links Cardinality to a Variable.</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#cardinality_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#cardinality_of) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#cardinality_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#cardinality_of) (op)<br />
### Cardinality_scale
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality_scale`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ratio_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ratio_scale) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#zero_element](http://ontology.eil.utoronto.ca/ISO21972/iso21972#zero_element) (op) **value** [http://ontology.eil.utoronto.ca/ISO21972/iso21972#fixed_zero_cardinality](http://ontology.eil.utoronto.ca/ISO21972/iso21972#fixed_zero_cardinality) (c)<br />
### Cardinality_unit
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality_unit`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit) (c)<br />
Restrictions |[ub36bL478C55](ub36bL478C55) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality_scale) (c)<br />
Has members |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#population_cardinality_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#population_cardinality_unit)<br />
### City
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#City`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />[schema:City](http://schema.org/City) (c)<br />
### compound unit
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Compound_unit`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c)<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_exponentiation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_exponentiation) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiplication](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiplication) (c)<br />
### Dimension
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Dimension`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
### Distinct_count
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Distinct_count`
Description | <p>Distinct_count class that is a Parameter that represents          the number of distinct values of a property of the members of a          Population</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#distinct_count_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#distinct_count_of) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />
### Feature
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Feature`
Super-classes |[http://http://www.opengis.net/ont/geosparql#Polygon](http://http://www.opengis.net/ont/geosparql#Polygon) (c)<br />[geo:Feature](http://www.w3.org/2003/01/geo/wgs84_pos#Feature) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
### fixed point
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Fixed_point`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Point](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Point) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#definition](http://ontology.eil.utoronto.ca/ISO21972/iso21972#definition) (op) **only** ([http://ontology.eil.utoronto.ca/ISO21972/iso21972#Fixed_point](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Fixed_point) (c) or [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure) (c) or [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c))<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Fixed_zero_point](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Fixed_zero_point) (c)<br />
### fixed zero point
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Fixed_zero_point`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Fixed_point](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Fixed_point) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#numerical_value](http://ontology.eil.utoronto.ca/ISO21972/iso21972#numerical_value) (dp) **value** [0](0) (c)<br />
### ISO21972Thing
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing`
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Dimension](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Dimension) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#System_of_units](http://ontology.eil.utoronto.ca/ISO21972/iso21972#System_of_units) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Application_area](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Application_area) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Phenomenon](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Phenomenon) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Vectorial_or_tensorial_character](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Vectorial_or_tensorial_character) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Point](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Point) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale_category](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale_category) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Indicator](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Indicator) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Variable](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Variable) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Prefix) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Monetary_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Monetary_unit) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Binary_prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Binary_prefix) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#City](http://ontology.eil.utoronto.ca/ISO21972/iso21972#City) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Observation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Observation) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ordered_measurement_scale_category](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ordered_measurement_scale_category) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Feature](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Feature) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic) (c)<br />
### Indicator
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Indicator`
Description | <p>An indicator is a quantity that is a ratio of a numerator and denominator that are also quantities. It has a city and time period associated with it. The numerator and denominator quantities can have different units of measure. One example of a unit of measure is the size of a population. A population_cardinality_unit is defined to be an individual of a Cardinality_unit that is a subclass of a Singular_unit.</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#unit_of_measure) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#for_time_interval](http://ontology.eil.utoronto.ca/ISO21972/iso21972#for_time_interval) (op) **exactly** 1 [time:DateTimeInterval](http://www.w3.org/2006/time#DateTimeInterval) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#for_city](http://ontology.eil.utoronto.ca/ISO21972/iso21972#for_city) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#City](http://ontology.eil.utoronto.ca/ISO21972/iso21972#City) (c)<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#RatioIndicator](http://ontology.eil.utoronto.ca/ISO21972/iso21972#RatioIndicator) (c)<br />
### interval scale
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Interval_scale`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinal_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinal_scale) (c)<br />
### Mean
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Mean`
Description | <p>Mean represents the mean value of a property all members of the Population have and is specified by the parameter_of_var property.</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#mean_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#mean_of) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#mean_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#mean_of) (op)<br />
### measure
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure`
Description | <p>A measure combines a number to a unit of measure or an interval or ratio scale. For example, "3 m" is a measure.</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
In range of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#value](http://ontology.eil.utoronto.ca/ISO21972/iso21972#value) (op)<br />
### measurement scale
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale`
Description | <p>Measurement scales are concepts used for the expression of quantities. Four types of measurement scales are: nominal scales, ordinal scales, interval scales and ratio scales. The latter two scales are also called cardinal scales. An example of a scale is the Celsius scale, a temperature scale.</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Nominal_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Nominal_scale) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinal_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinal_scale) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ordinal_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ordinal_scale) (c)<br />
In range of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#measurement_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#measurement_scale) (op)<br />
### Measurement_scale_category
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale_category`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
### Monetary_unit
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Monetary_unit`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit) (c)<br />
### nominal scale
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Nominal_scale`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#element](http://ontology.eil.utoronto.ca/ISO21972/iso21972#element) (op) **only** [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale_category](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale_category) (c)<br />
### Observation
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Observation`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#member_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#member_of) (op) **only** [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#has_characteristic](http://ontology.eil.utoronto.ca/ISO21972/iso21972#has_characteristic) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Variable](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Variable) (c)<br />
In range of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_composed_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_composed_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_characteristic_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_characteristic_of) (op)<br />
### Ordered_measurement_scale_category
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ordered_measurement_scale_category`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#rank](http://ontology.eil.utoronto.ca/ISO21972/iso21972#rank) (fp)<br />
### ordinal scale
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ordinal_scale`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#element](http://ontology.eil.utoronto.ca/ISO21972/iso21972#element) (op) **only** [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ordered_measurement_scale_category](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ordered_measurement_scale_category) (c)<br />
### Parameter
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter`
Description | <p>Parameter is the Class of all  measures that can be made of a Population, both statistical, e.g., Mean, Starndard_devation, and others, e.g., Cardinality, Sum.</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#parameter_of_var](http://ontology.eil.utoronto.ca/ISO21972/iso21972#parameter_of_var) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Variable](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Variable) (c)<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Mean](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Mean) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sum](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sum) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Distinct_count](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Distinct_count) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Standard_deviation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Standard_deviation) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#parameter_of_var](http://ontology.eil.utoronto.ca/ISO21972/iso21972#parameter_of_var) (op)<br />
In range of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_an_estimate_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_an_estimate_of) (op)<br />
### phenomenon
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Phenomenon`
Description | <p>A phenomenon is the qualitative object (e.g., food, star, molecule) that has quantifiable (standardized) aspects (e.g, length, mass, time).</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
### point
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Point`
Description | <p>A point is an element of an interval scale or a ratio scale, for example, 273.16 on the Kelvin scale indicates the triple point of water thermodynamic temperature.</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Fixed_point](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Fixed_point) (c)<br />
Has members |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#fixed_zero_cardinality](http://ontology.eil.utoronto.ca/ISO21972/iso21972#fixed_zero_cardinality)<br />
### Population
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population`
Description | <p>The core class is the Population to be measured. A Population is linked to a parameter (e.g., mean, standard deviation, cardinality) by the is_described_by property, and the parameter is a sub class of Parameter. Depending on the subclass of Parameter, there is a reverse link back to the Population.</p> <p>parameter links back to the using cardinality_of. parameter links back using the   property. parameter links back using the mean_of property.</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#for_time_interval](http://ontology.eil.utoronto.ca/ISO21972/iso21972#for_time_interval) (op) **only** [time:DateTimeInterval](http://www.w3.org/2006/time#DateTimeInterval) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#defined_by](http://ontology.eil.utoronto.ca/ISO21972/iso21972#defined_by) (op) **only** [owl:Thing](http://www.w3.org/2002/07/owl#Thing) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#definition](http://ontology.eil.utoronto.ca/ISO21972/iso21972#definition) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Feature](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Feature) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_composed_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_composed_of) (op) **only** [owl:Thing](http://www.w3.org/2002/07/owl#Thing) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_described_by](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_described_by) (op) **only** [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter) (c)<br />
In range of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#cardinality_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#cardinality_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#sum_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#sum_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#std_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#std_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_part_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_part_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#mean_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#mean_of) (op)<br />
### prefix
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Prefix`
Description | <p>A prefix is a name that precedes a basic unit of measure to indicate a decimal multiple or fraction of the unit. Each prefix has a unique symbol that is prepended to the unit symbol. For example, an electric current of 0.000 000 001 ampere is written by using the SI-prefix nano as 1 nanoampere or 1 nA.</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#factor](http://ontology.eil.utoronto.ca/ISO21972/iso21972#factor) (fp)<br />
In range of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#prefix) (op)<br />
### quantity
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity`
Description | <p>A quantity is a representation of a quantifiable (standardized) aspect (such as length, mass, and time) of a phenomenon (e.g., a star, food, or a molecule). Quantities are classified according to similarity in (implicit) metrological aspect, e.g. the length of my speedboat and the length of my racing car are classified as length.</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#value](http://ontology.eil.utoronto.ca/ISO21972/iso21972#value) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#unit_of_measure) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c)<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Indicator](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Indicator) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#value](http://ontology.eil.utoronto.ca/ISO21972/iso21972#value) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#phenomenon](http://ontology.eil.utoronto.ca/ISO21972/iso21972#phenomenon) (op)<br />
In range of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_quantity) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#derived_quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#derived_quantity) (op)<br />
### RatioIndicator
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#RatioIndicator`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Indicator](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Indicator) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#unit_of_measure) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#denominator](http://ontology.eil.utoronto.ca/ISO21972/iso21972#denominator) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#numerator](http://ontology.eil.utoronto.ca/ISO21972/iso21972#numerator) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c)<br />
### ratio scale
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ratio_scale`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinal_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinal_scale) (c)<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality_scale) (c)<br />
### SI prefix
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Prefix) (c)<br />
Has members |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#mega](http://ontology.eil.utoronto.ca/ISO21972/iso21972#mega)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#giga](http://ontology.eil.utoronto.ca/ISO21972/iso21972#giga)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#micro](http://ontology.eil.utoronto.ca/ISO21972/iso21972#micro)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#hecto_kilo](http://ontology.eil.utoronto.ca/ISO21972/iso21972#hecto_kilo)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#kilo](http://ontology.eil.utoronto.ca/ISO21972/iso21972#kilo)<br />
### Sample
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_described_by](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_described_by) (op) **only** [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_composed_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_composed_of) (op) **only** [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Observation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Observation) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_part_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_part_of) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_part_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_part_of) (op)<br />
### Sample_cardinality
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample_cardinality`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic) (c)<br />
### Sample_mean
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample_mean`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic) (c)<br />
### Sample_standard_deviation
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample_standard_deviation`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic) (c)<br />
### Sample_sum
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample_sum`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic) (c)<br />
### Singular_unit
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality_unit) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Monetary_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Monetary_unit) (c)<br />
In range of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#singular_unit) (op)<br />
Has members |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#year](http://ontology.eil.utoronto.ca/ISO21972/iso21972#year)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#hour](http://ontology.eil.utoronto.ca/ISO21972/iso21972#hour)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#minute-time](http://ontology.eil.utoronto.ca/ISO21972/iso21972#minute-time)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#metre](http://ontology.eil.utoronto.ca/ISO21972/iso21972#metre)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#watt](http://ontology.eil.utoronto.ca/ISO21972/iso21972#watt)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#occurrence](http://ontology.eil.utoronto.ca/ISO21972/iso21972#occurrence)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#gram](http://ontology.eil.utoronto.ca/ISO21972/iso21972#gram)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#decibel](http://ontology.eil.utoronto.ca/ISO21972/iso21972#decibel)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#interruption](http://ontology.eil.utoronto.ca/ISO21972/iso21972#interruption)<br />
### Standard_deviation
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Standard_deviation`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#std_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#std_of) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#std_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#std_of) (op)<br />
### Statistic
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_an_estimate_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_an_estimate_of) (op) **only** [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter) (c)<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample_cardinality](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample_cardinality) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample_sum](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample_sum) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample_standard_deviation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample_standard_deviation) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample_mean](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample_mean) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_an_estimate_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_an_estimate_of) (op)<br />
### Sum
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sum`
Description | <p>Sum defines the sum over a variable possessed by members of the Population.</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#sum_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#sum_of) (op) **exactly** 1 [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#sum_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#sum_of) (op)<br />
### System_of_units
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#System_of_units`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_quantity) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_unit) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#derived_quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#derived_quantity) (op)<br />
### unit division
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Compound_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Compound_unit) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#numerator](http://ontology.eil.utoronto.ca/ISO21972/iso21972#numerator) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#denominator](http://ontology.eil.utoronto.ca/ISO21972/iso21972#denominator) (op)<br />
Has members |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#kilowatt_hour](http://ontology.eil.utoronto.ca/ISO21972/iso21972#kilowatt_hour)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#interruption_per_year](http://ontology.eil.utoronto.ca/ISO21972/iso21972#interruption_per_year)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#population_ratio_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#population_ratio_unit)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#minute-time_per_occurence](http://ontology.eil.utoronto.ca/ISO21972/iso21972#minute-time_per_occurence)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#microgram_per_cubic_metre](http://ontology.eil.utoronto.ca/ISO21972/iso21972#microgram_per_cubic_metre)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#occurence_per_hecto_kilo_pc](http://ontology.eil.utoronto.ca/ISO21972/iso21972#occurence_per_hecto_kilo_pc)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#pc_per_hecto_kilo_pc](http://ontology.eil.utoronto.ca/ISO21972/iso21972#pc_per_hecto_kilo_pc)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#hour_per_interruption](http://ontology.eil.utoronto.ca/ISO21972/iso21972#hour_per_interruption)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#kwh_per_year](http://ontology.eil.utoronto.ca/ISO21972/iso21972#kwh_per_year)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#kwh_per_square_metre](http://ontology.eil.utoronto.ca/ISO21972/iso21972#kwh_per_square_metre)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#kwh_per_pc](http://ontology.eil.utoronto.ca/ISO21972/iso21972#kwh_per_pc)<br />
### unit exponentiation
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_exponentiation`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Compound_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Compound_unit) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#exponent](http://ontology.eil.utoronto.ca/ISO21972/iso21972#exponent) (fp)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#base](http://ontology.eil.utoronto.ca/ISO21972/iso21972#base) (op)<br />
Has members |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#cubic_metre](http://ontology.eil.utoronto.ca/ISO21972/iso21972#cubic_metre)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#square_metre](http://ontology.eil.utoronto.ca/ISO21972/iso21972#square_metre)<br />
### unit multiple or submultiple
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#definition](http://ontology.eil.utoronto.ca/ISO21972/iso21972#definition) (op) **only** ([http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure) (c) or [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c) or [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c))<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#prefix) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#singular_unit) (op)<br />
Has members |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#gigapc](http://ontology.eil.utoronto.ca/ISO21972/iso21972#gigapc)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#megapc](http://ontology.eil.utoronto.ca/ISO21972/iso21972#megapc)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#kilopc](http://ontology.eil.utoronto.ca/ISO21972/iso21972#kilopc)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#microgram](http://ontology.eil.utoronto.ca/ISO21972/iso21972#microgram)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#hecto_kilo_pc](http://ontology.eil.utoronto.ca/ISO21972/iso21972#hecto_kilo_pc)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#kilowatt](http://ontology.eil.utoronto.ca/ISO21972/iso21972#kilowatt)<br />
### unit multiplication
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiplication`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Compound_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Compound_unit) (c)<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_1](http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_1) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_2](http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_2) (op)<br />
### unit of measure
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure`
Description | <p>A unit of measure is a definite magnitude of a quantity, defined and adopted by convention and/or by law. It is used as a standard for measurement of the same quantity, where any other value of the quantity can be expressed as a simple multiple of the unit of measure. For example, length is a quantity; the metre is a unit of length that represents a definite predetermined length. When we say 10 metre (or 10 m), we actually mean 10 times the definite predetermined length called "metre".</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Compound_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Compound_unit) (c)<br />
In range of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#denominator](http://ontology.eil.utoronto.ca/ISO21972/iso21972#denominator) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_unit) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_2](http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_2) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#unit_of_measure) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#numerator](http://ontology.eil.utoronto.ca/ISO21972/iso21972#numerator) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_1](http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_1) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#base](http://ontology.eil.utoronto.ca/ISO21972/iso21972#base) (op)<br />
### Variable
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Variable`
Description | <p>The property that is being measured in the population.  Since Protege is not Full DL, cannot make the property a subclass of Variable, so have to specify it as a string name using has_Name.</p>
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
Restrictions |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_characteristic_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_characteristic_of) (op) **only** [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Observation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Observation) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#has_Name](http://ontology.eil.utoronto.ca/ISO21972/iso21972#has_Name) (dp) **max** 1<br />
In domain of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_characteristic_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_characteristic_of) (op)<br />
In range of |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#parameter_of_var](http://ontology.eil.utoronto.ca/ISO21972/iso21972#parameter_of_var) (op)<br />
### Vectorial_or_tensorial_character
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#Vectorial_or_tensorial_character`
Super-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing](http://ontology.eil.utoronto.ca/ISO21972/iso21972#ISO21972Thing) (c)<br />
### City
Property | Value
--- | ---
URI | `http://schema.org/City`
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#City](http://ontology.eil.utoronto.ca/ISO21972/iso21972#City) (c)<br />
### DataTypeProperty
Property | Value
--- | ---
URI | `http://www.w3.org/2002/07/owl#DataTypeProperty`
### ObjectProperty
Property | Value
--- | ---
URI | `http://www.w3.org/2002/07/owl#ObjectProperty`
Has members |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#value](http://ontology.eil.utoronto.ca/ISO21972/iso21972#value) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#zero_element](http://ontology.eil.utoronto.ca/ISO21972/iso21972#zero_element) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_described_by](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_described_by) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#definition](http://ontology.eil.utoronto.ca/ISO21972/iso21972#definition) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#singular_unit) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#std_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#std_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_characteristic_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_characteristic_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#base](http://ontology.eil.utoronto.ca/ISO21972/iso21972#base) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#member_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#member_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#has_characteristic](http://ontology.eil.utoronto.ca/ISO21972/iso21972#has_characteristic) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#parameter_of_var](http://ontology.eil.utoronto.ca/ISO21972/iso21972#parameter_of_var) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#element](http://ontology.eil.utoronto.ca/ISO21972/iso21972#element) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#derived_quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#derived_quantity) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#measurement_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#measurement_scale) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#distinct_count_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#distinct_count_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#located_in](http://ontology.eil.utoronto.ca/ISO21972/iso21972#located_in) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_1](http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_1) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#numerator](http://ontology.eil.utoronto.ca/ISO21972/iso21972#numerator) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#unit_of_measure) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_2](http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_2) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_an_estimate_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_an_estimate_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#mean_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#mean_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_composed_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_composed_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_quantity) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#for_time_interval](http://ontology.eil.utoronto.ca/ISO21972/iso21972#for_time_interval) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#denominator](http://ontology.eil.utoronto.ca/ISO21972/iso21972#denominator) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#prefix) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_unit) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#phenomenon](http://ontology.eil.utoronto.ca/ISO21972/iso21972#phenomenon) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#defined_by](http://ontology.eil.utoronto.ca/ISO21972/iso21972#defined_by) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#sum_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#sum_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#for_city](http://ontology.eil.utoronto.ca/ISO21972/iso21972#for_city) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_part_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_part_of) (op)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#cardinality_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#cardinality_of) (op)<br />
### Feature
Property | Value
--- | ---
URI | `http://www.w3.org/2003/01/geo/wgs84_pos#Feature`
Sub-classes |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Feature](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Feature) (c)<br />
### DateTimeInterval
Property | Value
--- | ---
URI | `http://www.w3.org/2006/time#DateTimeInterval`

## Object Properties
[base](#base),
[base quantity](#basequantity),
[base unit](#baseunit),
[cardinality_of](#cardinality_of),
[defined_by](#defined_by),
[definition](#definition),
[denominatot](#denominatot),
[derived quantity](#derivedquantity),
[description_of](#description_of),
[distinct_count_of](#distinct_count_of),
[element](#element),
[for_city](#for_city),
[for_time_interval](#for_time_interval),
[has_characteristic](#has_characteristic),
[is_an_estimate_of](#is_an_estimate_of),
[is_characteristic_of](#is_characteristic_of),
[is_composed_of](#is_composed_of),
[is_described_by](#is_described_by),
[is_part_of](#is_part_of),
[iso21972ObjectProperty](#iso21972ObjectProperty),
[located_in](#located_in),
[mean_of](#mean_of),
[measurement scale](#measurementscale),
[member_of](#member_of),
[numerator](#numerator),
[parameter_of_var](#parameter_of_var),
[phenomenon](#phenomenon),
[prefix](#prefix),
[singular unit](#singularunit),
[std_of](#std_of),
[sum_of](#sum_of),
[term 1](#term1),
[term 2](#term2),
[unit of measure](#unitofmeasure),
[value](#value),
[zero_element](#zero_element),
[](base)
### base
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#base`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_exponentiation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_exponentiation) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c)<br />
[](basequantity)
### base quantity
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_quantity`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#System_of_units](http://ontology.eil.utoronto.ca/ISO21972/iso21972#System_of_units) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c)<br />
[](baseunit)
### base unit
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#base_unit`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#System_of_units](http://ontology.eil.utoronto.ca/ISO21972/iso21972#System_of_units) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c)<br />
[](cardinality_of)
### cardinality_of
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#cardinality_of`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />
[](defined_by)
### defined_by
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#defined_by`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
[](definition)
### definition
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#definition`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
[](denominatot)
### denominatot
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#denominator`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c)<br />
[](derivedquantity)
### derived quantity
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#derived_quantity`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#System_of_units](http://ontology.eil.utoronto.ca/ISO21972/iso21972#System_of_units) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c)<br />
[](description_of)
### description_of
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
[](distinct_count_of)
### distinct_count_of
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#distinct_count_of`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of) (op)<br />
[](element)
### element
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#element`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
[](for_city)
### for_city
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#for_city`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
[](for_time_interval)
### for_time_interval
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#for_time_interval`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
[](has_characteristic)
### has_characteristic
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#has_characteristic`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
[](is_an_estimate_of)
### is_an_estimate_of
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_an_estimate_of`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter) (c)<br />
[](is_characteristic_of)
### is_characteristic_of
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_characteristic_of`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Variable](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Variable) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Observation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Observation) (c)<br />
[](is_composed_of)
### is_composed_of
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_composed_of`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |([http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c) or [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample) (c))<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Observation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Observation) (c)<br />
[](is_described_by)
### is_described_by
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_described_by`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |([http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c) or [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample) (c))<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter) (c)<br />[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Statistic) (c)<br />
[](is_part_of)
### is_part_of
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#is_part_of`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sample) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />
[](iso21972ObjectProperty)
### iso21972ObjectProperty
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty`
[](located_in)
### located_in
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#located_in`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
[](mean_of)
### mean_of
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#mean_of`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Mean](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Mean) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />
[](measurementscale)
### measurement scale
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#measurement_scale`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |([http://ontology.eil.utoronto.ca/ISO21972/iso21972#Application_area](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Application_area) (c) or [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Point](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Point) (c) or [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c))<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measurement_scale) (c)<br />
[](member_of)
### member_of
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#member_of`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
[](numerator)
### numerator
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#numerator`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c)<br />
[](parameter_of_var)
### parameter_of_var
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#parameter_of_var`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Parameter) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Variable](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Variable) (c)<br />
[](phenomenon)
### phenomenon
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#phenomenon`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c)<br />
[](prefix)
### prefix
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#prefix`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Prefix) (c)<br />
[](singularunit)
### singular unit
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#singular_unit`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit) (c)<br />
[](std_of)
### std_of
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#std_of`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Standard_deviation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Standard_deviation) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />
[](sum_of)
### sum_of
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#sum_of`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of](http://ontology.eil.utoronto.ca/ISO21972/iso21972#description_of) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sum](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Sum) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Population) (c)<br />
[](term1)
### term 1
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_1`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiplication](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiplication) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c)<br />
[](term2)
### term 2
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#term_2`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiplication](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiplication) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c)<br />
[](unitofmeasure)
### unit of measure
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#unit_of_measure`
Description | For quantity classes this property indicates a commonly-used unit.
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |([http://ontology.eil.utoronto.ca/ISO21972/iso21972#Application_area](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Application_area) (c) or [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinal_scale](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinal_scale) (c) or [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c))<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_of_measure) (c)<br />
[](value)
### value
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#value`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Quantity) (c)<br />
Range(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure) (c)<br />
[](zero_element)
### zero_element
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#zero_element`
Super-properties |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty](http://ontology.eil.utoronto.ca/ISO21972/iso21972#iso21972ObjectProperty) (op)<br />

## Functional Properties
[exponent](#exponent),
[factor](#factor),
[rank](#rank),
[](exponent)
### exponent
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#exponent`
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_exponentiation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_exponentiation) (c)<br />
Range(s) |[xsd:integer](http://www.w3.org/2001/XMLSchema#integer) (c)<br />
[](factor)
### factor
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#factor`
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Prefix) (c)<br />
Range(s) |[xsd:decimal](http://www.w3.org/2001/XMLSchema#decimal) (c)<br />
[](rank)
### rank
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#rank`
Domain(s) |[http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ordered_measurement_scale_category](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Ordered_measurement_scale_category) (c)<br />
Range(s) |[xsd:integer](http://www.w3.org/2001/XMLSchema#integer) (c)<br />

## Datatype Properties
[has_Name](#has_Name),
[numerical value](#numericalvalue),
[symbol](#symbol),
[](has_Name)
### has_Name
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#has_Name`
Super-properties |[owl:topDataProperty](http://www.w3.org/2002/07/owl#topDataProperty)<br />
[](numericalvalue)
### numerical value
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#numerical_value`
Domain(s) |([http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Measure) (c) or [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Point](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Point) (c))<br />
Range(s) |[xsd:decimal](http://www.w3.org/2001/XMLSchema#decimal) (c)<br />
[](symbol)
### symbol
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#symbol`

## Annotation Properties
[license](#license),
[creator](#creator),
[description](#description),
[title](#title),
[creator](#creator1),
[preferredNamespacePrefix](#preferredNamespacePrefix),
[preferredNamespaceUri](#preferredNamespaceUri),
[pattern](#pattern),
[relatedDocumentation](#relatedDocumentation),
[alternative_label](#alternative_label),
[](license)
### license
Property | Value
--- | ---
URI | `http://creativecommons.org/ns#license`
[](creator)
### creator
Property | Value
--- | ---
URI | `http://purl.org/dc/elements/1.1/creator`
[](description)
### description
Property | Value
--- | ---
URI | `http://purl.org/dc/elements/1.1/description`
[](title)
### title
Property | Value
--- | ---
URI | `http://purl.org/dc/elements/1.1/title`
[](creator1)
### creator
Property | Value
--- | ---
URI | `http://purl.org/dc/terms/creator`
[](preferredNamespacePrefix)
### preferredNamespacePrefix
Property | Value
--- | ---
URI | `http://purl.org/vocab/vann/preferredNamespacePrefix`
[](preferredNamespaceUri)
### preferredNamespaceUri
Property | Value
--- | ---
URI | `http://purl.org/vocab/vann/preferredNamespaceUri`
[](pattern)
### pattern
Property | Value
--- | ---
URI | `http://www.w3.org/2001/XMLSchema#pattern`
[](relatedDocumentation)
### relatedDocumentation
Property | Value
--- | ---
URI | `http://www.w3.org/ns/adms#relatedDocumentation`
[](alternative_label)
### alternative_label
Property | Value
--- | ---
URI | `http://www.wurvoc.org/vocabularies/om-1.8/alternative_label`

## Named Individuals
[cubic_metre](#cubic_metre),
[decibel](#decibel),
[fixed_zero_cardinality](#fixed_zero_cardinality),
[giga](#giga),
[gigapc](#gigapc),
[gram](#gram),
[hecto_kilo](#hecto_kilo),
[hecto_kilo_pc](#hecto_kilo_pc),
[hour](#hour),
[hour_per_interruption](#hour_per_interruption),
[interruption](#interruption),
[interruption_per_year](#interruption_per_year),
[kilo](#kilo),
[kilopc](#kilopc),
[kilowatt](#kilowatt),
[kilowatt_hour](#kilowatt_hour),
[kwh_per_pc](#kwh_per_pc),
[kwh_per_square_metre](#kwh_per_square_metre),
[kwh_per_year](#kwh_per_year),
[mega](#mega),
[megapc](#megapc),
[metre](#metre),
[micro](#micro),
[microgram](#microgram),
[microgram_per_cubic_metre](#microgram_per_cubic_metre),
[minute-time](#minute-time),
[minute-time_per_occurence](#minute-time_per_occurence),
[occurence_per_hecto_kilo_pc](#occurence_per_hecto_kilo_pc),
[occurrence](#occurrence),
[pc_per_hecto_kilo_pc](#pc_per_hecto_kilo_pc),
[population_cardinality_unit](#population_cardinality_unit),
[population_ratio_unit](#population_ratio_unit),
[square_metre](#square_metre),
[watt](#watt),
[year](#year),
### cubic_metre <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#cubic_metre`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_exponentiation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_exponentiation)
### decibel <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#decibel`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit)
### fixed_zero_cardinality <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#fixed_zero_cardinality`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Point](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Point)
### giga <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#giga`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix)
### gigapc <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#gigapc`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple)
### gram <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#gram`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit)
### hecto_kilo <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#hecto_kilo`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix)
### hecto_kilo_pc <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#hecto_kilo_pc`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple)
### hour <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#hour`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit)
### hour_per_interruption <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#hour_per_interruption`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division)
### interruption <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#interruption`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit)
### interruption_per_year <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#interruption_per_year`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division)
### kilo <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#kilo`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix)
### kilopc <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#kilopc`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple)
### kilowatt <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#kilowatt`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple)
### kilowatt_hour <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#kilowatt_hour`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division)
### kwh_per_pc <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#kwh_per_pc`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division)
### kwh_per_square_metre <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#kwh_per_square_metre`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division)
### kwh_per_year <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#kwh_per_year`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division)
### mega <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#mega`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix)
### megapc <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#megapc`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple)
### metre <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#metre`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit)
### micro <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#micro`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix](http://ontology.eil.utoronto.ca/ISO21972/iso21972#SI_prefix)
### microgram <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#microgram`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_multiple_or_submultiple)
### microgram_per_cubic_metre <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#microgram_per_cubic_metre`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division)
### minute-time <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#minute-time`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit)
### minute-time_per_occurence <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#minute-time_per_occurence`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division)
### occurence_per_hecto_kilo_pc <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#occurence_per_hecto_kilo_pc`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division)
### occurrence <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#occurrence`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit)
### pc_per_hecto_kilo_pc <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#pc_per_hecto_kilo_pc`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division)
### population_cardinality_unit <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#population_cardinality_unit`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Cardinality_unit)
### population_ratio_unit <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#population_ratio_unit`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_division)
### square_metre <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#square_metre`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_exponentiation](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Unit_exponentiation)
### watt <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#watt`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit)
### year <sup>c</sup>
Property | Value
--- | ---
URI | `http://ontology.eil.utoronto.ca/ISO21972/iso21972#year`
* **Contributor(s)**
  * [http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit](http://ontology.eil.utoronto.ca/ISO21972/iso21972#Singular_unit)
## Namespaces
* **adms**
  * `http://www.w3.org/ns/adms#`
* **cc**
  * `http://creativecommons.org/ns#`
* **dc**
  * `http://purl.org/dc/elements/1.1/`
* **dct**
  * `http://purl.org/dc/terms/`
* **geo**
  * `http://www.w3.org/2003/01/geo/wgs84_pos#`
* **owl**
  * `http://www.w3.org/2002/07/owl#`
* **prov**
  * `http://www.w3.org/ns/prov#`
* **rdf**
  * `http://www.w3.org/1999/02/22-rdf-syntax-ns#`
* **rdfs**
  * `http://www.w3.org/2000/01/rdf-schema#`
* **schema**
  * `http://schema.org/`
* **sdo**
  * `https://schema.org/`
* **skos**
  * `http://www.w3.org/2004/02/skos/core#`
* **time**
  * `http://www.w3.org/2006/time#`
* **vann**
  * `http://purl.org/vocab/vann/`
* **xsd**
  * `http://www.w3.org/2001/XMLSchema#`

## Legend
* Classes: c
* Object Properties: op
* Functional Properties: fp
* Data Properties: dp
* Annotation Properties: dp
* Properties: p
* Named Individuals: ni