from rdflib.plugin import register, Serializer
register("json-ld", Serializer, "rdflib_jsonld.serializer", "JsonLDSerializer")

try:
    # -- Distribution mode --
    # import from _version.py generated by setuptools_scm during release
    from ._version import version_tuple
    __version__ = f"{version_tuple[0]}.{version_tuple[1]}.{version_tuple[2]}"
except ImportError:
    # -- Source mode --
    # use setuptools_scm to get the current version from src using git
    from setuptools_scm import get_version as _gv
    from os import path as _path
    __version__ = _gv(_path.join(_path.dirname(__file__), _path.pardir))
    __version__ = ".".join(__version__.split(".")[0:3])

from .common import *
from .profiles import OntDoc, Prof, VocPub, NMPF, PROFILES, RDF_MEDIA_TYPES

__all__ = [
    "__version__",
    "OntDoc",
    "Prof",
    "VocPub",
    "NMPF",
    "PROFILES",
    "RDF_MEDIA_TYPES",
    "MakeDocco"
]
