package dyliss.biopax.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import dyliss.biopax.SpaimEnum;

public class SpaimEdge {
	
	//for graphml generation
	private	Integer numid;
	private	String interaction;	
	private String source;

	private String debug;
    
	



	private String target;
	
    //for biopax parsing	
	private  String  pk ;
	private Map<String, String> map ;
	private 	String label;
	 
    // for spaim and db integration 
    private String spaim;
    private String spaimTag;
    

    
  // for export to graphml or not 
	private Boolean export=false;
	
	
	
//for velocity only
public 	void defaultVal() {
	 
		if(pk==null) {
			pk="";
		}
		if(label==null) {
			label="";
		}
		if(spaim==null) {
			spaim="";
		}
		if(spaimTag==null) {
			spaimTag="";
		}
		if(debug==null) {
			debug="";
		}
		if(interaction==null) {
			interaction="";
		}
	}
	
	
	
	public Boolean getExport() {
		return export;
	}

	public void setExport(Boolean export) {
		this.export = export;
	}

	
	
	public String getSpaimTag() {
		return spaimTag;
	}

	public void setSpaimTag(String spaimTag) {
		this.spaimTag = spaimTag;
	}

	public String getSpaim() {
		if(spaim==null){
			return "";
		}
		return spaim;
	}

	public void setSpaim(String spaim) {
		this.spaim = spaim;
	}


	public String getSource() {
		return source;
	}
 
	public void setSource(String source) {
		this.source = source;
	}
 
	public String getTarget() {
		return target;
	}
 
	public void setTarget(String target) {
		this.target = target;
	}
 

	public Integer getNumid() {
		return numid;
	}





	public void setNumid(Integer numid) {
		this.numid = numid;
	}





	public String getInteraction() {
		return interaction;
	}





	public void setInteraction(String interaction) {
		this.interaction = interaction;
	}





	public SpaimEdge() {
		super();
		this.map =   new HashMap<String, String>();
	}





	public String getPk() {
		
		return pk;
	}



	public void setPkFromNodes(SpaimNode source, SpaimNode target) {
		this.pk = source.getPk()+"-->"+target.getPk();
	}

	public void setPk(String pk) {
		this.pk = pk;
	}





	public Map<String, String> getMap() {
		return map;
	}





	public void setMap(Map<String, String> map) {
		this.map = map;
	}





	public String getLabel() {
		return label;
	}





	@Override
	public String toString() {
		final int maxLen = 10;
		return String.format("\nSpaimEdge [pk=%s,  Label=%s]\n", pk,
				 label);
	}





	private String toString(Collection<?> collection, int maxLen) {
		StringBuilder builder = new StringBuilder();
		builder.append("[");
		int i = 0;
		for (Iterator<?> iterator = collection.iterator(); iterator.hasNext() && i < maxLen; i++) {
			if (i > 0)
				builder.append(", ");
			builder.append(iterator.next());
		}
		builder.append("]");
		return builder.toString();
	}





	public void setLabel(String labl) {
		label = labl;
	}

	public String getDebug() {
		return debug;
	}

	public void setDebug(String debug) {
		this.debug = debug;
	}
	
	
}
