package dyliss.biopax.db;


import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.collections15.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.VelocityContext;
import org.biopax.paxtools.impl.level3.CatalysisImpl;
import org.biopax.paxtools.impl.level3.ComplexImpl;
import org.biopax.paxtools.impl.level3.DnaImpl;
import org.biopax.paxtools.impl.level3.ProteinImpl;
import org.biopax.paxtools.impl.level3.RnaImpl;
import org.biopax.paxtools.impl.level3.SmallMoleculeImpl;
import org.biopax.paxtools.impl.level3.TemplateReactionRegulationImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Provenance;

//import dyliss.biopax.GraphConfig;
import dyliss.biopax.graph.SpaimEdge;
import dyliss.biopax.graph.SpaimNode;
import dyliss.biopax.util.LogUtils;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.filters.FilterUtils;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
 

public class SpaimGraphDBWriter extends SpaimGraphAbtractWriter {
	
 
	    
	 
	public SpaimGraphDBWriter( 	
			boolean isDoDB , boolean  isDoDBtoFile ,	
			boolean doHub ,String hubFile ,String dBFile,
				String dbDriver,String dbUrl,
				String dbUser,String dbPassword 
				) {
 
		super(isDoDB,isDoDBtoFile,doHub, hubFile , dBFile,	  dbDriver,  dbUrl,  dbUser,  dbPassword );
		 
	}
 
	
	public static void main(String[] args) {
		 
		Integer num=12;
		String formatted = String.format("M%09d", num);
		String name ="Class I MHC:B2M";
		  name = formatEntityName(name);
		
		String key=moleculeKey("m", name);
		LogUtils.info(key);
		LogUtils.info(formatted);
	}
	
	/*ERROR 10/2017:
	 * 
=> molecule_id count error
root@en1:~/KRF/docker_krf_mysql# grep 'MO000002100' ../db/reactome_pid_kegg_pc.sql | grep transpath_molecule |more
INSERT INTO `transpath_molecule` (`molecule_id`, `type_of_molecule`, `name`, `debug`)
 VALUES ('MO000002100', 'm', 'Class I MHC:B2M', 'ComplexImpl|Class I MHC:B2M');
INSERT INTO `transpath_molecule` (`molecule_id`, `type_of_molecule`, `name`, `debug`)
 VALUES ('MO000002100', 'm', 'CO2', 'SmallMoleculeImpl|CO2');

=> getPK() error
root@en1:~/KRF/docker_krf_mysql# grep 'SmallMoleculeImpl|CO2' ../db/reactome_pid_kegg_pc.sql | grep transpath_molecule |more
INSERT INTO `transpath_molecule` (`molecule_id`, `type_of_molecule`, `name`, `debug`)
 VALUES ('MO000000172', 'm', 'CO2', 'SmallMoleculeImpl|CO2');
INSERT INTO `transpath_molecule` (`molecule_id`, `type_of_molecule`, `name`, `debug`)
 VALUES ('MO000002100', 'm', 'CO2', 'SmallMoleculeImpl|CO2');

	 */
	
	  

	public void persistGs(Connection conn, GenericSignal si) throws Exception {
		String sql = si.insertQuery();
		this.executeQuery(sql, conn);
	}

	public void persistGss(Connection conn, GenericSignalSpaim gss) throws Exception {
		String sql = gss.insertQuery();
		this.executeQuery(sql, conn);
	}

	public void persistTuple(Connection conn, DBTuple t) throws Exception {
		String sql=t.insertQuery();
		 this.executeQuery(sql, conn);
	}

	public void initPersist(Connection conn) throws Exception {
		if( isDoDB ==true ||  isDoDBtoFile ==true){	
			executeQuery(emptyTable(DBMolecule.TABLE_NAME), conn);
			executeQuery(emptyTable(DBReaction.TABLE_NAME), conn);
			executeQuery(emptyTable(GenericSignalSpaim.TABLE_NAME), conn);
			executeQuery(emptyTable(GenericSignal.TABLE_NAME), conn);
		}
	}
	
	 
	 

	private   boolean executeQuery(String sql, Connection conn) throws  Exception  {

	  if( isDoDB  ==true){
		   if(conn==null){
			   conn=this.connect();
		   }
		   if(conn.isClosed()){
			   conn=this.connect();
		   }
	
			PreparedStatement preparedStatement = conn.prepareStatement(sql); 
	
			return preparedStatement.execute();
			
	  
	  }
	  if( isDoDBtoFile  ==true){
		    
		    File f = new File(dBFile );
		 
			 
		 
			Files.write(Paths.get(f.getAbsolutePath()), (sql+"\n").getBytes(), StandardOpenOption.APPEND);
			 
	  }
	  
	  return true;
	}
	
	public String emptyTable(String tn){
	 
		 return "truncate "+tn+";";
	 }
	
	public   Connection connect() throws Exception {
		Connection conn=null;
		if( isDoDB  ==true){
			Class.forName(this.dbDriver );
		 
			LogUtils.info("Connecting to database...");
			conn = DriverManager.getConnection(dbUrl ,dbUser ,dbPassword );
		}
		  if( isDoDBtoFile  ==true){
			    
			    File f = new File(dBFile );
			    
				//FileUtils.writeStringToFile(f, "", false); // create new void file

				Files.write(Paths.get(f.getAbsolutePath()), "".getBytes(), StandardOpenOption.CREATE);
		
		  }
		return conn;
	}

	
	
}
