package dyliss.biopax.app;


import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.collections15.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.VelocityContext;
import org.biopax.paxtools.impl.level3.CatalysisImpl;
import org.biopax.paxtools.impl.level3.ComplexImpl;
import org.biopax.paxtools.impl.level3.DnaImpl;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.impl.level3.ProteinImpl;
import org.biopax.paxtools.impl.level3.RnaImpl;
import org.biopax.paxtools.impl.level3.SmallMoleculeImpl;
import org.biopax.paxtools.impl.level3.TemplateReactionRegulationImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SequenceEntity;

import dyliss.biopax.GraphConfig;
import dyliss.biopax.db.DBMolecule;
import dyliss.biopax.db.DBReaction;
import dyliss.biopax.db.GenericSignalSpaim;
import dyliss.biopax.graph.SpaimEdge;
import dyliss.biopax.graph.SpaimNode;
import dyliss.biopax.util.LogUtils;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.filters.FilterUtils;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
//import edu.uci.ics.jung.io.GraphMLWriter;
 

public class VizuGenerator {

	private  GraphConfig graphConfig = null;
	private Map<String, GenericSignalSpaim> genericSignalSpaimMap  ;
	private DirectedSparseMultigraph spaimGraph=null;
	private HashMap<String, SpaimNode> vmap=null;
	private HashMap<String, SpaimEdge> emap=null;
	private Map<String,String> isInpMap= null;
	private int level;
	public static void main(String[] args) throws Exception {
		
		
		String propFilePath= "/home/fmoreews/Documents/keyreg/git/KRF/biopax/graphvizu.properties";
		if(args!=null && args.length>0){
			propFilePath=args[0];
		}
		//elaguer
		
		generateVizFile(propFilePath);
	}




	public static void generateVizFile(String propFilePath) throws IOException, Exception {
		GraphConfig gc = new GraphConfig(propFilePath);
			if(gc.isDoVizu()){
				boolean isid=true;
				ArrayList<String> entityList= new ArrayList<>();
				Map<String,String> isInpMapL= new HashMap<String,String>();
				if( gc.getVizuft()!=null){
				 
					
					   String linesstrR=FileUtils.readFileToString(new File(gc.getVizuresult()));
					   String[] linesR=linesstrR.split("\\n");
					   for(String l:linesR){
							 l=l.trim();
							 String[] row=l.split("\t");
							 String val = row[0].trim();
							 entityList.add(val);
							 isInpMapL.put(val, "3");//result
						}
					   
					
					   String linesstrTG=FileUtils.readFileToString(new File(gc.getVizutarget()));
					   String[] linesTG=linesstrTG.split("\\n");
					   for(String l:linesTG){
							 l=l.trim();
							 String[] row=l.split("\t");
							 String val = row[1].trim();
							 entityList.add(val);
							 isInpMapL.put(val, "1");//target input
						}
					   
					   
					   String linesstrFT=FileUtils.readFileToString(new File(gc.getVizuft()));
					   String[] lines=linesstrFT.split("\\n");
					   for(String l:lines){
							 l=l.trim();
							 String[] row=l.split("\t");
							 String val = row[0].trim();
							 String[] vl=val.split("#");
							 
					 
							 
							 entityList.add(vl[0]);
							 isInpMapL.put(vl[0], "2");//FT input
						}
					   

					   

					    
					   
					   
					   
				}else{
					String inputvizu= gc.getInputvizu();
					if(inputvizu!=null){
							//"/home/fmoreews/Documents/keyreg/git/KRF/biopax/inputvizu.txt";
		 
							String linesstr=FileUtils.readFileToString(new File(inputvizu));
							
							String[] lines=linesstr.split("\\n");
							
							int ididx=0;
							int isinputidx=2;
							if(isid==false){
								ididx=1;
							}
							for(String l:lines){
								 l=l.trim();
								 String[] row=l.split("\t");
								 String val = row[ididx].trim();
								 entityList.add(val);
								 String isinp=row[isinputidx].trim();
								 isInpMapL.put(val, isinp);
								
								 
							}
					
					}else{
					    LogUtils.info("warning: inputvizu is null");
					}
				}
			  
			   
			
			 LogUtils.info(isInpMapL);
			//System.exit(0);
	
			      String graphmlOutputFilePath="vizu.graphml";
				  LogUtils.info("***start do vizualization ");
				  File f = new File(graphmlOutputFilePath);
				 
				  String gname="krf_result";
				  int levelL=new Integer(gc.getLevel());
				   LogUtils.info("levelL:"+levelL);
				  VizuGenerator vz = new VizuGenerator(gc,levelL);
				  vz.setIsInpMap(isInpMapL);
			
				  //naive n neighbor method 
				  vz.generateGraphFromDBQuery( entityList, isid);
				  //TODO : using graph-tool/boost
				  //can use the output of vz.generateGraphFromDBQuery
				  //or the whole graph
				   LogUtils.info( "final EdgeCount:"+vz.getSpaimGraph().getEdgeCount());
				   LogUtils.info( "final VertexCount:"+vz.getSpaimGraph().getVertexCount());
				  File graphmlTemplateFile = new File(gc.getGraphmlTemplateFilePath());
				  VizGraphmlWriter vgw = new VizGraphmlWriter();
				  
				   LogUtils.info("start writing output:"+f.getAbsolutePath());
				  vgw.writeGraphToGraphmlFile( gname, vz.getSpaimGraph(), graphmlOutputFilePath ,graphmlTemplateFile	); 
	               
				   LogUtils.info("end  writing output:"+f.getAbsolutePath());
				  
			 }
	}

	
	

	public VizuGenerator(GraphConfig graphConfig, int levelL) {
		super();
		this.graphConfig = graphConfig;
		this. genericSignalSpaimMap = new HashMap<String, GenericSignalSpaim>();
		this.spaimGraph = new DirectedSparseMultigraph<SpaimNode, SpaimEdge>();
		this.vmap=new HashMap<String, SpaimNode>();
		this.emap=new HashMap<String, SpaimEdge>();
		this.isInpMap=new HashMap<String, String>();
		this.level=levelL;
	}
	
	public DirectedSparseMultigraph getSpaimGraph() {
		 
		return spaimGraph;
	}

	public void setSpaimGraph(DirectedSparseMultigraph spaimGraph) {
		this.spaimGraph = spaimGraph;
	}

	
	private SpaimEdge addVizSpaimEdge(DirectedSparseMultigraph<SpaimNode, SpaimEdge> g,  SpaimNode source,SpaimNode target, String spaimTag) {
		
		 SpaimEdge  e = new SpaimEdge();
		 
		if(source!=null && target!=null){
			
		
		 
		 e.setPkFromNodes(source, target);
		 e.setSpaimTag(spaimTag);

		 
		 
		 
		 if(emap.containsKey(e.getPk())){
			 e = emap.get(e.getPk());
		 }else{
		     g.addEdge(e, source,target);	 
			 emap.put(e.getPk(),e);
		 }
		 
		} 
		
		return e;
		 
		 
	}
	
	private SpaimNode addVizSpaimNode(DirectedSparseMultigraph<SpaimNode, SpaimEdge> g,
			String desc, String defaultlabel, String pk) throws Exception {
		
		
		 
		
		 SpaimNode no = null;
		 no=new SpaimNode();
		 //no.setElement(be);
		 
		 String label = defaultlabel;  
		 
		 if(label==null){
			 
		 return null;
			 
		 }
		
		 
		 no.setLabel(label);
		 no.getSafeLabel();
		 no.setDescription(desc);
		 no.setGroup("");
		 
		 no.setPk(pk);
		 
		 
		 
		if(vmap.containsKey(pk)){
			 no = vmap.get(pk);
		 }else{
			 g.addVertex(no);
			 vmap.put(pk, no);
		 }
		 
		 
		return no;
	}
	
	
	public static String defineBiopaxTypeFromDebug(SpaimNode v) {
		          String bptype="";
		  
		 
				 bptype="Ellipse";
				 if(v.getDebug().contains("ProteinImpl")){
					 bptype="ProteinImpl"; 
				 }
				 else if(v.getDebug().contains("ComplexAssemblyImpl")){
					 bptype="ComplexAssemblyImpl"; 
				 }
				 else if(v.getDebug().contains("ComplexImpl")){
					 bptype="ComplexImpl"; 
				 }
				 else if(v.getDebug().contains("SmallMoleculeImpl")){
					 bptype="SmallMoleculeImpl"; 
				 }
				 else if(v.getDebug().contains("DnaImpl")){
					 bptype="DnaImpl"; 
				 }
				 else if(v.getDebug().contains("RnaImpl")){
					 bptype="RnaImpl"; 
				 }
				 else if (v.getDebug().contains("Interaction") ){
			 
				 bptype="Interaction" ;
				 }
				 else if (v.getDebug().contains("Control") ){
					   
					   bptype="Control" ;
				 }
				 else if (v.getDebug().contains("CatalysisImpl") ){
					   
					   bptype="CatalysisImpl" ;
				 }
				 else if (v.getDebug().contains("BiochemicalReactionImpl") ){
					   
					   bptype="BiochemicalReactionImpl" ;
				 }
				 else if (v.getDebug().contains("PhysicalEntityImpl") ){
					   
					   bptype="PhysicalEntityImpl" ;
				 }
				 //
				 else{
					 bptype="undef";
				 }
		 
		 
		 
		return bptype;
	}
	public String generateGraphFromDBQuery(ArrayList<String> entityList, boolean isID) throws Exception{
		
		Connection conn=this.connect();
		String prfx="";
		 
		for(String el: entityList){
			
			
			neigh(isID, conn, el,prfx, this.getLevel());
		}
		
		 
		return null;
	}

	public void neigh(boolean isID, Connection conn, String el,String prfx, int levl) throws Exception, SQLException {
		
		levl=levl-1;
		if(levl==0){return;}
		
		if(isID==true){
			String sqlstart = "select "
					+ "s.signal_id, s.molecule_id,s.role_id,s.debug, "+
					" m.type_of_molecule,m.name,m.debug  "+
					  " from  generic_signal_spaim s, transpath_molecule m"
					  + " where m.molecule_id=s.molecule_id and ";
			String sql=sqlstart
			  		+ " s.molecule_id='"+el+ "'";
			ResultSet rs1= executeSelectQuery(  sql,   conn);
			while (rs1.next()) {
			  String signal_id = rs1.getString(1);
			  String molecule_id = rs1.getString(2);
			  String role_id = rs1.getString(3);
			  String debug = rs1.getString(4);
			  
			  String type_of_molecule=rs1.getString(5);
			  String namem=rs1.getString(6);
			  String debugm=rs1.getString(7);
			  DBMolecule m1 = new DBMolecule(molecule_id, type_of_molecule, namem);
			  m1.setDebug(debugm);
			  
			  DBReaction r1 =null;
			  // LogUtils.info(String.format(prfx+level+" %s %s %s %s", signal_id,molecule_id,role_id,debug));
			  if(signal_id.startsWith("XN")){
				  sql="select  r.reaction_id ,r.level ,r.reversible,"
				  		+ "r.effect,r.reaction_description,r.debug "+
				  " from transpath_reaction r where "+
						  "r.reaction_id='"+signal_id+ "'";
				  ResultSet rs1r= executeSelectQuery(  sql,   conn);
				 while (rs1r.next()) {
					    String reaction_idr1 = rs1r.getString(1);
					    String  levelr1 = rs1r.getString(2);
					    String  rev1 = rs1r.getString(3);
					    String  effectr1 = rs1r.getString(4);
					    String  reaction_descriptionr1 = rs1r.getString(5);
					    String  deb1 = rs1r.getString(6);
					    r1 = new DBReaction(reaction_idr1,
					    		levelr1, rev1, effectr1, reaction_descriptionr1);
					    r1.setDebug(deb1);
					}
			  
			  }
			  
			  addToGraph(signal_id, molecule_id, role_id, debug, r1,m1);

			  
			  String sql2=sqlstart
			  		+" signal_id='"+signal_id+ "'";
			  ResultSet rs2= executeSelectQuery(  sql2,   conn);
			  while (rs2.next()) {
				  String signal_id2 = rs2.getString(1);
				  String molecule_id2 = rs2.getString(2);
				  String role_id2 = rs2.getString(3);
				  String debug2 = rs2.getString(4);

				  
				  
				  String type_of_molecule2=rs2.getString(5);
				  String namem2=rs2.getString(6);
				  String debugm2=rs2.getString(7);
				  DBMolecule m2 = new DBMolecule(molecule_id2, type_of_molecule2, namem2);
				  m2.setDebug(debugm2);
				  
				  DBReaction r2 =null;

				  
				  
				 //  LogUtils.info(String.format(prfx+level+"     %s %s %s %s", signal_id2,molecule_id2,role_id2,debug2));  
				  if(signal_id2.startsWith("XN")){
					  sql="select  r.reaction_id ,r.level ,r.reversible,"
					  		+ "r.effect,r.reaction_description,r.debug "+
					  " from transpath_reaction r where "+
							  "r.reaction_id='"+signal_id2+ "'";
					  ResultSet rs2r= executeSelectQuery(  sql,   conn);
						while (rs2r.next()) {
						    String reaction_idr2 = rs2r.getString(1);
						    String  levelr2 = rs2r.getString(2);
						    String  rev2 = rs2r.getString(3);
						    String  effectr2 = rs2r.getString(4);
						    String  reaction_descriptionr2 = rs2r.getString(5);
						    String  deb2 = rs2r.getString(6);
						    r2 = new DBReaction(reaction_idr2,
						    		levelr2, rev2, effectr2, reaction_descriptionr2);
						    r2.setDebug(deb2);
						}
				  
				  }
				  
				  addToGraph(signal_id2, molecule_id2, role_id2, debug2,  r2,m2);

				  String prfx2=prfx+" ";
				 
				  neigh(isID, conn, molecule_id2,prfx2, levl);
			  }
		  }
		  
		 //SELECT (molecule_id ,type_of_molecule,name,debug)
		 // FROM transpath_molecule 
		}
	}

	private String genericSignalSpaimKey(String molecule_id, String rev, String signal_id) {
		String id= signal_id+"|"+molecule_id+"|"+rev;
		
		return id;
	}
	public void addToGraph(String signal_id, String molecule_id, String role_id,
			String dg, DBReaction r, DBMolecule m) throws Exception {
	
		String key =genericSignalSpaimKey(molecule_id, r.getReversible(), signal_id);
		
		if( this.genericSignalSpaimMap.containsKey(key)){
			 
		}else{
			GenericSignalSpaim gss = new GenericSignalSpaim(
					signal_id, molecule_id, role_id);
			
			gss.setDebug(dg);
			this.genericSignalSpaimMap.put(key, gss);
			DirectedSparseMultigraph<SpaimNode, SpaimEdge> g = this.getSpaimGraph();
			
			String pk1=r.getReaction_id();
			String  label1=r.getReaction_description();
			SpaimNode target = addVizSpaimNode(g,r.getReversible()+" "+r.getEffect()+" "+r.getDebug(),   label1, pk1);
			target.setDebug(r.getDebug());
			target.setBiopaxType(defineBiopaxTypeFromDebug(target));
			target.setInput(0);
			target.setSrctype("R");
			
			String pk2=m.getMolecule_id();
			String  label2=m.getName();
			SpaimNode source = addVizSpaimNode( g,m.getDebug(),label2, pk2);
			source.setDebug(m.getDebug());
			source.setBiopaxType(defineBiopaxTypeFromDebug(source));
			source.setSrctype("M");
			// LogUtils.info(m.getMolecule_id() +" "+this.getIsInpMap().get(m.getMolecule_id())) ;
			 
			if(     this.getIsInpMap().containsKey(m.getMolecule_id()) ){
				String v = this.getIsInpMap().get(m.getMolecule_id());
				source.setInput(new Integer(v));
				// LogUtils.info("!!!!");
			}else{
				source.setInput(0);
			}
			
			SpaimEdge  e =	addVizSpaimEdge(g, source, target, "spaimTag");
		    e.setDebug(dg);
		    e.setSpaim(role_id);
		}
	
	}
	
	
	private   ResultSet executeSelectQuery(String sql, Connection conn) throws  Exception  {

		  
			   if(conn==null){
				   conn=this.connect();
			   }
			   if(conn.isClosed()){
				   conn=this.connect();
			   }
		
				PreparedStatement preparedStatement = conn.prepareStatement(sql); 
				ResultSet res=preparedStatement.executeQuery();
				//return preparedStatement.execute();
				
				return res;
		  
		}
	
	private   Connection connect() throws Exception {
		Connection conn=null;
		 
			Class.forName(this.graphConfig.getDbDriver());
		 
			LogUtils.info("Connecting to database...");
			conn = DriverManager.getConnection(this.graphConfig.getDbUrl(),this.graphConfig.getDbUser(),this.graphConfig.getDbPassword());
	 
		return conn;
	}




	public Map<String, String> getIsInpMap() {
		return isInpMap;
	}




	public void setIsInpMap(Map<String, String> isInpMap) {
		this.isInpMap = isInpMap;
	}




	public int getLevel() {
		return level;
	}




	public void setLevel(int level) {
		this.level = level;
	}

	
	
}


 