package dyliss.biopax.app;


import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.collections15.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.VelocityContext;
import org.biopax.paxtools.impl.level3.CatalysisImpl;
import org.biopax.paxtools.impl.level3.ComplexImpl;
import org.biopax.paxtools.impl.level3.DnaImpl;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.impl.level3.ProteinImpl;
import org.biopax.paxtools.impl.level3.RnaImpl;
import org.biopax.paxtools.impl.level3.SmallMoleculeImpl;
import org.biopax.paxtools.impl.level3.TemplateReactionRegulationImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SequenceEntity;

import dyliss.biopax.GraphConfig;

import dyliss.biopax.db.DBMolecule;
import dyliss.biopax.db.DBReaction;
import dyliss.biopax.db.GenericSignalSpaim;

import dyliss.biopax.graph.SpaimEdge;
import dyliss.biopax.graph.SpaimNode;
import dyliss.biopax.util.LogUtils;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.filters.FilterUtils;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
//import edu.uci.ics.jung.io.GraphMLWriter;
 

public class SpaimDB2GTool {

	private  GraphConfig graphConfig = null;
	private Map<String, GenericSignalSpaim> genericSignalSpaimMap  ;
	private DirectedSparseMultigraph spaimGraph=null;
	private HashMap<String, SpaimNode> vmap=null;
	private HashMap<String, SpaimEdge> emap=null;
	private Map<String,String> isInpMap= null;
	public int edgeCount;
	private int nodeCount;
    public boolean debugtestmode=false;
    
	public SpaimDB2GTool(GraphConfig graphConfig ) {
		super();
		this.edgeCount=0;
		this.graphConfig = graphConfig;
		this. genericSignalSpaimMap = new HashMap<String, GenericSignalSpaim>();
		this.spaimGraph = new DirectedSparseMultigraph<SpaimNode, SpaimEdge>();
		this.vmap=new HashMap<String, SpaimNode>();
		this.emap=new HashMap<String, SpaimEdge>();
		this.isInpMap=new HashMap<String, String>();
		 
	}
	
	public static void main(String[] args) throws Exception {
		
		
		 LogUtils.info("start:SpaimDB2GTool");
		
		//String propFilePath= "/home/fmoreews/Documents/keyreg/git/KRF/biopax/graphvizu.properties";
		String propFilePath= null;
		//"/home/fmoreews/Documents/workspace/biopax_cyto/graphconf.properties";
		if(args!=null && args.length>0){
			propFilePath = args[0];
		}
		
		  testFilePath(propFilePath);
		  GraphConfig gc = new GraphConfig(propFilePath);
		  String gname="krf_result";
		  String graphmlOutputFilePath="db2gtool.graphml";
		  String graphmlTemplateFilePath = gc.getGraphmlTemplateFilePath();
		  if(graphmlTemplateFilePath==null){
			  graphmlTemplateFilePath="template/graphml.vm";
		  }
		  String simplegraphmlOutputFilePath="simpledb2gtool.graphml";
		  String simplegraphmlTemplateFilePath = gc.getGraphmlTemplateFilePath();
		  if(simplegraphmlTemplateFilePath==null){
			  simplegraphmlTemplateFilePath="template/simplegraphml.vm";
		  }
		 
			 
		  
		 
		  testFilePath(graphmlTemplateFilePath);
		  testFilePath(simplegraphmlTemplateFilePath);
		 // testFilePath(graphmlOutputFilePath);
		 // testFilePath(simplegraphmlOutputFilePath);
		  
		
		  SpaimDB2GTool vz = new SpaimDB2GTool(gc);
		  Connection conn=vz.connect();
		 
			
		  vz.db2graph( conn);

		 
		  VizGraphmlWriter vgw = new VizGraphmlWriter();
		  vgw.writeGraphToGraphmlFile( gname, vz.getSpaimGraph(), graphmlOutputFilePath ,new File(graphmlTemplateFilePath)	); 
             
		  File f = new File(graphmlOutputFilePath);
		   LogUtils.info("output:"+f.getAbsolutePath());
		  
		  
		  

		  
		  vgw.writeGraphToGraphmlFile( gname, vz.getSpaimGraph(), simplegraphmlOutputFilePath ,new File(simplegraphmlTemplateFilePath)	); 
             
		  File sf = new File(simplegraphmlOutputFilePath);
		   LogUtils.info("simple output:"+sf.getAbsolutePath());
		  

		  
		  
		  vgw.writeNodeIDFile(vz.getSpaimGraph(),"node.txt");
		  vgw.writeEdgeIDFile(vz.getSpaimGraph(),"edge.txt");
	}

	private static void testFilePath(String fi) throws Exception{
		
		File f = new File(fi);
		if(f.exists()){
			
		}else{
			throw new Exception("\nfile "+ f.getAbsolutePath()+ " not found\n");
		}
	}

	public void db2graph( Connection conn) throws Exception, SQLException {
		
 
		//convert to left join to enable molecule as  singleton
		
			String sqlstart = "";
			
			// implementation without singleton management
			/* 
			 
			 
			  sqlstart = "select "
					+ "s.signal_id, s.molecule_id,s.role_id,s.debug, "+
					" m.type_of_molecule,m.name,m.debug  "+
					  " from  generic_signal_spaim s, transpath_molecule m"
					  + " where m.molecule_id=s.molecule_id ";
			  */
			// implementation with singleton management
			  sqlstart = "select "
						+ "s.signal_id, m.molecule_id,s.role_id,s.debug, "+
						" m.type_of_molecule, m.name, m.debug  "+
						  " from  transpath_molecule m  "
						  + "left join generic_signal_spaim s "
						  + " on s.molecule_id=m.molecule_id "
						  + "";
			
			
			//String sql=sqlstart
			//  		+ "and s.molecule_id='"+el+ "'";
			ResultSet rs1= executeSelectQuery(  sqlstart,   conn);
			while (rs1.next()) {
			  String signal_id = rs1.getString(1);
			  String molecule_id = rs1.getString(2);
			  String role_id = rs1.getString(3);
			  String debug = rs1.getString(4);
			  
			  String type_of_molecule=rs1.getString(5);
			  String namem=rs1.getString(6);
			  String debugm=rs1.getString(7);
			  
			  DBMolecule m1 = new DBMolecule(molecule_id, type_of_molecule, namem);
			  m1.setDebug(debugm);
			  
			  DBReaction r1 =null;
			 //  LogUtils.info(String.format(" %s %s %s %s", signal_id,molecule_id,role_id,debug));
	
			  
			  if(signal_id==null){
				  //singleton case
				  //05/2019
				   defineMolNode(m1, this.getSpaimGraph());
			  }
			  else if(signal_id.startsWith("XN")){
				  //relation case
				  String sql="select  r.reaction_id ,r.level ,r.reversible,"
				  		+ "r.effect,r.reaction_description,r.debug "+
				  " from transpath_reaction r where "+
						  "r.reaction_id='"+signal_id+ "'";
				  ResultSet rs1r= executeSelectQuery(  sql,   conn);
				 
				  
				  while (rs1r.next()) {
					    String reaction_idr1 = rs1r.getString(1);
					    String  levelr1 = rs1r.getString(2);
					    String  rev1 = rs1r.getString(3);
					    String  effectr1 = rs1r.getString(4);
					    String  reaction_descriptionr1 = rs1r.getString(5);
					    String  deb1 = rs1r.getString(6);
					    
					    
					    r1 = new DBReaction(reaction_idr1,levelr1, rev1, effectr1, reaction_descriptionr1);
					    r1.setDebug(deb1);
					    
					    addToGraph(signal_id, molecule_id, role_id, debug, r1,m1);
					    
					 if(this.debugtestmode==true && this.edgeCount>10000 ){
						 return;
					 }
				 }
				
			  }
			  
		
		  }
 
	}


	public   void generateVizFile(String propFilePath) throws IOException, Exception {}

	
	


	
	public DirectedSparseMultigraph getSpaimGraph() {
		 
		return spaimGraph;
	}

	public void setSpaimGraph(DirectedSparseMultigraph spaimGraph) {
		this.spaimGraph = spaimGraph;
	}

	
	private SpaimEdge addVizSpaimEdge(DirectedSparseMultigraph<SpaimNode, SpaimEdge> g,  SpaimNode source,SpaimNode target, String spaimTag) {
		
		 SpaimEdge  e = new SpaimEdge();
		 
		if(source!=null && target!=null){
			
		
		 
		 e.setPkFromNodes(source, target);
		 e.setSpaimTag(spaimTag);

		 
		 
		 
		 if(emap.containsKey(e.getPk())){
			 e = emap.get(e.getPk());
		 }else{
			 this.edgeCount++;
			 // LogUtils.info("tmp EdgeCount"+g.getEdgeCount());
		     
			 g.addEdge(e, source,target);	 
			 emap.put(e.getPk(),e);
		 }
		 
		} 
		
		return e;
		 
		 
	}
	
	private SpaimNode addVizSpaimNode(DirectedSparseMultigraph<SpaimNode, SpaimEdge> g,
			String desc, String defaultlabel, String pk) throws Exception {
		
		
		 
		
		 SpaimNode no = null;
		 no=new SpaimNode();
		 //no.setElement(be);
		 
		 String label = defaultlabel;  
		 
		 if(label==null){
			 
		 return null;
			 
		 }
		
		 
		 no.setLabel(label);
		 no.getSafeLabel();
		 no.setDescription(desc);
		 no.setGroup("");
		 
		 no.setPk(pk);
		 
		 
		 
		if(vmap.containsKey(pk)){
			 no = vmap.get(pk);
		 }else{
			 
			 this.nodeCount++;
			  
			 
			 g.addVertex(no);
			 vmap.put(pk, no);
		 }
		 
		 
		return no;
	}
	
	
	public   String defineBiopaxTypeFromDebug(SpaimNode v) {
		          String bptype="";
		  
		          if(v.getDebug()==null){
		        	  return null;
		          }
				 bptype="Ellipse";
				 if(v.getDebug().contains("ProteinImpl")){
					 bptype="ProteinImpl"; 
				 }
				 else if(v.getDebug().contains("ComplexAssemblyImpl")){
					 bptype="ComplexAssemblyImpl"; 
				 }
				 else if(v.getDebug().contains("ComplexImpl")){
					 bptype="ComplexImpl"; 
				 }
				 else if(v.getDebug().contains("SmallMoleculeImpl")){
					 bptype="SmallMoleculeImpl"; 
				 }
				 else if(v.getDebug().contains("DnaImpl")){
					 bptype="DnaImpl"; 
				 }
				 else if(v.getDebug().contains("RnaImpl")){
					 bptype="RnaImpl"; 
				 }
				 else if (v.getDebug().contains("Interaction") ){
			 
				 bptype="Interaction" ;
				 }
				 else if (v.getDebug().contains("Control") ){
					   
					   bptype="Control" ;
				 }
				 else if (v.getDebug().contains("CatalysisImpl") ){
					   
					   bptype="CatalysisImpl" ;
				 }
				 else if (v.getDebug().contains("BiochemicalReactionImpl") ){
					   
					   bptype="BiochemicalReactionImpl" ;
				 }
				 else if (v.getDebug().contains("PhysicalEntityImpl") ){
					   
					   bptype="PhysicalEntityImpl" ;
				 }
				 //
				 else{
					 bptype="undef";
				 }
		 
		 
		 
		return bptype;
	}



	private String genericSignalSpaimKey(String molecule_id, String rev, String signal_id) {
		String id= signal_id+"|"+molecule_id+"|"+rev;
		
		return id;
	}
	public void addToGraph(String signal_id, String molecule_id, String role_id,
			String dg, DBReaction r, DBMolecule m) throws Exception {
	
		if(this.nodeCount % 1000 ==0){
			
			 LogUtils.info("addToGraph<<<@@@@this.edgeCount:"+this.edgeCount+"@@@>");
			 LogUtils.info("addToGraph<<<@@@@this.nodeCount:"+this.nodeCount+"@@@>");
			// LogUtils.info("    addToGraph<<<@@@@signal_id:"+signal_id+"@@@>");
			// LogUtils.info("    addToGraph<<<@@@@molecule_id:"+molecule_id+"@@@>");
		}
		
		String key =genericSignalSpaimKey(molecule_id, r.getReversible(), signal_id);
		
		if( this.genericSignalSpaimMap.containsKey(key)){
			 
		}else{
			GenericSignalSpaim gss = new GenericSignalSpaim(signal_id, molecule_id, role_id);
			
			gss.setDebug(dg);
			this.genericSignalSpaimMap.put(key, gss);
			DirectedSparseMultigraph<SpaimNode, SpaimEdge> g = this.getSpaimGraph();
			
			String pk1=r.getReaction_id();
			
			
			//if(this.nodeCount % 1000 ==0){
				// LogUtils.info("     addToGraph<<<@@@@pk1:"+pk1+"@@@>");
			//}
			
			
			String  label1=r.getReaction_description();
			if(label1==null){
				label1="DEFAULT_LB_"+pk1;
			}
			SpaimNode target = addVizSpaimNode(g,r.getReversible()+" "+r.getEffect()+" "+r.getDebug(),   label1, pk1);
			if(target==null){
				
				 LogUtils.info("!!target==null");
			}
			if(r==null){
				 LogUtils.info("!!r==null");
			}
			target.setDebug(r.getDebug());
			target.setBiopaxType(defineBiopaxTypeFromDebug(target));
			target.setInput(0);
			target.setSrctype("R");
			
			
			
			
			SpaimNode source = defineMolNode(m, g);
			
			
			
			SpaimEdge  e =	addVizSpaimEdge(g, source, target, "spaimTag");
		    e.setDebug(dg);
		    e.setSpaim(role_id);
		}
	
	}

	protected SpaimNode defineMolNode(DBMolecule m, DirectedSparseMultigraph<SpaimNode, SpaimEdge> g) throws Exception {
		String pk2=m.getMolecule_id();
		//if(this.nodeCount % 1000 ==0){
		//	 LogUtils.info("     addToGraph<<<@@@@pk2:"+pk2+"@@@>");
		//}
		String  label2=m.getName();
		SpaimNode source = addVizSpaimNode( g,m.getDebug(),label2, pk2);
		source.setDebug(m.getDebug());
		source.setBiopaxType(defineBiopaxTypeFromDebug(source));
		source.setSrctype("M");
		// LogUtils.info(m.getMolecule_id() +" "+this.getIsInpMap().get(m.getMolecule_id())) ;
		 
		if(this.getIsInpMap().containsKey(m.getMolecule_id()) ){
			
			
			
			
			String v = this.getIsInpMap().get(m.getMolecule_id());
			source.setInput(new Integer(v));
			// LogUtils.info("!!!!");
		}else{
			source.setInput(0);
		}
		return source;
	}
	
	
	protected   ResultSet executeSelectQuery(String sql, Connection conn) throws  Exception  {

		  
			   if(conn==null){
				   conn=this.connect();
			   }
			   if(conn.isClosed()){
				   conn=this.connect();
			   }
		
				PreparedStatement preparedStatement = conn.prepareStatement(sql); 
				ResultSet res=preparedStatement.executeQuery();
				//return preparedStatement.execute();
				
				return res;
		  
		}
	
	
	protected   boolean execute(String sql, Connection conn) throws  Exception  {

		  
		   if(conn==null){
			   conn=this.connect();
		   }
		   if(conn.isClosed()){
			   conn=this.connect();
		   }
	
			PreparedStatement preparedStatement = conn.prepareStatement(sql); 
			return preparedStatement.execute();
			
			 
	  
	}
	protected   Connection connect() throws Exception {
		Connection conn=null;
		 
			Class.forName(this.graphConfig.getDbDriver());
		 
			LogUtils.info("Connecting to database...");
			conn = DriverManager.getConnection(this.graphConfig.getDbUrl(),this.graphConfig.getDbUser(),this.graphConfig.getDbPassword());
	 
		return conn;
	}




	public Map<String, String> getIsInpMap() {
		return isInpMap;
	}




	public void setIsInpMap(Map<String, String> isInpMap) {
		this.isInpMap = isInpMap;
	}




 
	
	
}


 