package dyliss.biopax.app;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;

import org.apache.commons.cli.*;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.SimpleMerger;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.Model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import dyliss.biopax.GraphConfig;
import dyliss.biopax.util.LogUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.*;
public class Pax2Merge {
	
	private static Logger logger = Logger.getLogger("dyliss.biopax");
	private static final String DEFAULT_GRAPHML_TEMPLATE = "graphml.vm";
	private static final String DEFAULT_BLACKLIST = "blacklist.txt";
    private static final String SEP = "###";

	
	public static void main(String[] args) throws Exception {


		 
		  LogUtils.STDOUT=false;
		  
		final GsonBuilder builder = new GsonBuilder();
	    final Gson gson = builder.create();

		CmdResponse cs = new CmdResponse();
        Options options = new Options();

        Option input = new Option("i", "input", true, "biopax input file path, sperated by ','");
        input.setRequired(true);
        options.addOption(input);

        Option output = new Option("o", "output", true, "biopax output file");
        output.setRequired(true);
        options.addOption(output);

        
        
        Option indir = new Option("d", "indir", true, "input directory if input files not directly defined");
        indir.setRequired(false);
        options.addOption(indir);
        
        CommandLineParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd=null;

        try {
              cmd = parser.parse(options, args);
        } catch (ParseException e) {
       
               cs.setError(e.getMessage());
               cs.setStatus(1);
               displayResponse(gson, cs);
               System.exit(1);
        }
        
        String biopaxInDir=null;
        
        List<File> arr = new ArrayList<File>();
        File[] biopaxFileList = {};
        String inputBiopaxFileStr = cmd.getOptionValue("input");
        if(inputBiopaxFileStr!=null) {
        	String[] fl=inputBiopaxFileStr.split(",");
        			if( fl.length>0) {
        				for (int j = 0; j < fl.length; j++) {
        		            arr.add( new File( fl[j] ) );
        		        }
        			 biopaxFileList = new File[arr.size()]; 
        			  for (int j = 0; j < arr.size(); j++) {
        				  biopaxFileList[j] = arr.get(j);  
     		          }
        			}
        }else {
        	biopaxInDir = cmd.getOptionValue("indir");
        	
    		LogUtils.info("***biopaxInDir:"+biopaxInDir);
    		if(biopaxInDir!=null) {
    				File dir = new File(biopaxInDir);
    				  biopaxFileList = dir.listFiles(new FilenameFilter() {
    				    public boolean accept(File dir, String name) {
    				        return name.toLowerCase().endsWith(".owl");
    				    }
    				});
    		}
        	
        }
        
        
        String ouputBiopaxFilePath = cmd.getOptionValue("output");
        
         
  	
  	
 
        
        
        MainGenerator mg =new MainGenerator();
 
        for(File f:biopaxFileList){
        	  if(!f.exists()) {
        	 	   cs.setError("input file not found ("+f.getAbsolutePath() +")");
        	       cs.setStatus(1);
        	       displayResponse(gson, cs);
        	       System.exit(1);
        	  }
        }

  try {
	  

		 List<Model> models=new ArrayList<Model>();

		for(File fi:biopaxFileList){
			models.add(mg.readBiopax3File(fi));
		}
		
		 mg.mergeBioPax3ToFile(ouputBiopaxFilePath,models);

        cs.setError(null);
        cs.setStatus(0);
        cs.setMessage("merged biopax file generated");
        cs.setOutput(ouputBiopaxFilePath);
        displayResponse(gson, cs);
  }catch(Exception ex) {
	    cs.setError(ex.getMessage());
        cs.setStatus(1);
        displayResponse(gson, cs);
        System.exit(1);
  }
    }


	private static void displayResponse(final Gson gson, CmdResponse cs) {
		System.out.println( SEP);
		System.out.println(  gson.toJson(cs));
	}
	
	
	
	private static void createMergedBioPax(GraphConfig gc ) throws IOException, FileNotFoundException {
		 
	
	}
 
		

}
