package dyliss.biopax.app;
import java.io.File;
import java.io.IOException;

import org.apache.commons.cli.*;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import dyliss.biopax.util.LogUtils;

import java.util.logging.*;
public class Pax2GraphML {
	
	private static Logger logger = Logger.getLogger("dyliss.biopax");
	private static final String DEFAULT_GRAPHML_TEMPLATE = "graphml.vm";
	private static final String DEFAULT_BLACKLIST = "blacklist.txt";
    private static final String SEP = "###";

	
	public static void main(String[] args) throws Exception {


		 
		  LogUtils.STDOUT=false;
		  
		final GsonBuilder builder = new GsonBuilder();
	    final Gson gson = builder.create();

		CmdResponse cs = new CmdResponse();
        Options options = new Options();

        Option input = new Option("i", "input", true, "biopax input file path");
        input.setRequired(true);
        options.addOption(input);

        Option output = new Option("o", "output", true, "graphml output file");
        output.setRequired(true);
        options.addOption(output);

        
        Option blacklist = new Option("b", "blacklist", true, "blacklist output file");
        blacklist.setRequired(false);
        options.addOption(blacklist);
        
        Option template = new Option("t", "template", true, "graphml template file");
        template.setRequired(false);
        options.addOption(template);
        
        CommandLineParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd=null;

        try {
              cmd = parser.parse(options, args);
        } catch (ParseException e) {
         //       LogUtils.info(e.getMessage());
             //  formatter.printHelp("pax2graphml", options);
            //   logger.log(Level.WARNING, "command line arguments error", e);
               cs.setError(e.getMessage());
               cs.setStatus(1);
               displayResponse(gson, cs);
               System.exit(1);
        }

        String inputBiopaxFile = cmd.getOptionValue("input");
        String graphmlOutputFilePath = cmd.getOptionValue("output");
        
        
        Boolean doGenerateBlackList=false;
        String blackListFile= null;
        if (cmd.getOptionValue("blacklist")!=null){
        	blackListFile= cmd.getOptionValue("blacklist");
        	doGenerateBlackList=true;
        }else {
        	blackListFile=DEFAULT_BLACKLIST;
        }
       
        String graphmlTemplateFilePath=DEFAULT_GRAPHML_TEMPLATE;
        if (cmd.getOptionValue("template")!=null){
        	graphmlTemplateFilePath= cmd.getOptionValue("template");
        }
        	
        
        
        MainGenerator mg =new MainGenerator();
        
 
        
    	Boolean doGraphml=true;

        
    	
    	Boolean addEntityReference=false;
    	Boolean addComplexComponent=true;
		
		
		
		Boolean doDB=false;
		Boolean doDBtoFile=false;
		Boolean doHub=false;
		
		String hubFile=null;
		String dBFile=null;
		String dbDriver=null;
		String dbUser=null;
		String dbUrl=null;
		String dbPassword=null;
		
  File f = new File(inputBiopaxFile);
  if(!f.exists()) {
 	   cs.setError("input file not found ("+f.getAbsolutePath() +")");
       cs.setStatus(1);
       displayResponse(gson, cs);
       System.exit(1);
  }
  try {
	  
	
	  
        mg.runDoSpaim(  blackListFile,   graphmlOutputFilePath,   f,
    			  doGenerateBlackList,   addEntityReference, 
    			  addComplexComponent,   doGraphml,
    			  graphmlTemplateFilePath,   doDB,   doDBtoFile,   doHub,   hubFile,
    			  dBFile,   dbDriver,   dbUser,   dbUrl,   dbPassword);
        
        cs.setError(null);
        cs.setStatus(0);
        cs.setMessage("graph file generated");
        cs.setOutput(graphmlOutputFilePath);
        displayResponse(gson, cs);
  }catch(Exception ex) {
	    cs.setError(ex.getMessage());
        cs.setStatus(1);
        displayResponse(gson, cs);
        System.exit(1);
  }
    }


	private static void displayResponse(final Gson gson, CmdResponse cs) {
		System.out.println( SEP);
		System.out.println(  gson.toJson(cs));
	}
	

}
