package dyliss.biopax.app;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.Provenance;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import dyliss.biopax.util.LogUtils;


/*
 *  
 bind
 biogrid
 corum
 ctd
 dip
 drugbank
 hprd
 humancyc
 innatedb
 inoh
 intact
 intact_complex
 kegg
 mirtarbase
 msigdb
 netpath
 panther
 pid
 psp
 reactome
 reconx
 smpdb
 wp
 */
public class BioPaxFilter {
	
    private static final String SEP = "###";

	
public static void main(String[] args) throws FileNotFoundException, IOException {
	final GsonBuilder builder = new GsonBuilder();
    final Gson gson = builder.create();

	CmdResponse cs = new CmdResponse();
	String pathname=null;
	
	String outFilePath=null;
	String exludedSource =null;
	
	
	pathname=args[0];
	exludedSource=args[1];
	outFilePath=args[2];
	
	if(pathname==null || exludedSource==null || outFilePath==null){
		System.err.println("error, parameters not set");
		System.exit(1);
	}
	
	try {
		  
		File inputBiopaxFile= new File(pathname);
		MainGenerator m = new MainGenerator();
		Model model = m.readBiopax3File(inputBiopaxFile);
		

		BioPaxFilter bf = new BioPaxFilter();
		bf.filter(model,exludedSource);
		m.writeBioPax3ToFile(  outFilePath, model);
	
		   
		    cs.setError(null);
		    cs.setStatus(0);
		    cs.setMessage("filtered Biopax file generated");
		    cs.setOutput(outFilePath);
		    displayResponse(gson, cs);
			System.exit(0);
		}catch(Exception ex) {
		    cs.setError(ex.getMessage());
		    cs.setStatus(1);
		    displayResponse(gson, cs);
		    System.exit(1);
		}
	
	
}





private static void displayResponse(final Gson gson, CmdResponse cs) {
	System.out.println( SEP);
	System.out.println(  gson.toJson(cs));
}


public static void filter(Model model,String exludedSourceL) {
 
	String[] exsrc = exludedSourceL.split(":");
	
	Set<Entity> entitySet = model.getObjects(Entity.class);
	List  <Entity> entityList = new ArrayList<Entity>();
	for(Entity en : entitySet ){
		entityList.add(en);
	}
	for(Entity en : entityList) {
		
	 //<bp:xref rdf:resource="#RelationshipXref_mirtarbasehttp___mirtarbase_mbc_nctu_edu_tw__mirbase_MI0017373" />

	   
		boolean doremove=false;
		Set<Provenance> dataSource = en.getDataSource();
		if(dataSource!=null){
			for(Provenance p : dataSource){
				 LogUtils.info(p+"--"+p.getDisplayName());
				
				
			for(String exludedSource : exsrc) {
				if(p.getDisplayName().toLowerCase().contains(exludedSource.toLowerCase())){
					doremove=true;
					 LogUtils.info( "--"+en+" removed" );
				}
			}
				
				
				
			}
			
		}
		
		if(doremove==true){
			model.remove(en);
		}
		
		

		//mir
	}

	 
}

}
