import copy
import time

import aiofiles

from .image import tricolor_gradient
from .maimaidx_best_50 import *
from .maimaidx_music import Music, mai


async def update_rating_table() -> str:
    """更新定数表"""
    try:
        dx = Image.open(maimaidir / 'DX.png').convert('RGBA').resize((44, 16))
        diff = [Image.new('RGBA', (75, 16), color) for color in ScoreBaseImage.bg_color]
        atime = 0
        for lv in levelList[5:]:
            _otime = time.time()
            picname = ratingdir / f'{lv}.png'
            lvlist = mai.total_level_data[lv]
            lines = 0
            for _lv in lvlist:
                musicnum = len(lvlist[_lv])
                if musicnum == 0:
                    r = 1
                else:
                    remainder = musicnum % 14
                    r = (musicnum // 14) + (1 if remainder else 0)
                lines += r

            if '+' in lv:
                f = 3
            elif lv == '6':
                f = 10
            else:
                f = 7

            linesheight = 85 * lines
            """
            `85` 为曲绘高度 `80` + 间隔 `5`
            `lines` 为行数
            """
            
            width, height = 1400, 325 + f * 20 + linesheight
            """
            `325` 为顶部文字和底部图片高度 + 上下间隔高度
            `f * 20` 为等级数量 `f` * 等级间隔 `20`
            `linesheight` 为各等级曲绘和间隔总和高度
            """
            
            im = tricolor_gradient(width, height)
            
            im.alpha_composite(ScoreBaseImage.aurora_bg)
            im.alpha_composite(ScoreBaseImage.shines_bg, (34, 0))
            im.alpha_composite(ScoreBaseImage.rainbow_bg, (319, height - 643))
            im.alpha_composite(ScoreBaseImage.rainbow_bottom_bg, (100, height - 343))
            for h in range((height // 358) + 1):
                im.alpha_composite(ScoreBaseImage.pattern_bg, (0, (358 + 7) * h))

            dr = ImageDraw.Draw(im)
            sy = DrawText(dr, SIYUAN)
            ts = DrawText(dr, TBFONT)
            im.alpha_composite(Image.open(maimaidir / 'design.png'), (200, height - 113))
            sy.draw(
                700, 
                height - 70, 
                22, 
                f'Designed by Yuri-YuzuChaN & BlueDeer233. Generated by {maiconfig.botName} BOT', 
                ScoreBaseImage.text_color, 
                'mm'
            )
            y = 100
            for _lv in lvlist: 
                x = 160
                y += 20
                im.alpha_composite(
                    Image.open(maimaidir / 'UI_CMN_Chara_Level_S_01.png').resize((80, 80)), (50, y + 80)
                )
                ts.draw(88, y + 120, 35, _lv, anchor='mm')
                for num, music in enumerate(lvlist[_lv]):
                    if num % 14 == 0:
                        x = 160
                        y += 85
                    else:
                        x += 85
                    cover = Image.open(music_picture(music.id)).resize((75, 75))
                    im.alpha_composite(cover, (x, y))
                    if music.type == 'DX':
                        im.alpha_composite(dx, (x + 31, y))
                    im.alpha_composite(diff[int(music.lv)], (x, y + 59))
                    ts.draw(x + 37, y + 67, 13, music.id, ScoreBaseImage.t_color[int(music.lv)], 'mm')
                if not lvlist[_lv]:
                    y += 85

            by = BytesIO()
            im.save(by, 'PNG')
            async with aiofiles.open(picname, 'wb') as f:
                await f.write(by.getbuffer())
            _ntime = int(time.time() - _otime)
            atime += _ntime
            log.info(f'lv.{lv} 定数表更新完成，耗时：{_ntime}s')
        log.info(f'定数表更新完成，共耗时{atime}s')
        return f'定数表更新完成，共耗时{atime}s'
    except Exception as e:
        log.error(traceback.format_exc())
        return f'定数表更新失败，Error: {e}'


async def update_plate_table() -> str:
    """更新完成表"""
    try:
        version = list(_ for _ in plate_to_version.keys())[1:]
        # version.append('霸')
        # version.append('舞')
        id_bg = Image.new('RGBA', (100, 20), (124, 129, 255, 255))
        rlv: Dict[str, List[Music]] = {}
        for _ in list(reversed(levelList)):
            rlv[_] = []
        for _v in version:
            if _v in platecn:
                _v = platecn[_v]
            if _v in ['熊', '华', '華']:
                _ver = '熊&华'
            elif _v in ['爽', '煌']:
                _ver = '爽&煌'
            elif _v in ['宙', '星']:
                _ver = '宙&星'
            elif _v in ['祭', '祝']:
                _ver = '祭&祝'
            elif _v in ['双', '宴']:
                _ver = '双&宴'
            else:
                _ver = _v
            
            music_id_list = mai.total_plate_id_list[_ver]
            music = mai.total_list.by_id_list(music_id_list)
            ralv = copy.deepcopy(rlv)

            for m in music:
                ralv[m.level[3]].append(m)

            lines = 0
            interval = 0
            for _ in ralv:
                musicnum = len(ralv[_])
                if musicnum == 0:
                    continue
                interval += 1
                remainder = musicnum % 10
                lines += (musicnum // 10) + (1 if remainder else 0)
            
            linesheight = 115 * lines + (interval - 1) * 15
            """
            `linesheight`: 各等级曲绘和间隔总和高度
            
                - `115` 为曲绘高度 `100` + 间隔 `15`
                - `lines` 为行数
                - `interval` 为各等级间隔行数
                - `(interval - 1) * 15` 为各等级间隔高度，各等级之间间隔为 `30`，所以只加 `15`
            """
            width, height = 1400, 150 + linesheight + 360
            """
            `150` 为底部图片 `design` 高度 + 上下间隔高度
            `linesheight` 为各等级曲绘和间隔总和高度
            `360` 为顶部图片 `` 高度 + 上下间隔高度
            """

            im = tricolor_gradient(width, height)
            
            im.alpha_composite(ScoreBaseImage.aurora_bg)
            im.alpha_composite(ScoreBaseImage.shines_bg, (34, 0))
            im.alpha_composite(ScoreBaseImage.rainbow_bg, (319, height - 643))
            im.alpha_composite(ScoreBaseImage.rainbow_bottom_bg, (100, height - 343))
            for h in range((height // 358) + 1):
                im.alpha_composite(ScoreBaseImage.pattern_bg, (0, (358 + 7) * h))
            
            dr = ImageDraw.Draw(im)
            ts = DrawText(dr, TBFONT)
            sy = DrawText(dr, SIYUAN)
            im.alpha_composite(Image.open(maimaidir / 'design.png'), (200, height - 113))
            sy.draw(
                700, 
                height - 70, 
                22, 
                f'Designed by Yuri-YuzuChaN & BlueDeer233. Generated by {maiconfig.botName} BOT', 
                ScoreBaseImage.text_color, 
                'mm'
            )
            y = 245
            for r in ralv:
                if _v in ['霸', '舞']:
                    ralv[r].sort(key=lambda x: x.ds[-1], reverse=True)
                else:
                    ralv[r].sort(key=lambda x: x.ds[3], reverse=True)
                if ralv[r]:
                    y += 15
                    im.alpha_composite(
                        Image.open(maimaidir / 'UI_CMN_Chara_Level_S_01.png'), (65, y + 115)
                    )
                    ts.draw(113, y + 164, 35, r, anchor='mm')
                x = 200
                for num, music in enumerate(ralv[r]):
                    if num % 10 == 0:
                        x = 200
                        y += 115
                    else:
                        x += 115
                    cover = music_picture(music.id)
                    im.alpha_composite(Image.open(cover).resize((100, 100)), (x, y))
                    im.alpha_composite(id_bg, (x, y + 80))
                    ts.draw(x + 50, y + 88, 20, music.id, anchor='mm')

            by = BytesIO()
            im.save(by, 'PNG')
            async with aiofiles.open(platedir / f'{_v}.png', 'wb') as f:
                await f.write(by.getbuffer())
            log.info(f'{_v}代牌子更新完成')
        return f'完成表更新完成'
    except Exception as e:
        log.error(traceback.format_exc())
        return f'完成表更新失败，Error: {e}'