# Generated by Django 3.2.14 on 2022-07-19 11:27

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('saas', '0014_v0_9_3'),
    ]

    operations = [
        migrations.AlterField(
            model_name='balanceline',
            name='selector',
            field=models.CharField(blank=True, help_text='Filter on transaction accounts', max_length=255),
        ),
        migrations.AlterField(
            model_name='cartitem',
            name='email',
            field=models.CharField(blank=True, help_text='e-mail of the person that will benefit from the subscription (GroupBuy)', max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name='cartitem',
            name='option',
            field=models.PositiveIntegerField(default=0, help_text='Index in the list of discounts for advance payments'),
        ),
        migrations.AlterField(
            model_name='cartitem',
            name='plan',
            field=models.ForeignKey(help_text='Item in the cart (if plan)', null=True, on_delete=django.db.models.deletion.CASCADE, to='saas.plan'),
        ),
        migrations.AlterField(
            model_name='cartitem',
            name='sync_on',
            field=models.CharField(blank=True, help_text='identifier of the person that will benefit from the subscription (GroupBuy)', max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name='charge',
            name='description',
            field=models.TextField(help_text='Description for the charge as appears on billing statements', null=True),
        ),
        migrations.AlterField(
            model_name='charge',
            name='processor_key',
            field=models.SlugField(help_text='Unique identifier returned by the payment processor', max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name='charge',
            name='state',
            field=models.PositiveSmallIntegerField(choices=[(0, 'created'), (1, 'done'), (2, 'failed'), (3, 'disputed')], default=0, help_text='Current state (i.e. created, done, failed, disputed)'),
        ),
        migrations.AlterField(
            model_name='chargeitem',
            name='invoiced_processor_fee',
            field=models.ForeignKey(help_text='Fee transaction to processor in order to process the transaction invoiced through this charge', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='invoiced_processor_fee_item', to='saas.transaction'),
        ),
        migrations.AlterField(
            model_name='coupon',
            name='description',
            field=models.TextField(blank=True, help_text='Free-form text description for the coupon', null=True),
        ),
        migrations.AlterField(
            model_name='coupon',
            name='discount_type',
            field=models.PositiveSmallIntegerField(choices=[(1, 'percentage'), (2, 'currency'), (3, 'period')], default=1),
        ),
        migrations.AlterField(
            model_name='coupon',
            name='discount_value',
            field=models.PositiveIntegerField(default=0, help_text='Amount of the discount'),
        ),
        migrations.AlterField(
            model_name='organization',
            name='country',
            field=django_countries.fields.CountryField(max_length=2, verbose_name='Country'),
        ),
        migrations.AlterField(
            model_name='organization',
            name='default_timezone',
            field=models.CharField(default='America/Chicago', help_text='Timezone to use when reporting metrics', max_length=100),
        ),
        migrations.AlterField(
            model_name='plan',
            name='broker_fee_percent',
            field=models.PositiveIntegerField(default=0, help_text='Broker fee per transaction (in per 10000).'),
        ),
        migrations.AlterField(
            model_name='plan',
            name='created_at',
            field=models.DateTimeField(auto_now_add=True, help_text='Date/time of creation (in ISO format)'),
        ),
        migrations.AlterField(
            model_name='plan',
            name='description',
            field=models.TextField(help_text='Description of the plan'),
        ),
        migrations.AlterField(
            model_name='plan',
            name='discontinued_at',
            field=models.DateTimeField(blank=True, help_text='Date/time the plan was discountinued (in ISO format)', null=True),
        ),
        migrations.AlterField(
            model_name='plan',
            name='is_active',
            field=models.BooleanField(default=False, help_text='True when a profile can subscribe to the plan'),
        ),
        migrations.AlterField(
            model_name='plan',
            name='optin_on_request',
            field=models.BooleanField(default=False, help_text='True requires a provider to accept the subscription when created by the subscriber'),
        ),
        migrations.AlterField(
            model_name='plan',
            name='organization',
            field=models.ForeignKey(help_text='Profile the plan belongs to', on_delete=django.db.models.deletion.CASCADE, related_name='plans', to='saas.organization'),
        ),
        migrations.AlterField(
            model_name='plan',
            name='period_length',
            field=models.PositiveSmallIntegerField(default=1, help_text='Number of periods for a subscription to the plan (defaults to 1)'),
        ),
        migrations.AlterField(
            model_name='plan',
            name='period_type',
            field=models.PositiveSmallIntegerField(choices=[(1, 'HOURLY'), (2, 'DAILY'), (3, 'WEEKLY'), (4, 'MONTHLY'), (5, 'YEARLY')], default=5, help_text='Natural period length of a subscription to the plan (hourly, daily, weekly, monthly, yearly)'),
        ),
        migrations.AlterField(
            model_name='plan',
            name='renewal_type',
            field=models.PositiveSmallIntegerField(choices=[(0, 'ONE-TIME'), (1, 'AUTO-RENEW'), (2, 'REPEAT')], default=1, help_text='What happens at the end of a subscription period (one-time, auto-renew, repeat)'),
        ),
        migrations.AlterField(
            model_name='plan',
            name='skip_optin_on_grant',
            field=models.BooleanField(default=False, help_text='True requires a subscriber to accept the subscription when created by the provider'),
        ),
        migrations.AlterField(
            model_name='plan',
            name='slug',
            field=models.SlugField(help_text='Unique identifier shown in the URL bar', unique=True),
        ),
        migrations.AlterField(
            model_name='plan',
            name='title',
            field=models.CharField(help_text='Title of the plan', max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name='plan',
            name='unit',
            field=models.CharField(default='usd', help_text='Three-letter ISO 4217 code for currency unit (ex: usd)', max_length=3),
        ),
        migrations.AlterField(
            model_name='role',
            name='created_at',
            field=models.DateTimeField(auto_now_add=True, help_text='Date/time of creation (in ISO format)'),
        ),
        migrations.AlterField(
            model_name='role',
            name='grant_key',
            field=models.SlugField(blank=True, help_text='Key to identify the grant of the role', max_length=40, null=True),
        ),
        migrations.AlterField(
            model_name='role',
            name='request_key',
            field=models.SlugField(blank=True, help_text='Key to identify the request for the role', max_length=40, null=True),
        ),
        migrations.AlterField(
            model_name='roledescription',
            name='skip_optin_on_grant',
            field=models.BooleanField(default=False, help_text='Automatically grants the role without requiring a user to accept it.'),
        ),
        migrations.AlterField(
            model_name='subscription',
            name='organization',
            field=models.ForeignKey(help_text='Profile subscribed to the plan', on_delete=django.db.models.deletion.CASCADE, related_name='subscriptions', to='saas.organization'),
        ),
        migrations.AlterField(
            model_name='transaction',
            name='dest_organization',
            field=models.ForeignKey(help_text='Billing profile to which funds are deposited', on_delete=django.db.models.deletion.PROTECT, related_name='incoming', to='saas.organization'),
        ),
        migrations.AlterField(
            model_name='transaction',
            name='orig_organization',
            field=models.ForeignKey(help_text='Billing profile from which funds are withdrawn', on_delete=django.db.models.deletion.PROTECT, related_name='outgoing', to='saas.organization'),
        ),
    ]
