#!/usr/bin/env python2
# -*- coding: utf-8 -*-

from collections import namedtuple
import numpy as np

class debugCore():

    def __init__(self):

        rho1d= np.concatenate((np.linspace(0, 0.8, 10, endpoint=False), np.linspace(0.8, 1, 100, endpoint=True)))
        self.a = 0.5640316391827651
        self.kappa = namedtuple('kappa', 'axis sep')(1.2507812426138631,1.6533128554966692)
        self.shaf_shift = 0.04273763321406595
        self.theta, self.rho = np.meshgrid([0., 1.], rho1d)
        loader=np.loadtxt("inputs/nbDebugProfs.dat")
        # This named tuple is generated by:
        #
        # np.savetxt('nbDebugProfs.dat', (core.n.e[:,0] / ((1.+.025*6.0)), core.n.e[:, 0], core.T.i.kev[:, 0], core.T.e.kev[:, 0]))
        #
        # in a module supporting calls to core. 9/4/2018 nbeams debug profiles obtained from shot 118890.1560

        self.n = namedtuple('n','i e')(np.array([loader[0],loader[0]]).transpose(),np.array([loader[1],loader[1]]).transpose())
        self.T = namedtuple('T','i e')(namedtuple('i', 'kev')(np.array([loader[2],loader[2]]).transpose()),
                                       namedtuple('e', 'kev')(np.array([loader[3],loader[3]]).transpose()))


        self.pts = namedtuple('pts','axis')(namedtuple('axis','mag')([1.7151768587049954,None]))
        self.kappa_vals = namedtuple('kappa_vals', 'axis sep')(1.2507812426138631, 1.6533128554966692)
