# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetApiKeyResult',
    'AwaitableGetApiKeyResult',
    'get_api_key',
    'get_api_key_output',
]

@pulumi.output_type
class GetApiKeyResult:
    def __init__(__self__, a_pi_key_id=None, customer_id=None, description=None, enabled=None, stage_keys=None, tags=None):
        if a_pi_key_id and not isinstance(a_pi_key_id, str):
            raise TypeError("Expected argument 'a_pi_key_id' to be a str")
        pulumi.set(__self__, "a_pi_key_id", a_pi_key_id)
        if customer_id and not isinstance(customer_id, str):
            raise TypeError("Expected argument 'customer_id' to be a str")
        pulumi.set(__self__, "customer_id", customer_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if stage_keys and not isinstance(stage_keys, list):
            raise TypeError("Expected argument 'stage_keys' to be a list")
        pulumi.set(__self__, "stage_keys", stage_keys)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="aPIKeyId")
    def a_pi_key_id(self) -> Optional[str]:
        """
        A Unique Key ID which identifies the API Key. Generated by the Create API and returned by the Read and List APIs 
        """
        return pulumi.get(self, "a_pi_key_id")

    @property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> Optional[str]:
        """
        An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
        """
        return pulumi.get(self, "customer_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the purpose of the API key.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Indicates whether the API key can be used by clients.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="stageKeys")
    def stage_keys(self) -> Optional[Sequence['outputs.ApiKeyStageKey']]:
        """
        A list of stages to associate with this API key.
        """
        return pulumi.get(self, "stage_keys")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.ApiKeyTag']]:
        """
        An array of arbitrary tags (key-value pairs) to associate with the API key.
        """
        return pulumi.get(self, "tags")


class AwaitableGetApiKeyResult(GetApiKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiKeyResult(
            a_pi_key_id=self.a_pi_key_id,
            customer_id=self.customer_id,
            description=self.description,
            enabled=self.enabled,
            stage_keys=self.stage_keys,
            tags=self.tags)


def get_api_key(a_pi_key_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiKeyResult:
    """
    Resource Type definition for AWS::ApiGateway::ApiKey


    :param str a_pi_key_id: A Unique Key ID which identifies the API Key. Generated by the Create API and returned by the Read and List APIs 
    """
    __args__ = dict()
    __args__['aPIKeyId'] = a_pi_key_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:apigateway:getApiKey', __args__, opts=opts, typ=GetApiKeyResult).value

    return AwaitableGetApiKeyResult(
        a_pi_key_id=__ret__.a_pi_key_id,
        customer_id=__ret__.customer_id,
        description=__ret__.description,
        enabled=__ret__.enabled,
        stage_keys=__ret__.stage_keys,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_api_key)
def get_api_key_output(a_pi_key_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApiKeyResult]:
    """
    Resource Type definition for AWS::ApiGateway::ApiKey


    :param str a_pi_key_id: A Unique Key ID which identifies the API Key. Generated by the Create API and returned by the Read and List APIs 
    """
    ...
