# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['check_docker']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['check_docker = check_docker.check_docker:main',
                     'check_swarm = check_docker.check_swarm:main']}

setup_kwargs = {
    'name': 'check-docker',
    'version': '2.2.2',
    'description': 'Nagios/NRPE compatible plugins for checking Docker based services',
    'long_description': '|Build Status| |Code Climate| |Test Coverage| |Downloads|\n\n\n============\ncheck_docker\n============\n\nNagios/NRPE compatible plugins for checking docker based services. Currently there are two nagios checks\n\n-  **check_docker** which checks docker container health\n-  **check_swarm** which checks health of swarm nodes and services\n\nWith **check_docker** can use it to check and alert on\n\n-  memory consumption in absolute units (bytes, kb, mb, gb) and as a percentage (0-100%)\n   of the container limit.\n-  CPU usages as a percentage (0-100%) of container limit.\n-  automatic restarts performed by the docker daemon\n-  container status, i.e. is it running?\n-  container health checks are passing?\n-  uptime, i.e. is it able to stay running for a long enough time?\n-  the presence of a container or containers matching specified names\n-  image version, does the running image match that in the remote registry?\n-  image age, when was the image built the last time?\n\nWith **check_swarm** you can alert\n\n-  if a node is not joined to a docker swarm\n-  if a service is running in a swarm\n\nThese checks can communicate with a local docker daemon socket file (default) or with local\nor remote docker daemons using secure and non-secure TCP connections.\n\nThese plugins require python 3. It is tested on 3.5 and greater but may work on older\nversions of 3.\n\nInstallation\n-----------------\n\nWith pip\n::\n\n    pip3 install check_docker\n    --or--\n    pip install check_docker\n\nWith curl\n::\n\n    curl -o /usr/local/bin/check_docker https://raw.githubusercontent.com/timdaman/check_docker/master/check_docker/check_docker.py\n    curl -o /usr/local/bin/check_swarm https://raw.githubusercontent.com/timdaman/check_docker/master/check_docker/check_swarm.py\n    chmod a+rx /usr/local/bin/check_docker /usr/local/bin/check_swarm\n\nWith wget\n::\n\n    wget -O /usr/local/bin/check_docker https://raw.githubusercontent.com/timdaman/check_docker/master/check_docker/check_docker.py\n    wget -O /usr/local/bin/check_swarm https://raw.githubusercontent.com/timdaman/check_docker/master/check_docker/check_swarm.py\n    chmod a+rx /usr/local/bin/check_docker /usr/local/bin/check_swarm\n\n\ncheck_docker Usage\n------------------\n\n::\n\n  usage: check_docker.py [-h]\n                         [--connection [/<path to>/docker.socket|<ip/host address>:<port>]\n                         | --secure-connection [<ip/host address>:<port>]]\n                         [--binary_units | --decimal_units] [--timeout TIMEOUT]\n                         [--containers CONTAINERS [CONTAINERS ...]] [--present]\n                         [--threads THREADS] [--cpu WARN:CRIT]\n                         [--memory WARN:CRIT:UNITS] [--status STATUS] [--health]\n                         [--uptime WARN:CRIT] [--image-age WARN:CRIT] [--version]\n                         [--insecure-registries INSECURE_REGISTRIES [INSECURE_REGISTRIES ...]]\n                         [--restarts WARN:CRIT] [-V]\n\n  Check docker containers.\n\n  optional arguments:\n    -h, --help            show this help message and exit\n    --connection [/<path to>/docker.socket|<ip/host address>:<port>]\n                          Where to find docker daemon socket. (default:\n                          /var/run/docker.sock)\n    --secure-connection [<ip/host address>:<port>]\n                          Where to find TLS protected docker daemon socket.\n    --binary_units        Use a base of 1024 when doing calculations of KB, MB,\n                          GB, & TB (This is default)\n    --decimal_units       Use a base of 1000 when doing calculations of KB, MB,\n                          GB, & TB\n    --timeout TIMEOUT     Connection timeout in seconds. (default: 10.0)\n    --containers CONTAINERS [CONTAINERS ...]\n                          One or more RegEx that match the names of the\n                          container(s) to check. If omitted all containers are\n                          checked. (default: [\'all\'])\n    --present             Modifies --containers so that each RegEx must match at\n                          least one container.\n    --threads THREADS     This + 1 is the maximum number of concurent\n                          threads/network connections. (default: 10)\n    --cpu WARN:CRIT       Check cpu usage percentage taking into account any\n                          limits. Valid values are 0 - 100.\n    --memory WARN:CRIT:UNITS\n                          Check memory usage taking into account any limits.\n                          Valid values for units are %,B,KB,MB,GB.\n    --status STATUS       Desired container status (running, exited, etc).\n    --health              Check container\'s health check status\n    --uptime WARN:CRIT    Minimum container uptime in seconds. Use when\n                          infrequent crashes are tolerated.\n    --image-age WARN:CRIT Maximum image age in days.\n    --version             Check if the running images are the same version as\n                          those in the registry. Useful for finding stale\n                          images. Does not support login.\n    --insecure-registries INSECURE_REGISTRIES [INSECURE_REGISTRIES ...]\n                          List of registries to connect to with http(no TLS).\n                          Useful when using "--version" with images from\n                          insecure registries.\n    --restarts WARN:CRIT  Container restart thresholds.\n    --no-ok               Make output terse suppressing OK messages. If all\n                          checks are OK return a single OK.\n    --no-performance      Suppress performance data. Reduces output when\n                          performance data is not being used.\n    -V                    show program\'s version number and exit\n\n\ncheck_swarm Usage\n-----------------\n\n::\n\n  usage: check_swarm [-h]\n                     [--connection [/<path to>/docker.socket|<ip/host address>:<port>]\n                     | --secure-connection [<ip/host address>:<port>]]\n                     [--timeout TIMEOUT]\n                     (--swarm | --service SERVICE [SERVICE ...]) [-V]\n\n  Check docker swarm.\n\n  optional arguments:\n    -h, --help            show this help message and exit\n    --connection [/<path to>/docker.socket|<ip/host address>:<port>]\n                          Where to find docker daemon socket. (default:\n                          /var/run/docker.sock)\n    --secure-connection [<ip/host address>:<port>]\n                          Where to find TLS protected docker daemon socket.\n    --timeout TIMEOUT     Connection timeout in seconds. (default: 10.0)\n    --swarm               Check swarm status\n    --service SERVICE [SERVICE ...]\n                          One or more RegEx that match the names of the\n                          services(s) to check.\n    -V                    show program\'s version number and exit\n\nGotchas\n-------\n\n-  When using check_docker with older versions of docker (I have seen 1.4 and 1.5) –status only supports ‘running’, ‘restarting’, and ‘paused’.\n-  When using check_docker, if no container is specified, all containers are checked. Some containers may return critcal status if the selected check(s) require a running container.\n-  When using check_docker, --present cannot be used without --containers to indicate what to check the presence of.\n\n.. |Build Status| image:: https://travis-ci.org/timdaman/check_docker.svg?branch=master\n   :target: https://travis-ci.org/timdaman/check_docker\n.. |Code Climate| image:: https://codeclimate.com/github/timdaman/check_docker/badges/gpa.svg\n   :target: https://codeclimate.com/github/timdaman/check_docker\n.. |Test Coverage| image:: https://codeclimate.com/github/timdaman/check_docker/badges/coverage.svg\n   :target: https://codeclimate.com/github/timdaman/check_docker/coverage\n.. |Downloads| image:: http://pepy.tech/badge/check-docker\n   :target: http://pepy.tech/count/check-docker\n',
    'author': 'Tim Laurence',
    'author_email': 'timdaman@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/timdaman/check_docker',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
}


setup(**setup_kwargs)
