# This file was autogenerated from vk-api json schema

from typing import List, Union, Optional, overload
from easy_vk.types import objects
from easy_vk.types import responses
from easy_vk.api_category import BaseCategory
try:
    from typing import Literal
except Exception:
    from typing_extensions import Literal


class Docs(BaseCategory):
    def __init__(self, session, access_token: str, v: str, last_call_timer, delay: float, auto_retry: bool, max_retries: int, timeout: float):
        super().__init__(session, access_token, v, last_call_timer, delay, auto_retry, max_retries, timeout)

    def add(self, owner_id: int, doc_id: int, access_key: Optional[str] = None) -> responses.DocsAdd:
        """
        Copies a document to a user's or community's document list.
        
        :param owner_id: ID of the user or community that owns the document. Use a negative value to designate a community ID.
        :param doc_id: Document ID.
        :param access_key: Access key. This parameter is required if 'access_key' was returned with the document's data.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'docs.add'
        response_type = responses.DocsAdd
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def delete(self, owner_id: int, doc_id: int) -> responses.BaseOk:
        """
        Deletes a user or community document.
        
        :param owner_id: ID of the user or community that owns the document. Use a negative value to designate a community ID.
        :param doc_id: Document ID.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'docs.delete'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def edit(self, owner_id: int, doc_id: int, title: Optional[str] = None, tags: Optional[List[str]] = None) -> responses.BaseOk:
        """
        Edits a document.
        
        :param owner_id: User ID or community ID. Use a negative value to designate a community ID.
        :param doc_id: Document ID.
        :param title: Document title.
        :param tags: Document tags.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'docs.edit'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get(self, count: Optional[int] = None, offset: Optional[int] = None, type_: Optional[int] = None, owner_id: Optional[int] = None, return_tags: Optional[bool] = None) -> responses.DocsGet:
        """
        Returns detailed information about user or community documents.
        
        :param count: Number of documents to return. By default, all documents.
        :param offset: Offset needed to return a specific subset of documents.
        :param type_:
        :param owner_id: ID of the user or community that owns the documents. Use a negative value to designate a community ID.
        :param return_tags:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = [('type_', 'type')]
        method_name = 'docs.get'
        response_type = responses.DocsGet
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_by_id(self, docs: List[str], return_tags: Optional[bool] = None) -> responses.DocsGetById:
        """
        Returns information about documents by their IDs.
        
        :param docs: Document IDs. Example: , "66748_91488,66748_91455",
        :param return_tags:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'docs.getById'
        response_type = responses.DocsGetById
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_messages_upload_server(self, type_: Optional[str] = None, peer_id: Optional[int] = None) -> responses.BaseGetUploadServer:
        """
        Returns the server address for document upload.
        
        :param type_: Document type.
        :param peer_id: Destination ID. "For user: 'User ID', e.g. '12345'. For chat: '2000000000' + 'Chat ID', e.g. '2000000001'. For community: '- Community ID', e.g. '-12345'. "
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = [('type_', 'type')]
        method_name = 'docs.getMessagesUploadServer'
        response_type = responses.BaseGetUploadServer
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_types(self, owner_id: int) -> responses.DocsGetTypes:
        """
        Returns documents types available for current user.
        
        :param owner_id: ID of the user or community that owns the documents. Use a negative value to designate a community ID.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'docs.getTypes'
        response_type = responses.DocsGetTypes
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_upload_server(self, group_id: Optional[int] = None) -> responses.DocsGetUploadServer:
        """
        Returns the server address for document upload.
        
        :param group_id: Community ID (if the document will be uploaded to the community).
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'docs.getUploadServer'
        response_type = responses.DocsGetUploadServer
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_wall_upload_server(self, group_id: Optional[int] = None) -> responses.BaseGetUploadServer:
        """
        Returns the server address for document upload onto a user's or community's wall.
        
        :param group_id: Community ID (if the document will be uploaded to the community).
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'docs.getWallUploadServer'
        response_type = responses.BaseGetUploadServer
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def save(self, file: str, title: Optional[str] = None, tags: Optional[str] = None, return_tags: Optional[bool] = None) -> responses.DocsSave:
        """
        Saves a document after [vk.com/dev/upload_files_2|uploading it to a server].
        
        :param file: This parameter is returned when the file is [vk.com/dev/upload_files_2|uploaded to the server].
        :param title: Document title.
        :param tags: Document tags.
        :param return_tags:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'docs.save'
        response_type = responses.DocsSave
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def search(self, q: str, search_own: Optional[bool] = None, count: Optional[int] = None, offset: Optional[int] = None, return_tags: Optional[bool] = None) -> responses.DocsSearch:
        """
        Returns a list of documents matching the search criteria.
        
        :param q: Search query string.
        :param search_own:
        :param count: Number of results to return.
        :param offset: Offset needed to return a specific subset of results.
        :param return_tags:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'docs.search'
        response_type = responses.DocsSearch
        return self._call(method_name, method_parameters, param_aliases, response_type)
