"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CacheBehavior = void 0;
const distribution_1 = require("../distribution");
/**
 * Allows configuring a variety of CloudFront functionality for a given URL path pattern.
 *
 * Note: This really should simply by called 'Behavior', but this name is already taken by the legacy
 * CloudFrontWebDistribution implementation.
 */
class CacheBehavior {
    constructor(originId, props) {
        this.props = props;
        this.originId = originId;
    }
    /**
     * Creates and returns the CloudFormation representation of this behavior.
     * This renders as a "CacheBehaviorProperty" regardless of if this is a default
     * cache behavior or not, as the two are identical except that the pathPattern
     * is omitted for the default cache behavior.
     *
     * @internal
     */
    _renderBehavior() {
        var _a, _b, _c, _d;
        return {
            pathPattern: this.props.pathPattern,
            targetOriginId: this.originId,
            allowedMethods: (_a = this.props.allowedMethods) === null || _a === void 0 ? void 0 : _a.methods,
            cachedMethods: (_b = this.props.cachedMethods) === null || _b === void 0 ? void 0 : _b.methods,
            compress: this.props.compress,
            forwardedValues: {
                queryString: (_c = this.props.forwardQueryString) !== null && _c !== void 0 ? _c : false,
                queryStringCacheKeys: this.props.forwardQueryStringCacheKeys,
            },
            smoothStreaming: this.props.smoothStreaming,
            viewerProtocolPolicy: (_d = this.props.viewerProtocolPolicy) !== null && _d !== void 0 ? _d : distribution_1.ViewerProtocolPolicy.ALLOW_ALL,
            lambdaFunctionAssociations: this.props.edgeLambdas
                ? this.props.edgeLambdas.map(edgeLambda => ({
                    lambdaFunctionArn: edgeLambda.functionVersion.edgeArn,
                    eventType: edgeLambda.eventType.toString(),
                }))
                : undefined,
        };
    }
}
exports.CacheBehavior = CacheBehavior;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FjaGUtYmVoYXZpb3IuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjYWNoZS1iZWhhdmlvci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSxrREFBMkU7QUFjM0U7Ozs7O0dBS0c7QUFDSCxNQUFhLGFBQWE7SUFHeEIsWUFBWSxRQUFnQixFQUFtQixLQUF5QjtRQUF6QixVQUFLLEdBQUwsS0FBSyxDQUFvQjtRQUN0RSxJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztJQUMzQixDQUFDO0lBRUQ7Ozs7Ozs7T0FPRztJQUNJLGVBQWU7O1FBQ3BCLE9BQU87WUFDTCxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXO1lBQ25DLGNBQWMsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUM3QixjQUFjLFFBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjLDBDQUFFLE9BQU87WUFDbEQsYUFBYSxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSwwQ0FBRSxPQUFPO1lBQ2hELFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7WUFDN0IsZUFBZSxFQUFFO2dCQUNmLFdBQVcsUUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGtCQUFrQixtQ0FBSSxLQUFLO2dCQUNuRCxvQkFBb0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLDJCQUEyQjthQUM3RDtZQUNELGVBQWUsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWU7WUFDM0Msb0JBQW9CLFFBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxvQkFBb0IsbUNBQUksbUNBQW9CLENBQUMsU0FBUztZQUN2RiwwQkFBMEIsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVc7Z0JBQ2hELENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLEVBQUUsQ0FBQyxDQUFDO29CQUMxQyxpQkFBaUIsRUFBRSxVQUFVLENBQUMsZUFBZSxDQUFDLE9BQU87b0JBQ3JELFNBQVMsRUFBRSxVQUFVLENBQUMsU0FBUyxDQUFDLFFBQVEsRUFBRTtpQkFDM0MsQ0FBQyxDQUFDO2dCQUNILENBQUMsQ0FBQyxTQUFTO1NBQ2QsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQXBDRCxzQ0FvQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDZm5EaXN0cmlidXRpb24gfSBmcm9tICcuLi9jbG91ZGZyb250LmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBBZGRCZWhhdmlvck9wdGlvbnMsIFZpZXdlclByb3RvY29sUG9saWN5IH0gZnJvbSAnLi4vZGlzdHJpYnV0aW9uJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBzcGVjaWZ5aW5nIGN1c3RvbSBiZWhhdmlvcnMgZm9yIG9yaWdpbnMuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2FjaGVCZWhhdmlvclByb3BzIGV4dGVuZHMgQWRkQmVoYXZpb3JPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBwYXR0ZXJuIChlLmcuLCBgaW1hZ2VzLyouanBnYCkgdGhhdCBzcGVjaWZpZXMgd2hpY2ggcmVxdWVzdHMgdG8gYXBwbHkgdGhlIGJlaGF2aW9yIHRvLlxuICAgKiBUaGVyZSBtdXN0IGJlIGV4YWN0bHkgb25lIGJlaGF2aW9yIGFzc29jaWF0ZWQgd2l0aCBlYWNoIGBEaXN0cmlidXRpb25gIHRoYXQgaGFzIGEgcGF0aCBwYXR0ZXJuXG4gICAqIG9mICcqJywgd2hpY2ggYWN0cyBhcyB0aGUgY2F0Y2gtYWxsIGRlZmF1bHQgYmVoYXZpb3IuXG4gICAqL1xuICByZWFkb25seSBwYXRoUGF0dGVybjogc3RyaW5nO1xufVxuXG4vKipcbiAqIEFsbG93cyBjb25maWd1cmluZyBhIHZhcmlldHkgb2YgQ2xvdWRGcm9udCBmdW5jdGlvbmFsaXR5IGZvciBhIGdpdmVuIFVSTCBwYXRoIHBhdHRlcm4uXG4gKlxuICogTm90ZTogVGhpcyByZWFsbHkgc2hvdWxkIHNpbXBseSBieSBjYWxsZWQgJ0JlaGF2aW9yJywgYnV0IHRoaXMgbmFtZSBpcyBhbHJlYWR5IHRha2VuIGJ5IHRoZSBsZWdhY3lcbiAqIENsb3VkRnJvbnRXZWJEaXN0cmlidXRpb24gaW1wbGVtZW50YXRpb24uXG4gKi9cbmV4cG9ydCBjbGFzcyBDYWNoZUJlaGF2aW9yIHtcbiAgcHJpdmF0ZSByZWFkb25seSBvcmlnaW5JZDogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKG9yaWdpbklkOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IENhY2hlQmVoYXZpb3JQcm9wcykge1xuICAgIHRoaXMub3JpZ2luSWQgPSBvcmlnaW5JZDtcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGFuZCByZXR1cm5zIHRoZSBDbG91ZEZvcm1hdGlvbiByZXByZXNlbnRhdGlvbiBvZiB0aGlzIGJlaGF2aW9yLlxuICAgKiBUaGlzIHJlbmRlcnMgYXMgYSBcIkNhY2hlQmVoYXZpb3JQcm9wZXJ0eVwiIHJlZ2FyZGxlc3Mgb2YgaWYgdGhpcyBpcyBhIGRlZmF1bHRcbiAgICogY2FjaGUgYmVoYXZpb3Igb3Igbm90LCBhcyB0aGUgdHdvIGFyZSBpZGVudGljYWwgZXhjZXB0IHRoYXQgdGhlIHBhdGhQYXR0ZXJuXG4gICAqIGlzIG9taXR0ZWQgZm9yIHRoZSBkZWZhdWx0IGNhY2hlIGJlaGF2aW9yLlxuICAgKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyBfcmVuZGVyQmVoYXZpb3IoKTogQ2ZuRGlzdHJpYnV0aW9uLkNhY2hlQmVoYXZpb3JQcm9wZXJ0eSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHBhdGhQYXR0ZXJuOiB0aGlzLnByb3BzLnBhdGhQYXR0ZXJuLFxuICAgICAgdGFyZ2V0T3JpZ2luSWQ6IHRoaXMub3JpZ2luSWQsXG4gICAgICBhbGxvd2VkTWV0aG9kczogdGhpcy5wcm9wcy5hbGxvd2VkTWV0aG9kcz8ubWV0aG9kcyxcbiAgICAgIGNhY2hlZE1ldGhvZHM6IHRoaXMucHJvcHMuY2FjaGVkTWV0aG9kcz8ubWV0aG9kcyxcbiAgICAgIGNvbXByZXNzOiB0aGlzLnByb3BzLmNvbXByZXNzLFxuICAgICAgZm9yd2FyZGVkVmFsdWVzOiB7XG4gICAgICAgIHF1ZXJ5U3RyaW5nOiB0aGlzLnByb3BzLmZvcndhcmRRdWVyeVN0cmluZyA/PyBmYWxzZSxcbiAgICAgICAgcXVlcnlTdHJpbmdDYWNoZUtleXM6IHRoaXMucHJvcHMuZm9yd2FyZFF1ZXJ5U3RyaW5nQ2FjaGVLZXlzLFxuICAgICAgfSxcbiAgICAgIHNtb290aFN0cmVhbWluZzogdGhpcy5wcm9wcy5zbW9vdGhTdHJlYW1pbmcsXG4gICAgICB2aWV3ZXJQcm90b2NvbFBvbGljeTogdGhpcy5wcm9wcy52aWV3ZXJQcm90b2NvbFBvbGljeSA/PyBWaWV3ZXJQcm90b2NvbFBvbGljeS5BTExPV19BTEwsXG4gICAgICBsYW1iZGFGdW5jdGlvbkFzc29jaWF0aW9uczogdGhpcy5wcm9wcy5lZGdlTGFtYmRhc1xuICAgICAgICA/IHRoaXMucHJvcHMuZWRnZUxhbWJkYXMubWFwKGVkZ2VMYW1iZGEgPT4gKHtcbiAgICAgICAgICBsYW1iZGFGdW5jdGlvbkFybjogZWRnZUxhbWJkYS5mdW5jdGlvblZlcnNpb24uZWRnZUFybixcbiAgICAgICAgICBldmVudFR5cGU6IGVkZ2VMYW1iZGEuZXZlbnRUeXBlLnRvU3RyaW5nKCksXG4gICAgICAgIH0pKVxuICAgICAgICA6IHVuZGVmaW5lZCxcbiAgICB9O1xuICB9XG59XG4iXX0=