// ****
// Auto-generated by cainome do not edit.
// ****

#![allow(clippy::all)]
#![allow(warnings)]

use serde::{Deserialize, Serialize};

#[derive(Clone, Serialize, Deserialize, Debug)]
pub struct EkuboCore<A: starknet::accounts::ConnectedAccount + Sync> {
    pub address: starknet::core::types::Felt,
    pub account: A,
    pub block_id: starknet::core::types::BlockId,
}
impl<A: starknet::accounts::ConnectedAccount + Sync> EkuboCore<A> {
    pub fn new(address: starknet::core::types::Felt, account: A) -> Self {
        Self {
            address,
            account,
            block_id: starknet::core::types::BlockId::Tag(starknet::core::types::BlockTag::Pending),
        }
    }
    pub fn set_contract_address(&mut self, address: starknet::core::types::Felt) {
        self.address = address;
    }
    pub fn provider(&self) -> &A::Provider {
        self.account.provider()
    }
    pub fn set_block(&mut self, block_id: starknet::core::types::BlockId) {
        self.block_id = block_id;
    }
    pub fn with_block(self, block_id: starknet::core::types::BlockId) -> Self {
        Self { block_id, ..self }
    }
}
#[derive(Clone, Serialize, Deserialize, Debug)]
pub struct EkuboCoreReader<P: starknet::providers::Provider + Sync> {
    pub address: starknet::core::types::Felt,
    pub provider: P,
    pub block_id: starknet::core::types::BlockId,
}
impl<P: starknet::providers::Provider + Sync> EkuboCoreReader<P> {
    pub fn new(address: starknet::core::types::Felt, provider: P) -> Self {
        Self {
            address,
            provider,
            block_id: starknet::core::types::BlockId::Tag(starknet::core::types::BlockTag::Pending),
        }
    }
    pub fn set_contract_address(&mut self, address: starknet::core::types::Felt) {
        self.address = address;
    }
    pub fn provider(&self) -> &P {
        &self.provider
    }
    pub fn set_block(&mut self, block_id: starknet::core::types::BlockId) {
        self.block_id = block_id;
    }
    pub fn with_block(self, block_id: starknet::core::types::BlockId) -> Self {
        Self { block_id, ..self }
    }
}
#[derive(PartialEq)]
pub struct Bounds {
    pub lower: I129,
    pub upper: I129,
}
impl cainome::cairo_serde::CairoSerde for Bounds {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += I129::cairo_serialized_size(&__rust.lower);
        __size += I129::cairo_serialized_size(&__rust.upper);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(I129::cairo_serialize(&__rust.lower));
        __out.extend(I129::cairo_serialize(&__rust.upper));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let lower = I129::cairo_deserialize(__felts, __offset)?;
        __offset += I129::cairo_serialized_size(&lower);
        let upper = I129::cairo_deserialize(__felts, __offset)?;
        __offset += I129::cairo_serialized_size(&upper);
        Ok(Bounds { lower, upper })
    }
}
#[derive(PartialEq)]
pub struct CallPoints {
    pub before_initialize_pool: bool,
    pub after_initialize_pool: bool,
    pub before_swap: bool,
    pub after_swap: bool,
    pub before_update_position: bool,
    pub after_update_position: bool,
    pub before_collect_fees: bool,
    pub after_collect_fees: bool,
}
impl cainome::cairo_serde::CairoSerde for CallPoints {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += bool::cairo_serialized_size(&__rust.before_initialize_pool);
        __size += bool::cairo_serialized_size(&__rust.after_initialize_pool);
        __size += bool::cairo_serialized_size(&__rust.before_swap);
        __size += bool::cairo_serialized_size(&__rust.after_swap);
        __size += bool::cairo_serialized_size(&__rust.before_update_position);
        __size += bool::cairo_serialized_size(&__rust.after_update_position);
        __size += bool::cairo_serialized_size(&__rust.before_collect_fees);
        __size += bool::cairo_serialized_size(&__rust.after_collect_fees);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(bool::cairo_serialize(&__rust.before_initialize_pool));
        __out.extend(bool::cairo_serialize(&__rust.after_initialize_pool));
        __out.extend(bool::cairo_serialize(&__rust.before_swap));
        __out.extend(bool::cairo_serialize(&__rust.after_swap));
        __out.extend(bool::cairo_serialize(&__rust.before_update_position));
        __out.extend(bool::cairo_serialize(&__rust.after_update_position));
        __out.extend(bool::cairo_serialize(&__rust.before_collect_fees));
        __out.extend(bool::cairo_serialize(&__rust.after_collect_fees));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let before_initialize_pool = bool::cairo_deserialize(__felts, __offset)?;
        __offset += bool::cairo_serialized_size(&before_initialize_pool);
        let after_initialize_pool = bool::cairo_deserialize(__felts, __offset)?;
        __offset += bool::cairo_serialized_size(&after_initialize_pool);
        let before_swap = bool::cairo_deserialize(__felts, __offset)?;
        __offset += bool::cairo_serialized_size(&before_swap);
        let after_swap = bool::cairo_deserialize(__felts, __offset)?;
        __offset += bool::cairo_serialized_size(&after_swap);
        let before_update_position = bool::cairo_deserialize(__felts, __offset)?;
        __offset += bool::cairo_serialized_size(&before_update_position);
        let after_update_position = bool::cairo_deserialize(__felts, __offset)?;
        __offset += bool::cairo_serialized_size(&after_update_position);
        let before_collect_fees = bool::cairo_deserialize(__felts, __offset)?;
        __offset += bool::cairo_serialized_size(&before_collect_fees);
        let after_collect_fees = bool::cairo_deserialize(__felts, __offset)?;
        __offset += bool::cairo_serialized_size(&after_collect_fees);
        Ok(CallPoints {
            before_initialize_pool,
            after_initialize_pool,
            before_swap,
            after_swap,
            before_update_position,
            after_update_position,
            before_collect_fees,
            after_collect_fees,
        })
    }
}
#[derive(PartialEq)]
pub struct ClassHashReplaced {
    pub new_class_hash: cainome::cairo_serde::ClassHash,
}
impl cainome::cairo_serde::CairoSerde for ClassHashReplaced {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += cainome::cairo_serde::ClassHash::cairo_serialized_size(&__rust.new_class_hash);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(cainome::cairo_serde::ClassHash::cairo_serialize(
            &__rust.new_class_hash,
        ));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let new_class_hash = cainome::cairo_serde::ClassHash::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ClassHash::cairo_serialized_size(&new_class_hash);
        Ok(ClassHashReplaced { new_class_hash })
    }
}
impl ClassHashReplaced {
    pub fn event_selector() -> starknet::core::types::Felt {
        starknet::core::utils::get_selector_from_name("ClassHashReplaced").unwrap()
    }
    pub fn event_name() -> &'static str {
        "ClassHashReplaced"
    }
}
#[derive(PartialEq, Serialize, Deserialize)]
pub struct Delta {
    pub amount0: I129,
    pub amount1: I129,
}
impl cainome::cairo_serde::CairoSerde for Delta {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += I129::cairo_serialized_size(&__rust.amount0);
        __size += I129::cairo_serialized_size(&__rust.amount1);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(I129::cairo_serialize(&__rust.amount0));
        __out.extend(I129::cairo_serialize(&__rust.amount1));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let amount0 = I129::cairo_deserialize(__felts, __offset)?;
        __offset += I129::cairo_serialized_size(&amount0);
        let amount1 = I129::cairo_deserialize(__felts, __offset)?;
        __offset += I129::cairo_serialized_size(&amount1);
        Ok(Delta { amount0, amount1 })
    }
}
#[derive(PartialEq, Serialize, Deserialize)]
pub struct FeesAccumulated {
    pub pool_key: PoolKey,
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub amount0: u128,
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub amount1: u128,
}
impl cainome::cairo_serde::CairoSerde for FeesAccumulated {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += PoolKey::cairo_serialized_size(&__rust.pool_key);
        __size += u128::cairo_serialized_size(&__rust.amount0);
        __size += u128::cairo_serialized_size(&__rust.amount1);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(PoolKey::cairo_serialize(&__rust.pool_key));
        __out.extend(u128::cairo_serialize(&__rust.amount0));
        __out.extend(u128::cairo_serialize(&__rust.amount1));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let pool_key = PoolKey::cairo_deserialize(__felts, __offset)?;
        __offset += PoolKey::cairo_serialized_size(&pool_key);
        let amount0 = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&amount0);
        let amount1 = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&amount1);
        Ok(FeesAccumulated {
            pool_key,
            amount0,
            amount1,
        })
    }
}
impl FeesAccumulated {
    pub fn event_selector() -> starknet::core::types::Felt {
        starknet::core::utils::get_selector_from_name("FeesAccumulated").unwrap()
    }
    pub fn event_name() -> &'static str {
        "FeesAccumulated"
    }
}
#[derive(PartialEq, Serialize, Deserialize)]
pub struct FeesPerLiquidity {
    pub value0: starknet::core::types::Felt,
    pub value1: starknet::core::types::Felt,
}
impl cainome::cairo_serde::CairoSerde for FeesPerLiquidity {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += starknet::core::types::Felt::cairo_serialized_size(&__rust.value0);
        __size += starknet::core::types::Felt::cairo_serialized_size(&__rust.value1);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(starknet::core::types::Felt::cairo_serialize(&__rust.value0));
        __out.extend(starknet::core::types::Felt::cairo_serialize(&__rust.value1));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let value0 = starknet::core::types::Felt::cairo_deserialize(__felts, __offset)?;
        __offset += starknet::core::types::Felt::cairo_serialized_size(&value0);
        let value1 = starknet::core::types::Felt::cairo_deserialize(__felts, __offset)?;
        __offset += starknet::core::types::Felt::cairo_serialized_size(&value1);
        Ok(FeesPerLiquidity { value0, value1 })
    }
}
#[derive(PartialEq, Serialize, Deserialize)]
pub struct GetPositionWithFeesResult {
    pub position: Position,
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub fees0: u128,
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub fees1: u128,
    pub fees_per_liquidity_inside_current: FeesPerLiquidity,
}
impl cainome::cairo_serde::CairoSerde for GetPositionWithFeesResult {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += Position::cairo_serialized_size(&__rust.position);
        __size += u128::cairo_serialized_size(&__rust.fees0);
        __size += u128::cairo_serialized_size(&__rust.fees1);
        __size +=
            FeesPerLiquidity::cairo_serialized_size(&__rust.fees_per_liquidity_inside_current);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(Position::cairo_serialize(&__rust.position));
        __out.extend(u128::cairo_serialize(&__rust.fees0));
        __out.extend(u128::cairo_serialize(&__rust.fees1));
        __out.extend(FeesPerLiquidity::cairo_serialize(
            &__rust.fees_per_liquidity_inside_current,
        ));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let position = Position::cairo_deserialize(__felts, __offset)?;
        __offset += Position::cairo_serialized_size(&position);
        let fees0 = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&fees0);
        let fees1 = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&fees1);
        let fees_per_liquidity_inside_current =
            FeesPerLiquidity::cairo_deserialize(__felts, __offset)?;
        __offset += FeesPerLiquidity::cairo_serialized_size(&fees_per_liquidity_inside_current);
        Ok(GetPositionWithFeesResult {
            position,
            fees0,
            fees1,
            fees_per_liquidity_inside_current,
        })
    }
}
#[derive(PartialEq, Serialize, Deserialize, Debug)]
pub struct I129 {
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub mag: u128,
    pub sign: bool,
}
impl cainome::cairo_serde::CairoSerde for I129 {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += u128::cairo_serialized_size(&__rust.mag);
        __size += bool::cairo_serialized_size(&__rust.sign);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(u128::cairo_serialize(&__rust.mag));
        __out.extend(bool::cairo_serialize(&__rust.sign));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let mag = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&mag);
        let sign = bool::cairo_deserialize(__felts, __offset)?;
        __offset += bool::cairo_serialized_size(&sign);
        Ok(I129 { mag, sign })
    }
}
#[derive(PartialEq)]
pub struct IForwardeeDispatcher {
    pub contract_address: cainome::cairo_serde::ContractAddress,
}
impl cainome::cairo_serde::CairoSerde for IForwardeeDispatcher {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size +=
            cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.contract_address);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.contract_address,
        ));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let contract_address =
            cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&contract_address);
        Ok(IForwardeeDispatcher { contract_address })
    }
}
#[derive(PartialEq, Serialize, Deserialize)]
pub struct LoadedBalance {
    pub key: SavedBalanceKey,
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub amount: u128,
}
impl cainome::cairo_serde::CairoSerde for LoadedBalance {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += SavedBalanceKey::cairo_serialized_size(&__rust.key);
        __size += u128::cairo_serialized_size(&__rust.amount);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(SavedBalanceKey::cairo_serialize(&__rust.key));
        __out.extend(u128::cairo_serialize(&__rust.amount));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let key = SavedBalanceKey::cairo_deserialize(__felts, __offset)?;
        __offset += SavedBalanceKey::cairo_serialized_size(&key);
        let amount = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&amount);
        Ok(LoadedBalance { key, amount })
    }
}
impl LoadedBalance {
    pub fn event_selector() -> starknet::core::types::Felt {
        starknet::core::utils::get_selector_from_name("LoadedBalance").unwrap()
    }
    pub fn event_name() -> &'static str {
        "LoadedBalance"
    }
}
#[derive(PartialEq)]
pub struct LockerState {
    pub address: cainome::cairo_serde::ContractAddress,
    pub nonzero_delta_count: u32,
}
impl cainome::cairo_serde::CairoSerde for LockerState {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.address);
        __size += u32::cairo_serialized_size(&__rust.nonzero_delta_count);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.address,
        ));
        __out.extend(u32::cairo_serialize(&__rust.nonzero_delta_count));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let address = cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&address);
        let nonzero_delta_count = u32::cairo_deserialize(__felts, __offset)?;
        __offset += u32::cairo_serialized_size(&nonzero_delta_count);
        Ok(LockerState {
            address,
            nonzero_delta_count,
        })
    }
}
#[derive(PartialEq)]
pub struct OwnershipTransferred {
    pub old_owner: cainome::cairo_serde::ContractAddress,
    pub new_owner: cainome::cairo_serde::ContractAddress,
}
impl cainome::cairo_serde::CairoSerde for OwnershipTransferred {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.old_owner);
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.new_owner);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.old_owner,
        ));
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.new_owner,
        ));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let old_owner =
            cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&old_owner);
        let new_owner =
            cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&new_owner);
        Ok(OwnershipTransferred {
            old_owner,
            new_owner,
        })
    }
}
impl OwnershipTransferred {
    pub fn event_selector() -> starknet::core::types::Felt {
        starknet::core::utils::get_selector_from_name("OwnershipTransferred").unwrap()
    }
    pub fn event_name() -> &'static str {
        "OwnershipTransferred"
    }
}
#[derive(PartialEq)]
pub struct PoolInitialized {
    pub pool_key: PoolKey,
    pub initial_tick: I129,
    pub sqrt_ratio: cainome::cairo_serde::U256,
}
impl cainome::cairo_serde::CairoSerde for PoolInitialized {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += PoolKey::cairo_serialized_size(&__rust.pool_key);
        __size += I129::cairo_serialized_size(&__rust.initial_tick);
        __size += cainome::cairo_serde::U256::cairo_serialized_size(&__rust.sqrt_ratio);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(PoolKey::cairo_serialize(&__rust.pool_key));
        __out.extend(I129::cairo_serialize(&__rust.initial_tick));
        __out.extend(cainome::cairo_serde::U256::cairo_serialize(
            &__rust.sqrt_ratio,
        ));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let pool_key = PoolKey::cairo_deserialize(__felts, __offset)?;
        __offset += PoolKey::cairo_serialized_size(&pool_key);
        let initial_tick = I129::cairo_deserialize(__felts, __offset)?;
        __offset += I129::cairo_serialized_size(&initial_tick);
        let sqrt_ratio = cainome::cairo_serde::U256::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::U256::cairo_serialized_size(&sqrt_ratio);
        Ok(PoolInitialized {
            pool_key,
            initial_tick,
            sqrt_ratio,
        })
    }
}
impl PoolInitialized {
    pub fn event_selector() -> starknet::core::types::Felt {
        starknet::core::utils::get_selector_from_name("PoolInitialized").unwrap()
    }
    pub fn event_name() -> &'static str {
        "PoolInitialized"
    }
}
#[derive(PartialEq, Serialize, Deserialize)]
pub struct PoolKey {
    pub token0: cainome::cairo_serde::ContractAddress,
    pub token1: cainome::cairo_serde::ContractAddress,
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub fee: u128,
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub tick_spacing: u128,
    pub extension: cainome::cairo_serde::ContractAddress,
}
impl cainome::cairo_serde::CairoSerde for PoolKey {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.token0);
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.token1);
        __size += u128::cairo_serialized_size(&__rust.fee);
        __size += u128::cairo_serialized_size(&__rust.tick_spacing);
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.extension);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.token0,
        ));
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.token1,
        ));
        __out.extend(u128::cairo_serialize(&__rust.fee));
        __out.extend(u128::cairo_serialize(&__rust.tick_spacing));
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.extension,
        ));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let token0 = cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&token0);
        let token1 = cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&token1);
        let fee = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&fee);
        let tick_spacing = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&tick_spacing);
        let extension =
            cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&extension);
        Ok(PoolKey {
            token0,
            token1,
            fee,
            tick_spacing,
            extension,
        })
    }
}
#[derive(PartialEq, Debug)]
pub struct PoolPrice {
    pub sqrt_ratio: cainome::cairo_serde::U256,
    pub tick: I129,
}
impl cainome::cairo_serde::CairoSerde for PoolPrice {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += cainome::cairo_serde::U256::cairo_serialized_size(&__rust.sqrt_ratio);
        __size += I129::cairo_serialized_size(&__rust.tick);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(cainome::cairo_serde::U256::cairo_serialize(
            &__rust.sqrt_ratio,
        ));
        __out.extend(I129::cairo_serialize(&__rust.tick));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let sqrt_ratio = cainome::cairo_serde::U256::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::U256::cairo_serialized_size(&sqrt_ratio);
        let tick = I129::cairo_deserialize(__felts, __offset)?;
        __offset += I129::cairo_serialized_size(&tick);
        Ok(PoolPrice { sqrt_ratio, tick })
    }
}
#[derive(PartialEq, Serialize, Deserialize)]
pub struct Position {
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub liquidity: u128,
    pub fees_per_liquidity_inside_last: FeesPerLiquidity,
}
impl cainome::cairo_serde::CairoSerde for Position {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += u128::cairo_serialized_size(&__rust.liquidity);
        __size += FeesPerLiquidity::cairo_serialized_size(&__rust.fees_per_liquidity_inside_last);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(u128::cairo_serialize(&__rust.liquidity));
        __out.extend(FeesPerLiquidity::cairo_serialize(
            &__rust.fees_per_liquidity_inside_last,
        ));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let liquidity = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&liquidity);
        let fees_per_liquidity_inside_last =
            FeesPerLiquidity::cairo_deserialize(__felts, __offset)?;
        __offset += FeesPerLiquidity::cairo_serialized_size(&fees_per_liquidity_inside_last);
        Ok(Position {
            liquidity,
            fees_per_liquidity_inside_last,
        })
    }
}
#[derive(PartialEq)]
pub struct PositionFeesCollected {
    pub pool_key: PoolKey,
    pub position_key: PositionKey,
    pub delta: Delta,
}
impl cainome::cairo_serde::CairoSerde for PositionFeesCollected {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += PoolKey::cairo_serialized_size(&__rust.pool_key);
        __size += PositionKey::cairo_serialized_size(&__rust.position_key);
        __size += Delta::cairo_serialized_size(&__rust.delta);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(PoolKey::cairo_serialize(&__rust.pool_key));
        __out.extend(PositionKey::cairo_serialize(&__rust.position_key));
        __out.extend(Delta::cairo_serialize(&__rust.delta));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let pool_key = PoolKey::cairo_deserialize(__felts, __offset)?;
        __offset += PoolKey::cairo_serialized_size(&pool_key);
        let position_key = PositionKey::cairo_deserialize(__felts, __offset)?;
        __offset += PositionKey::cairo_serialized_size(&position_key);
        let delta = Delta::cairo_deserialize(__felts, __offset)?;
        __offset += Delta::cairo_serialized_size(&delta);
        Ok(PositionFeesCollected {
            pool_key,
            position_key,
            delta,
        })
    }
}
impl PositionFeesCollected {
    pub fn event_selector() -> starknet::core::types::Felt {
        starknet::core::utils::get_selector_from_name("PositionFeesCollected").unwrap()
    }
    pub fn event_name() -> &'static str {
        "PositionFeesCollected"
    }
}
#[derive(PartialEq)]
pub struct PositionKey {
    pub salt: starknet::core::types::Felt,
    pub owner: cainome::cairo_serde::ContractAddress,
    pub bounds: Bounds,
}
impl cainome::cairo_serde::CairoSerde for PositionKey {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += starknet::core::types::Felt::cairo_serialized_size(&__rust.salt);
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.owner);
        __size += Bounds::cairo_serialized_size(&__rust.bounds);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(starknet::core::types::Felt::cairo_serialize(&__rust.salt));
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.owner,
        ));
        __out.extend(Bounds::cairo_serialize(&__rust.bounds));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let salt = starknet::core::types::Felt::cairo_deserialize(__felts, __offset)?;
        __offset += starknet::core::types::Felt::cairo_serialized_size(&salt);
        let owner = cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&owner);
        let bounds = Bounds::cairo_deserialize(__felts, __offset)?;
        __offset += Bounds::cairo_serialized_size(&bounds);
        Ok(PositionKey {
            salt,
            owner,
            bounds,
        })
    }
}
#[derive(PartialEq)]
pub struct PositionUpdated {
    pub locker: cainome::cairo_serde::ContractAddress,
    pub pool_key: PoolKey,
    pub params: UpdatePositionParameters,
    pub delta: Delta,
}
impl cainome::cairo_serde::CairoSerde for PositionUpdated {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.locker);
        __size += PoolKey::cairo_serialized_size(&__rust.pool_key);
        __size += UpdatePositionParameters::cairo_serialized_size(&__rust.params);
        __size += Delta::cairo_serialized_size(&__rust.delta);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.locker,
        ));
        __out.extend(PoolKey::cairo_serialize(&__rust.pool_key));
        __out.extend(UpdatePositionParameters::cairo_serialize(&__rust.params));
        __out.extend(Delta::cairo_serialize(&__rust.delta));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let locker = cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&locker);
        let pool_key = PoolKey::cairo_deserialize(__felts, __offset)?;
        __offset += PoolKey::cairo_serialized_size(&pool_key);
        let params = UpdatePositionParameters::cairo_deserialize(__felts, __offset)?;
        __offset += UpdatePositionParameters::cairo_serialized_size(&params);
        let delta = Delta::cairo_deserialize(__felts, __offset)?;
        __offset += Delta::cairo_serialized_size(&delta);
        Ok(PositionUpdated {
            locker,
            pool_key,
            params,
            delta,
        })
    }
}
impl PositionUpdated {
    pub fn event_selector() -> starknet::core::types::Felt {
        starknet::core::utils::get_selector_from_name("PositionUpdated").unwrap()
    }
    pub fn event_name() -> &'static str {
        "PositionUpdated"
    }
}
#[derive(PartialEq)]
pub struct ProtocolFeesPaid {
    pub pool_key: PoolKey,
    pub position_key: PositionKey,
    pub delta: Delta,
}
impl cainome::cairo_serde::CairoSerde for ProtocolFeesPaid {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += PoolKey::cairo_serialized_size(&__rust.pool_key);
        __size += PositionKey::cairo_serialized_size(&__rust.position_key);
        __size += Delta::cairo_serialized_size(&__rust.delta);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(PoolKey::cairo_serialize(&__rust.pool_key));
        __out.extend(PositionKey::cairo_serialize(&__rust.position_key));
        __out.extend(Delta::cairo_serialize(&__rust.delta));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let pool_key = PoolKey::cairo_deserialize(__felts, __offset)?;
        __offset += PoolKey::cairo_serialized_size(&pool_key);
        let position_key = PositionKey::cairo_deserialize(__felts, __offset)?;
        __offset += PositionKey::cairo_serialized_size(&position_key);
        let delta = Delta::cairo_deserialize(__felts, __offset)?;
        __offset += Delta::cairo_serialized_size(&delta);
        Ok(ProtocolFeesPaid {
            pool_key,
            position_key,
            delta,
        })
    }
}
impl ProtocolFeesPaid {
    pub fn event_selector() -> starknet::core::types::Felt {
        starknet::core::utils::get_selector_from_name("ProtocolFeesPaid").unwrap()
    }
    pub fn event_name() -> &'static str {
        "ProtocolFeesPaid"
    }
}
#[derive(PartialEq, Serialize, Deserialize)]
pub struct ProtocolFeesWithdrawn {
    pub recipient: cainome::cairo_serde::ContractAddress,
    pub token: cainome::cairo_serde::ContractAddress,
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub amount: u128,
}
impl cainome::cairo_serde::CairoSerde for ProtocolFeesWithdrawn {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.recipient);
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.token);
        __size += u128::cairo_serialized_size(&__rust.amount);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.recipient,
        ));
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.token,
        ));
        __out.extend(u128::cairo_serialize(&__rust.amount));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let recipient =
            cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&recipient);
        let token = cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&token);
        let amount = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&amount);
        Ok(ProtocolFeesWithdrawn {
            recipient,
            token,
            amount,
        })
    }
}
impl ProtocolFeesWithdrawn {
    pub fn event_selector() -> starknet::core::types::Felt {
        starknet::core::utils::get_selector_from_name("ProtocolFeesWithdrawn").unwrap()
    }
    pub fn event_name() -> &'static str {
        "ProtocolFeesWithdrawn"
    }
}
#[derive(PartialEq, Serialize, Deserialize)]
pub struct SavedBalance {
    pub key: SavedBalanceKey,
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub amount: u128,
}
impl cainome::cairo_serde::CairoSerde for SavedBalance {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += SavedBalanceKey::cairo_serialized_size(&__rust.key);
        __size += u128::cairo_serialized_size(&__rust.amount);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(SavedBalanceKey::cairo_serialize(&__rust.key));
        __out.extend(u128::cairo_serialize(&__rust.amount));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let key = SavedBalanceKey::cairo_deserialize(__felts, __offset)?;
        __offset += SavedBalanceKey::cairo_serialized_size(&key);
        let amount = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&amount);
        Ok(SavedBalance { key, amount })
    }
}
impl SavedBalance {
    pub fn event_selector() -> starknet::core::types::Felt {
        starknet::core::utils::get_selector_from_name("SavedBalance").unwrap()
    }
    pub fn event_name() -> &'static str {
        "SavedBalance"
    }
}
#[derive(PartialEq, Serialize, Deserialize)]
pub struct SavedBalanceKey {
    pub owner: cainome::cairo_serde::ContractAddress,
    pub token: cainome::cairo_serde::ContractAddress,
    pub salt: starknet::core::types::Felt,
}
impl cainome::cairo_serde::CairoSerde for SavedBalanceKey {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.owner);
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.token);
        __size += starknet::core::types::Felt::cairo_serialized_size(&__rust.salt);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.owner,
        ));
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.token,
        ));
        __out.extend(starknet::core::types::Felt::cairo_serialize(&__rust.salt));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let owner = cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&owner);
        let token = cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&token);
        let salt = starknet::core::types::Felt::cairo_deserialize(__felts, __offset)?;
        __offset += starknet::core::types::Felt::cairo_serialized_size(&salt);
        Ok(SavedBalanceKey { owner, token, salt })
    }
}
#[derive(PartialEq, Serialize, Deserialize)]
pub struct SwapParameters {
    pub amount: I129,
    pub is_token1: bool,
    pub sqrt_ratio_limit: cainome::cairo_serde::U256,
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub skip_ahead: u128,
}
impl cainome::cairo_serde::CairoSerde for SwapParameters {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += I129::cairo_serialized_size(&__rust.amount);
        __size += bool::cairo_serialized_size(&__rust.is_token1);
        __size += cainome::cairo_serde::U256::cairo_serialized_size(&__rust.sqrt_ratio_limit);
        __size += u128::cairo_serialized_size(&__rust.skip_ahead);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(I129::cairo_serialize(&__rust.amount));
        __out.extend(bool::cairo_serialize(&__rust.is_token1));
        __out.extend(cainome::cairo_serde::U256::cairo_serialize(
            &__rust.sqrt_ratio_limit,
        ));
        __out.extend(u128::cairo_serialize(&__rust.skip_ahead));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let amount = I129::cairo_deserialize(__felts, __offset)?;
        __offset += I129::cairo_serialized_size(&amount);
        let is_token1 = bool::cairo_deserialize(__felts, __offset)?;
        __offset += bool::cairo_serialized_size(&is_token1);
        let sqrt_ratio_limit = cainome::cairo_serde::U256::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::U256::cairo_serialized_size(&sqrt_ratio_limit);
        let skip_ahead = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&skip_ahead);
        Ok(SwapParameters {
            amount,
            is_token1,
            sqrt_ratio_limit,
            skip_ahead,
        })
    }
}
#[derive(PartialEq, Serialize, Deserialize)]
pub struct Swapped {
    pub locker: cainome::cairo_serde::ContractAddress,
    pub pool_key: PoolKey,
    pub params: SwapParameters,
    pub delta: Delta,
    pub sqrt_ratio_after: cainome::cairo_serde::U256,
    pub tick_after: I129,
    #[serde(
        serialize_with = "cainome::cairo_serde::serialize_as_hex",
        deserialize_with = "cainome::cairo_serde::deserialize_from_hex"
    )]
    pub liquidity_after: u128,
}
impl cainome::cairo_serde::CairoSerde for Swapped {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&__rust.locker);
        __size += PoolKey::cairo_serialized_size(&__rust.pool_key);
        __size += SwapParameters::cairo_serialized_size(&__rust.params);
        __size += Delta::cairo_serialized_size(&__rust.delta);
        __size += cainome::cairo_serde::U256::cairo_serialized_size(&__rust.sqrt_ratio_after);
        __size += I129::cairo_serialized_size(&__rust.tick_after);
        __size += u128::cairo_serialized_size(&__rust.liquidity_after);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            &__rust.locker,
        ));
        __out.extend(PoolKey::cairo_serialize(&__rust.pool_key));
        __out.extend(SwapParameters::cairo_serialize(&__rust.params));
        __out.extend(Delta::cairo_serialize(&__rust.delta));
        __out.extend(cainome::cairo_serde::U256::cairo_serialize(
            &__rust.sqrt_ratio_after,
        ));
        __out.extend(I129::cairo_serialize(&__rust.tick_after));
        __out.extend(u128::cairo_serialize(&__rust.liquidity_after));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let locker = cainome::cairo_serde::ContractAddress::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&locker);
        let pool_key = PoolKey::cairo_deserialize(__felts, __offset)?;
        __offset += PoolKey::cairo_serialized_size(&pool_key);
        let params = SwapParameters::cairo_deserialize(__felts, __offset)?;
        __offset += SwapParameters::cairo_serialized_size(&params);
        let delta = Delta::cairo_deserialize(__felts, __offset)?;
        __offset += Delta::cairo_serialized_size(&delta);
        let sqrt_ratio_after = cainome::cairo_serde::U256::cairo_deserialize(__felts, __offset)?;
        __offset += cainome::cairo_serde::U256::cairo_serialized_size(&sqrt_ratio_after);
        let tick_after = I129::cairo_deserialize(__felts, __offset)?;
        __offset += I129::cairo_serialized_size(&tick_after);
        let liquidity_after = u128::cairo_deserialize(__felts, __offset)?;
        __offset += u128::cairo_serialized_size(&liquidity_after);
        Ok(Swapped {
            locker,
            pool_key,
            params,
            delta,
            sqrt_ratio_after,
            tick_after,
            liquidity_after,
        })
    }
}
impl Swapped {
    pub fn event_selector() -> starknet::core::types::Felt {
        starknet::core::utils::get_selector_from_name("Swapped").unwrap()
    }
    pub fn event_name() -> &'static str {
        "Swapped"
    }
}
#[derive(PartialEq)]
pub struct UpdatePositionParameters {
    pub salt: starknet::core::types::Felt,
    pub bounds: Bounds,
    pub liquidity_delta: I129,
}
impl cainome::cairo_serde::CairoSerde for UpdatePositionParameters {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        let mut __size = 0;
        __size += starknet::core::types::Felt::cairo_serialized_size(&__rust.salt);
        __size += Bounds::cairo_serialized_size(&__rust.bounds);
        __size += I129::cairo_serialized_size(&__rust.liquidity_delta);
        __size
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        let mut __out: Vec<starknet::core::types::Felt> = vec![];
        __out.extend(starknet::core::types::Felt::cairo_serialize(&__rust.salt));
        __out.extend(Bounds::cairo_serialize(&__rust.bounds));
        __out.extend(I129::cairo_serialize(&__rust.liquidity_delta));
        __out
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let mut __offset = __offset;
        let salt = starknet::core::types::Felt::cairo_deserialize(__felts, __offset)?;
        __offset += starknet::core::types::Felt::cairo_serialized_size(&salt);
        let bounds = Bounds::cairo_deserialize(__felts, __offset)?;
        __offset += Bounds::cairo_serialized_size(&bounds);
        let liquidity_delta = I129::cairo_deserialize(__felts, __offset)?;
        __offset += I129::cairo_serialized_size(&liquidity_delta);
        Ok(UpdatePositionParameters {
            salt,
            bounds,
            liquidity_delta,
        })
    }
}
#[derive(PartialEq)]
pub enum CoreEvent {
    UpgradeableEvent(UpgradeableEvent),
    OwnedEvent(OwnedEvent),
    ProtocolFeesPaid(ProtocolFeesPaid),
    ProtocolFeesWithdrawn(ProtocolFeesWithdrawn),
    PoolInitialized(PoolInitialized),
    PositionUpdated(PositionUpdated),
    PositionFeesCollected(PositionFeesCollected),
    Swapped(Swapped),
    SavedBalance(SavedBalance),
    LoadedBalance(LoadedBalance),
    FeesAccumulated(FeesAccumulated),
}
impl cainome::cairo_serde::CairoSerde for CoreEvent {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = std::option::Option::None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        match __rust {
            CoreEvent::UpgradeableEvent(val) => UpgradeableEvent::cairo_serialized_size(val) + 1,
            CoreEvent::OwnedEvent(val) => OwnedEvent::cairo_serialized_size(val) + 1,
            CoreEvent::ProtocolFeesPaid(val) => ProtocolFeesPaid::cairo_serialized_size(val) + 1,
            CoreEvent::ProtocolFeesWithdrawn(val) => {
                ProtocolFeesWithdrawn::cairo_serialized_size(val) + 1
            }
            CoreEvent::PoolInitialized(val) => PoolInitialized::cairo_serialized_size(val) + 1,
            CoreEvent::PositionUpdated(val) => PositionUpdated::cairo_serialized_size(val) + 1,
            CoreEvent::PositionFeesCollected(val) => {
                PositionFeesCollected::cairo_serialized_size(val) + 1
            }
            CoreEvent::Swapped(val) => Swapped::cairo_serialized_size(val) + 1,
            CoreEvent::SavedBalance(val) => SavedBalance::cairo_serialized_size(val) + 1,
            CoreEvent::LoadedBalance(val) => LoadedBalance::cairo_serialized_size(val) + 1,
            CoreEvent::FeesAccumulated(val) => FeesAccumulated::cairo_serialized_size(val) + 1,
            _ => 0,
        }
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        match __rust {
            CoreEvent::UpgradeableEvent(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&0usize));
                temp.extend(UpgradeableEvent::cairo_serialize(val));
                temp
            }
            CoreEvent::OwnedEvent(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&1usize));
                temp.extend(OwnedEvent::cairo_serialize(val));
                temp
            }
            CoreEvent::ProtocolFeesPaid(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&2usize));
                temp.extend(ProtocolFeesPaid::cairo_serialize(val));
                temp
            }
            CoreEvent::ProtocolFeesWithdrawn(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&3usize));
                temp.extend(ProtocolFeesWithdrawn::cairo_serialize(val));
                temp
            }
            CoreEvent::PoolInitialized(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&4usize));
                temp.extend(PoolInitialized::cairo_serialize(val));
                temp
            }
            CoreEvent::PositionUpdated(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&5usize));
                temp.extend(PositionUpdated::cairo_serialize(val));
                temp
            }
            CoreEvent::PositionFeesCollected(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&6usize));
                temp.extend(PositionFeesCollected::cairo_serialize(val));
                temp
            }
            CoreEvent::Swapped(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&7usize));
                temp.extend(Swapped::cairo_serialize(val));
                temp
            }
            CoreEvent::SavedBalance(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&8usize));
                temp.extend(SavedBalance::cairo_serialize(val));
                temp
            }
            CoreEvent::LoadedBalance(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&9usize));
                temp.extend(LoadedBalance::cairo_serialize(val));
                temp
            }
            CoreEvent::FeesAccumulated(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&10usize));
                temp.extend(FeesAccumulated::cairo_serialize(val));
                temp
            }
            _ => vec![],
        }
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let __f = __felts[__offset];
        let __index = u128::from_be_bytes(__f.to_bytes_be()[16..].try_into().unwrap());
        match __index as usize {
            0usize => Ok(CoreEvent::UpgradeableEvent(
                UpgradeableEvent::cairo_deserialize(__felts, __offset + 1)?,
            )),
            1usize => Ok(CoreEvent::OwnedEvent(OwnedEvent::cairo_deserialize(
                __felts,
                __offset + 1,
            )?)),
            2usize => Ok(CoreEvent::ProtocolFeesPaid(
                ProtocolFeesPaid::cairo_deserialize(__felts, __offset + 1)?,
            )),
            3usize => Ok(CoreEvent::ProtocolFeesWithdrawn(
                ProtocolFeesWithdrawn::cairo_deserialize(__felts, __offset + 1)?,
            )),
            4usize => Ok(CoreEvent::PoolInitialized(
                PoolInitialized::cairo_deserialize(__felts, __offset + 1)?,
            )),
            5usize => Ok(CoreEvent::PositionUpdated(
                PositionUpdated::cairo_deserialize(__felts, __offset + 1)?,
            )),
            6usize => Ok(CoreEvent::PositionFeesCollected(
                PositionFeesCollected::cairo_deserialize(__felts, __offset + 1)?,
            )),
            7usize => Ok(CoreEvent::Swapped(Swapped::cairo_deserialize(
                __felts,
                __offset + 1,
            )?)),
            8usize => Ok(CoreEvent::SavedBalance(SavedBalance::cairo_deserialize(
                __felts,
                __offset + 1,
            )?)),
            9usize => Ok(CoreEvent::LoadedBalance(LoadedBalance::cairo_deserialize(
                __felts,
                __offset + 1,
            )?)),
            10usize => Ok(CoreEvent::FeesAccumulated(
                FeesAccumulated::cairo_deserialize(__felts, __offset + 1)?,
            )),
            _ => {
                return Err(cainome::cairo_serde::Error::Deserialize(format!(
                    "Index not handle for enum {}",
                    "CoreEvent"
                )));
            }
        }
    }
}
impl TryFrom<&starknet::core::types::EmittedEvent> for CoreEvent {
    type Error = String;
    fn try_from(event: &starknet::core::types::EmittedEvent) -> Result<Self, Self::Error> {
        use cainome::cairo_serde::CairoSerde;
        if event.keys.is_empty() {
            return Err("Event has no key".to_string());
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("ClassHashReplaced")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "ClassHashReplaced"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let new_class_hash = match cainome::cairo_serde::ClassHash::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "new_class_hash", "ClassHashReplaced", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ClassHash::cairo_serialized_size(&new_class_hash);
            return Ok(CoreEvent::UpgradeableEvent(
                UpgradeableEvent::ClassHashReplaced(ClassHashReplaced { new_class_hash }),
            ));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("OwnedEvent")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "OwnedEvent"))
        {
            let selector = event.keys[1];
            if selector
                == starknet::core::utils::get_selector_from_name("OwnershipTransferred")
                    .unwrap_or_else(|_| panic!("Invalid selector for {}", "OwnershipTransferred"))
            {
                let mut key_offset = 1 + 1;
                let mut data_offset = 0;
                let old_owner = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                    &event.data,
                    data_offset,
                ) {
                    Ok(v) => v,
                    Err(e) => {
                        return Err(format!(
                            "Could not deserialize field {} for {}: {:?}",
                            "old_owner", "OwnershipTransferred", e,
                        ));
                    }
                };
                data_offset +=
                    cainome::cairo_serde::ContractAddress::cairo_serialized_size(&old_owner);
                let new_owner = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                    &event.data,
                    data_offset,
                ) {
                    Ok(v) => v,
                    Err(e) => {
                        return Err(format!(
                            "Could not deserialize field {} for {}: {:?}",
                            "new_owner", "OwnershipTransferred", e,
                        ));
                    }
                };
                data_offset +=
                    cainome::cairo_serde::ContractAddress::cairo_serialized_size(&new_owner);
                return Ok(CoreEvent::OwnedEvent(OwnedEvent::OwnershipTransferred(
                    OwnershipTransferred {
                        old_owner,
                        new_owner,
                    },
                )));
            }
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("ProtocolFeesPaid")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "ProtocolFeesPaid"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let pool_key = match PoolKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "pool_key", "ProtocolFeesPaid", e,
                    ));
                }
            };
            data_offset += PoolKey::cairo_serialized_size(&pool_key);
            let position_key = match PositionKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "position_key", "ProtocolFeesPaid", e,
                    ));
                }
            };
            data_offset += PositionKey::cairo_serialized_size(&position_key);
            let delta = match Delta::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "delta", "ProtocolFeesPaid", e,
                    ));
                }
            };
            data_offset += Delta::cairo_serialized_size(&delta);
            return Ok(CoreEvent::ProtocolFeesPaid(ProtocolFeesPaid {
                pool_key,
                position_key,
                delta,
            }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("ProtocolFeesWithdrawn")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "ProtocolFeesWithdrawn"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let recipient = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "recipient", "ProtocolFeesWithdrawn", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&recipient);
            let token = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "token", "ProtocolFeesWithdrawn", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&token);
            let amount = match u128::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "amount", "ProtocolFeesWithdrawn", e,
                    ));
                }
            };
            data_offset += u128::cairo_serialized_size(&amount);
            return Ok(CoreEvent::ProtocolFeesWithdrawn(ProtocolFeesWithdrawn {
                recipient,
                token,
                amount,
            }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("PoolInitialized")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "PoolInitialized"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let pool_key = match PoolKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "pool_key", "PoolInitialized", e,
                    ));
                }
            };
            data_offset += PoolKey::cairo_serialized_size(&pool_key);
            let initial_tick = match I129::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "initial_tick", "PoolInitialized", e,
                    ));
                }
            };
            data_offset += I129::cairo_serialized_size(&initial_tick);
            let sqrt_ratio =
                match cainome::cairo_serde::U256::cairo_deserialize(&event.data, data_offset) {
                    Ok(v) => v,
                    Err(e) => {
                        return Err(format!(
                            "Could not deserialize field {} for {}: {:?}",
                            "sqrt_ratio", "PoolInitialized", e,
                        ));
                    }
                };
            data_offset += cainome::cairo_serde::U256::cairo_serialized_size(&sqrt_ratio);
            return Ok(CoreEvent::PoolInitialized(PoolInitialized {
                pool_key,
                initial_tick,
                sqrt_ratio,
            }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("PositionUpdated")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "PositionUpdated"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let locker = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "locker", "PositionUpdated", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&locker);
            let pool_key = match PoolKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "pool_key", "PositionUpdated", e,
                    ));
                }
            };
            data_offset += PoolKey::cairo_serialized_size(&pool_key);
            let params = match UpdatePositionParameters::cairo_deserialize(&event.data, data_offset)
            {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "params", "PositionUpdated", e,
                    ));
                }
            };
            data_offset += UpdatePositionParameters::cairo_serialized_size(&params);
            let delta = match Delta::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "delta", "PositionUpdated", e,
                    ));
                }
            };
            data_offset += Delta::cairo_serialized_size(&delta);
            return Ok(CoreEvent::PositionUpdated(PositionUpdated {
                locker,
                pool_key,
                params,
                delta,
            }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("PositionFeesCollected")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "PositionFeesCollected"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let pool_key = match PoolKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "pool_key", "PositionFeesCollected", e,
                    ));
                }
            };
            data_offset += PoolKey::cairo_serialized_size(&pool_key);
            let position_key = match PositionKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "position_key", "PositionFeesCollected", e,
                    ));
                }
            };
            data_offset += PositionKey::cairo_serialized_size(&position_key);
            let delta = match Delta::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "delta", "PositionFeesCollected", e,
                    ));
                }
            };
            data_offset += Delta::cairo_serialized_size(&delta);
            return Ok(CoreEvent::PositionFeesCollected(PositionFeesCollected {
                pool_key,
                position_key,
                delta,
            }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("Swapped")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "Swapped"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let locker = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "locker", "Swapped", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&locker);
            let pool_key = match PoolKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "pool_key", "Swapped", e,
                    ));
                }
            };
            data_offset += PoolKey::cairo_serialized_size(&pool_key);
            let params = match SwapParameters::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "params", "Swapped", e,
                    ));
                }
            };
            data_offset += SwapParameters::cairo_serialized_size(&params);
            let delta = match Delta::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "delta", "Swapped", e,
                    ));
                }
            };
            data_offset += Delta::cairo_serialized_size(&delta);
            let sqrt_ratio_after =
                match cainome::cairo_serde::U256::cairo_deserialize(&event.data, data_offset) {
                    Ok(v) => v,
                    Err(e) => {
                        return Err(format!(
                            "Could not deserialize field {} for {}: {:?}",
                            "sqrt_ratio_after", "Swapped", e,
                        ));
                    }
                };
            data_offset += cainome::cairo_serde::U256::cairo_serialized_size(&sqrt_ratio_after);
            let tick_after = match I129::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "tick_after", "Swapped", e,
                    ));
                }
            };
            data_offset += I129::cairo_serialized_size(&tick_after);
            let liquidity_after = match u128::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "liquidity_after", "Swapped", e,
                    ));
                }
            };
            data_offset += u128::cairo_serialized_size(&liquidity_after);
            return Ok(CoreEvent::Swapped(Swapped {
                locker,
                pool_key,
                params,
                delta,
                sqrt_ratio_after,
                tick_after,
                liquidity_after,
            }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("SavedBalance")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "SavedBalance"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let key = match SavedBalanceKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "key", "SavedBalance", e,
                    ));
                }
            };
            data_offset += SavedBalanceKey::cairo_serialized_size(&key);
            let amount = match u128::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "amount", "SavedBalance", e,
                    ));
                }
            };
            data_offset += u128::cairo_serialized_size(&amount);
            return Ok(CoreEvent::SavedBalance(SavedBalance { key, amount }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("LoadedBalance")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "LoadedBalance"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let key = match SavedBalanceKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "key", "LoadedBalance", e,
                    ));
                }
            };
            data_offset += SavedBalanceKey::cairo_serialized_size(&key);
            let amount = match u128::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "amount", "LoadedBalance", e,
                    ));
                }
            };
            data_offset += u128::cairo_serialized_size(&amount);
            return Ok(CoreEvent::LoadedBalance(LoadedBalance { key, amount }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("FeesAccumulated")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "FeesAccumulated"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let pool_key = match PoolKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "pool_key", "FeesAccumulated", e,
                    ));
                }
            };
            data_offset += PoolKey::cairo_serialized_size(&pool_key);
            let amount0 = match u128::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "amount0", "FeesAccumulated", e,
                    ));
                }
            };
            data_offset += u128::cairo_serialized_size(&amount0);
            let amount1 = match u128::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "amount1", "FeesAccumulated", e,
                    ));
                }
            };
            data_offset += u128::cairo_serialized_size(&amount1);
            return Ok(CoreEvent::FeesAccumulated(FeesAccumulated {
                pool_key,
                amount0,
                amount1,
            }));
        }
        Err(format!(
            "Could not match any event from keys {:?}",
            event.keys
        ))
    }
}
impl TryFrom<&starknet::core::types::Event> for CoreEvent {
    type Error = String;
    fn try_from(event: &starknet::core::types::Event) -> Result<Self, Self::Error> {
        use cainome::cairo_serde::CairoSerde;
        if event.keys.is_empty() {
            return Err("Event has no key".to_string());
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("ClassHashReplaced")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "ClassHashReplaced"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let new_class_hash = match cainome::cairo_serde::ClassHash::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "new_class_hash", "ClassHashReplaced", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ClassHash::cairo_serialized_size(&new_class_hash);
            return Ok(CoreEvent::UpgradeableEvent(
                UpgradeableEvent::ClassHashReplaced(ClassHashReplaced { new_class_hash }),
            ));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("OwnedEvent")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "OwnedEvent"))
        {
            let selector = event.keys[1];
            if selector
                == starknet::core::utils::get_selector_from_name("OwnershipTransferred")
                    .unwrap_or_else(|_| panic!("Invalid selector for {}", "OwnershipTransferred"))
            {
                let mut key_offset = 1 + 1;
                let mut data_offset = 0;
                let old_owner = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                    &event.data,
                    data_offset,
                ) {
                    Ok(v) => v,
                    Err(e) => {
                        return Err(format!(
                            "Could not deserialize field {} for {}: {:?}",
                            "old_owner", "OwnershipTransferred", e,
                        ));
                    }
                };
                data_offset +=
                    cainome::cairo_serde::ContractAddress::cairo_serialized_size(&old_owner);
                let new_owner = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                    &event.data,
                    data_offset,
                ) {
                    Ok(v) => v,
                    Err(e) => {
                        return Err(format!(
                            "Could not deserialize field {} for {}: {:?}",
                            "new_owner", "OwnershipTransferred", e,
                        ));
                    }
                };
                data_offset +=
                    cainome::cairo_serde::ContractAddress::cairo_serialized_size(&new_owner);
                return Ok(CoreEvent::OwnedEvent(OwnedEvent::OwnershipTransferred(
                    OwnershipTransferred {
                        old_owner,
                        new_owner,
                    },
                )));
            }
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("ProtocolFeesPaid")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "ProtocolFeesPaid"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let pool_key = match PoolKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "pool_key", "ProtocolFeesPaid", e,
                    ));
                }
            };
            data_offset += PoolKey::cairo_serialized_size(&pool_key);
            let position_key = match PositionKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "position_key", "ProtocolFeesPaid", e,
                    ));
                }
            };
            data_offset += PositionKey::cairo_serialized_size(&position_key);
            let delta = match Delta::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "delta", "ProtocolFeesPaid", e,
                    ));
                }
            };
            data_offset += Delta::cairo_serialized_size(&delta);
            return Ok(CoreEvent::ProtocolFeesPaid(ProtocolFeesPaid {
                pool_key,
                position_key,
                delta,
            }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("ProtocolFeesWithdrawn")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "ProtocolFeesWithdrawn"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let recipient = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "recipient", "ProtocolFeesWithdrawn", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&recipient);
            let token = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "token", "ProtocolFeesWithdrawn", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&token);
            let amount = match u128::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "amount", "ProtocolFeesWithdrawn", e,
                    ));
                }
            };
            data_offset += u128::cairo_serialized_size(&amount);
            return Ok(CoreEvent::ProtocolFeesWithdrawn(ProtocolFeesWithdrawn {
                recipient,
                token,
                amount,
            }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("PoolInitialized")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "PoolInitialized"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let pool_key = match PoolKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "pool_key", "PoolInitialized", e,
                    ));
                }
            };
            data_offset += PoolKey::cairo_serialized_size(&pool_key);
            let initial_tick = match I129::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "initial_tick", "PoolInitialized", e,
                    ));
                }
            };
            data_offset += I129::cairo_serialized_size(&initial_tick);
            let sqrt_ratio =
                match cainome::cairo_serde::U256::cairo_deserialize(&event.data, data_offset) {
                    Ok(v) => v,
                    Err(e) => {
                        return Err(format!(
                            "Could not deserialize field {} for {}: {:?}",
                            "sqrt_ratio", "PoolInitialized", e,
                        ));
                    }
                };
            data_offset += cainome::cairo_serde::U256::cairo_serialized_size(&sqrt_ratio);
            return Ok(CoreEvent::PoolInitialized(PoolInitialized {
                pool_key,
                initial_tick,
                sqrt_ratio,
            }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("PositionUpdated")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "PositionUpdated"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let locker = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "locker", "PositionUpdated", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&locker);
            let pool_key = match PoolKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "pool_key", "PositionUpdated", e,
                    ));
                }
            };
            data_offset += PoolKey::cairo_serialized_size(&pool_key);
            let params = match UpdatePositionParameters::cairo_deserialize(&event.data, data_offset)
            {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "params", "PositionUpdated", e,
                    ));
                }
            };
            data_offset += UpdatePositionParameters::cairo_serialized_size(&params);
            let delta = match Delta::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "delta", "PositionUpdated", e,
                    ));
                }
            };
            data_offset += Delta::cairo_serialized_size(&delta);
            return Ok(CoreEvent::PositionUpdated(PositionUpdated {
                locker,
                pool_key,
                params,
                delta,
            }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("PositionFeesCollected")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "PositionFeesCollected"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let pool_key = match PoolKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "pool_key", "PositionFeesCollected", e,
                    ));
                }
            };
            data_offset += PoolKey::cairo_serialized_size(&pool_key);
            let position_key = match PositionKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "position_key", "PositionFeesCollected", e,
                    ));
                }
            };
            data_offset += PositionKey::cairo_serialized_size(&position_key);
            let delta = match Delta::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "delta", "PositionFeesCollected", e,
                    ));
                }
            };
            data_offset += Delta::cairo_serialized_size(&delta);
            return Ok(CoreEvent::PositionFeesCollected(PositionFeesCollected {
                pool_key,
                position_key,
                delta,
            }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("Swapped")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "Swapped"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let locker = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "locker", "Swapped", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&locker);
            let pool_key = match PoolKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "pool_key", "Swapped", e,
                    ));
                }
            };
            data_offset += PoolKey::cairo_serialized_size(&pool_key);
            let params = match SwapParameters::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "params", "Swapped", e,
                    ));
                }
            };
            data_offset += SwapParameters::cairo_serialized_size(&params);
            let delta = match Delta::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "delta", "Swapped", e,
                    ));
                }
            };
            data_offset += Delta::cairo_serialized_size(&delta);
            let sqrt_ratio_after =
                match cainome::cairo_serde::U256::cairo_deserialize(&event.data, data_offset) {
                    Ok(v) => v,
                    Err(e) => {
                        return Err(format!(
                            "Could not deserialize field {} for {}: {:?}",
                            "sqrt_ratio_after", "Swapped", e,
                        ));
                    }
                };
            data_offset += cainome::cairo_serde::U256::cairo_serialized_size(&sqrt_ratio_after);
            let tick_after = match I129::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "tick_after", "Swapped", e,
                    ));
                }
            };
            data_offset += I129::cairo_serialized_size(&tick_after);
            let liquidity_after = match u128::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "liquidity_after", "Swapped", e,
                    ));
                }
            };
            data_offset += u128::cairo_serialized_size(&liquidity_after);
            return Ok(CoreEvent::Swapped(Swapped {
                locker,
                pool_key,
                params,
                delta,
                sqrt_ratio_after,
                tick_after,
                liquidity_after,
            }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("SavedBalance")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "SavedBalance"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let key = match SavedBalanceKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "key", "SavedBalance", e,
                    ));
                }
            };
            data_offset += SavedBalanceKey::cairo_serialized_size(&key);
            let amount = match u128::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "amount", "SavedBalance", e,
                    ));
                }
            };
            data_offset += u128::cairo_serialized_size(&amount);
            return Ok(CoreEvent::SavedBalance(SavedBalance { key, amount }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("LoadedBalance")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "LoadedBalance"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let key = match SavedBalanceKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "key", "LoadedBalance", e,
                    ));
                }
            };
            data_offset += SavedBalanceKey::cairo_serialized_size(&key);
            let amount = match u128::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "amount", "LoadedBalance", e,
                    ));
                }
            };
            data_offset += u128::cairo_serialized_size(&amount);
            return Ok(CoreEvent::LoadedBalance(LoadedBalance { key, amount }));
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("FeesAccumulated")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "FeesAccumulated"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let pool_key = match PoolKey::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "pool_key", "FeesAccumulated", e,
                    ));
                }
            };
            data_offset += PoolKey::cairo_serialized_size(&pool_key);
            let amount0 = match u128::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "amount0", "FeesAccumulated", e,
                    ));
                }
            };
            data_offset += u128::cairo_serialized_size(&amount0);
            let amount1 = match u128::cairo_deserialize(&event.data, data_offset) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "amount1", "FeesAccumulated", e,
                    ));
                }
            };
            data_offset += u128::cairo_serialized_size(&amount1);
            return Ok(CoreEvent::FeesAccumulated(FeesAccumulated {
                pool_key,
                amount0,
                amount1,
            }));
        }
        Err(format!(
            "Could not match any event from keys {:?}",
            event.keys
        ))
    }
}
#[derive(PartialEq)]
pub enum OwnedEvent {
    OwnershipTransferred(OwnershipTransferred),
}
impl cainome::cairo_serde::CairoSerde for OwnedEvent {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = std::option::Option::None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        match __rust {
            OwnedEvent::OwnershipTransferred(val) => {
                OwnershipTransferred::cairo_serialized_size(val) + 1
            }
            _ => 0,
        }
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        match __rust {
            OwnedEvent::OwnershipTransferred(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&0usize));
                temp.extend(OwnershipTransferred::cairo_serialize(val));
                temp
            }
            _ => vec![],
        }
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let __f = __felts[__offset];
        let __index = u128::from_be_bytes(__f.to_bytes_be()[16..].try_into().unwrap());
        match __index as usize {
            0usize => Ok(OwnedEvent::OwnershipTransferred(
                OwnershipTransferred::cairo_deserialize(__felts, __offset + 1)?,
            )),
            _ => {
                return Err(cainome::cairo_serde::Error::Deserialize(format!(
                    "Index not handle for enum {}",
                    "OwnedEvent"
                )));
            }
        }
    }
}
impl TryFrom<&starknet::core::types::EmittedEvent> for OwnedEvent {
    type Error = String;
    fn try_from(event: &starknet::core::types::EmittedEvent) -> Result<Self, Self::Error> {
        use cainome::cairo_serde::CairoSerde;
        if event.keys.is_empty() {
            return Err("Event has no key".to_string());
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("OwnershipTransferred")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "OwnershipTransferred"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let old_owner = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "old_owner", "OwnershipTransferred", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&old_owner);
            let new_owner = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "new_owner", "OwnershipTransferred", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&new_owner);
            return Ok(OwnedEvent::OwnershipTransferred(OwnershipTransferred {
                old_owner,
                new_owner,
            }));
        }
        Err(format!(
            "Could not match any event from keys {:?}",
            event.keys
        ))
    }
}
impl TryFrom<&starknet::core::types::Event> for OwnedEvent {
    type Error = String;
    fn try_from(event: &starknet::core::types::Event) -> Result<Self, Self::Error> {
        use cainome::cairo_serde::CairoSerde;
        if event.keys.is_empty() {
            return Err("Event has no key".to_string());
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("OwnershipTransferred")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "OwnershipTransferred"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let old_owner = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "old_owner", "OwnershipTransferred", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&old_owner);
            let new_owner = match cainome::cairo_serde::ContractAddress::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "new_owner", "OwnershipTransferred", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ContractAddress::cairo_serialized_size(&new_owner);
            return Ok(OwnedEvent::OwnershipTransferred(OwnershipTransferred {
                old_owner,
                new_owner,
            }));
        }
        Err(format!(
            "Could not match any event from keys {:?}",
            event.keys
        ))
    }
}
#[derive(PartialEq)]
pub enum UpgradeableEvent {
    ClassHashReplaced(ClassHashReplaced),
}
impl cainome::cairo_serde::CairoSerde for UpgradeableEvent {
    type RustType = Self;
    const SERIALIZED_SIZE: std::option::Option<usize> = std::option::Option::None;
    #[inline]
    fn cairo_serialized_size(__rust: &Self::RustType) -> usize {
        match __rust {
            UpgradeableEvent::ClassHashReplaced(val) => {
                ClassHashReplaced::cairo_serialized_size(val) + 1
            }
            _ => 0,
        }
    }
    fn cairo_serialize(__rust: &Self::RustType) -> Vec<starknet::core::types::Felt> {
        match __rust {
            UpgradeableEvent::ClassHashReplaced(val) => {
                let mut temp = vec![];
                temp.extend(usize::cairo_serialize(&0usize));
                temp.extend(ClassHashReplaced::cairo_serialize(val));
                temp
            }
            _ => vec![],
        }
    }
    fn cairo_deserialize(
        __felts: &[starknet::core::types::Felt],
        __offset: usize,
    ) -> cainome::cairo_serde::Result<Self::RustType> {
        let __f = __felts[__offset];
        let __index = u128::from_be_bytes(__f.to_bytes_be()[16..].try_into().unwrap());
        match __index as usize {
            0usize => Ok(UpgradeableEvent::ClassHashReplaced(
                ClassHashReplaced::cairo_deserialize(__felts, __offset + 1)?,
            )),
            _ => {
                return Err(cainome::cairo_serde::Error::Deserialize(format!(
                    "Index not handle for enum {}",
                    "UpgradeableEvent"
                )));
            }
        }
    }
}
impl TryFrom<&starknet::core::types::EmittedEvent> for UpgradeableEvent {
    type Error = String;
    fn try_from(event: &starknet::core::types::EmittedEvent) -> Result<Self, Self::Error> {
        use cainome::cairo_serde::CairoSerde;
        if event.keys.is_empty() {
            return Err("Event has no key".to_string());
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("ClassHashReplaced")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "ClassHashReplaced"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let new_class_hash = match cainome::cairo_serde::ClassHash::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "new_class_hash", "ClassHashReplaced", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ClassHash::cairo_serialized_size(&new_class_hash);
            return Ok(UpgradeableEvent::ClassHashReplaced(ClassHashReplaced {
                new_class_hash,
            }));
        }
        Err(format!(
            "Could not match any event from keys {:?}",
            event.keys
        ))
    }
}
impl TryFrom<&starknet::core::types::Event> for UpgradeableEvent {
    type Error = String;
    fn try_from(event: &starknet::core::types::Event) -> Result<Self, Self::Error> {
        use cainome::cairo_serde::CairoSerde;
        if event.keys.is_empty() {
            return Err("Event has no key".to_string());
        }
        let selector = event.keys[0];
        if selector
            == starknet::core::utils::get_selector_from_name("ClassHashReplaced")
                .unwrap_or_else(|_| panic!("Invalid selector for {}", "ClassHashReplaced"))
        {
            let mut key_offset = 0 + 1;
            let mut data_offset = 0;
            let new_class_hash = match cainome::cairo_serde::ClassHash::cairo_deserialize(
                &event.data,
                data_offset,
            ) {
                Ok(v) => v,
                Err(e) => {
                    return Err(format!(
                        "Could not deserialize field {} for {}: {:?}",
                        "new_class_hash", "ClassHashReplaced", e,
                    ));
                }
            };
            data_offset += cainome::cairo_serde::ClassHash::cairo_serialized_size(&new_class_hash);
            return Ok(UpgradeableEvent::ClassHashReplaced(ClassHashReplaced {
                new_class_hash,
            }));
        }
        Err(format!(
            "Could not match any event from keys {:?}",
            event.keys
        ))
    }
}
impl<A: starknet::accounts::ConnectedAccount + Sync> EkuboCore<A> {
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_call_points(
        &self,
        extension: &cainome::cairo_serde::ContractAddress,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, CallPoints> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            extension,
        ));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_call_points"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_locker_delta(
        &self,
        id: &u32,
        token_address: &cainome::cairo_serde::ContractAddress,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, I129> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(u32::cairo_serialize(id));
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token_address,
        ));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_locker_delta"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_locker_state(
        &self,
        id: &u32,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, LockerState> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(u32::cairo_serialize(id));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_locker_state"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_owner(
        &self,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, cainome::cairo_serde::ContractAddress> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_owner"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_fees_per_liquidity(
        &self,
        pool_key: &PoolKey,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, FeesPerLiquidity> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_fees_per_liquidity"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_fees_per_liquidity_inside(
        &self,
        pool_key: &PoolKey,
        bounds: &Bounds,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, FeesPerLiquidity> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(Bounds::cairo_serialize(bounds));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_fees_per_liquidity_inside"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_liquidity(
        &self,
        pool_key: &PoolKey,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, u128> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_liquidity"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_price(
        &self,
        pool_key: &PoolKey,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, PoolPrice> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_price"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_tick_fees_outside(
        &self,
        pool_key: &PoolKey,
        index: &I129,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, FeesPerLiquidity> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(index));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_tick_fees_outside"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_tick_liquidity_delta(
        &self,
        pool_key: &PoolKey,
        index: &I129,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, I129> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(index));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_tick_liquidity_delta"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_tick_liquidity_net(
        &self,
        pool_key: &PoolKey,
        index: &I129,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, u128> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(index));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_tick_liquidity_net"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_position(
        &self,
        pool_key: &PoolKey,
        position_key: &PositionKey,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, Position> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(PositionKey::cairo_serialize(position_key));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_position"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_position_with_fees(
        &self,
        pool_key: &PoolKey,
        position_key: &PositionKey,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, GetPositionWithFeesResult> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(PositionKey::cairo_serialize(position_key));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_position_with_fees"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_primary_interface_id(
        &self,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, starknet::core::types::Felt> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_primary_interface_id"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_protocol_fees_collected(
        &self,
        token: &cainome::cairo_serde::ContractAddress,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, u128> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token,
        ));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_protocol_fees_collected"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_saved_balance(
        &self,
        key: &SavedBalanceKey,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, u128> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(SavedBalanceKey::cairo_serialize(key));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_saved_balance"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn next_initialized_tick(
        &self,
        pool_key: &PoolKey,
        from: &I129,
        skip_ahead: &u128,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, (I129, bool)> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(from));
        __calldata.extend(u128::cairo_serialize(skip_ahead));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("next_initialized_tick"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn prev_initialized_tick(
        &self,
        pool_key: &PoolKey,
        from: &I129,
        skip_ahead: &u128,
    ) -> cainome::cairo_serde::call::FCall<A::Provider, (I129, bool)> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(from));
        __calldata.extend(u128::cairo_serialize(skip_ahead));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("prev_initialized_tick"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn accumulate_as_fees_getcall(
        &self,
        pool_key: &PoolKey,
        amount0: &u128,
        amount1: &u128,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(u128::cairo_serialize(amount0));
        __calldata.extend(u128::cairo_serialize(amount1));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("accumulate_as_fees"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn accumulate_as_fees(
        &self,
        pool_key: &PoolKey,
        amount0: &u128,
        amount1: &u128,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(u128::cairo_serialize(amount0));
        __calldata.extend(u128::cairo_serialize(amount1));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("accumulate_as_fees"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn collect_fees_getcall(
        &self,
        pool_key: &PoolKey,
        salt: &starknet::core::types::Felt,
        bounds: &Bounds,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(starknet::core::types::Felt::cairo_serialize(salt));
        __calldata.extend(Bounds::cairo_serialize(bounds));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("collect_fees"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn collect_fees(
        &self,
        pool_key: &PoolKey,
        salt: &starknet::core::types::Felt,
        bounds: &Bounds,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(starknet::core::types::Felt::cairo_serialize(salt));
        __calldata.extend(Bounds::cairo_serialize(bounds));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("collect_fees"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn forward_getcall(
        &self,
        to: &IForwardeeDispatcher,
        data: &Vec<starknet::core::types::Felt>,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(IForwardeeDispatcher::cairo_serialize(to));
        __calldata.extend(Vec::<starknet::core::types::Felt>::cairo_serialize(data));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("forward"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn forward(
        &self,
        to: &IForwardeeDispatcher,
        data: &Vec<starknet::core::types::Felt>,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(IForwardeeDispatcher::cairo_serialize(to));
        __calldata.extend(Vec::<starknet::core::types::Felt>::cairo_serialize(data));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("forward"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn initialize_pool_getcall(
        &self,
        pool_key: &PoolKey,
        initial_tick: &I129,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(initial_tick));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("initialize_pool"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn initialize_pool(
        &self,
        pool_key: &PoolKey,
        initial_tick: &I129,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(initial_tick));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("initialize_pool"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn load_getcall(
        &self,
        token: &cainome::cairo_serde::ContractAddress,
        salt: &starknet::core::types::Felt,
        amount: &u128,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token,
        ));
        __calldata.extend(starknet::core::types::Felt::cairo_serialize(salt));
        __calldata.extend(u128::cairo_serialize(amount));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("load"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn load(
        &self,
        token: &cainome::cairo_serde::ContractAddress,
        salt: &starknet::core::types::Felt,
        amount: &u128,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token,
        ));
        __calldata.extend(starknet::core::types::Felt::cairo_serialize(salt));
        __calldata.extend(u128::cairo_serialize(amount));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("load"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn lock_getcall(
        &self,
        data: &Vec<starknet::core::types::Felt>,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(Vec::<starknet::core::types::Felt>::cairo_serialize(data));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("lock"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn lock(
        &self,
        data: &Vec<starknet::core::types::Felt>,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(Vec::<starknet::core::types::Felt>::cairo_serialize(data));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("lock"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn maybe_initialize_pool_getcall(
        &self,
        pool_key: &PoolKey,
        initial_tick: &I129,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(initial_tick));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("maybe_initialize_pool"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn maybe_initialize_pool(
        &self,
        pool_key: &PoolKey,
        initial_tick: &I129,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(initial_tick));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("maybe_initialize_pool"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn pay_getcall(
        &self,
        token_address: &cainome::cairo_serde::ContractAddress,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token_address,
        ));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("pay"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn pay(
        &self,
        token_address: &cainome::cairo_serde::ContractAddress,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token_address,
        ));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("pay"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn replace_class_hash_getcall(
        &self,
        class_hash: &cainome::cairo_serde::ClassHash,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ClassHash::cairo_serialize(class_hash));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("replace_class_hash"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn replace_class_hash(
        &self,
        class_hash: &cainome::cairo_serde::ClassHash,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ClassHash::cairo_serialize(class_hash));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("replace_class_hash"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn save_getcall(
        &self,
        key: &SavedBalanceKey,
        amount: &u128,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(SavedBalanceKey::cairo_serialize(key));
        __calldata.extend(u128::cairo_serialize(amount));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("save"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn save(&self, key: &SavedBalanceKey, amount: &u128) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(SavedBalanceKey::cairo_serialize(key));
        __calldata.extend(u128::cairo_serialize(amount));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("save"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn set_call_points_getcall(&self, call_points: &CallPoints) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(CallPoints::cairo_serialize(call_points));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("set_call_points"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn set_call_points(&self, call_points: &CallPoints) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(CallPoints::cairo_serialize(call_points));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("set_call_points"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn swap_getcall(
        &self,
        pool_key: &PoolKey,
        params: &SwapParameters,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(SwapParameters::cairo_serialize(params));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("swap"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn swap(
        &self,
        pool_key: &PoolKey,
        params: &SwapParameters,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(SwapParameters::cairo_serialize(params));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("swap"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn transfer_ownership_getcall(
        &self,
        new_owner: &cainome::cairo_serde::ContractAddress,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            new_owner,
        ));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("transfer_ownership"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn transfer_ownership(
        &self,
        new_owner: &cainome::cairo_serde::ContractAddress,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            new_owner,
        ));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("transfer_ownership"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn update_position_getcall(
        &self,
        pool_key: &PoolKey,
        params: &UpdatePositionParameters,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(UpdatePositionParameters::cairo_serialize(params));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("update_position"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn update_position(
        &self,
        pool_key: &PoolKey,
        params: &UpdatePositionParameters,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(UpdatePositionParameters::cairo_serialize(params));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("update_position"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn withdraw_getcall(
        &self,
        token_address: &cainome::cairo_serde::ContractAddress,
        recipient: &cainome::cairo_serde::ContractAddress,
        amount: &u128,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token_address,
        ));
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            recipient,
        ));
        __calldata.extend(u128::cairo_serialize(amount));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("withdraw"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn withdraw(
        &self,
        token_address: &cainome::cairo_serde::ContractAddress,
        recipient: &cainome::cairo_serde::ContractAddress,
        amount: &u128,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token_address,
        ));
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            recipient,
        ));
        __calldata.extend(u128::cairo_serialize(amount));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("withdraw"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn withdraw_all_protocol_fees_getcall(
        &self,
        recipient: &cainome::cairo_serde::ContractAddress,
        token: &cainome::cairo_serde::ContractAddress,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            recipient,
        ));
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token,
        ));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("withdraw_all_protocol_fees"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn withdraw_all_protocol_fees(
        &self,
        recipient: &cainome::cairo_serde::ContractAddress,
        token: &cainome::cairo_serde::ContractAddress,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            recipient,
        ));
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token,
        ));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("withdraw_all_protocol_fees"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn withdraw_protocol_fees_getcall(
        &self,
        recipient: &cainome::cairo_serde::ContractAddress,
        token: &cainome::cairo_serde::ContractAddress,
        amount: &u128,
    ) -> starknet::core::types::Call {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            recipient,
        ));
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token,
        ));
        __calldata.extend(u128::cairo_serialize(amount));
        starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("withdraw_protocol_fees"),
            calldata: __calldata,
        }
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn withdraw_protocol_fees(
        &self,
        recipient: &cainome::cairo_serde::ContractAddress,
        token: &cainome::cairo_serde::ContractAddress,
        amount: &u128,
    ) -> starknet::accounts::ExecutionV3<A> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            recipient,
        ));
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token,
        ));
        __calldata.extend(u128::cairo_serialize(amount));
        let __call = starknet::core::types::Call {
            to: self.address,
            selector: starknet::macros::selector!("withdraw_protocol_fees"),
            calldata: __calldata,
        };
        self.account.execute_v3(vec![__call])
    }
}
impl<P: starknet::providers::Provider + Sync> EkuboCoreReader<P> {
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_call_points(
        &self,
        extension: &cainome::cairo_serde::ContractAddress,
    ) -> cainome::cairo_serde::call::FCall<P, CallPoints> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            extension,
        ));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_call_points"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_locker_delta(
        &self,
        id: &u32,
        token_address: &cainome::cairo_serde::ContractAddress,
    ) -> cainome::cairo_serde::call::FCall<P, I129> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(u32::cairo_serialize(id));
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token_address,
        ));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_locker_delta"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_locker_state(&self, id: &u32) -> cainome::cairo_serde::call::FCall<P, LockerState> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(u32::cairo_serialize(id));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_locker_state"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_owner(
        &self,
    ) -> cainome::cairo_serde::call::FCall<P, cainome::cairo_serde::ContractAddress> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_owner"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_fees_per_liquidity(
        &self,
        pool_key: &PoolKey,
    ) -> cainome::cairo_serde::call::FCall<P, FeesPerLiquidity> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_fees_per_liquidity"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_fees_per_liquidity_inside(
        &self,
        pool_key: &PoolKey,
        bounds: &Bounds,
    ) -> cainome::cairo_serde::call::FCall<P, FeesPerLiquidity> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(Bounds::cairo_serialize(bounds));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_fees_per_liquidity_inside"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_liquidity(
        &self,
        pool_key: &PoolKey,
    ) -> cainome::cairo_serde::call::FCall<P, u128> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_liquidity"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_price(
        &self,
        pool_key: &PoolKey,
    ) -> cainome::cairo_serde::call::FCall<P, PoolPrice> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_price"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_tick_fees_outside(
        &self,
        pool_key: &PoolKey,
        index: &I129,
    ) -> cainome::cairo_serde::call::FCall<P, FeesPerLiquidity> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(index));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_tick_fees_outside"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_tick_liquidity_delta(
        &self,
        pool_key: &PoolKey,
        index: &I129,
    ) -> cainome::cairo_serde::call::FCall<P, I129> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(index));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_tick_liquidity_delta"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_pool_tick_liquidity_net(
        &self,
        pool_key: &PoolKey,
        index: &I129,
    ) -> cainome::cairo_serde::call::FCall<P, u128> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(index));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_pool_tick_liquidity_net"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_position(
        &self,
        pool_key: &PoolKey,
        position_key: &PositionKey,
    ) -> cainome::cairo_serde::call::FCall<P, Position> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(PositionKey::cairo_serialize(position_key));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_position"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_position_with_fees(
        &self,
        pool_key: &PoolKey,
        position_key: &PositionKey,
    ) -> cainome::cairo_serde::call::FCall<P, GetPositionWithFeesResult> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(PositionKey::cairo_serialize(position_key));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_position_with_fees"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_primary_interface_id(
        &self,
    ) -> cainome::cairo_serde::call::FCall<P, starknet::core::types::Felt> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_primary_interface_id"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_protocol_fees_collected(
        &self,
        token: &cainome::cairo_serde::ContractAddress,
    ) -> cainome::cairo_serde::call::FCall<P, u128> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(cainome::cairo_serde::ContractAddress::cairo_serialize(
            token,
        ));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_protocol_fees_collected"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn get_saved_balance(
        &self,
        key: &SavedBalanceKey,
    ) -> cainome::cairo_serde::call::FCall<P, u128> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(SavedBalanceKey::cairo_serialize(key));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("get_saved_balance"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn next_initialized_tick(
        &self,
        pool_key: &PoolKey,
        from: &I129,
        skip_ahead: &u128,
    ) -> cainome::cairo_serde::call::FCall<P, (I129, bool)> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(from));
        __calldata.extend(u128::cairo_serialize(skip_ahead));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("next_initialized_tick"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
    #[allow(clippy::ptr_arg)]
    #[allow(clippy::too_many_arguments)]
    pub fn prev_initialized_tick(
        &self,
        pool_key: &PoolKey,
        from: &I129,
        skip_ahead: &u128,
    ) -> cainome::cairo_serde::call::FCall<P, (I129, bool)> {
        use cainome::cairo_serde::CairoSerde;
        let mut __calldata = vec![];
        __calldata.extend(PoolKey::cairo_serialize(pool_key));
        __calldata.extend(I129::cairo_serialize(from));
        __calldata.extend(u128::cairo_serialize(skip_ahead));
        let __call = starknet::core::types::FunctionCall {
            contract_address: self.address,
            entry_point_selector: starknet::macros::selector!("prev_initialized_tick"),
            calldata: __calldata,
        };
        cainome::cairo_serde::call::FCall::new(__call, self.provider())
    }
}
