# jaxfss
![github workflow](https://github.com/yonesuke/jaxfss/actions/workflows/book.yml/badge.svg)
[![Jupyter Book Badge](https://jupyterbook.org/badge.svg)](https://yonesuke.github.io/jaxfss/)

JAX/Flax implementation of finite-size scaling analysis
![ising_binder](https://user-images.githubusercontent.com/12659790/191948671-dc28959d-0e24-4197-baca-0c2ef0aad311.png)


## Installation
`jaxfss` can be installed with pip with the following command:
```
pip install jaxfss
```

## Quickstart
Check out the [documentation](https://yonesuke.github.io/jaxfss/)!!

## Other packages
- Finite-size scaling package by Gaussian process with C++

    https://kenjiharada.github.io/BSA/
- Finite-size scaling package by neural network and Gaussian process with Python (PyTorch)

    https://github.com/KenjiHarada/FSS-tools

## Citation
Please cite this paper when you use this package for your research!!
- [Full paper] Ryosuke Yoneda and Kenji Harada, Neural Network Approach to Scaling Analysis of Critical Phenomena, [arXiv: 2209.01777](https://arxiv.org/abs/2209.01777).

    ```tex
    @article{yoneda2022neural,
        title={Neural Network Approach to Scaling Analysis of Critical Phenomena},
        author={Yoneda, Ryosuke and Harada, Kenji},
        url={https://arxiv.org/abs/2209.01777},
        journal={arXiv preprint arXiv:2209.01777},
        year={2022}
    }
    ```

- [Conference paper] Currently preparing!!
