import sys

"""
This script takes the output of Cloud watch log csv file generated by HSDS Lambda,
and converts it to a tab-seperated output with columns:
   timestamp, loglevel, process, message
Note: timestamps may not be strictly increasing since there can be a log between
the time the message is logged in the subprocess and time it is processed in the 
parent process (and then printed to stdout).
It might be useful to open in Excel and sort by the timestamp column.
"""
DEBUG = 10
INFO = 20
WARNING = 30
ERROR = 40

def getLogLevel(name):
    if name.startswith("DEBUG"):
        level = DEBUG
    elif name.startswith("INFO"):
        level = INFO
    elif name.startswith("WARN"):
        level = WARNING
    elif name.startswith("ERROR"):
        level = ERROR
    else:
        level = INFO
    return level

#
# Main
#
if len(sys.argv) < 2 or sys.argv[1] in ("-h", "--help"):
    print("usage: python zero_adjust_timestamp.py [log_file]")
    sys.exit(0)

log_file = sys.argv[1]
ts_zero = None

# each element will be ts, loglevel, process (lambda, sn, dn[1-9], rg), msg
print("process\tlog_level\ttimestamp\tmessage")

# cloud watch log format consists of lines like:
# 1636040451248,"got cpu_count of: 6"
# outuput lines timestamp adjusted to be deltas from first line

# 1636134916895,"sn 1636134915.882 INFO> running in standalone mode

with open(log_file, 'r') as f:
    while True:
        line = f.readline()
        if not line:
            break
        line = line.strip()
        index = line.find(',')
        if index < 0:
            continue
        ts_field = line[:index]
        if ts_field == "timestamp":
            # header line
            continue  
        msg_field = line[index+2:]
        if len(msg_field) > 500:
            msg_field = msg_field[:500] + "..."
        fields = msg_field.split()
        if len(fields) == 0:
            continue
        if fields[0].startswith("sn") or fields[0].startswith("dn") or fields[0].startswith("rg"):
            # process hsds container log
            process = fields[0]
            timestamp = int(float(fields[1]) * 1000.0)
            if ts_zero:
                timestamp -= ts_zero
            log_level = getLogLevel(fields[2])
            msg_field = fields[3]
            for i in range(4, len(fields)):
                msg_field += ' '
                msg_field += fields[i]
        else:
            process = "lambda"
            timestamp = int(ts_field)
            if ts_zero is None:
                ts_zero = timestamp
            timestamp -= ts_zero
            if fields[0] == "DEBUG>":
                log_level = DEBUG
                msg_field = msg_field[len("DEBUG> "):]
            elif fields[0] == "INFO>":
                log_level = INFO
                msg_field = msg_field[len("INFO> "):]
            elif fields[0] == "WARN>":
                log_level = WARNING
                msg_field = msg_field[len("WARN> "):]
            elif fields[0] == "WARNING>":
                log_level = WARNING
                msg_field = msg_field[len("WARNING> "):]
            elif fields[0] == "ERROR>":
                log_level = ERROR
                msg_field = msg_field[len("ERROR> "):]
            else:
                log_level = INFO
          
        print(f"{process}\t{log_level}\t{timestamp:6d}\t{msg_field}")

         
