HSDS - Using The Amazon EC2 Container Service
==============================================
 
This is a basic example illustrating how one might package and run 
the hsds service using the amazon web services EC2 Container Service.

Prologue
--------

For simplicity, you should first go to the EC2 Container Service on the aws 
web console and then create a repository (ECR). Note, it is advised you create 
an IAM group with the appropriate permissions and attached policies and then 
add/create a user and attach it to the group. The permissions for this simple 
example will also require S3 access to the bucket that the hsds service will 
use, such as GET/PUT/delete/list, since hsds will read, write and find objects in S3.

1. See [Amazon EC2 Container Service - Getting Started](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/get-set-up-for-amazon-ecs.html)
2. Create a repository, for simplicity call it _hsds_. Make sure your IAM user has the appropriate access permissions for the ECS service.
3. Determine your ecr base URI, it looks something this **https://158023651469.dkr.ecr.us-west-2.amazonaws.com**
4. Create an S3 bucket, for simplicity call it something like XXXXXhsds, replace XXXXX with some random characters of your choosing. Make sure 
   your IAM user has the appropriate access permissions for the bucket XXXXXhsds. 

Building the image, buildecr.sh  
-------------------------------

These steps and using the buildecr.sh script will build the docker image and push it to your newly created ecr repository hsds (done in prologue).

1. Login to your build host (the host where you will build the docker image) if you're not already there.
2. Get project source code: `$ git clone https://github.com/HDFGroup/hsds`
3. Go to install directory: `$ cd hsds`
4. Copy buildecr.sh example script to your current working directory: `$ cp admin/ecs/buildecr.sh .`
5. Create an environment variable to pass the bucket name that was created in the Prologue: `$ export BUCKET_NAME=XXXXXhsds
6. Open buildecr.sh in your favorite editor and set the REPURI shell variable to your ecr URI.
7. Login to the ecr service via (note, you may need to change the region): `$ aws ecr get-login --region us-west-2`, which will print 
   something like: **docker login -u AWS -p <big-b64-string> -e none https://158023651469.dkr.ecr.us-west-2.amazonaws.com**, cut and paste this 
   to the shell to complete the login, e.g. `$ docker login -u AWS -p <big-b64-string> -e none https://158023651469.dkr.ecr.us-west-2.amazonaws.com`
8. Run the buildecr.sh script: `$ buildecr.sh` 
9. Optional, check your repository in aws web console and see that hsds image is indeed there.

#### Notes
* The build script will create a credential file in admin/config/passwd.txt, of which hsds will use for basic authentication (2017-03)

Running the containers, runecs.sh (locally using the aws repository) 
---------------------------------------------------------------------

0. Make sure you are still logged in to the ecr service, if not use the aws ecr get-login as done above.
1. Make sure you have a local docker daemon up and running. See the [install docker on aws if needed](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/docker-basics.html#install_docker)
2. Go to this example directory: `$ cd admin/ecs`
3. Run the runecs.sh script: `$ ./runecs.sh --help` to see the which environ variables need to be set, then set 
   them. Some of these are related to what was set in buildecr.sh script.
4. Now run the runecs.sh script: `$ ./runecs.sh 2` 

#### Notes

* If you see the error 'docker: Error response from daemon: Conflict. The name "/hsds_head"' this suggests you may need to do some cleanup 
  from a previous hsds instantiation. One can do a cleanup via `$ docker ps -aq --filter name="hsds\*" |  xargs docker rm`

* The runecs.sh script will attempt to create a root hsds domain via the create_toplevel_domain_json.py (in ../../hsds/create_toplevel_domain_json.py 
  relative to this README), via a docker exec into the head. 
  

Running the containers, runecs.sh (using the aws repository and the aws container cluster) 
-------------------------------------------------------------------------------------------


