from enum import IntEnum

from spherov2.toy.core import Toy
from spherov2.types import ToyType


class RVR(Toy):
    toy_type = ToyType('Sphero RVR', 'RV-', 'RV', .075)

    class LEDs(IntEnum):
        RIGHT_HEADLIGHT_RED = 0
        RIGHT_HEADLIGHT_GREEN = 1
        RIGHT_HEADLIGHT_BLUE = 2
        LEFT_HEADLIGHT_RED = 3
        LEFT_HEADLIGHT_GREEN = 4
        LEFT_HEADLIGHT_BLUE = 5
        LEFT_STATUS_INDICATION_RED = 6
        LEFT_STATUS_INDICATION_GREEN = 7
        LEFT_STATUS_INDICATION_BLUE = 8
        RIGHT_STATUS_INDICATION_RED = 9
        RIGHT_STATUS_INDICATION_GREEN = 10
        RIGHT_STATUS_INDICATION_BLUE = 11
        BATTERY_DOOR_REAR_RED = 12
        BATTERY_DOOR_REAR_GREEN = 13
        BATTERY_DOOR_REAR_BLUE = 14
        BATTERY_DOOR_FRONT_RED = 15
        BATTERY_DOOR_FRONT_GREEN = 16
        BATTERY_DOOR_FRONT_BLUE = 17
        POWER_BUTTON_FRONT_RED = 18
        POWER_BUTTON_FRONT_GREEN = 19
        POWER_BUTTON_FRONT_BLUE = 20
        POWER_BUTTON_REAR_RED = 21
        POWER_BUTTON_REAR_GREEN = 22
        POWER_BUTTON_REAR_BLUE = 23
        LEFT_BRAKELIGHT_RED = 24
        LEFT_BRAKELIGHT_GREEN = 25
        LEFT_BRAKELIGHT_BLUE = 26
        RIGHT_BRAKELIGHT_RED = 27
        RIGHT_BRAKELIGHT_GREEN = 28
        RIGHT_BRAKELIGHT_BLUE = 29
        UNDERCARRIAGE_WHITE = 30
