# Welcome to crypto_data_fetcher’s documentation!

# Introduction

This package is built totally for fetching the stats for different Crypto
Currencies for Analytics purposes.

# QuickStart

To start with crypto_data_fetcher run:

```
pip install crypto_data_fetcher
```

For Developers:

```
pip install crypto_data_fetcher[dev]
```

# Usage

Crypto Data Fetcher is a utility first class built with **template design pattern** in mind for better
developer experience and flexibility to modify the code as per user need with only few amendments. All the **Fetcher** classes inherit
from `crypto_data_fetcher.bases.BaseFetcher`

Base Fetcher supports both Synchronous and Asynchronous API calls.


* Synchronous API: `crypto_data_fetcher.bases.BaseFetcher.fetch_first()` and `crypto_data_fetcher.bases.BaseFetcher.fetch_all_records()`


* Asynchronous API: `crypto_data_fetcher.bases.BaseFetcher.async_fetch_first()` and `crypto_data_fetcher.bases.BaseFetcher.async_fetch_all_records()`

To Fetch the data, use the Default Fetcher class as below:


* For sync API

```
from pprint import pprint
from crypto_data_fetcher.data_fetchers import DefaultFetcher

d = DefaultFetcher()
d.fetch_first()

# data returns nicely formatted data
# oriented as records
pprint(d.data)
```


* For Async API

```
import asyncio
from pprint import pprint
from crypto_data_fetcher.data_fetchers import DefaultFetcher

d = DefaultFetcher()
asyncio.run(d.async_fetch_first())

# data returns nicely formatted data
# oriented as records
pprint(d.data)
```

```python
>>> {
    "Default": [
        {
            "Market Cap Now": 701056748178,
            "Price Now": 37440,
            "Price 1h": 0,
            "Price 1d": 2,
            "Price 7d": -5,
            "Price 30d": -36,
            "Price 90d": -20,
            "Price Graph 4h": "<svg viewBox=\"0 0 250 101\" class=\"graph\"><polyline points=\"0,37 6,60 12,60 18,87 25,90 31,100 37,88 43,70 50,55 56,11 62,0 68,35 75,55 81,25 87,13 93,13 100,39 106,36 112,59 118,79 125,73 131,63 137,55 143,55 150,55 156,55 162,55 168,55 175,55 181,55 187,82 193,65 200,65 206,65 212,65 218,65 225,65 231,65 237,8 243,19 250,12 \"></polyline><polygon points=\"0,37 6,60 12,60 18,87 25,90 31,100 37,88 43,70 50,55 56,11 62,0 68,35 75,55 81,25 87,13 93,13 100,39 106,36 112,59 118,79 125,73 131,63 137,55 143,55 150,55 156,55 162,55 168,55 175,55 181,55 187,82 193,65 200,65 206,65 212,65 218,65 225,65 231,65 237,8 243,19 250,12  250,100 0,100\"></polygon></svg><!--values: 37365.04200312,37296.63191407,37296.63191407,37215.49259381,37206.23641474,37173.70198689,37210.70844598,37265.44868129,37311.61683211,37443.47585215,37476.1339767,37371.79104761,37312.37130359,37402.60021005,37437.4512805,37439.10471625,37358.69964656,37368.92611738,37300.02099685,37239.83688821,37257.57935705,37285.70566116,37310.02231437,37310.02231437,37310.02231437,37310.02231437,37310.02231437,37310.02231437,37310.02231437,37310.02231437,37229.47080686,37280.63682646,37280.63682646,37280.63682646,37280.63682646,37280.63682646,37280.63682646,37280.63682646,37454.79474481,37418.82733097,37440.22456007 min: 37173.70198689 max: 37476.1339767-->",
            "Price Graph 1d": "<svg viewBox=\"0 0 250 101\" class=\"graph\"><polyline points=\"0,66 6,53 12,71 18,100 24,10 30,39 36,52 42,76 48,78 54,81 60,99 67,82 73,75 79,90 85,100 91,82 97,73 103,76 109,61 115,66 121,45 128,50 134,63 140,84 146,70 152,60 158,54 164,59 170,45 176,55 182,37 189,34 195,41 201,6 207,16 213,0 219,3 225,10 231,9 237,9 243,11 250,1 \"></polyline><polygon points=\"0,66 6,53 12,71 18,100 24,10 30,39 36,52 42,76 48,78 54,81 60,99 67,82 73,75 79,90 85,100 91,82 97,73 103,76 109,61 115,66 121,45 128,50 134,63 140,84 146,70 152,60 158,54 164,59 170,45 176,55 182,37 189,34 195,41 201,6 207,16 213,0 219,3 225,10 231,9 237,9 243,11 250,1  250,100 0,100\"></polygon></svg><!--values: 36445.44238254,36638.24174904,36360.00032537,35923.76163604,37291.36495756,36859.90661298,36652.88771323,36290.41926472,36254.51819324,36215.75606526,35943.62507438,36193.61625528,36312.19986566,36082.42643543,35916.96084909,36194.69438781,36334.20441212,36286.38267917,36516.30752131,36447.56097307,36765.70073665,36685.07256837,36482.52283094,36174.38198656,36376.8010791,36541.07820737,36631.92666064,36553.77355677,36758.92083731,36612.52864775,36886.93001542,36930.5624451,36830.99596776,37365.04200312,37206.23641474,37443.47585215,37402.60021005,37302.51552633,37310.02231437,37310.02231437,37280.63682646,37440.22456007 min: 35916.96084909 max: 37443.47585215-->",
            "Price Graph 7d": "<svg viewBox=\"0 0 250 101\" class=\"graph\"><polyline points=\"0,11 6,19 12,13 18,36 25,11 31,0 37,9 43,13 50,27 56,48 62,67 68,51 75,61 81,85 87,61 93,56 100,74 106,94 112,100 118,92 125,88 131,71 137,73 143,71 150,66 156,81 162,92 168,66 175,56 181,52 187,45 193,51 200,48 206,59 212,61 218,65 225,53 231,56 237,44 243,40 250,40 \"></polyline><polygon points=\"0,11 6,19 12,13 18,36 25,11 31,0 37,9 43,13 50,27 56,48 62,67 68,51 75,61 81,85 87,61 93,56 100,74 106,94 112,100 118,92 125,88 131,71 137,73 143,71 150,66 156,81 162,92 168,66 175,56 181,52 187,45 193,51 200,48 206,59 212,61 218,65 225,53 231,56 237,44 243,40 250,40  250,100 0,100\"></polygon></svg><!--values: 39022.38766982,38574.25145261,38934.21798323,37654.05773327,39015.03700084,39613.527996,39131.64203153,38908.23372104,38162.28793453,37029.12616382,35952.67861429,36858.35499626,36311.83444924,34965.09629266,36315.81046786,36578.88897942,35591.77462577,34486.32273483,34137.54709859,34608.6433174,34795.24508201,35748.95783867,35655.04312349,35774.23249618,36047.84674437,35218.71322764,34588.89007861,36015.86871476,36568.07765572,36797.27253057,37155.36660189,36861.11357936,36991.5413731,36424.9177756,36286.17799645,36102.31017777,36765.70073665,36553.77355677,37215.49259381,37446.8873318,37440.22456007 min: 34137.54709859 max: 39613.527996-->",
            "Price Graph 30d": "<svg viewBox=\"0 0 250 101\" class=\"graph\"><polyline points=\"0,5 6,4 12,12 18,18 24,7 30,11 36,2 42,4 48,0 54,4 60,4 67,13 73,6 79,19 85,36 91,35 97,33 103,46 109,41 115,56 121,55 128,64 134,97 140,73 146,69 152,92 158,81 164,91 170,95 176,84 182,85 189,74 195,83 201,81 207,88 213,91 219,100 225,91 231,89 237,89 243,91 250,86 \"></polyline><polygon points=\"0,5 6,4 12,12 18,18 24,7 30,11 36,2 42,4 48,0 54,4 60,4 67,13 73,6 79,19 85,36 91,35 97,33 103,46 109,41 115,56 121,55 128,64 134,97 140,73 146,69 152,92 158,81 164,91 170,95 176,84 182,85 189,74 195,83 201,81 207,88 213,91 219,100 225,91 231,89 237,89 243,91 250,86  250,100 0,100\"></polygon></svg><!--values: 57561.00987414,57849.84001948,56015.61066094,54517.58817125,57268.62748668,56098.15552378,58309.29362019,57967.42951903,58786.76573701,57840.32635802,57882.40244288,55691.19474037,57363.21253484,54131.59123947,49887.14951294,50135.6523561,50624.44445597,47359.74225347,48740.82920602,44872.0533409,45111.47243597,42863.34520737,34794.34582739,40688.88839148,41772.54258199,36006.78806815,38750.78736833,36337.10207343,35298.70135632,38095.00905908,37719.69963905,40522.78574491,38316.41952184,38716.3965,37008.68881557,36202.59222852,33898.83750793,36197.3921725,36684.07253647,36872.38648234,36245.32270355,37440.22456007 min: 33898.83750793 max: 58786.76573701-->",
            "Price Graph 90d": "<svg viewBox=\"0 0 250 101\" class=\"graph\"><polyline points=\"0,44 6,55 12,44 18,35 24,25 30,13 36,25 42,19 48,25 54,28 60,43 67,26 73,15 79,18 85,23 91,11 97,25 103,13 109,13 115,0 121,3 128,22 134,34 140,46 146,35 152,30 158,20 164,19 170,28 176,18 182,18 189,22 195,46 201,61 207,73 213,85 219,100 225,91 231,89 237,100 243,97 250,93 \"></polyline><polygon points=\"0,44 6,55 12,44 18,35 24,25 30,13 36,25 42,19 48,25 54,28 60,43 67,26 73,15 79,18 85,23 91,11 97,25 103,13 109,13 115,0 121,3 128,22 134,34 140,46 146,35 152,30 158,20 164,19 170,28 176,18 182,18 189,22 195,46 201,61 207,73 213,85 219,100 225,91 231,89 237,100 243,97 250,93  250,100 0,100\"></polygon></svg><!--values: 51289.14216856,48093.87524342,51070.43504566,53618.41853136,56532.24998811,59766.3524214,56507.15737731,58275.9159777,56346.72717898,55761.45189842,51542.75759554,56201.76641473,59291.39916843,58564.19222055,57165.97146184,60337.64465079,56590.58604521,59838.16787014,59978.88776531,63342.4384284,62548.25866353,57398.15570498,54066.09334042,50577.91224986,53681.98529325,55082.80542414,57836.23496307,58061.99520822,55772.94467967,58546.15197771,58420.56031981,57331.71970416,50612.43252948,46476.12648293,43122.0343187,39785.1300661,35347.75274008,38080.4156008,38590.32838816,35418.95927449,36360.00032537,37440.22456007 min: 35347.75274008 max: 63342.4384284-->",
            "Volume 24h Now": 33562898018,
            "Volume 24h Graph 1h": 0,
            "Volume 24h Graph 1d": "<svg viewBox=\"0 0 250 101\" class=\"graph\"><polyline points=\"0,2 6,4 12,9 18,13 24,0 30,2 36,100 42,1 48,4 54,8 60,11 67,9 73,6 79,8 85,8 91,6 97,5 103,5 109,4 115,4 121,2 128,3 134,8 140,12 146,13 152,14 158,14 164,17 170,19 176,17 182,18 189,19 195,20 201,19 207,24 213,23 219,19 225,24 231,24 237,20 243,20 250,17 \"></polyline><polygon points=\"0,2 6,4 12,9 18,13 24,0 30,2 36,100 42,1 48,4 54,8 60,11 67,9 73,6 79,8 85,8 91,6 97,5 103,5 109,4 115,4 121,2 128,3 134,8 140,12 146,13 152,14 158,14 164,17 170,19 176,17 182,18 189,19 195,20 201,19 207,24 213,23 219,19 225,24 231,24 237,20 243,20 250,17  250,100 0,100\"></polygon></svg><!--values: 35833440910.817,35464206135.35,34759125662.373,34165274474.879,36023179575.361,35869766680.071,21302742795.399,35941817057.743,35439305360.564,34894192992.508,34421221639.308,34738937124.285,35196475343.835,34928051875.543,34926498037.912,35231985734.138,35301348109.075,35363153062.599,35503169137.316,35546550474.716,35836056252.07,35684883357.329,34882827828.491,34296889594.9,34137739076.61,34018629096.011,33962683033.612,33581796465.315,33336406578.797,33609468026.395,33481351904.339,33355227128.945,33125469764.8,33284950250.802,32605929498.602,32744435982.512,33310562173.382,32494937497.328,32550571939.531,33092085726.258,33196278861.304,33562898018.251 min: 2.1302742795399E10 max: 3.6023179575361E10-->",
            "Volume 24h Graph 7d": "<svg viewBox=\"0 0 250 101\" class=\"graph\"><polyline points=\"0,22 6,16 12,23 19,31 25,26 32,33 38,47 44,53 51,64 57,48 64,25 70,24 76,13 83,0 89,3 96,28 102,39 108,45 115,50 121,53 128,44 134,59 141,78 147,87 153,98 160,100 166,91 173,79 179,67 185,67 192,65 198,67 205,79 211,79 217,83 224,81 230,89 237,90 243,90 250,89 \"></polyline><polygon points=\"0,22 6,16 12,23 19,31 25,26 32,33 38,47 44,53 51,64 57,48 64,25 70,24 76,13 83,0 89,3 96,28 102,39 108,45 115,50 121,53 128,44 134,59 141,78 147,87 153,98 160,100 166,91 173,79 179,67 185,67 192,65 198,67 205,79 211,79 217,83 224,81 230,89 237,90 243,90 250,89  250,100 0,100\"></polygon></svg><!--values: 51058232346.879,52552469404.37,50641243105.948,48536544814.721,49967831828.081,48170686704.454,44512915278.663,42917103650.522,40016358007.16,44188193242.506,50170070586.993,50439694954.894,53305229178.912,56540674665.488,55940083685.908,49502027490.933,46467601628.924,45080572981.16,43679980814.702,42907986551.714,45195482025.502,41333000388.067,36467959784.895,33894000277.89,31027545325.679,30503557910.886,32885125557.613,36229318517.964,39274759134.426,39194585174.684,39774957404.644,39206290255.037,36201619253.214,36164951307.634,35099952041.266,35537508607.229,33620500285.412,33284950250.802,33196278861.304,33562898018.251 min: 3.0503557910886E10 max: 5.6540674665488E10-->",
            "Available Supply Now": 18724694,
            "Available Supply 1d": 0,
            "Available Supply 7d": 0,
            "Market Cap Rank 7d": 0,
            "Market Cap Rank 30d": 0,
            "Market Cap Rank Graph 90d": "<svg viewBox=\"0 0 250 101\" class=\"graph\"><polyline points=\"0,50 250,50 \"></polyline><polygon points=\"0,50 250,50  250,100 0,100\"></polygon></svg>",
            "Vol / Mcap Now": 4,
            "Vol / Mcap Graph 7d": "<svg viewBox=\"0 0 250 101\" class=\"graph\"><polyline points=\"0,23 6,34 12,34 18,32 24,30 30,38 36,44 42,48 48,57 54,63 60,71 67,55 73,34 79,23 85,8 91,2 97,0 103,16 109,28 115,30 121,41 128,46 134,47 140,58 146,74 152,87 158,96 164,98 170,95 176,85 182,76 189,73 195,70 201,74 207,79 213,86 219,87 225,86 231,91 237,94 243,100 250,97 \"></polyline><polygon points=\"0,23 6,34 12,34 18,32 24,30 30,38 36,44 42,48 48,57 54,63 60,71 67,55 73,34 79,23 85,8 91,2 97,0 103,16 109,28 115,30 121,41 128,46 134,47 140,58 146,74 152,87 158,96 164,98 170,95 176,85 182,76 189,73 195,70 201,74 207,79 213,86 219,87 225,86 231,91 237,94 243,100 250,97  250,100 0,100\"></polygon></svg><!--values: 7.4550000000000000,7.0587500000000000,7.0680000000000000,7.1200000000000000,7.1987500000000000,6.9100000000000000,6.7162500000000000,6.5520000000000000,6.2387500000000000,6.0187500000000000,5.7100000000000000,6.3000000000000000,7.0480000000000000,7.4612500000000000,8.0025000000000000,8.2400000000000000,8.2775000000000000,7.7040000000000000,7.2662500000000000,7.2237500000000000,6.7950000000000000,6.6362500000000000,6.6080000000000000,6.2050000000000000,5.6325000000000000,5.1662500000000000,4.8100000000000000,4.7470000000000000,4.8450000000000000,5.2225000000000000,5.5450000000000000,5.6650000000000000,5.7570000000000000,5.6287500000000000,5.4200000000000000,5.1712500000000000,5.1637500000000000,5.1990000000000000,4.9950000000000000,4.9000000000000000,4.66,4.78 min: 4.66 max: 8.2775-->",
            "name": "Bitcoin"
        },
]
}
```
