# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AnswerSpan(msrest.serialization.Model):
    """Answer span object of QnA.

    :param text: Predicted text of answer span.
    :type text: str
    :param confidence_score: Predicted score of answer span, value ranges from 0 to 1.
    :type confidence_score: float
    :param offset: The answer span offset from the start of answer.
    :type offset: int
    :param length: The length of the answer span.
    :type length: int
    """

    _validation = {
        "confidence_score": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
    }

    def __init__(self, **kwargs):
        super(AnswerSpan, self).__init__(**kwargs)
        self.text = kwargs.get("text", None)
        self.confidence_score = kwargs.get("confidence_score", None)
        self.offset = kwargs.get("offset", None)
        self.length = kwargs.get("length", None)


class AnswerSpanRequest(msrest.serialization.Model):
    """To configure Answer span prediction feature.

    :param enable: Enable or disable Answer Span prediction.
    :type enable: bool
    :param confidence_score_threshold: Minimum threshold score required to include an answer span,
     value ranges from 0 to 1.
    :type confidence_score_threshold: float
    :param top_answers_with_span: Number of Top answers to be considered for span prediction from 1
     to 10.
    :type top_answers_with_span: int
    """

    _validation = {
        "confidence_score_threshold": {"maximum": 1, "minimum": 0},
        "top_answers_with_span": {"maximum": 10, "minimum": 1},
    }

    _attribute_map = {
        "enable": {"key": "enable", "type": "bool"},
        "confidence_score_threshold": {"key": "confidenceScoreThreshold", "type": "float"},
        "top_answers_with_span": {"key": "topAnswersWithSpan", "type": "int"},
    }

    def __init__(self, **kwargs):
        super(AnswerSpanRequest, self).__init__(**kwargs)
        self.enable = kwargs.get("enable", None)
        self.confidence_score_threshold = kwargs.get("confidence_score_threshold", None)
        self.top_answers_with_span = kwargs.get("top_answers_with_span", None)


class Error(msrest.serialization.Model):
    """The error object.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. One of a server-defined set of error codes. Possible values include:
     "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
     "TooManyRequests", "InternalServerError", "ServiceUnavailable".
    :type code: str or ~azure.ai.language.questionanswering.models.ErrorCode
    :param message: Required. A human-readable representation of the error.
    :type message: str
    :param target: The target of the error.
    :type target: str
    :param details: An array of details about specific errors that led to this reported error.
    :type details: list[~azure.ai.language.questionanswering.models.Error]
    :param innererror: An object containing more specific information than the current object about
     the error.
    :type innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[Error]"},
        "innererror": {"key": "innererror", "type": "InnerErrorModel"},
    }

    def __init__(self, **kwargs):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs["code"]
        self.message = kwargs["message"]
        self.target = kwargs.get("target", None)
        self.details = kwargs.get("details", None)
        self.innererror = kwargs.get("innererror", None)


class ErrorResponse(msrest.serialization.Model):
    """Error response.

    :param error: The error object.
    :type error: ~azure.ai.language.questionanswering.models.Error
    """

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get("error", None)


class InnerErrorModel(msrest.serialization.Model):
    """An object containing more specific information about the error. As per Microsoft One API guidelines - https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. One of a server-defined set of error codes. Possible values include:
     "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
     "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure".
    :type code: str or ~azure.ai.language.questionanswering.models.InnerErrorCode
    :param message: Required. Error message.
    :type message: str
    :param details: Error details.
    :type details: dict[str, str]
    :param target: Error target.
    :type target: str
    :param innererror: An object containing more specific information than the current object about
     the error.
    :type innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "{str}"},
        "target": {"key": "target", "type": "str"},
        "innererror": {"key": "innererror", "type": "InnerErrorModel"},
    }

    def __init__(self, **kwargs):
        super(InnerErrorModel, self).__init__(**kwargs)
        self.code = kwargs["code"]
        self.message = kwargs["message"]
        self.details = kwargs.get("details", None)
        self.target = kwargs.get("target", None)
        self.innererror = kwargs.get("innererror", None)


class KnowledgeBaseAnswer(msrest.serialization.Model):
    """Represents knowledge base answer.

    :param questions: List of questions.
    :type questions: list[str]
    :param answer: The Answer.
    :type answer: str
    :param confidence_score: Answer confidence score, value ranges from 0 to 1.
    :type confidence_score: float
    :param id: ID of the QnA result.
    :type id: int
    :param source: Source of QnA result.
    :type source: str
    :param metadata: Metadata associated with the answer, useful to categorize or filter question
     answers.
    :type metadata: dict[str, str]
    :param dialog: Dialog associated with Answer.
    :type dialog: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerDialog
    :param answer_span: Answer span object of QnA with respect to user's question.
    :type answer_span: ~azure.ai.language.questionanswering.models.AnswerSpan
    """

    _validation = {
        "confidence_score": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "questions": {"key": "questions", "type": "[str]"},
        "answer": {"key": "answer", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "id": {"key": "id", "type": "int"},
        "source": {"key": "source", "type": "str"},
        "metadata": {"key": "metadata", "type": "{str}"},
        "dialog": {"key": "dialog", "type": "KnowledgeBaseAnswerDialog"},
        "answer_span": {"key": "answerSpan", "type": "AnswerSpan"},
    }

    def __init__(self, **kwargs):
        super(KnowledgeBaseAnswer, self).__init__(**kwargs)
        self.questions = kwargs.get("questions", None)
        self.answer = kwargs.get("answer", None)
        self.confidence_score = kwargs.get("confidence_score", None)
        self.id = kwargs.get("id", None)
        self.source = kwargs.get("source", None)
        self.metadata = kwargs.get("metadata", None)
        self.dialog = kwargs.get("dialog", None)
        self.answer_span = kwargs.get("answer_span", None)


class KnowledgeBaseAnswerDialog(msrest.serialization.Model):
    """Dialog associated with Answer.

    :param is_context_only: To mark if a prompt is relevant only with a previous question or not.
     If true, do not include this QnA as search result for queries without context; otherwise, if
     false, ignores context and includes this QnA in search result.
    :type is_context_only: bool
    :param prompts: List of 0 to 20 prompts associated with the answer.
    :type prompts: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerPrompt]
    """

    _validation = {
        "prompts": {"max_items": 20, "min_items": 0},
    }

    _attribute_map = {
        "is_context_only": {"key": "isContextOnly", "type": "bool"},
        "prompts": {"key": "prompts", "type": "[KnowledgeBaseAnswerPrompt]"},
    }

    def __init__(self, **kwargs):
        super(KnowledgeBaseAnswerDialog, self).__init__(**kwargs)
        self.is_context_only = kwargs.get("is_context_only", None)
        self.prompts = kwargs.get("prompts", None)


class KnowledgeBaseAnswerPrompt(msrest.serialization.Model):
    """Prompt for an answer.

    :param display_order: Index of the prompt - used in ordering of the prompts.
    :type display_order: int
    :param qna_id: QnA ID corresponding to the prompt.
    :type qna_id: int
    :param display_text: Text displayed to represent a follow up question prompt.
    :type display_text: str
    """

    _validation = {
        "display_text": {"max_length": 200, "min_length": 0},
    }

    _attribute_map = {
        "display_order": {"key": "displayOrder", "type": "int"},
        "qna_id": {"key": "qnaId", "type": "int"},
        "display_text": {"key": "displayText", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(KnowledgeBaseAnswerPrompt, self).__init__(**kwargs)
        self.display_order = kwargs.get("display_order", None)
        self.qna_id = kwargs.get("qna_id", None)
        self.display_text = kwargs.get("display_text", None)


class KnowledgeBaseAnswerRequestContext(msrest.serialization.Model):
    """Context object with previous QnA's information.

    All required parameters must be populated in order to send to Azure.

    :param previous_qna_id: Required. Previous turn top answer result QnA ID.
    :type previous_qna_id: int
    :param previous_user_query: Previous user query.
    :type previous_user_query: str
    """

    _validation = {
        "previous_qna_id": {"required": True},
    }

    _attribute_map = {
        "previous_qna_id": {"key": "previousQnaId", "type": "int"},
        "previous_user_query": {"key": "previousUserQuery", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(KnowledgeBaseAnswerRequestContext, self).__init__(**kwargs)
        self.previous_qna_id = kwargs["previous_qna_id"]
        self.previous_user_query = kwargs.get("previous_user_query", None)


class KnowledgeBaseAnswers(msrest.serialization.Model):
    """Represents List of Question Answers.

    :param answers: Represents Answer Result list.
    :type answers: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswer]
    """

    _attribute_map = {
        "answers": {"key": "answers", "type": "[KnowledgeBaseAnswer]"},
    }

    def __init__(self, **kwargs):
        super(KnowledgeBaseAnswers, self).__init__(**kwargs)
        self.answers = kwargs.get("answers", None)


class KnowledgeBaseQueryOptions(msrest.serialization.Model):
    """The question parameters to answer using a knowledge base.

    :param qna_id: Exact QnA ID to fetch from the knowledge base, this field takes priority over
     question.
    :type qna_id: int
    :param question: User question to query against the knowledge base.
    :type question: str
    :param top: Max number of answers to be returned for the question.
    :type top: int
    :param user_id: Unique identifier for the user.
    :type user_id: str
    :param confidence_score_threshold: Minimum threshold score for answers, value ranges from 0 to
     1.
    :type confidence_score_threshold: float
    :param context: Context object with previous QnA's information.
    :type context: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerRequestContext
    :param ranker_type: (Optional) Set to 'QuestionOnly' for using a question only Ranker. Possible
     values include: "Default", "QuestionOnly".
    :type ranker_type: str or ~azure.ai.language.questionanswering.models.RankerType
    :param strict_filters: Filter QnAs based on give metadata list and knowledge base source names.
    :type strict_filters: ~azure.ai.language.questionanswering.models.StrictFilters
    :param answer_span_request: To configure Answer span prediction feature.
    :type answer_span_request: ~azure.ai.language.questionanswering.models.AnswerSpanRequest
    :param include_unstructured_sources: (Optional) Flag to enable Query over Unstructured Sources.
    :type include_unstructured_sources: bool
    """

    _validation = {
        "confidence_score_threshold": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "qna_id": {"key": "qnaId", "type": "int"},
        "question": {"key": "question", "type": "str"},
        "top": {"key": "top", "type": "int"},
        "user_id": {"key": "userId", "type": "str"},
        "confidence_score_threshold": {"key": "confidenceScoreThreshold", "type": "float"},
        "context": {"key": "context", "type": "KnowledgeBaseAnswerRequestContext"},
        "ranker_type": {"key": "rankerType", "type": "str"},
        "strict_filters": {"key": "strictFilters", "type": "StrictFilters"},
        "answer_span_request": {"key": "answerSpanRequest", "type": "AnswerSpanRequest"},
        "include_unstructured_sources": {"key": "includeUnstructuredSources", "type": "bool"},
    }

    def __init__(self, **kwargs):
        super(KnowledgeBaseQueryOptions, self).__init__(**kwargs)
        self.qna_id = kwargs.get("qna_id", None)
        self.question = kwargs.get("question", None)
        self.top = kwargs.get("top", None)
        self.user_id = kwargs.get("user_id", None)
        self.confidence_score_threshold = kwargs.get("confidence_score_threshold", None)
        self.context = kwargs.get("context", None)
        self.ranker_type = kwargs.get("ranker_type", None)
        self.strict_filters = kwargs.get("strict_filters", None)
        self.answer_span_request = kwargs.get("answer_span_request", None)
        self.include_unstructured_sources = kwargs.get("include_unstructured_sources", None)


class MetadataFilter(msrest.serialization.Model):
    """Find QnAs that are associated with the given list of metadata.

    :param metadata: Dictionary of :code:`<string>`.
    :type metadata: dict[str, str]
    :param compound_operation: (Optional) Set to 'OR' for joining metadata using 'OR' operation.
     Possible values include: "AND", "OR".
    :type compound_operation: str or
     ~azure.ai.language.questionanswering.models.CompoundOperationKind
    """

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "{str}"},
        "compound_operation": {"key": "compoundOperation", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(MetadataFilter, self).__init__(**kwargs)
        self.metadata = kwargs.get("metadata", None)
        self.compound_operation = kwargs.get("compound_operation", None)


class StrictFilters(msrest.serialization.Model):
    """filters over knowledge base.

    :param metadata_filter: Find QnAs that are associated with the given list of metadata.
    :type metadata_filter: ~azure.ai.language.questionanswering.models.MetadataFilter
    :param source_filter: Find QnAs that are associated with the given list of sources in knowledge
     base.
    :type source_filter: list[str]
    :param compound_operation: (Optional) Set to 'OR' for joining metadata using 'OR' operation.
     Possible values include: "AND", "OR".
    :type compound_operation: str or
     ~azure.ai.language.questionanswering.models.CompoundOperationKind
    """

    _attribute_map = {
        "metadata_filter": {"key": "metadataFilter", "type": "MetadataFilter"},
        "source_filter": {"key": "sourceFilter", "type": "[str]"},
        "compound_operation": {"key": "compoundOperation", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(StrictFilters, self).__init__(**kwargs)
        self.metadata_filter = kwargs.get("metadata_filter", None)
        self.source_filter = kwargs.get("source_filter", None)
        self.compound_operation = kwargs.get("compound_operation", None)


class TextAnswer(msrest.serialization.Model):
    """Represents answer result.

    :param answer: Answer.
    :type answer: str
    :param confidence_score: answer confidence score, value ranges from 0 to 1.
    :type confidence_score: float
    :param id: record ID.
    :type id: str
    :param answer_span: Answer span object with respect to user's question.
    :type answer_span: ~azure.ai.language.questionanswering.models.AnswerSpan
    :param offset: The sentence offset from the start of the document.
    :type offset: int
    :param length: The length of the sentence.
    :type length: int
    """

    _validation = {
        "confidence_score": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "answer": {"key": "answer", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "id": {"key": "id", "type": "str"},
        "answer_span": {"key": "answerSpan", "type": "AnswerSpan"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
    }

    def __init__(self, **kwargs):
        super(TextAnswer, self).__init__(**kwargs)
        self.answer = kwargs.get("answer", None)
        self.confidence_score = kwargs.get("confidence_score", None)
        self.id = kwargs.get("id", None)
        self.answer_span = kwargs.get("answer_span", None)
        self.offset = kwargs.get("offset", None)
        self.length = kwargs.get("length", None)


class TextAnswers(msrest.serialization.Model):
    """Represents the answer results.

    :param answers: Represents the answer results.
    :type answers: list[~azure.ai.language.questionanswering.models.TextAnswer]
    """

    _attribute_map = {
        "answers": {"key": "answers", "type": "[TextAnswer]"},
    }

    def __init__(self, **kwargs):
        super(TextAnswers, self).__init__(**kwargs)
        self.answers = kwargs.get("answers", None)


class TextQueryOptions(msrest.serialization.Model):
    """The question and text record parameters to answer.

    All required parameters must be populated in order to send to Azure.

    :param question: Required. User question to query against the given text records.
    :type question: str
    :param records: Required. Text records to be searched for given question.
    :type records: list[~azure.ai.language.questionanswering.models.TextRecord]
    :param language: Language of the text records. This is BCP-47 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
     default.
    :type language: str
    :param string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Possible values include: "TextElements_v8",
     "UnicodeCodePoint", "Utf16CodeUnit". Default value: "TextElements_v8".
    :type string_index_type: str or ~azure.ai.language.questionanswering.models.StringIndexType
    """

    _validation = {
        "question": {"required": True},
        "records": {"required": True},
    }

    _attribute_map = {
        "question": {"key": "question", "type": "str"},
        "records": {"key": "records", "type": "[TextRecord]"},
        "language": {"key": "language", "type": "str"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(TextQueryOptions, self).__init__(**kwargs)
        self.question = kwargs["question"]
        self.records = kwargs["records"]
        self.language = kwargs.get("language", None)
        self.string_index_type = kwargs.get("string_index_type", "TextElements_v8")


class TextRecord(msrest.serialization.Model):
    """Represent input text record to be queried.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique identifier for the text record.
    :type id: str
    :param text: Required. Text contents of the record.
    :type text: str
    """

    _validation = {
        "id": {"required": True},
        "text": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "text": {"key": "text", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(TextRecord, self).__init__(**kwargs)
        self.id = kwargs["id"]
        self.text = kwargs["text"]
