MARTINI_LIPIDS = dict(
    PC=[
        ["DTPC", "PO4"],["DLPC", "PO4"],["DPPC", "PO4"],["DBPC", "PO4"],["DXPC", "PO4"],["DYPC", "PO4"],["DVPC", "PO4"],["DOPC", "PO4"],
        ["DIPC", "PO4"],["DFPC", "PO4"],["DGPC", "PO4"],["DAPC", "PO4"],["DRPC", "PO4"],["DNPC", "PO4"],["LPPC", "PO4"],["POPC", "PO4"],
        ["POPX", "PO4"],["PGPC", "PO4"],["PEPC", "PO4"],["PIPC", "PO4"],["PIPX", "PO4"],["PAPC", "PO4"],["PUPC", "PO4"],["PRPC", "PO4"]
        ],
    PE=[
        ["DTPE", "PO4"],["DLPE", "PO4"],["DPPE", "PO4"],["DBPE", "PO4"],["DXPE", "PO4"],["DYPE", "PO4"],["DVPE", "PO4"],["DOPE", "PO4"],
        ["DIPE", "PO4"],["DFPE", "PO4"],["DGPE", "PO4"],["DAPE", "PO4"],["DUPE", "PO4"],["DRPE", "PO4"],["DNPE", "PO4"],["LPPE", "PO4"],
        ["POPE", "PO4"],["PGPE", "PO4"],["PQPE", "PO4"],["PIPE", "PO4"],["PAPE", "PO4"],["PUPE", "PO4"],["PRPE", "PO4"]
        ],
    PS=[
        ["DTPS", "PO4"],["DLPS", "PO4"],["DPPS", "PO4"],["DBPS", "PO4"],["DXPS", "PO4"],["DYPS", "PO4"],["DVPS", "PO4"],["DOPS", "PO4"],
        ["DIPS", "PO4"],["DFPS", "PO4"],["DGPS", "PO4"],["DAPS", "PO4"],["DUPS", "PO4"],["DRPS", "PO4"],["DNPS", "PO4"],["LPPS", "PO4"],
        ["POPS", "PO4"],["PGPS", "PO4"],["PQPS", "PO4"],["PIPS", "PO4"],["PAPS", "PO4"],["PUPS", "PO4"],["PRPS", "PO4"]
        ],
    PG=[
        ["DTPG", "PO4"],["DLPG", "PO4"],["DPPG", "PO4"],["DBPG", "PO4"],["DXPG", "PO4"],["DYPG", "PO4"],["DVPG", "PO4"],["DOPG", "PO4"],
        ["DIPG", "PO4"],["DFPG", "PO4"],["DGPG", "PO4"],["DAPG", "PO4"],["DRPG", "PO4"],["DNPG", "PO4"],["LPPG", "PO4"],["POPG", "PO4"],
        ["PGPG", "PO4"],["PIPG", "PO4"],["PAPG", "PO4"],["PRPG", "PO4"],["OPPG", "PO4"],["JPPG", "PO4"],["JFPG", "PO4"]
        ],
    PA=[
        ["DTPA", "PO4"],["DLPA", "PO4"],["DPPA", "PO4"],["DBPA", "PO4"],["DXPA", "PO4"],["DYPA", "PO4"],["DVPA", "PO4"],
        ["DOPA", "PO4"],["DIPA", "PO4"],["DFPA", "PO4"],["DGPA", "PO4"],["DAPA", "PO4"],["DRPA", "PO4"],["DNPA", "PO4"],
        ["LPPA", "PO4"],["POPA", "PO4"],["PGPA", "PO4"],["PIPA", "PO4"],["PAPA", "PO4"],["PUPA", "PO4"],["PRPA", "PO4"]
        ],
    PI=[
        ["DPPI", "CP"],["PVPI", "CP"],["POPI", "CP"],
        ["PIPI", "CP"],["PAPI", "CP"],["PUPI", "CP"]
        ],
    PIP=[
        ["DPP1", "P1"],["PVP1", "P1"],["POP1", "P1"],["DPP2", "P1"],
        ["PVP2", "P1"],["POP2", "P1"],["PVP3", "P1"],["POP3", "P1"]
        ],
    DAG=[
        ["PVDG", "GL1"],["PODG", "GL1"],["PIDG", "GL1"],["PADG", "GL1"],["PUDG", "GL1"]
        ],
    TAG=[
        ["TOG", "ES3"]
        ],
    LPC=[
        ["CPC", "PO4"],["TPC", "PO4"],["LPC", "PO4"],["PPC", "PO4"],["VPC", "PO4"],
        ["OPC", "PO4"],["IPC", "PO4"],["APC", "PO4"],["UPC", "PO4"]
        ],
    SM=[
        ["DPSM", "PO4"],["DBSM", "PO4"],["DXSM", "PO4"],["PVSM", "PO4"],["POSM", "PO4"],
        ["PGSM", "PO4"],["PNSM", "PO4"],["BNSM", "PO4"],["XNSM", "PO4"]
        ],
    CER=[
        ["DPCE", "AM1"],["DXCE", "AM1"],["PNCE", "AM1"],["XNCE", "AM1"]
        ],
    GM=[
        ["DPGS", "AM1"],["DPG1", "AM1"],["DBG1", "AM1"],["DXG1", "AM1"],["PNG1", "AM1"],["XNG1", "AM1"],
        ["DPG3", "AM1"],["DBG3", "AM1"],["DXG3", "AM1"],["PNG3", "AM1"],["XNG3", "AM1"]
        ],
    DG=[
        ["DPMG", "GL1"],["OPMG", "GL1"],["DFMG", "GL1"],["FPMG", "GL1"],["DPSG", "GL1"],["OPSG", "GL1"],
        ["FPSG", "GL1"],["DPGG", "GL1"],["OPGG", "GL1"],["DFGG", "GL1"],["FPGG", "GL1"]
        ],
    CHOL=[
        ["CHOL", "ROH"],["CHOA", "ROH"],["CHYO", "R0"],["ERGO", "ROH"],
        ["HBHT", "R1"], ["HDPT", "R1"], ["HHOP", "R1"],["HOPR", "R1"]
        ],
    FA=[
        ["LCA", "COO"],["PCA", "COO"],["BCA", "COO"],["XCA", "COO"],["ACA", "COO"],["UCA", "COO"]
        ],
    Surfactants=[
        ["BOG", "B1"],["C12E2", "C1"],["C12E4", "C1"],["C12E6", "C1"],
        ["EO5", "OH"],["DDM", "B1"],["DPC", "PO4"],["SDS", "SO3"]
        ],
    Other=[
        ["BOLA", "PO1"],["BOLB", "PO1"],["CDL0", "PO41"],["CDL1", "PO41"],["CDL2", "PO41"],["LPS", "V61"],["BFRA", "LANA"],
        ["BPER", "LANA"],["CJEJ", "LANA"],["CTRA", "LANA"],["HPYL", "LANA"],["NMEN", "LANA"],["PGIN", "LANA"],["PARU", "L10"],
        ["PARC", "L10"],["SMIN", "LANA"],["DPTAP", "TAP"],["DOTAP", "TAP"],["DITAP", "TAP"]
        ]
)

def martini_lipids(input_system_lipids):
    """
    Return a key:value pair for lipids in the MD system. key is the lipid group and value is a
    list containing all the individual lipids belonging to that group. Since it is most widely
    used, cholesterol is used as a group name to represent all sterols.
    """

    PLASMA_LIPIDS = {}
    plasma_keys = MARTINI_LIPIDS.keys()
    for lg, li in MARTINI_LIPIDS.items():
        for lipid in li:
            if lipid[0] in input_system_lipids:
                if PLASMA_LIPIDS.get(lg):
                    PLASMA_LIPIDS[lg].append(lipid[0])
                else:
                    PLASMA_LIPIDS[lg] = [lipid[0]]

    return PLASMA_LIPIDS


def martini_headgroups(input_system_lipids, groups):


    PLASMA_HEADGROUPS = {}
    for lg, li in MARTINI_LIPIDS.items():
        for lipid in li:
            if lipid[0] in input_system_lipids:
                if groups:
                    PLASMA_HEADGROUPS[lg] = lipid[1]
                else:
                    PLASMA_HEADGROUPS[lipid[0]] = lipid[1]

    return PLASMA_HEADGROUPS

def lipid_species(lipid, PLASMA_LIPIDS):

    for k, v in PLASMA_LIPIDS.items():
        if lipid in v:
            return k

    return lipid

