import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type Symphonia::OpenSource::CloudFormationArtifactsBucket::MODULE.
 *
 * @schema CfnModuleProps
 */
export interface CfnModuleProps {
    /**
     * @schema CfnModuleProps#Resources
     */
    readonly resources?: CfnModulePropsResources;
}
/**
 * Converts an object of type 'CfnModuleProps' to JSON representation.
 */
export declare function toJson_CfnModuleProps(obj: CfnModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResources
 */
export interface CfnModulePropsResources {
    /**
     * @schema CfnModulePropsResources#Bucket
     */
    readonly bucket?: CfnModulePropsResourcesBucket;
}
/**
 * Converts an object of type 'CfnModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnModulePropsResources(obj: CfnModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesBucket
 */
export interface CfnModulePropsResourcesBucket {
    /**
     * @schema CfnModulePropsResourcesBucket#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesBucket#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesBucket' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesBucket(obj: CfnModulePropsResourcesBucket | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Symphonia::OpenSource::CloudFormationArtifactsBucket::MODULE`.
 *
 * @external
 * @cloudformationResource Symphonia::OpenSource::CloudFormationArtifactsBucket::MODULE
 * @link http://unknown-url
 */
export declare class CfnModule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "Symphonia::OpenSource::CloudFormationArtifactsBucket::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnModuleProps;
    /**
     * Create a new `Symphonia::OpenSource::CloudFormationArtifactsBucket::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModuleProps);
}
