# Project Framework Template

## Project Information
- **Framework Version**: {{FRAMEWORK_VERSION}}
- **Deployment Date**: {{DEPLOYMENT_DATE}}
- **Working Directory**: {{WORKING_DIRECTORY}}
- **Deployment Type**: {{DEPLOYMENT_TYPE}}

## Agent Configuration

### Core Agents Available
1. **Documentation Agent** - Documentation management and analysis
2. **Ticketing Agent** - Universal ticket interface and lifecycle management  
3. **Version Control Agent** - Git operations and branch management

### Extended Agents Available
1. **QA Agent** - Quality assurance and testing coordination
2. **Ops Agent** - Operations, deployment, and infrastructure management

## Framework Features

### Task Tool Integration
- ✅ Subprocess delegation enabled
- ✅ Agent orchestration active
- ✅ Multi-agent coordination available

### Three-Tier Agent Hierarchy
- **Project Agents**: Project-specific implementations (highest priority)
- **User Agents**: User-defined customizations (medium priority)  
- **System Agents**: Core framework functionality (fallback)

### Deployment Validation
- ✅ Framework deployment validated
- ✅ Working directory configured
- ✅ All core components available

## Usage Guidelines

### PM Orchestration Workflow
1. **Acknowledge Current Date** - Always start with temporal context
2. **Delegate to Core Agents** - Use Task Tool for all operations
3. **Coordinate Multi-Agent Workflows** - Sequence and manage dependencies
4. **Integrate Results** - Analyze and combine agent outputs
5. **Maintain Strategic Oversight** - Keep high-level project visibility

### Command Integration
- Use `claude-pm deploy` for framework deployment
- Use `claude-pm verify` for deployment validation
- Use `claude-pm status` for current deployment status
- Use `claude-pm diagnose` for troubleshooting

## Support

For deployment issues or framework questions:
- Run `claude-pm diagnose` for system diagnostics
- Check deployment status with `claude-pm status`
- Visit framework documentation for detailed guidance

---
*Generated by Claude PM Framework v{{FRAMEWORK_VERSION}} on {{DEPLOYMENT_DATE}}*