"""
Todo and Task Tools section generator for framework CLAUDE.md.
"""

from typing import Dict, Any
from . import BaseSectionGenerator


class TodoTaskToolsGenerator(BaseSectionGenerator):
    """Generates the Todo and Task Tools section."""
    
    def generate(self, data: Dict[str, Any]) -> str:
        """Generate the todo and task tools section."""
        return """
## B) TODO AND TASK TOOLS

### 🚨 MANDATORY: TodoWrite Integration with Task Tool

**Workflow Pattern:**
1. **Create TodoWrite entries** for complex multi-agent tasks with automatic agent name prefixes
2. **Mark todo as in_progress** when delegating via Task Tool
3. **Update todo status** based on subprocess completion
4. **Mark todo as completed** when agent delivers results

### Agent Name Prefix System

**Standard TodoWrite Entry Format:**
- **Research tasks** → `Researcher: [task description]`
- **Documentation tasks** → `Documentater: [task description]`
- **Changelog tasks** → `Documentater: [changelog description]`
- **QA tasks** → `QA: [task description]`
- **DevOps tasks** → `Ops: [task description]`
- **Security tasks** → `Security: [task description]`
- **Version Control tasks** → `Versioner: [task description]`
- **Version Management tasks** → `Versioner: [version management description]`
- **Code Implementation tasks** → `Engineer: [implementation description]`
- **Data Operations tasks** → `Data Engineer: [data management description]`

### Task Tool Subprocess Naming Conventions

**Template Pattern:**
```
**[Agent Nickname]**: [Specific task description with clear deliverables]
```

**Examples of Proper Naming:**
- ✅ **Documentationer**: Update framework/CLAUDE.md with Task Tool naming conventions
- ✅ **QA**: Execute comprehensive test suite validation for merge readiness
- ✅ **Versioner**: Create feature branch and sync with remote repository
- ✅ **Researcher**: Investigate Next.js 14 performance optimization patterns
- ✅ **Engineer**: Implement user authentication system with JWT tokens
- ✅ **Data Engineer**: Configure PostgreSQL database and optimize query performance

### 🚨 MANDATORY: THREE SHORTCUT COMMANDS

#### 1. **"push"** - Version Control, Quality Assurance & Release Management
**Enhanced Delegation Flow**: PM → Documentation Agent (changelog & version docs) → QA Agent (testing/linting) → Data Engineer Agent (data validation & API checks) → Version Control Agent (tracking, version bumping & Git operations)

**Components:**
1. **Documentation Agent**: Generate changelog, analyze semantic versioning impact
2. **QA Agent**: Execute test suite, perform quality validation
3. **Data Engineer Agent**: Validate data integrity, verify API connectivity, check database schemas
4. **Version Control Agent**: Track files, apply version bumps, create tags, execute Git operations

#### 2. **"deploy"** - Local Deployment Operations
**Delegation Flow**: PM → Ops Agent (local deployment) → QA Agent (deployment validation)

#### 3. **"publish"** - Package Publication Pipeline
**Delegation Flow**: PM → Documentation Agent (version docs) → Ops Agent (package publication)

### Multi-Agent Coordination Workflows

**Example Integration:**
```
TodoWrite: Create prefixed todos for "Push release"
- ☐ Documentation Agent: Generate changelog and analyze version impact
- ☐ QA Agent: Execute full test suite and quality validation
- ☐ Data Engineer Agent: Validate data integrity and verify API connectivity
- ☐ Version Control Agent: Apply semantic version bump and create release tags

Task Tool → Documentation Agent: Generate changelog and analyze version impact
Task Tool → QA Agent: Execute full test suite and quality validation
Task Tool → Data Engineer Agent: Validate data integrity and verify API connectivity
Task Tool → Version Control Agent: Apply semantic version bump and create release tags

Update TodoWrite status based on agent completions
```

---"""