# ai-trackdown-pytools

An AI-Trackdown project for hierarchical project management.

**Project Type:** general  
**Created:** 2025-07-21
**Tasks Directory:** tickets/

## Overview

This project uses AI-Trackdown for hierarchical project management with Epics, Issues, and Tasks. Each item has YAML frontmatter for metadata and Markdown content for descriptions.

## Unified Directory Structure

```
ai-trackdown-pytools/
├── .ai-trackdown/          # Configuration and metadata
│   ├── config.yaml         # Project configuration
│   ├── counters.json       # ID generation counters
│   └── templates/          # Item templates
├── tickets/                # Tasks root directory (configurable)
│   ├── epics/              # Epic-level planning (.md files)
│   ├── issues/             # Issue-level work items (.md files)
│   ├── tasks/              # Task-level activities (.md files)
│   ├── prs/                # Pull request tracking (.md files)
│   └── templates/          # Item templates
├── .gitignore             # Git ignore patterns
└── README.md              # This file
```

## Hierarchy

- **Epics** (EP-XXXX): High-level features or objectives
- **Issues** (ISS-XXXX): Specific work items within epics
- **Tasks** (TSK-XXXX): Granular activities within issues

## Getting Started

### View Items
```bash
# List all epics
ls tickets/epics/

# List all issues
ls tickets/issues/

# List all tasks
ls tickets/tasks/

# List all PRs
ls tickets/prs/
```

### Create New Items
```bash
# Create a new epic
aitrackdown epic create "New Feature Development"

# Create an issue within an epic
aitrackdown issue create "API Implementation" --epic EP-0001

# Create a task within an issue
aitrackdown task create "Design API Schema" --issue ISS-0001
```

### Project Management
```bash
# View project status
aitrackdown status

# Search items
aitrackdown search --status active --priority high

# Update item status
aitrackdown task update TSK-0001 --status completed

# Export project data
aitrackdown export --format json
```

## Configuration

Project configuration is stored in `.ai-trackdown/config.yaml`. You can modify:

- Directory structure
- Naming conventions
- Default assignee
- AI context templates
- Automation settings

## File Format

Each item file contains YAML frontmatter and Markdown content:

```markdown
---
epic_id: EP-0001
title: Project Setup and Initial Development
description: Initial setup and foundational development
status: active
priority: high
assignee: masa
created_date: 2023-XX-XX
updated_date: 2023-XX-XX
estimated_tokens: 500
actual_tokens: 0
ai_context:
  - project-setup
  - initial-development
related_issues:
  - ISS-0001
sync_status: local
---

# Epic: Project Setup and Initial Development

## Overview
Detailed description of the epic...
```

## Examples

The project includes example items to help you get started:
- **EP-0001**: Project Setup and Initial Development
- **ISS-0001**: Development Environment Setup
- **TSK-0001**: Install and configure development tools
- **TSK-0002**: Create development setup documentation

## Commands

| Command | Description |
|---------|-------------|
| `aitrackdown init` | Initialize a new project |
| `aitrackdown epic create` | Create a new epic |
| `aitrackdown issue create` | Create a new issue |
| `aitrackdown task create` | Create a new task |
| `aitrackdown status` | View project status |
| `aitrackdown search` | Search items |
| `aitrackdown export` | Export project data |

## Links

- [AI-Trackdown Documentation](https://github.com/your-org/ai-trackdown-tools)
- [Project Issues](https://github.com/your-org/ai-trackdown-tools/issues)

---

*Generated by ai-trackdown-tools on 2025-07-21*
