# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['welcome_wizard',
 'welcome_wizard.api',
 'welcome_wizard.migrations',
 'welcome_wizard.models',
 'welcome_wizard.tests']

package_data = \
{'': ['*'], 'welcome_wizard': ['templates/welcome_wizard/*']}

install_requires = \
['nautobot']

setup_kwargs = {
    'name': 'nautobot-welcome-wizard',
    'version': '1.0.1',
    'description': "Nautobot's Welcome Wizard",
    'long_description': '# Welcome Wizard\n\n[![Code Style](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n![Coverage](coverage.svg)\n\nA plugin for [Nautobot](https://github.com/nautobot/nautobot).\n\n![Wecome Wizard GIF](docs/img/WelcomeWizard.gif)\n\n## Overview\n\nThe Welcome Wizard is an open-source Nautobot Plugin with the goal to assist users with the necessary initial steps in populating data within Nautobot.\n\nThe Welcome Wizard adds four (4) key features:\n\n### Import Wizard\n\nWelcome Wizard uses the `Import Wizard` to allow ease of adding community defined Device Types and Manufacturers into Nautobot. This is built upon the [git datasources](https://nautobot.readthedocs.io/en/stable/user-guides/git-data-source/#git-as-a-data-source) feature of Nautobot.\n\n### Quick-Start Settings\n\nWelcome Wizard includes by default the [DeviceType-library](https://github.com/netbox-community/devicetype-library), but this can be disabled and a custom library can be used instead.\n\n### Helpful Middleware\n\nWelcome Wizard includes banners in forms to alert the user when required form fields have no associated resources in Nautobot.\n\n### Welcome Wizard Dashboard\n\nThe Welcome Wizard Dashboard contains a list of common Nautobot Data Models that many other Nautobot models require. This page allows ease of adding items to Nautobot or, if supported, importing them. This ties all of the features together.1\n\n## Installation\n\nInstalling the Nautobot Welcome Wizard follows the [Plugin Installation](https://nautobot.readthedocs.io/en/stable/plugins/#installing-plugins).\n\nThe plugin is available as a Python package in pypi and can be installed with pip\n\n```shell\npip install nautobot-welcome-wizard\n```\n\n> The plugin is compatible with Nautobot 1.0.0b4 and higher\n\nTo ensure Welcome Wizard is automatically re-installed during future upgrades, create a file named `local_requirements.txt` (if not already existing) in the Nautobot root directory (alongside `requirements.txt`) and list the `nautobot-welcome-wizard` package:\n\n```no-highlight\n# echo nautobot-welcome-wizard >> local_requirements.txt\n```\n\nOnce installed, the plugin needs to be enabled in your `nautobot_config.py`\n\n```python\n# In your nautobot_config.py\nPLUGINS = ["welcome_wizard"]\n\n# PLUGINS_CONFIG = {\n#   "welcome_wizard": {\n#     "enable_devicetype-library": True\n#   }\n# }\n```\n\nThe plugin behavior can be controlled with the following list of settings:\n\n- `enable_devicetype-library`: If enabled the [device type](https://github.com/netbox-community/devicetype-library) git repository will be automatically added for you.\n\nAfter updating nautobot_config.py, you will need to run `nautobot-server migrate` and then reload the nautobot service and the nautobot-worker service.\n\n## Usage\n\nLog in to Nautobot and you will be guided through Banners on the top of the pages.\n\n## Contributing\n\nPull Requests are welcome and automatically built and tested against multiple versions of Python and Nautobot through TravisCI.\n\nThe project is packaged with a light development environment based on `docker-compose` to help with the local development of the project and to run the tests within TravisCI.\n\nThe project is following Network to Code\'s software development guideline and is leveraging:\n\n- Black, Pylint, Bandit and pydocstyle for Python linting and formatting.\n- Django unit test to ensure the plugin is working properly.\n\n### Development Environment\n\nThe development environment can be used in 2 ways. First, with a local poetry environment if you wish to develop outside of docker, and second, inside of a docker container. The below commands will start the Nautobot server listening on port 8080.\n\n#### Local Poetry Development Environment\n\n1. Copy `development/creds.example.env` to `development/creds.env` (This file will be ignored by git and docker)\n2. Uncomment the `POSTGRES_HOST`, `REDIS_HOST`, and `NAUTOBOT_ROOT` variables in `development/creds.env`\n3. Create an invoke.yml with the following contents at the root of the repo:\n\n```shell\n---\nwelcome_wizard:\n  local: true\n  compose_files:\n    - "docker-compose.requirements.yml"\n```\n\n4. Run the following commands:\n\n```shell\npoetry shell\npoetry install\nexport $(cat development/dev.env | xargs)\nexport $(cat development/creds.env | xargs)\n```\n\n5. You can now run nautobot-server commands as you would from the [Nautobot documentation](https://nautobot.readthedocs.io/en/latest/). For example, to start the development server:\n\n```shell\nnautobot-server runserver 0.0.0.0:8080 --insecure\n```\n\n#### Docker Development Environment\n\nThis project is managed by [Python Poetry](https://python-poetry.org/) and has a few requirements to setup your development environment:\n\n1. Install Poetry, see the [Poetry Documentation](https://python-poetry.org/docs/#installation) for your operating system.\n2. Install Docker, see the [Docker documentation](https://docs.docker.com/get-docker/) for your operating system.\n\nOnce you have Poetry and Docker installed you can run the following commands to install all other development dependencies in an isolated python virtual environment:\n\n```shell\npoetry shell\npoetry install\ninvoke start\n```\n\n### CLI Helper Commands\n\nThe project includes a CLI helper based on [invoke](http://www.pyinvoke.org/) to help setup the development environment. The commands are listed below in 3 categories `dev environment`, `utility` and `testing`.\n\nEach command can be executed with `invoke <command>`. Environment variables `INVOKE_WELCOME_WIZARD_PYTHON_VER` and `INVOKE_WELCOME_WIZARD_NAUTOBOT_VER` may be specified to override the default versions. Each command also has its own help `invoke <command> --help`\n\n#### Docker dev environment\n\n```no-highlight\n  build            Build all docker images.\n  debug            Start Nautobot and its dependencies in debug mode.\n  destroy          Destroy all containers and volumes.\n  restart          Restart Nautobot and its dependencies.\n  start            Start Nautobot and its dependencies in detached mode.\n  stop             Stop Nautobot and its dependencies.\n```\n\n#### Utility\n\n```no-highlight\n  cli              Launch a bash shell inside the running Nautobot container.\n  create-user      Create a new user in django (default: admin), will prompt for password.\n  makemigrations   Run Make Migration in Django.\n  nbshell          Launch a nbshell session.\n```\n\n#### Testing\n\n```no-highlight\n  bandit           Run bandit to validate basic static code security analysis.\n  black            Run black to check that Python files adhere to its style standards.\n  flake8           This will run flake8 for the specified name and Python version.\n  pydocstyle       Run pydocstyle to validate docstring formatting adheres to NTC defined standards.\n  pylint           Run pylint code analysis.\n  tests            Run all tests for this plugin.\n  unittest         Run Django unit tests for the plugin.\n```\n\n## Questions\n\nFor any questions or comments, please check the [FAQ](FAQ.md) first and feel free to swing by the [Network to Code slack channel](https://networktocode.slack.com/) (channel #networktocode).\nSign up [here](https://slack.networktocode.com/)\n\n## Screenshots\n\n![Welcome Wizard Banner](docs/img/merlin_banner.png)  \n![Welcome Wizard Middleware](docs/img/merlin_middleware_x3.png)  \n![Welcome Wizard Dashboard](docs/img/welcome_wizard.png)  \n![Welcome Wizard Completions](docs/img/dashboard_with_completions.png)\n![Welcome Wizard Import Device Types](docs/img/merlin_import_device_type.png)\n',
    'author': 'Network to Code, LLC',
    'author_email': 'info@networktocode.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/nautobot/nautobot-plugin-welcome-wizard',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
