"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const cdk = require("@aws-cdk/core");
const index_1 = require("./index");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const envUSEast1 = {
            region: 'us-east-1',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        /**
         * Test WAF for CloudFront
         */
        const stackTest1 = new cdk.Stack(app, 'TestStackAutomatedWafForCloudFront', { env: envUSEast1 });
        new index_1.AutomatedWaf(stackTest1, 'AutomatedWaf', {
            waf2Scope: index_1.Waf2ScopeOption.CLOUDFRONT,
            resourceNamingPrefix: 'CloudFront_ApiGW',
            errorThreshold: 55,
            requestThreshold: 3000,
            blockPeriod: 60,
            logLevel: index_1.LogLevel.DEBUG,
        });
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        /**
         * Test For ALB
         */
        const stackTest2 = new cdk.Stack(app, 'TestStackAutomatedWafForALB', { env });
        const albArn = `arn:aws:elasticloadbalancing:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:loadbalancer/app/ApiNe-Alb16-2VIC9075YQEZ/db92cdc88d2e7c9d`;
        new index_1.AutomatedWaf(stackTest2, 'AutomatedWaf', {
            waf2Scope: index_1.Waf2ScopeOption.REGIONAL,
            associatedResourceArn: albArn,
            resourceNamingPrefix: 'Alb_Api',
            errorThreshold: 50,
            requestThreshold: 300,
            blockPeriod: 60,
            logLevel: index_1.LogLevel.DEBUG,
        });
        /**
         * Test For API Gateway
         */
        const stackTest3 = new cdk.Stack(app, 'TestStackAutomatedWafForApiGW', { env });
        /**
         * Ref Stage arn in https://docs.aws.amazon.com/apigateway/latest/developerguide/arn-format-reference.html
         */
        const restApiArn = `arn:aws:apigateway:${cdk.Aws.REGION}::/restapis/0j90w09yf9/stages/prod`;
        new index_1.AutomatedWaf(stackTest3, 'AutomatedWaf', {
            waf2Scope: index_1.Waf2ScopeOption.REGIONAL,
            associatedResourceArn: restApiArn,
            resourceNamingPrefix: 'ApiGW',
            errorThreshold: 50,
            requestThreshold: 300,
            blockPeriod: 60,
            logLevel: index_1.LogLevel.DEBUG,
        });
        /**
         * Test For ALB on count mode
         */
        const stackTest4 = new cdk.Stack(app, 'TestStackAutomatedWafForALBOnCountMode', { env });
        new index_1.AutomatedWaf(stackTest4, 'AutomatedWaf', {
            waf2Scope: index_1.Waf2ScopeOption.REGIONAL,
            countMode: true,
            resourceNamingPrefix: 'Alb_CountMode',
            errorThreshold: 50,
            requestThreshold: 300,
            blockPeriod: 60,
            logLevel: index_1.LogLevel.DEBUG,
        });
        app.synth();
        this.stack = [stackTest1, stackTest2, stackTest3, stackTest4];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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