from marshmallow import fields
from cc_py_commons.schemas.camel_case_schema import CamelCaseSchema
from cc_py_commons.loads.equipment_schema import EquipmentSchema
from cc_py_commons.loads.location_schema import LocationSchema
from cc_py_commons.loads.freighthub_contact_schema import FreightHubContactSchema

class LoadSchema(CamelCaseSchema):
    reference_number = fields.String()
    # C4 Account ID
    customer_id = fields.Integer()
    origin = fields.Nested(LocationSchema)
    destination = fields.Nested(LocationSchema)
    pickup_date = fields.Date()
    delivery_date = fields.Date()
    status_id = fields.UUID()
    source_id = fields.UUID()
    equipment = fields.Nested(EquipmentSchema)
    equipment_description = fields.String()     
    contact = fields.Nested(FreightHubContactSchema)
    pickup_open_time= fields.Time()
    pickup_close_time= fields.Time()
    pickup_appointment_required= fields.Boolean()
    delivery_open_time= fields.Time()
    delivery_close_time= fields.Time()
    delivery_appointment_required= fields.Boolean()
    tracking_number = fields.String()
    full_load = fields.Boolean()
    length = fields.Integer()
    width = fields.Integer()
    height = fields.Integer()
    weight = fields.Integer()
    load_count = fields.Integer()
    distance = fields.Integer()
    stops = fields.Integer()
    rate = fields.String()
    declared_value = fields.Integer()
    comment = fields.String()
    commodity = fields.String()
    min_temperature= fields.Float()
    max_temperature= fields.Float()
    tarp_size = fields.Integer()
    carrier_id = fields.UUID()
    contact_id = fields.UUID()
    url = fields.String()
    demo_load= fields.Boolean()
    team_service_required= fields.Boolean()
    quote_id = fields.UUID()
    truck_lane_search_id = fields.UUID()
    truck_search_id = fields.UUID()
    # generated by server and returned
    id = fields.UUID()
    # generated by server and returned
    load_number = fields.String()   