#   Copyright 2019 Avaamo, Inc.
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

import os
import requests
import json

ENDPOINT = os.environ['AVAAMO_ENDPOINT']
ACCESS_TOKEN = os.environ['AVAAMO_ACCESS_TOKEN']
BOT_ID = os.environ['AVAAMO_BOT_ID']
CONVERSATION_ID = '237d4e461e10f6e1a8e4a524e3d2e968'


url = "https://{0}/conversations/{1}/messages.json".format(ENDPOINT, CONVERSATION_ID)

querystring = {
    "per_page": "100",
    "page": "1"
}

headers = {
    'Access-Token': ACCESS_TOKEN,
    'Content-Type': "application/json",
}


response = requests.request("GET", url, headers=headers, params=querystring)
print(response.text)
print(response.status_code)
if len(response.text) > 0:
    print(json.dumps(json.loads(response.text), separators=(', ', ': '), indent=4, sort_keys=True))

