# -*- coding: utf-8 -*-
# Generated by Django 1.11.27 on 2020-02-02 12:23
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=50, verbose_name="Nom de l'évènement")),
                ('startDate', models.DateField(verbose_name='Date de début')),
                ('startTime', models.TimeField(verbose_name='Heure de début')),
                ('endDate', models.DateField(blank=True, null=True, verbose_name='Date de fin')),
                ('endTime', models.TimeField(blank=True, null=True, verbose_name='Heure de fin')),
                ('img', models.ImageField(blank=True, null=True, upload_to='', verbose_name="Illustration de l'évènement")),
                ('shortDescription', models.CharField(max_length=250, verbose_name='Short description')),
                ('longDescription', models.TextField(verbose_name='Long description')),
                ('link', models.CharField(blank=True, max_length=50, null=True, verbose_name='Lien internet')),
                ('facebook', models.CharField(blank=True, max_length=50, null=True, verbose_name='Lien Facebook')),
            ],
            options={
                'ordering': ['startDate'],
            },
        ),
        migrations.CreateModel(
            name='Locationevent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=50, verbose_name='Lieu, établissement')),
                ('address', models.TextField(blank=True, max_length=225, null=True, verbose_name='Adresse')),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.CreateModel(
            name='Typeevent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=20, verbose_name="Type d'évènement")),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.AddField(
            model_name='event',
            name='location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='djangoldp_event.Locationevent', verbose_name="Lieu de l'évènement"),
        ),
        migrations.AddField(
            model_name='event',
            name='type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_event.Typeevent', verbose_name="Type d'évènement"),
        ),
    ]
