"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Scanner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const aws_lambda_event_sources_1 = require("@aws-cdk/aws-lambda-event-sources");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const clamav_layer_1 = require("./clamav-layer");
const definition_initializer_1 = require("./definition-initializer");
const sandbox_1 = require("./sandbox");
class Scanner extends core_1.Construct {
    constructor(scope, id, props = {}) {
        var _b, _c, _d;
        super(scope, id);
        this.scanStatusTagName = (_b = props.scanStatusTagName) !== null && _b !== void 0 ? _b : 'cc:scna-status';
        this.sandbox = new sandbox_1.Sandbox(this, 'Sandbox');
        const layer = new clamav_layer_1.ClamavLayer(this, 'ClamavLayer');
        this.scanFunction = new aws_lambda_1.Function(this, 'ScanFunction', {
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'scan')),
            handler: 'index.handler',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            onSuccess: props.onResult,
            onFailure: props.onError,
            filesystem: aws_lambda_1.FileSystem.fromEfsAccessPoint(this.sandbox.lambdaAccessPoint, '/mnt/lambda'),
            vpc: this.sandbox.vpc,
            vpcSubnets: { subnets: this.sandbox.vpc.isolatedSubnets },
            allowAllOutbound: false,
            timeout: core_1.Duration.minutes(15),
            memorySize: 10240,
            environment: {
                SCAN_STATUS_TAG_NAME: this.scanStatusTagName,
                EFS_MOUNT_PATH: '/mnt/lambda',
                EFS_DEFINITIONS_PATH: 'virus_database/',
                DEFINITIONS_URL: this.sandbox.definitionBucket.virtualHostedUrlForObject(),
            },
            layers: [layer],
        });
        this.scanFunction.connections.allowToAnyIpv4(aws_ec2_1.Port.tcp(443), 'Allow outbound HTTPS traffic for S3 access.');
        this.sandbox.definitionBucket.grantRead(this.scanFunction);
        this.updateFunction = new aws_lambda_1.Function(this, 'UpdateFunction', {
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'update')),
            handler: 'index.handler',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            onFailure: props.onError,
            timeout: core_1.Duration.minutes(5),
            memorySize: 1024,
            environment: {
                SCAN_STATUS_TAG_NAME: this.scanStatusTagName,
                DEFINITIONS_BUCKET: this.sandbox.definitionBucket.bucketName,
            },
            layers: [layer],
        });
        this.sandbox.definitionBucket.grantReadWrite(this.updateFunction);
        new aws_events_1.Rule(this, 'UpdateRule', {
            schedule: (_c = props.updateSchedule) !== null && _c !== void 0 ? _c : aws_events_1.Schedule.rate(core_1.Duration.hours(1)),
            targets: [new aws_events_targets_1.LambdaFunction(this.updateFunction)],
        });
        new definition_initializer_1.DefinitionInitializer(this, 'DefinitionInitializer', {
            fn: this.updateFunction,
        });
        (_d = props.buckets) === null || _d === void 0 ? void 0 : _d.forEach((bucket) => {
            this.addSourceBucket(bucket);
        });
    }
    addSourceBucket(bucket) {
        this.scanFunction.addEventSource(new aws_lambda_event_sources_1.S3EventSource(bucket, { events: [aws_s3_1.EventType.OBJECT_CREATED] }));
        bucket.grantRead(this.scanFunction);
        this.scanFunction.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:PutObjectTagging', 's3:PutObjectVersionTagging'],
            resources: [bucket.arnForObjects('*')],
        }));
        if (this.scanFunction.role) {
            const stack = core_1.Stack.of(this);
            const scanAssumedRole = `arn:${stack.partition}:sts::${stack.account}:assumed-role/${this.scanFunction.role.roleName}/${this.scanFunction.functionName}`;
            const scanAssumedPrincipal = new aws_iam_1.ArnPrincipal(scanAssumedRole);
            this.sandbox.addToS3EnpointPolicy(new aws_iam_1.PolicyStatement({
                effect: aws_iam_1.Effect.ALLOW,
                actions: ['s3:GetObject*', 's3:GetBucket*', 's3:List*'],
                resources: [bucket.bucketArn, bucket.arnForObjects('*')],
                principals: [this.scanFunction.role, scanAssumedPrincipal],
            }));
            this.sandbox.addToS3EnpointPolicy(new aws_iam_1.PolicyStatement({
                effect: aws_iam_1.Effect.ALLOW,
                actions: ['s3:PutObjectTagging', 's3:PutObjectVersionTagging'],
                resources: [bucket.arnForObjects('*')],
                principals: [this.scanFunction.role, scanAssumedPrincipal],
            }));
            bucket.addToResourcePolicy(new aws_iam_1.PolicyStatement({
                effect: aws_iam_1.Effect.DENY,
                actions: ['s3:GetObject'],
                resources: [bucket.arnForObjects('*')],
                notPrincipals: [this.scanFunction.role, scanAssumedPrincipal],
                conditions: {
                    StringEquals: {
                        [`s3:ExistingObjectTag/${this.scanStatusTagName}`]: ['IN PROGRESS', 'INFECTED', 'ERROR'],
                    },
                },
            }));
        }
    }
}
exports.Scanner = Scanner;
_a = JSII_RTTI_SYMBOL_1;
Scanner[_a] = { fqn: "@cloudcomponents/cdk-s3-antivirus.Scanner", version: "1.7.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2Nhbm5lci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9zY2FubmVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBQzdCLDhDQUF3QztBQUN4QyxvREFBcUQ7QUFDckQsb0VBQTZEO0FBQzdELDhDQUF5RTtBQUN6RSxvREFBbUc7QUFDbkcsZ0ZBQWtFO0FBQ2xFLDRDQUFvRDtBQUNwRCx3Q0FBMkQ7QUFFM0QsaURBQTZDO0FBQzdDLHFFQUFpRTtBQUNqRSx1Q0FBb0M7QUFXcEMsTUFBYSxPQUFRLFNBQVEsZ0JBQVM7SUFNcEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUFzQixFQUFFOztRQUNoRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxpQkFBaUIsU0FBRyxLQUFLLENBQUMsaUJBQWlCLG1DQUFJLGdCQUFnQixDQUFDO1FBRXJFLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxpQkFBTyxDQUFDLElBQUksRUFBRSxTQUFTLENBQUMsQ0FBQztRQUU1QyxNQUFNLEtBQUssR0FBRyxJQUFJLDBCQUFXLENBQUMsSUFBSSxFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBRW5ELElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxxQkFBUSxDQUFDLElBQUksRUFBRSxjQUFjLEVBQUU7WUFDckQsSUFBSSxFQUFFLGlCQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztZQUM3RCxPQUFPLEVBQUUsZUFBZTtZQUN4QixPQUFPLEVBQUUsb0JBQU8sQ0FBQyxXQUFXO1lBQzVCLFNBQVMsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsS0FBSyxDQUFDLE9BQU87WUFDeEIsVUFBVSxFQUFFLHVCQUFVLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxpQkFBaUIsRUFBRSxhQUFhLENBQUM7WUFDeEYsR0FBRyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRztZQUNyQixVQUFVLEVBQUUsRUFBRSxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsZUFBZSxFQUFFO1lBQ3pELGdCQUFnQixFQUFFLEtBQUs7WUFDdkIsT0FBTyxFQUFFLGVBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1lBQzdCLFVBQVUsRUFBRSxLQUFLO1lBQ2pCLFdBQVcsRUFBRTtnQkFDWCxvQkFBb0IsRUFBRSxJQUFJLENBQUMsaUJBQWlCO2dCQUM1QyxjQUFjLEVBQUUsYUFBYTtnQkFDN0Isb0JBQW9CLEVBQUUsaUJBQWlCO2dCQUN2QyxlQUFlLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyx5QkFBeUIsRUFBRTthQUMzRTtZQUNELE1BQU0sRUFBRSxDQUFDLEtBQUssQ0FBQztTQUNoQixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsWUFBWSxDQUFDLFdBQVcsQ0FBQyxjQUFjLENBQUMsY0FBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsRUFBRSw2Q0FBNkMsQ0FBQyxDQUFDO1FBQzNHLElBQUksQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUUzRCxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUkscUJBQVEsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUU7WUFDekQsSUFBSSxFQUFFLGlCQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxRQUFRLENBQUMsQ0FBQztZQUMvRCxPQUFPLEVBQUUsZUFBZTtZQUN4QixPQUFPLEVBQUUsb0JBQU8sQ0FBQyxXQUFXO1lBQzVCLFNBQVMsRUFBRSxLQUFLLENBQUMsT0FBTztZQUN4QixPQUFPLEVBQUUsZUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7WUFDNUIsVUFBVSxFQUFFLElBQUk7WUFDaEIsV0FBVyxFQUFFO2dCQUNYLG9CQUFvQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7Z0JBQzVDLGtCQUFrQixFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsVUFBVTthQUM3RDtZQUNELE1BQU0sRUFBRSxDQUFDLEtBQUssQ0FBQztTQUNoQixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLENBQUM7UUFFbEUsSUFBSSxpQkFBSSxDQUFDLElBQUksRUFBRSxZQUFZLEVBQUU7WUFDM0IsUUFBUSxRQUFFLEtBQUssQ0FBQyxjQUFjLG1DQUFJLHFCQUFRLENBQUMsSUFBSSxDQUFDLGVBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDbEUsT0FBTyxFQUFFLENBQUMsSUFBSSxtQ0FBYyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQztTQUNuRCxDQUFDLENBQUM7UUFFSCxJQUFJLDhDQUFxQixDQUFDLElBQUksRUFBRSx1QkFBdUIsRUFBRTtZQUN2RCxFQUFFLEVBQUUsSUFBSSxDQUFDLGNBQWM7U0FDeEIsQ0FBQyxDQUFDO1FBRUgsTUFBQSxLQUFLLENBQUMsT0FBTywwQ0FBRSxPQUFPLENBQUMsQ0FBQyxNQUFNLEVBQUUsRUFBRTtZQUNoQyxJQUFJLENBQUMsZUFBZSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQy9CLENBQUMsRUFBRTtJQUNMLENBQUM7SUFFTSxlQUFlLENBQUMsTUFBYztRQUNuQyxJQUFJLENBQUMsWUFBWSxDQUFDLGNBQWMsQ0FBQyxJQUFJLHdDQUFhLENBQUMsTUFBTSxFQUFFLEVBQUUsTUFBTSxFQUFFLENBQUMsa0JBQVMsQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztRQUVwRyxNQUFNLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUVwQyxJQUFJLENBQUMsWUFBWSxDQUFDLGVBQWUsQ0FDL0IsSUFBSSx5QkFBZSxDQUFDO1lBQ2xCLE1BQU0sRUFBRSxnQkFBTSxDQUFDLEtBQUs7WUFDcEIsT0FBTyxFQUFFLENBQUMscUJBQXFCLEVBQUUsNEJBQTRCLENBQUM7WUFDOUQsU0FBUyxFQUFFLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsQ0FBQztTQUN2QyxDQUFDLENBQ0gsQ0FBQztRQUVGLElBQUksSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLEVBQUU7WUFDMUIsTUFBTSxLQUFLLEdBQUcsWUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUM3QixNQUFNLGVBQWUsR0FBRyxPQUFPLEtBQUssQ0FBQyxTQUFTLFNBQVMsS0FBSyxDQUFDLE9BQU8saUJBQWlCLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFFBQVEsSUFBSSxJQUFJLENBQUMsWUFBWSxDQUFDLFlBQVksRUFBRSxDQUFDO1lBQ3pKLE1BQU0sb0JBQW9CLEdBQUcsSUFBSSxzQkFBWSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1lBRS9ELElBQUksQ0FBQyxPQUFPLENBQUMsb0JBQW9CLENBQy9CLElBQUkseUJBQWUsQ0FBQztnQkFDbEIsTUFBTSxFQUFFLGdCQUFNLENBQUMsS0FBSztnQkFDcEIsT0FBTyxFQUFFLENBQUMsZUFBZSxFQUFFLGVBQWUsRUFBRSxVQUFVLENBQUM7Z0JBQ3ZELFNBQVMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsQ0FBQztnQkFDeEQsVUFBVSxFQUFFLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLEVBQUUsb0JBQW9CLENBQUM7YUFDM0QsQ0FBQyxDQUNILENBQUM7WUFFRixJQUFJLENBQUMsT0FBTyxDQUFDLG9CQUFvQixDQUMvQixJQUFJLHlCQUFlLENBQUM7Z0JBQ2xCLE1BQU0sRUFBRSxnQkFBTSxDQUFDLEtBQUs7Z0JBQ3BCLE9BQU8sRUFBRSxDQUFDLHFCQUFxQixFQUFFLDRCQUE0QixDQUFDO2dCQUM5RCxTQUFTLEVBQUUsQ0FBQyxNQUFNLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUN0QyxVQUFVLEVBQUUsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksRUFBRSxvQkFBb0IsQ0FBQzthQUMzRCxDQUFDLENBQ0gsQ0FBQztZQUVGLE1BQU0sQ0FBQyxtQkFBbUIsQ0FDeEIsSUFBSSx5QkFBZSxDQUFDO2dCQUNsQixNQUFNLEVBQUUsZ0JBQU0sQ0FBQyxJQUFJO2dCQUNuQixPQUFPLEVBQUUsQ0FBQyxjQUFjLENBQUM7Z0JBQ3pCLFNBQVMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLENBQUM7Z0JBQ3RDLGFBQWEsRUFBRSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxFQUFFLG9CQUFvQixDQUFDO2dCQUM3RCxVQUFVLEVBQUU7b0JBQ1YsWUFBWSxFQUFFO3dCQUNaLENBQUMsd0JBQXdCLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFDLEVBQUUsQ0FBQyxhQUFhLEVBQUUsVUFBVSxFQUFFLE9BQU8sQ0FBQztxQkFDekY7aUJBQ0Y7YUFDRixDQUFDLENBQ0gsQ0FBQztTQUNIO0lBQ0gsQ0FBQzs7QUF2SEgsMEJBd0hDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCB7IFBvcnQgfSBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCB7IFJ1bGUsIFNjaGVkdWxlIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWV2ZW50cyc7XG5pbXBvcnQgeyBMYW1iZGFGdW5jdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1ldmVudHMtdGFyZ2V0cyc7XG5pbXBvcnQgeyBBcm5QcmluY2lwYWwsIEVmZmVjdCwgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgeyBDb2RlLCBGdW5jdGlvbiwgSUZ1bmN0aW9uLCBGaWxlU3lzdGVtLCBSdW50aW1lLCBJRGVzdGluYXRpb24gfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCB7IFMzRXZlbnRTb3VyY2UgfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhLWV2ZW50LXNvdXJjZXMnO1xuaW1wb3J0IHsgQnVja2V0LCBFdmVudFR5cGUgfSBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBEdXJhdGlvbiwgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuaW1wb3J0IHsgQ2xhbWF2TGF5ZXIgfSBmcm9tICcuL2NsYW1hdi1sYXllcic7XG5pbXBvcnQgeyBEZWZpbml0aW9uSW5pdGlhbGl6ZXIgfSBmcm9tICcuL2RlZmluaXRpb24taW5pdGlhbGl6ZXInO1xuaW1wb3J0IHsgU2FuZGJveCB9IGZyb20gJy4vc2FuZGJveCc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgU2Nhbm5lclByb3BzIHtcbiAgcmVhZG9ubHkgYnVja2V0cz86IEJ1Y2tldFtdO1xuICByZWFkb25seSBvblJlc3VsdD86IElEZXN0aW5hdGlvbjtcbiAgcmVhZG9ubHkgb25FcnJvcj86IElEZXN0aW5hdGlvbjtcbiAgcmVhZG9ubHkgdXBkYXRlU2NoZWR1bGU/OiBTY2hlZHVsZTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc2NhblN0YXR1c1RhZ05hbWU/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBTY2FubmVyIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IHNjYW5GdW5jdGlvbjogSUZ1bmN0aW9uO1xuICBwdWJsaWMgcmVhZG9ubHkgdXBkYXRlRnVuY3Rpb246IElGdW5jdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IHNhbmRib3g6IFNhbmRib3g7XG4gIHB1YmxpYyByZWFkb25seSBzY2FuU3RhdHVzVGFnTmFtZTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTY2FubmVyUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLnNjYW5TdGF0dXNUYWdOYW1lID0gcHJvcHMuc2NhblN0YXR1c1RhZ05hbWUgPz8gJ2NjOnNjbmEtc3RhdHVzJztcblxuICAgIHRoaXMuc2FuZGJveCA9IG5ldyBTYW5kYm94KHRoaXMsICdTYW5kYm94Jyk7XG5cbiAgICBjb25zdCBsYXllciA9IG5ldyBDbGFtYXZMYXllcih0aGlzLCAnQ2xhbWF2TGF5ZXInKTtcblxuICAgIHRoaXMuc2NhbkZ1bmN0aW9uID0gbmV3IEZ1bmN0aW9uKHRoaXMsICdTY2FuRnVuY3Rpb24nLCB7XG4gICAgICBjb2RlOiBDb2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnbGFtYmRhcycsICdzY2FuJykpLFxuICAgICAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICAgICAgcnVudGltZTogUnVudGltZS5OT0RFSlNfMTJfWCxcbiAgICAgIG9uU3VjY2VzczogcHJvcHMub25SZXN1bHQsXG4gICAgICBvbkZhaWx1cmU6IHByb3BzLm9uRXJyb3IsXG4gICAgICBmaWxlc3lzdGVtOiBGaWxlU3lzdGVtLmZyb21FZnNBY2Nlc3NQb2ludCh0aGlzLnNhbmRib3gubGFtYmRhQWNjZXNzUG9pbnQsICcvbW50L2xhbWJkYScpLFxuICAgICAgdnBjOiB0aGlzLnNhbmRib3gudnBjLFxuICAgICAgdnBjU3VibmV0czogeyBzdWJuZXRzOiB0aGlzLnNhbmRib3gudnBjLmlzb2xhdGVkU3VibmV0cyB9LFxuICAgICAgYWxsb3dBbGxPdXRib3VuZDogZmFsc2UsXG4gICAgICB0aW1lb3V0OiBEdXJhdGlvbi5taW51dGVzKDE1KSxcbiAgICAgIG1lbW9yeVNpemU6IDEwMjQwLFxuICAgICAgZW52aXJvbm1lbnQ6IHtcbiAgICAgICAgU0NBTl9TVEFUVVNfVEFHX05BTUU6IHRoaXMuc2NhblN0YXR1c1RhZ05hbWUsXG4gICAgICAgIEVGU19NT1VOVF9QQVRIOiAnL21udC9sYW1iZGEnLFxuICAgICAgICBFRlNfREVGSU5JVElPTlNfUEFUSDogJ3ZpcnVzX2RhdGFiYXNlLycsXG4gICAgICAgIERFRklOSVRJT05TX1VSTDogdGhpcy5zYW5kYm94LmRlZmluaXRpb25CdWNrZXQudmlydHVhbEhvc3RlZFVybEZvck9iamVjdCgpLFxuICAgICAgfSxcbiAgICAgIGxheWVyczogW2xheWVyXSxcbiAgICB9KTtcblxuICAgIHRoaXMuc2NhbkZ1bmN0aW9uLmNvbm5lY3Rpb25zLmFsbG93VG9BbnlJcHY0KFBvcnQudGNwKDQ0MyksICdBbGxvdyBvdXRib3VuZCBIVFRQUyB0cmFmZmljIGZvciBTMyBhY2Nlc3MuJyk7XG4gICAgdGhpcy5zYW5kYm94LmRlZmluaXRpb25CdWNrZXQuZ3JhbnRSZWFkKHRoaXMuc2NhbkZ1bmN0aW9uKTtcblxuICAgIHRoaXMudXBkYXRlRnVuY3Rpb24gPSBuZXcgRnVuY3Rpb24odGhpcywgJ1VwZGF0ZUZ1bmN0aW9uJywge1xuICAgICAgY29kZTogQ29kZS5mcm9tQXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJ2xhbWJkYXMnLCAndXBkYXRlJykpLFxuICAgICAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICAgICAgcnVudGltZTogUnVudGltZS5OT0RFSlNfMTJfWCxcbiAgICAgIG9uRmFpbHVyZTogcHJvcHMub25FcnJvcixcbiAgICAgIHRpbWVvdXQ6IER1cmF0aW9uLm1pbnV0ZXMoNSksXG4gICAgICBtZW1vcnlTaXplOiAxMDI0LFxuICAgICAgZW52aXJvbm1lbnQ6IHtcbiAgICAgICAgU0NBTl9TVEFUVVNfVEFHX05BTUU6IHRoaXMuc2NhblN0YXR1c1RhZ05hbWUsXG4gICAgICAgIERFRklOSVRJT05TX0JVQ0tFVDogdGhpcy5zYW5kYm94LmRlZmluaXRpb25CdWNrZXQuYnVja2V0TmFtZSxcbiAgICAgIH0sXG4gICAgICBsYXllcnM6IFtsYXllcl0sXG4gICAgfSk7XG5cbiAgICB0aGlzLnNhbmRib3guZGVmaW5pdGlvbkJ1Y2tldC5ncmFudFJlYWRXcml0ZSh0aGlzLnVwZGF0ZUZ1bmN0aW9uKTtcblxuICAgIG5ldyBSdWxlKHRoaXMsICdVcGRhdGVSdWxlJywge1xuICAgICAgc2NoZWR1bGU6IHByb3BzLnVwZGF0ZVNjaGVkdWxlID8/IFNjaGVkdWxlLnJhdGUoRHVyYXRpb24uaG91cnMoMSkpLFxuICAgICAgdGFyZ2V0czogW25ldyBMYW1iZGFGdW5jdGlvbih0aGlzLnVwZGF0ZUZ1bmN0aW9uKV0sXG4gICAgfSk7XG5cbiAgICBuZXcgRGVmaW5pdGlvbkluaXRpYWxpemVyKHRoaXMsICdEZWZpbml0aW9uSW5pdGlhbGl6ZXInLCB7XG4gICAgICBmbjogdGhpcy51cGRhdGVGdW5jdGlvbixcbiAgICB9KTtcblxuICAgIHByb3BzLmJ1Y2tldHM/LmZvckVhY2goKGJ1Y2tldCkgPT4ge1xuICAgICAgdGhpcy5hZGRTb3VyY2VCdWNrZXQoYnVja2V0KTtcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBhZGRTb3VyY2VCdWNrZXQoYnVja2V0OiBCdWNrZXQpOiB2b2lkIHtcbiAgICB0aGlzLnNjYW5GdW5jdGlvbi5hZGRFdmVudFNvdXJjZShuZXcgUzNFdmVudFNvdXJjZShidWNrZXQsIHsgZXZlbnRzOiBbRXZlbnRUeXBlLk9CSkVDVF9DUkVBVEVEXSB9KSk7XG5cbiAgICBidWNrZXQuZ3JhbnRSZWFkKHRoaXMuc2NhbkZ1bmN0aW9uKTtcblxuICAgIHRoaXMuc2NhbkZ1bmN0aW9uLmFkZFRvUm9sZVBvbGljeShcbiAgICAgIG5ldyBQb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICBlZmZlY3Q6IEVmZmVjdC5BTExPVyxcbiAgICAgICAgYWN0aW9uczogWydzMzpQdXRPYmplY3RUYWdnaW5nJywgJ3MzOlB1dE9iamVjdFZlcnNpb25UYWdnaW5nJ10sXG4gICAgICAgIHJlc291cmNlczogW2J1Y2tldC5hcm5Gb3JPYmplY3RzKCcqJyldLFxuICAgICAgfSksXG4gICAgKTtcblxuICAgIGlmICh0aGlzLnNjYW5GdW5jdGlvbi5yb2xlKSB7XG4gICAgICBjb25zdCBzdGFjayA9IFN0YWNrLm9mKHRoaXMpO1xuICAgICAgY29uc3Qgc2NhbkFzc3VtZWRSb2xlID0gYGFybjoke3N0YWNrLnBhcnRpdGlvbn06c3RzOjoke3N0YWNrLmFjY291bnR9OmFzc3VtZWQtcm9sZS8ke3RoaXMuc2NhbkZ1bmN0aW9uLnJvbGUucm9sZU5hbWV9LyR7dGhpcy5zY2FuRnVuY3Rpb24uZnVuY3Rpb25OYW1lfWA7XG4gICAgICBjb25zdCBzY2FuQXNzdW1lZFByaW5jaXBhbCA9IG5ldyBBcm5QcmluY2lwYWwoc2NhbkFzc3VtZWRSb2xlKTtcblxuICAgICAgdGhpcy5zYW5kYm94LmFkZFRvUzNFbnBvaW50UG9saWN5KFxuICAgICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICBlZmZlY3Q6IEVmZmVjdC5BTExPVyxcbiAgICAgICAgICBhY3Rpb25zOiBbJ3MzOkdldE9iamVjdConLCAnczM6R2V0QnVja2V0KicsICdzMzpMaXN0KiddLFxuICAgICAgICAgIHJlc291cmNlczogW2J1Y2tldC5idWNrZXRBcm4sIGJ1Y2tldC5hcm5Gb3JPYmplY3RzKCcqJyldLFxuICAgICAgICAgIHByaW5jaXBhbHM6IFt0aGlzLnNjYW5GdW5jdGlvbi5yb2xlLCBzY2FuQXNzdW1lZFByaW5jaXBhbF0sXG4gICAgICAgIH0pLFxuICAgICAgKTtcblxuICAgICAgdGhpcy5zYW5kYm94LmFkZFRvUzNFbnBvaW50UG9saWN5KFxuICAgICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICBlZmZlY3Q6IEVmZmVjdC5BTExPVyxcbiAgICAgICAgICBhY3Rpb25zOiBbJ3MzOlB1dE9iamVjdFRhZ2dpbmcnLCAnczM6UHV0T2JqZWN0VmVyc2lvblRhZ2dpbmcnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFtidWNrZXQuYXJuRm9yT2JqZWN0cygnKicpXSxcbiAgICAgICAgICBwcmluY2lwYWxzOiBbdGhpcy5zY2FuRnVuY3Rpb24ucm9sZSwgc2NhbkFzc3VtZWRQcmluY2lwYWxdLFxuICAgICAgICB9KSxcbiAgICAgICk7XG5cbiAgICAgIGJ1Y2tldC5hZGRUb1Jlc291cmNlUG9saWN5KFxuICAgICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICBlZmZlY3Q6IEVmZmVjdC5ERU5ZLFxuICAgICAgICAgIGFjdGlvbnM6IFsnczM6R2V0T2JqZWN0J10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbYnVja2V0LmFybkZvck9iamVjdHMoJyonKV0sXG4gICAgICAgICAgbm90UHJpbmNpcGFsczogW3RoaXMuc2NhbkZ1bmN0aW9uLnJvbGUsIHNjYW5Bc3N1bWVkUHJpbmNpcGFsXSxcbiAgICAgICAgICBjb25kaXRpb25zOiB7XG4gICAgICAgICAgICBTdHJpbmdFcXVhbHM6IHtcbiAgICAgICAgICAgICAgW2BzMzpFeGlzdGluZ09iamVjdFRhZy8ke3RoaXMuc2NhblN0YXR1c1RhZ05hbWV9YF06IFsnSU4gUFJPR1JFU1MnLCAnSU5GRUNURUQnLCAnRVJST1InXSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSxcbiAgICAgICAgfSksXG4gICAgICApO1xuICAgIH1cbiAgfVxufVxuIl19