"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventbridgeToSns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("aws-cdk-lib/aws-events");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const core_1 = require("@aws-solutions-constructs/core");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
class EventbridgeToSns extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the EventbridgeToSns class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {EventbridgeToSnsProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let enableEncryptionParam = props.enableEncryptionWithCustomerManagedKey;
        if (props.enableEncryptionWithCustomerManagedKey === undefined ||
            props.enableEncryptionWithCustomerManagedKey === true) {
            enableEncryptionParam = true;
        }
        // Setup the sns topic.
        [this.snsTopic, this.encryptionKey] = defaults.buildTopic(this, {
            existingTopicObj: props.existingTopicObj,
            topicProps: props.topicProps,
            enableEncryptionWithCustomerManagedKey: enableEncryptionParam,
            encryptionKey: props.encryptionKey,
            encryptionKeyProps: props.encryptionKeyProps
        });
        // Setup the event rule target as sns topic.
        const topicEventTarget = {
            bind: () => ({
                id: this.snsTopic.topicName,
                arn: this.snsTopic.topicArn
            })
        };
        // build an event bus if existingEventBus is provided or eventBusProps are provided
        this.eventBus = defaults.buildEventBus(this, {
            existingEventBusInterface: props.existingEventBusInterface,
            eventBusProps: props.eventBusProps
        });
        // Setup up the event rule property.
        const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([topicEventTarget], this.eventBus);
        const eventsRuleProps = core_1.overrideProps(defaultEventsRuleProps, props.eventRuleProps, true);
        // Setup up the event rule.
        this.eventsRule = new events.Rule(this, 'EventsRule', eventsRuleProps);
        // Setup up the grant policy for event to be able to publish to the sns topic.
        this.snsTopic.grantPublish(new aws_iam_1.ServicePrincipal('events.amazonaws.com'));
        // Grant EventBridge service access to the SNS Topic encryption key
        this.encryptionKey?.grant(new aws_iam_1.ServicePrincipal('events.amazonaws.com'), "kms:Decrypt", "kms:Encrypt", "kms:ReEncrypt*", "kms:GenerateDataKey*");
    }
}
exports.EventbridgeToSns = EventbridgeToSns;
_a = JSII_RTTI_SYMBOL_1;
EventbridgeToSns[_a] = { fqn: "@aws-solutions-constructs/aws-eventbridge-sns.EventbridgeToSns", version: "2.22.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWNBLGlEQUFpRDtBQUVqRCwyREFBMkQ7QUFDM0Qsd0ZBQXdGO0FBQ3hGLDJDQUF1QztBQUN2Qyx5REFBK0Q7QUFDL0QsaURBQXVEO0FBc0R2RCxNQUFhLGdCQUFpQixTQUFRLHNCQUFTO0lBTTNDOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBNEI7UUFDcEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixRQUFRLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBRTNCLElBQUkscUJBQXFCLEdBQUcsS0FBSyxDQUFDLHNDQUFzQyxDQUFDO1FBQ3pFLElBQUksS0FBSyxDQUFDLHNDQUFzQyxLQUFLLFNBQVM7WUFDMUQsS0FBSyxDQUFDLHNDQUFzQyxLQUFLLElBQUksRUFBRTtZQUN6RCxxQkFBcUIsR0FBRyxJQUFJLENBQUM7U0FDOUI7UUFFRCx1QkFBdUI7UUFDdkIsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsR0FBRyxRQUFRLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRTtZQUM5RCxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO1lBQ3hDLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixzQ0FBc0MsRUFBRSxxQkFBcUI7WUFDN0QsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhO1lBQ2xDLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7U0FDN0MsQ0FBQyxDQUFDO1FBRUgsNENBQTRDO1FBQzVDLE1BQU0sZ0JBQWdCLEdBQXVCO1lBQzNDLElBQUksRUFBRSxHQUFHLEVBQUUsQ0FBQyxDQUFDO2dCQUNYLEVBQUUsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLFNBQVM7Z0JBQzNCLEdBQUcsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVE7YUFDNUIsQ0FBQztTQUNILENBQUM7UUFFRixtRkFBbUY7UUFDbkYsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRTtZQUMzQyx5QkFBeUIsRUFBRSxLQUFLLENBQUMseUJBQXlCO1lBQzFELGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtTQUNuQyxDQUFDLENBQUM7UUFFSCxvQ0FBb0M7UUFDcEMsTUFBTSxzQkFBc0IsR0FBRyxRQUFRLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUNsRyxNQUFNLGVBQWUsR0FBRyxvQkFBYSxDQUFDLHNCQUFzQixFQUFFLEtBQUssQ0FBQyxjQUFjLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFFMUYsMkJBQTJCO1FBQzNCLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxZQUFZLEVBQUUsZUFBZSxDQUFDLENBQUM7UUFFdkUsOEVBQThFO1FBQzlFLElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLElBQUksMEJBQWdCLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxDQUFDO1FBRXpFLG1FQUFtRTtRQUNuRSxJQUFJLENBQUMsYUFBYSxFQUFFLEtBQUssQ0FBQyxJQUFJLDBCQUFnQixDQUFDLHNCQUFzQixDQUFDLEVBQ3BFLGFBQWEsRUFDYixhQUFhLEVBQ2IsZ0JBQWdCLEVBQ2hCLHNCQUFzQixDQUN2QixDQUFDO0lBQ0osQ0FBQzs7QUEvREwsNENBZ0VDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IDIwMjIgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiAgTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZVxuICogIHdpdGggdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgb3IgaW4gdGhlICdsaWNlbnNlJyBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiAnQVMgSVMnIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVNcbiAqICBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgKiBhcyBzbnMgZnJvbSAnYXdzLWNkay1saWIvYXdzLXNucyc7XG5pbXBvcnQgKiBhcyBldmVudHMgZnJvbSAnYXdzLWNkay1saWIvYXdzLWV2ZW50cyc7XG5pbXBvcnQgKiBhcyBrbXMgZnJvbSAnYXdzLWNkay1saWIvYXdzLWttcyc7XG5pbXBvcnQgKiBhcyBkZWZhdWx0cyBmcm9tICdAYXdzLXNvbHV0aW9ucy1jb25zdHJ1Y3RzL2NvcmUnO1xuLy8gTm90ZTogVG8gZW5zdXJlIENES3YyIGNvbXBhdGliaWxpdHksIGtlZXAgdGhlIGltcG9ydCBzdGF0ZW1lbnQgZm9yIENvbnN0cnVjdCBzZXBhcmF0ZVxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBvdmVycmlkZVByb3BzIH0gZnJvbSAnQGF3cy1zb2x1dGlvbnMtY29uc3RydWN0cy9jb3JlJztcbmltcG9ydCB7IFNlcnZpY2VQcmluY2lwYWwgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcblxuZXhwb3J0IGludGVyZmFjZSBFdmVudGJyaWRnZVRvU25zUHJvcHMge1xuICAgIC8qKlxuICAgICAqIFVzZXIgcHJvdmlkZWQgcHJvcHMgdG8gb3ZlcnJpZGUgdGhlIGRlZmF1bHQgcHJvcHMgZm9yIHRoZSBTTlMgVG9waWMuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgcHJvcHMgYXJlIHVzZWRcbiAgICAgKi9cbiAgICByZWFkb25seSB0b3BpY1Byb3BzPzogc25zLlRvcGljUHJvcHM7XG4gICAgLyoqXG4gICAgICogRXhpc3RpbmcgaW5zdGFuY2Ugb2YgYSBjdXN0b20gRXZlbnRCdXMuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICAgKi9cbiAgICByZWFkb25seSBleGlzdGluZ0V2ZW50QnVzSW50ZXJmYWNlPzogZXZlbnRzLklFdmVudEJ1cztcbiAgICAvKipcbiAgICAgKiBBIG5ldyBjdXN0b20gRXZlbnRCdXMgaXMgY3JlYXRlZCB3aXRoIHByb3ZpZGVkIHByb3BzLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBOb25lXG4gICAgICovXG4gICAgcmVhZG9ubHkgZXZlbnRCdXNQcm9wcz86IGV2ZW50cy5FdmVudEJ1c1Byb3BzO1xuICAgIC8qKlxuICAgICAqIFVzZXIgcHJvdmlkZWQgZXZlbnRSdWxlUHJvcHMgdG8gb3ZlcnJpZGUgdGhlIGRlZmF1bHRzXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICAgKi9cbiAgICByZWFkb25seSBldmVudFJ1bGVQcm9wczogZXZlbnRzLlJ1bGVQcm9wcztcbiAgICAvKipcbiAgICAgKiBFeGlzdGluZyBpbnN0YW5jZSBvZiBTTlMgVG9waWMgb2JqZWN0LCBwcm92aWRpbmcgYm90aCB0aGlzIGFuZCB0b3BpY1Byb3BzIHdpbGwgY2F1c2UgYW4gZXJyb3IuLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBEZWZhdWx0IHByb3BzIGFyZSB1c2VkXG4gICAgICovXG4gICAgcmVhZG9ubHkgZXhpc3RpbmdUb3BpY09iaj86IHNucy5Ub3BpYztcbiAgICAvKipcbiAgICAgKiBVc2UgYSBLTVMgS2V5LCBlaXRoZXIgbWFuYWdlZCBieSB0aGlzIENESyBhcHAsIG9yIGltcG9ydGVkLiBJZiBpbXBvcnRpbmcgYW4gZW5jcnlwdGlvbiBrZXksIGl0IG11c3QgYmUgc3BlY2lmaWVkIGluXG4gICAgICogdGhlIGVuY3J5cHRpb25LZXkgcHJvcGVydHkgZm9yIHRoaXMgY29uc3RydWN0LlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSB0cnVlIChlbmNyeXB0aW9uIGVuYWJsZWQsIG1hbmFnZWQgYnkgdGhpcyBDREsgYXBwKS5cbiAgICAgKi9cbiAgICByZWFkb25seSBlbmFibGVFbmNyeXB0aW9uV2l0aEN1c3RvbWVyTWFuYWdlZEtleT86IGJvb2xlYW47XG4gICAgLyoqXG4gICAgICogQW4gb3B0aW9uYWwsIGltcG9ydGVkIGVuY3J5cHRpb24ga2V5IHRvIGVuY3J5cHQgdGhlIFNRUyBxdWV1ZSwgYW5kIFNOUyBUb3BpYy5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gbm90IHNwZWNpZmllZC5cbiAgICAgKi9cbiAgICByZWFkb25seSBlbmNyeXB0aW9uS2V5Pzoga21zLktleTtcbiAgICAvKipcbiAgICAgKiBPcHRpb25hbCB1c2VyLXByb3ZpZGVkIHByb3BzIHRvIG92ZXJyaWRlIHRoZSBkZWZhdWx0IHByb3BzIGZvciB0aGUgZW5jcnlwdGlvbiBrZXkuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgcHJvcHMgYXJlIHVzZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZW5jcnlwdGlvbktleVByb3BzPzoga21zLktleVByb3BzO1xufVxuXG5leHBvcnQgY2xhc3MgRXZlbnRicmlkZ2VUb1NucyBleHRlbmRzIENvbnN0cnVjdCB7XG4gICAgcHVibGljIHJlYWRvbmx5IHNuc1RvcGljOiBzbnMuVG9waWM7XG4gICAgcHVibGljIHJlYWRvbmx5IGV2ZW50QnVzPzogZXZlbnRzLklFdmVudEJ1cztcbiAgICBwdWJsaWMgcmVhZG9ubHkgZXZlbnRzUnVsZTogZXZlbnRzLlJ1bGU7XG4gICAgcHVibGljIHJlYWRvbmx5IGVuY3J5cHRpb25LZXk/OiBrbXMuS2V5O1xuXG4gICAgLyoqXG4gICAgICogQHN1bW1hcnkgQ29uc3RydWN0cyBhIG5ldyBpbnN0YW5jZSBvZiB0aGUgRXZlbnRicmlkZ2VUb1NucyBjbGFzcy5cbiAgICAgKiBAcGFyYW0ge2Nkay5BcHB9IHNjb3BlIC0gcmVwcmVzZW50cyB0aGUgc2NvcGUgZm9yIGFsbCB0aGUgcmVzb3VyY2VzLlxuICAgICAqIEBwYXJhbSB7c3RyaW5nfSBpZCAtIHRoaXMgaXMgYSBhIHNjb3BlLXVuaXF1ZSBpZC5cbiAgICAgKiBAcGFyYW0ge0V2ZW50YnJpZGdlVG9TbnNQcm9wc30gcHJvcHMgLSB1c2VyIHByb3ZpZGVkIHByb3BzIGZvciB0aGUgY29uc3RydWN0LlxuICAgICAqIEBhY2Nlc3MgcHVibGljXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEV2ZW50YnJpZGdlVG9TbnNQcm9wcykge1xuICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgIGRlZmF1bHRzLkNoZWNrUHJvcHMocHJvcHMpO1xuXG4gICAgICBsZXQgZW5hYmxlRW5jcnlwdGlvblBhcmFtID0gcHJvcHMuZW5hYmxlRW5jcnlwdGlvbldpdGhDdXN0b21lck1hbmFnZWRLZXk7XG4gICAgICBpZiAocHJvcHMuZW5hYmxlRW5jcnlwdGlvbldpdGhDdXN0b21lck1hbmFnZWRLZXkgPT09IHVuZGVmaW5lZCB8fFxuICAgICAgICAgIHByb3BzLmVuYWJsZUVuY3J5cHRpb25XaXRoQ3VzdG9tZXJNYW5hZ2VkS2V5ID09PSB0cnVlKSB7XG4gICAgICAgIGVuYWJsZUVuY3J5cHRpb25QYXJhbSA9IHRydWU7XG4gICAgICB9XG5cbiAgICAgIC8vIFNldHVwIHRoZSBzbnMgdG9waWMuXG4gICAgICBbdGhpcy5zbnNUb3BpYywgdGhpcy5lbmNyeXB0aW9uS2V5XSA9IGRlZmF1bHRzLmJ1aWxkVG9waWModGhpcywge1xuICAgICAgICBleGlzdGluZ1RvcGljT2JqOiBwcm9wcy5leGlzdGluZ1RvcGljT2JqLFxuICAgICAgICB0b3BpY1Byb3BzOiBwcm9wcy50b3BpY1Byb3BzLFxuICAgICAgICBlbmFibGVFbmNyeXB0aW9uV2l0aEN1c3RvbWVyTWFuYWdlZEtleTogZW5hYmxlRW5jcnlwdGlvblBhcmFtLFxuICAgICAgICBlbmNyeXB0aW9uS2V5OiBwcm9wcy5lbmNyeXB0aW9uS2V5LFxuICAgICAgICBlbmNyeXB0aW9uS2V5UHJvcHM6IHByb3BzLmVuY3J5cHRpb25LZXlQcm9wc1xuICAgICAgfSk7XG5cbiAgICAgIC8vIFNldHVwIHRoZSBldmVudCBydWxlIHRhcmdldCBhcyBzbnMgdG9waWMuXG4gICAgICBjb25zdCB0b3BpY0V2ZW50VGFyZ2V0OiBldmVudHMuSVJ1bGVUYXJnZXQgPSB7XG4gICAgICAgIGJpbmQ6ICgpID0+ICh7XG4gICAgICAgICAgaWQ6IHRoaXMuc25zVG9waWMudG9waWNOYW1lLFxuICAgICAgICAgIGFybjogdGhpcy5zbnNUb3BpYy50b3BpY0FyblxuICAgICAgICB9KVxuICAgICAgfTtcblxuICAgICAgLy8gYnVpbGQgYW4gZXZlbnQgYnVzIGlmIGV4aXN0aW5nRXZlbnRCdXMgaXMgcHJvdmlkZWQgb3IgZXZlbnRCdXNQcm9wcyBhcmUgcHJvdmlkZWRcbiAgICAgIHRoaXMuZXZlbnRCdXMgPSBkZWZhdWx0cy5idWlsZEV2ZW50QnVzKHRoaXMsIHtcbiAgICAgICAgZXhpc3RpbmdFdmVudEJ1c0ludGVyZmFjZTogcHJvcHMuZXhpc3RpbmdFdmVudEJ1c0ludGVyZmFjZSxcbiAgICAgICAgZXZlbnRCdXNQcm9wczogcHJvcHMuZXZlbnRCdXNQcm9wc1xuICAgICAgfSk7XG5cbiAgICAgIC8vIFNldHVwIHVwIHRoZSBldmVudCBydWxlIHByb3BlcnR5LlxuICAgICAgY29uc3QgZGVmYXVsdEV2ZW50c1J1bGVQcm9wcyA9IGRlZmF1bHRzLkRlZmF1bHRFdmVudHNSdWxlUHJvcHMoW3RvcGljRXZlbnRUYXJnZXRdLCB0aGlzLmV2ZW50QnVzKTtcbiAgICAgIGNvbnN0IGV2ZW50c1J1bGVQcm9wcyA9IG92ZXJyaWRlUHJvcHMoZGVmYXVsdEV2ZW50c1J1bGVQcm9wcywgcHJvcHMuZXZlbnRSdWxlUHJvcHMsIHRydWUpO1xuXG4gICAgICAvLyBTZXR1cCB1cCB0aGUgZXZlbnQgcnVsZS5cbiAgICAgIHRoaXMuZXZlbnRzUnVsZSA9IG5ldyBldmVudHMuUnVsZSh0aGlzLCAnRXZlbnRzUnVsZScsIGV2ZW50c1J1bGVQcm9wcyk7XG5cbiAgICAgIC8vIFNldHVwIHVwIHRoZSBncmFudCBwb2xpY3kgZm9yIGV2ZW50IHRvIGJlIGFibGUgdG8gcHVibGlzaCB0byB0aGUgc25zIHRvcGljLlxuICAgICAgdGhpcy5zbnNUb3BpYy5ncmFudFB1Ymxpc2gobmV3IFNlcnZpY2VQcmluY2lwYWwoJ2V2ZW50cy5hbWF6b25hd3MuY29tJykpO1xuXG4gICAgICAvLyBHcmFudCBFdmVudEJyaWRnZSBzZXJ2aWNlIGFjY2VzcyB0byB0aGUgU05TIFRvcGljIGVuY3J5cHRpb24ga2V5XG4gICAgICB0aGlzLmVuY3J5cHRpb25LZXk/LmdyYW50KG5ldyBTZXJ2aWNlUHJpbmNpcGFsKCdldmVudHMuYW1hem9uYXdzLmNvbScpLFxuICAgICAgICBcImttczpEZWNyeXB0XCIsXG4gICAgICAgIFwia21zOkVuY3J5cHRcIixcbiAgICAgICAgXCJrbXM6UmVFbmNyeXB0KlwiLFxuICAgICAgICBcImttczpHZW5lcmF0ZURhdGFLZXkqXCJcbiAgICAgICk7XG4gICAgfVxufSJdfQ==