/*
 * Decompiled with CFR 0.152.
 */
package launcher.utils;

import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.toree.utils.LogLike;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

public final class SocketUtils$
implements LogLike {
    public static SocketUtils$ MODULE$;
    private final Random random;
    private final String loggerName;
    private final Logger logger;

    static {
        new SocketUtils$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$apache$toree$utils$LogLike$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$toree$utils$LogLike$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Random random() {
        return this.random;
    }

    public void writeToSocket(String socketAddress, String content) {
        String[] ipPort = socketAddress.split(":");
        if (ipPort.length == 2) {
            this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Sending connection info to gateway at %s\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketAddress, content})));
            String ip = ipPort[0];
            int port = new StringOps(Predef$.MODULE$.augmentString(ipPort[1])).toInt();
            Socket s = new Socket(InetAddress.getByName(ip), port);
            PrintStream out = new PrintStream(s.getOutputStream());
            try {
                out.append(content);
                out.flush();
            }
            finally {
                s.close();
            }
        } else {
            this.logger().error(new StringOps(Predef$.MODULE$.augmentString("Invalid format for response address '%s'!")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketAddress})));
        }
    }

    public int findPort(int portLowerBound, int portUpperBound) {
        ServerSocket socket = this.findSocket(portLowerBound, portUpperBound);
        int port = socket.getLocalPort();
        this.logger().info(new StringOps(Predef$.MODULE$.augmentString("port %s is available")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)})));
        socket.close();
        this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Port %s closed...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)})));
        return port;
    }

    public ServerSocket findSocket(int portLowerBound, int portUpperBound) {
        boolean foundAvailable = false;
        ServerSocket socket = null;
        while (!foundAvailable) {
            int candidatePort = this.getCandidatePort(portLowerBound, portUpperBound);
            if (candidatePort > 0) {
                this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Trying port %s ...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)candidatePort)})));
            }
            try {
                socket = new ServerSocket(candidatePort);
                foundAvailable = true;
            }
            catch (Throwable throwable) {
                this.logger().info(new StringOps(Predef$.MODULE$.augmentString("port %s is in use")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)candidatePort)})));
                socket = null;
            }
        }
        return socket;
    }

    private int getCandidatePort(int portLowerBound, int portUpperBound) {
        int portRange = portUpperBound - portLowerBound;
        if (portRange <= 0) {
            return 0;
        }
        int port = portLowerBound + this.random().nextInt(portRange);
        return port;
    }

    private SocketUtils$() {
        MODULE$ = this;
        LogLike.$init$((LogLike)this);
        this.random = new Random(System.currentTimeMillis());
    }
}

