/*
 * Decompiled with CFR 0.152.
 */
package launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import launcher.KernelProfile$;
import launcher.utils.SecurityUtils$;
import launcher.utils.SocketUtils$;
import org.apache.toree.Main$;
import org.apache.toree.utils.LogLike;
import org.slf4j.Logger;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import sun.misc.Signal;

public final class ToreeLauncher$
implements LogLike {
    public static ToreeLauncher$ MODULE$;
    private final int minPortRangeSize;
    private final String kernelTempDir;
    private String profilePath;
    private String kernelId;
    private int portLowerBound;
    private int portUpperBound;
    private String responseAddress;
    private String publicKey;
    private String alternateSigint;
    private String initMode;
    private ArrayBuffer<String> toreeArgs;
    private final String loggerName;
    private final Logger logger;

    static {
        new ToreeLauncher$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$apache$toree$utils$LogLike$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$toree$utils$LogLike$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int minPortRangeSize() {
        return this.minPortRangeSize;
    }

    public String kernelTempDir() {
        return this.kernelTempDir;
    }

    public String profilePath() {
        return this.profilePath;
    }

    public void profilePath_$eq(String x$1) {
        this.profilePath = x$1;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public void kernelId_$eq(String x$1) {
        this.kernelId = x$1;
    }

    public int portLowerBound() {
        return this.portLowerBound;
    }

    public void portLowerBound_$eq(int x$1) {
        this.portLowerBound = x$1;
    }

    public int portUpperBound() {
        return this.portUpperBound;
    }

    public void portUpperBound_$eq(int x$1) {
        this.portUpperBound = x$1;
    }

    public String responseAddress() {
        return this.responseAddress;
    }

    public void responseAddress_$eq(String x$1) {
        this.responseAddress = x$1;
    }

    public String publicKey() {
        return this.publicKey;
    }

    public void publicKey_$eq(String x$1) {
        this.publicKey = x$1;
    }

    public String alternateSigint() {
        return this.alternateSigint;
    }

    public void alternateSigint_$eq(String x$1) {
        this.alternateSigint = x$1;
    }

    public String initMode() {
        return this.initMode;
    }

    public void initMode_$eq(String x$1) {
        this.initMode = x$1;
    }

    public ArrayBuffer<String> toreeArgs() {
        return this.toreeArgs;
    }

    public void toreeArgs_$eq(ArrayBuffer<String> x$1) {
        this.toreeArgs = x$1;
    }

    private boolean pathExists(String filePath) {
        return filePath == null ? false : Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]);
    }

    private void writeToFile(String outputPath, String content) {
        File file = new File(outputPath);
        Object object = !this.pathExists(file.getParentFile().toString()) ? BoxesRunTime.boxToBoolean((boolean)file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            bw.write(content);
        }
    }

    private void initPortRange(String portRange) {
        String[] ports = portRange.split("\\.\\.");
        this.portLowerBound_$eq(new StringOps(Predef$.MODULE$.augmentString(ports[0])).toInt());
        this.portUpperBound_$eq(new StringOps(Predef$.MODULE$.augmentString(ports[1])).toInt());
        this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Port Range: lower bound ( %s ) / upper bound ( %s )")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.portLowerBound()), BoxesRunTime.boxToInteger((int)this.portUpperBound())})));
        if (this.portLowerBound() != this.portUpperBound() && (this.portLowerBound() < 0 || this.portUpperBound() < 0 || this.portUpperBound() - this.portLowerBound() < this.minPortRangeSize())) {
            this.logger().error("Invalid port range, use --port-range <LowerBound>..<UpperBound>, range must be >= MIN_PORT_RANGE_SIZE ($minPortRangeSize)");
            throw package$.MODULE$.exit(-1);
        }
    }

    private void initArguments(String[] args) {
        this.logger().info("Toree launcher arguments (initial):");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            ToreeLauncher$.$anonfun$initArguments$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.logger().info("---------------------------");
        for (int i = 0; i < args.length; ++i) {
            ArrayBuffer arrayBuffer;
            String arg = args[i];
            String string = arg;
            if ("--alternate-sigint".equals(string)) {
                this.alternateSigint_$eq(args[++i].trim());
                this.toreeArgs().$plus$eq((Object)arg);
                arrayBuffer = this.toreeArgs().$plus$eq((Object)this.alternateSigint());
                continue;
            }
            if ("--spark-context-initialization-mode".equals(string)) {
                ArrayBuffer arrayBuffer2;
                this.initMode_$eq(args[++i].trim());
                String string2 = this.initMode();
                if ("none".equals(string2)) {
                    arrayBuffer2 = this.toreeArgs().$plus$eq((Object)"--nosparkcontext");
                } else {
                    this.toreeArgs().$plus$eq((Object)"--spark-context-initialization-mode");
                    arrayBuffer2 = this.toreeArgs().$plus$eq((Object)this.initMode());
                }
                arrayBuffer = arrayBuffer2;
                continue;
            }
            if ("--port-range".equals(string)) {
                this.initPortRange(args[++i].trim());
                arrayBuffer = BoxedUnit.UNIT;
                continue;
            }
            if ("--response-address".equals(string)) {
                this.responseAddress_$eq(args[++i].trim());
                arrayBuffer = BoxedUnit.UNIT;
                continue;
            }
            if ("--kernel-id".equals(string)) {
                this.kernelId_$eq(args[++i].trim());
                arrayBuffer = BoxedUnit.UNIT;
                continue;
            }
            if ("--public-key".equals(string)) {
                this.publicKey_$eq(args[++i].trim());
                arrayBuffer = BoxedUnit.UNIT;
                continue;
            }
            arrayBuffer = this.toreeArgs().$plus$eq((Object)args[i].trim());
        }
    }

    private void deleteDirRecur(File file2) {
        block2: {
            if (file2 == null) break block2;
            if (file2.isDirectory()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file2.listFiles())).foreach((Function1 & Serializable & scala.Serializable)file -> {
                    ToreeLauncher$.MODULE$.deleteDirRecur(file);
                    return BoxedUnit.UNIT;
                });
            }
            if (file2.exists()) {
                file2.delete();
            }
        }
    }

    private String determineConnectionFile(String connectionFile, String kernelId) {
        Path tmpPath = Files.createTempDirectory(this.kernelTempDir(), new FileAttribute[0]);
        package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.deleteDirRecur(tmpPath.toFile()));
        String fileName = kernelId != null ? new StringBuilder(12).append("kernel-").append(kernelId).append(".json").toString() : ((Object)Paths.get(connectionFile, new String[0]).getFileName()).toString();
        Path newPath = Paths.get(((Object)tmpPath).toString(), fileName);
        String newConnectionFile = ((Object)newPath).toString();
        this.toreeArgs().$plus$eq((Object)"--profile");
        this.toreeArgs().$plus$eq((Object)newConnectionFile);
        return newConnectionFile;
    }

    private String getPID() {
        return new StringOps(Predef$.MODULE$.augmentString(ManagementFactory.getRuntimeMXBean().getName())).split('@')[0];
    }

    /*
     * WARNING - void declaration
     */
    private ServerSocket initProfile(String[] args) {
        void var2_2;
        block3: {
            ServerSocket commSocket = null;
            this.initArguments(args);
            if (this.kernelId() == null) {
                this.logger().error("Parameter '--kernel-id' must be provided - exiting!");
                throw package$.MODULE$.exit(-1);
            }
            if (this.publicKey() == null) {
                this.logger().error("Parameter '--public-key' must be provided - exiting!");
                throw package$.MODULE$.exit(-1);
            }
            this.profilePath_$eq(this.determineConnectionFile(this.profilePath(), this.kernelId()));
            this.logger().info(new StringOps(Predef$.MODULE$.augmentString("The profile %s doesn't exist, now creating it...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.profilePath()})));
            String content = KernelProfile$.MODULE$.createJsonProfile(this.portLowerBound(), this.portUpperBound());
            this.writeToFile(this.profilePath(), content);
            if (!this.pathExists(this.profilePath())) {
                this.logger().error(new StringOps(Predef$.MODULE$.augmentString("Failed to create: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.profilePath()})));
                throw package$.MODULE$.exit(-1);
            }
            this.logger().info(new StringOps(Predef$.MODULE$.augmentString("%s saved")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.profilePath()})));
            JsValue connectionJson = Json$.MODULE$.parse(content);
            connectionJson = ((JsObject)connectionJson.as((Reads)Reads$.MODULE$.JsObjectReads())).$plus$plus(Json$.MODULE$.obj((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.getPID(), (Writes)Writes$.MODULE$.StringWrites()))})));
            connectionJson = ((JsObject)connectionJson.as((Reads)Reads$.MODULE$.JsObjectReads())).$plus$plus(Json$.MODULE$.obj((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kernel_id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.kernelId(), (Writes)Writes$.MODULE$.StringWrites()))})));
            commSocket = SocketUtils$.MODULE$.findSocket(this.portLowerBound(), this.portUpperBound());
            connectionJson = ((JsObject)connectionJson.as((Reads)Reads$.MODULE$.JsObjectReads())).$plus$plus(Json$.MODULE$.obj((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comm_port"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)commSocket.getLocalPort()), (Writes)Writes$.MODULE$.IntWrites()))})));
            String jsonContent = Json$.MODULE$.toJson((Object)connectionJson, (Writes)Writes$.MODULE$.JsValueWrites()).toString();
            if (this.responseAddress() == null) break block3;
            this.logger().info(new StringOps(Predef$.MODULE$.augmentString("JSON Payload: '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jsonContent})));
            String payload = SecurityUtils$.MODULE$.encrypt(this.publicKey(), jsonContent);
            this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Encrypted Payload: '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{payload})));
            SocketUtils$.MODULE$.writeToSocket(this.responseAddress(), payload);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String getServerRequest(ServerSocket commSocket) {
        void var3_3;
        Socket s = commSocket.accept();
        String data = new BufferedSource(s.getInputStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        s.close();
        return var3_3;
    }

    private String getReconciledSignalName(int sigNum) {
        String string;
        Predef$.MODULE$.require(sigNum > 0, (Function0 & Serializable & scala.Serializable)() -> "sigNum must be greater than zero");
        if (sigNum == 9) {
            string = "TERM";
        } else if (this.alternateSigint() == null) {
            this.logger().warn(new StringBuilder(176).append("--alternate-sigint is not defined and signum %d has been requested.  Using SIGINT, which probably won't get received due to JVM preventing interrupts on background processes.  ").append(new StringOps(Predef$.MODULE$.augmentString("Define --alternate-sigint using __TOREE_OPTS__.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sigNum)}))).toString());
            string = "INT";
        } else {
            string = this.alternateSigint();
        }
        return string;
    }

    public void launcher$ToreeLauncher$$serverListener(ServerSocket commSocket) {
        boolean stop = false;
        while (!stop) {
            int shutdown;
            int sigNum;
            String requestData = this.getServerRequest(commSocket);
            Map requestJson = ((JsObject)Json$.MODULE$.parse(requestData).as((Reads)Reads$.MODULE$.JsObjectReads())).value();
            if (requestJson.contains((Object)"signum") && (sigNum = ((JsNumber)requestJson.apply((Object)"signum")).value().toInt()) > 0) {
                String sigName = this.getReconciledSignalName(sigNum);
                Signal sigToRaise = new Signal(sigName);
                this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Server listener raising signal: '%s' (%d) for signum: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sigToRaise.getName(), BoxesRunTime.boxToInteger((int)sigToRaise.getNumber()), BoxesRunTime.boxToInteger((int)sigNum)})));
                Signal.raise(sigToRaise);
            }
            if (!requestJson.contains((Object)"shutdown") || (shutdown = ((JsNumber)requestJson.apply((Object)"shutdown")).value().toInt()) != 1) continue;
            this.logger().info("Stopping server listener.");
            stop = true;
        }
    }

    public void main(String[] args) {
        ServerSocket commSocket = this.initProfile(args);
        if (commSocket != null) {
            Thread serverListenerThread = new Thread(commSocket){
                private final ServerSocket commSocket$1;

                public void run() {
                    ToreeLauncher$.MODULE$.launcher$ToreeLauncher$$serverListener(this.commSocket$1);
                }
                {
                    this.commSocket$1 = commSocket$1;
                }
            };
            this.logger().info("Starting server listener...");
            serverListenerThread.start();
        }
        this.logger().info("Toree kernel arguments (final):");
        this.toreeArgs().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            ToreeLauncher$.$anonfun$main$1(x$2);
            return BoxedUnit.UNIT;
        });
        this.logger().info("---------------------------");
        Main$.MODULE$.main((String[])this.toreeArgs().toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public static final /* synthetic */ void $anonfun$initArguments$1(String x$1) {
        MODULE$.logger().info(x$1);
    }

    public static final /* synthetic */ void $anonfun$main$1(String x$2) {
        MODULE$.logger().info(x$2);
    }

    private ToreeLauncher$() {
        MODULE$ = this;
        LogLike.$init$((LogLike)this);
        this.minPortRangeSize = new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().getOrElse((Object)"MIN_PORT_RANGE_SIZE", (Function0 & Serializable & scala.Serializable)() -> "1000"))).toInt();
        this.kernelTempDir = "jupyter-kernel";
        this.portLowerBound = -1;
        this.portUpperBound = -1;
        this.initMode = "lazy";
        this.toreeArgs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

