# AUTOGENERATED! DO NOT EDIT! File to edit: 01_PreProcessor.ipynb (unless otherwise specified).

__all__ = ['PreProcessor']

# Cell
from .DataFrameLoader import *

# Cell
# hide
import pandas as pd
from sklearn.compose import ColumnTransformer
from sklearn.pipeline import Pipeline
from sklearn.impute import SimpleImputer
from sklearn.preprocessing import OneHotEncoder
from sklearn.preprocessing import OrdinalEncoder
from sklearn.ensemble import RandomForestRegressor
from sklearn.metrics import mean_absolute_error

# Cell

class PreProcessor:
    """
    Represent PreProcessor class

    Attributes:
    numerical_transformer: Numerical Columns Tranformer
    categorical_transformer: Categorical Columns Transformer
    preprocessor: Preprocessor for Columns Tranformer
    """

    def __init__(self):
        self.numerical_transformer = None
        self.categorical_transformer = None
        self.columns_transfomer = None
        self.transformer_type = None
        self.OHE_categorical_transformer = None
        self.ORE_categorical_transformer = None
#         self.numerical_cols = None
#         self.low_card_cat_cols = None
#         self.high_card_cat_cols = None
#         self.final_cols = None

    def __str__(self):
        """Returns human readable string reprsentation"""
        attr_str = "numerical_transformer, categorical_transformer,columns_transfomer"
        return "PreProcessor object with attributes:" + attr_str

    def __repr__(self):
        return self.__str__()

#     def __lt__(self):
#         """returns: boolean"""
#         return True

    # PreProcess core methods
    # Preprocessing for numerical data
    def preprocess_numerical_data(self):
        self.numerical_transformer = SimpleImputer(strategy='constant')

    def preprocess_OHE_categorical_data(self):
        self.OHE_categorical_transformer = Pipeline(steps=[
        ('imputer', SimpleImputer(strategy='most_frequent')),
        ('onehot', OneHotEncoder(handle_unknown='ignore'))
        ])

    def preprocess_OE_categorical_data(self):
        self.OE_categorical_transformer = Pipeline(steps=[
        ('imputer', SimpleImputer(strategy='most_frequent')),
        ('ordinal', OrdinalEncoder())
        ])

    # Bundle preprocessing for numerical and categorical data
    def preprocess_all_cols_for_training(self, dataframeloader):
        # create scikit-learn pipelines instances
        self.preprocess_numerical_data()
        self.preprocess_OHE_categorical_data()
        self.preprocess_OE_categorical_data()
        # convert to Scikit-learn ColumnTranfomer
        self.columns_transfomer = ColumnTransformer(
            transformers=[
                ('num', self.numerical_transformer, dataframeloader.numerical_cols),
                ('low_cad_cat', self.OHE_categorical_transformer,
                 dataframeloader.low_card_cat_cols),
                ('high_cad_cat', self.OE_categorical_transformer,
                 dataframeloader.high_card_cat_cols)
            ])
        self.transformer_type = self.columns_transfomer
        return self

    # Bundle preprocessing for cv_cols
    def preprocess_cols_for_cv(self, cv_cols_type, dataframeloader):
                        # change column types and preprocessor according to cv_cols provided
        if cv_cols_type == "all":
            # create scikit-learn pipelines instances
            self.preprocess_numerical_data()
            self.preprocess_OHE_categorical_data()
#             self.preprocess_OE_categorical_data()
            # convert to Scikit-learn ColumnTranfomer
            self.columns_transfomer = ColumnTransformer(
                transformers=[
                    ('num', self.numerical_transformer, dataframeloader.numerical_cols),
                    ('low_cad_cat', self.OHE_categorical_transformer,
                     dataframeloader.low_card_cat_cols)
#                     ,('high_cad_cat', self.OE_categorical_transformer,
#                      dataframeloader.high_card_cat_cols)
                ])
            self.transformer_type = self.columns_transfomer

        elif cv_cols_type == "num":
            # for num columns, just process numerocal columns
#             self.columns_transfomer = ColumnTransformer(
#                 transformers=[
#                 ('num', self.numerical_transformer, dataframeloader.numerical_cols)
#                 ])
            self.preprocess_numerical_data()
            self.transformer_type = self.numerical_transformer

        elif cv_cols_type == "cat":
            # create scikit-learn pipelines instances
            self.preprocess_OHE_categorical_data()
#             self.preprocess_OE_categorical_data()
            # convert all categorical columns to OrdinalEncoder with Scikit-learn ColumnTranfomer
            self.columns_transfomer = ColumnTransformer(
                transformers=[
                    ('low_cad_cat', self.OHE_categorical_transformer,
                     dataframeloader.low_card_cat_cols)
                    # REMOVING HIGH CARDINALITY COLUMNS BECAUSE OF NOT ENOUGH REPRESENTATION
                    # OF CARDINALITY DURING K-FOLD SPLIT OF DATA
#                     ,('high_cad_cat', self.OE_categorical_transformer,
#                      dataframeloader.high_card_cat_cols)
                ])
            self.transformer_type = self.columns_transfomer
        else:
            raise ValueError("Bad cv_cols_type, Only 'num','cat','all' are allowed!")

        return self