# File Operations

Simple python API for performing directory and file-based operations.

## Installation

You can install the `file_operations` library with the following command:

    pip install file_operations

Then import into your program as:

    import file_operations.file_ops as file_ops

    def main():
        data = "aabaaba"
        src_file = "hello.src"
        dest_file = "hello.dest"

        file_ops.write_file(src_file, data, mode='w')
        file_ops.copy_file(src_file, dest_file)

    if __name__ == '__main__':
        main()


## API Architecture

The following discusses the available methods in this library:

    read_bytes(src_file, offset, limit)

    copy_file(src_file, dest_file)
    write_file(dest_file, data, mode ='w', overwrite = False)
    move_file(src_file, dest_file)
    remove_file(src_file)

    create_dir(dest_dir)
    copy_dir(src_dir, dest_dir, overwrite = False)
    move_dir(src_dir, dest_dir)
    remove_dir(dest_dir)

    buffered_reader(file_name, buffer_size, mode ='rb'):
    buffered_reader.has_next()
    buffered_reader.read()
    buffered_reader.close()

The `_file` methods require both `src_file` and `dest_file` to be formatted as `path/file_name.extension`.
Note the `buffered_reader` is a class which is used for reading a large file in chunks, the size of each chunk is `buffer_size`.
If an operation is successfully applied, then the function returns `True` and `False` otherwise.

For coding interview preparation, please visit [algorithmspath.com] (https://algorithmspath.com).
