# ┌─────────────────────────────────────────────────────────────────────────────────────
# │ GENERAL IMPORTS
# └─────────────────────────────────────────────────────────────────────────────────────

import re


# ┌─────────────────────────────────────────────────────────────────────────────────────
# │ SPLIT CAMEL CASE
# └─────────────────────────────────────────────────────────────────────────────────────


def split_camel_case(string):

    # Get regex matches
    matches = re.finditer(
        ".+?(?:(?<=[a-z])(?=[A-Z])|(?<=[A-Z])(?=[A-Z][a-z])|$)", string
    )

    # Return split string
    return [m.group(0) for m in matches]
