/**
This file was auto-generated by mupdfwrap.py.
*/

#ifndef MUPDF_EXCEPTIONS_H
#define MUPDF_EXCEPTIONS_H


#include <stdexcept>
#include <string>

#include "mupdf/fitz.h"


namespace mupdf
{

/** Base class for `None` exceptions */
struct ErrorBase : std::exception
{
	int         m_code;
	std::string m_text;
	const char* what() const throw();
	ErrorBase(int code, const char* text);
};

/** For `FZ_ERROR_NONE`. */
struct ErrorNone : ErrorBase
{
	ErrorNone(const char* message);
};


/** For `FZ_ERROR_MEMORY`. */
struct ErrorMemory : ErrorBase
{
	ErrorMemory(const char* message);
};


/** For `FZ_ERROR_GENERIC`. */
struct ErrorGeneric : ErrorBase
{
	ErrorGeneric(const char* message);
};


/** For `FZ_ERROR_SYNTAX`. */
struct ErrorSyntax : ErrorBase
{
	ErrorSyntax(const char* message);
};


/** For `FZ_ERROR_MINOR`. */
struct ErrorMinor : ErrorBase
{
	ErrorMinor(const char* message);
};


/** For `FZ_ERROR_TRYLATER`. */
struct ErrorTrylater : ErrorBase
{
	ErrorTrylater(const char* message);
};


/** For `FZ_ERROR_ABORT`. */
struct ErrorAbort : ErrorBase
{
	ErrorAbort(const char* message);
};


/** For `FZ_ERROR_REPAIRED`. */
struct ErrorRepaired : ErrorBase
{
	ErrorRepaired(const char* message);
};


/** For `FZ_ERROR_COUNT`. */
struct ErrorCount : ErrorBase
{
	ErrorCount(const char* message);
};


/** Throw exception appropriate for error in `ctx`. */
void internal_throw_exception(fz_context* ctx);


} /* End of namespace mupdf. */

#endif
